# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__SUMA_REPREFIXIZE_SPEC_METADATA = Metadata(
    id="6cfc02f203c0f727d55853e820f666475c263072.boutiques",
    name="@suma_reprefixize_spec",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VSumaReprefixizeSpecParameters = typing.TypedDict('VSumaReprefixizeSpecParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@suma_reprefixize_spec"]],
    "input_file": InputPathType,
    "prefix": str,
    "output_dir": str,
    "work_dir": str,
    "no_clean": bool,
})
VSumaReprefixizeSpecParametersTagged = typing.TypedDict('VSumaReprefixizeSpecParametersTagged', {
    "@type": typing.Literal["afni/@suma_reprefixize_spec"],
    "input_file": InputPathType,
    "prefix": str,
    "output_dir": str,
    "work_dir": str,
    "no_clean": bool,
})


class VSumaReprefixizeSpecOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VSumaReprefixizeSpecParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v__suma_reprefixize_spec_params(
    input_file: InputPathType,
    prefix: str,
    output_dir: str,
    work_dir: str,
    no_clean: bool = False,
) -> VSumaReprefixizeSpecParametersTagged:
    """
    Build parameters.
    
    Args:
        input_file: Input SUMA specification file.
        prefix: Prefix to be added to the file names.
        output_dir: Output directory where the prefixed files will be saved.
        work_dir: Working directory for temporary files.
        no_clean: Flag to avoid cleaning temporary files.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@suma_reprefixize_spec",
        "input_file": input_file,
        "prefix": prefix,
        "output_dir": output_dir,
        "work_dir": work_dir,
        "no_clean": no_clean,
    }
    return params


def v__suma_reprefixize_spec_cargs(
    params: VSumaReprefixizeSpecParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@suma_reprefixize_spec")
    cargs.extend([
        "-input",
        execution.input_file(params.get("input_file", None))
    ])
    cargs.extend([
        "-preprefix",
        params.get("prefix", None)
    ])
    cargs.extend([
        "-odir",
        params.get("output_dir", None)
    ])
    cargs.extend([
        "-workdir",
        params.get("work_dir", None)
    ])
    if params.get("no_clean", False):
        cargs.append("-no_clean")
    return cargs


def v__suma_reprefixize_spec_outputs(
    params: VSumaReprefixizeSpecParameters,
    execution: Execution,
) -> VSumaReprefixizeSpecOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VSumaReprefixizeSpecOutputs(
        root=execution.output_file("."),
    )
    return ret


def v__suma_reprefixize_spec_execute(
    params: VSumaReprefixizeSpecParameters,
    runner: Runner | None = None,
) -> VSumaReprefixizeSpecOutputs:
    """
    @suma_reprefixize_spec
    
    A tool for prefixing and working with SUMA specification files.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VSumaReprefixizeSpecOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__SUMA_REPREFIXIZE_SPEC_METADATA)
    params = execution.params(params)
    cargs = v__suma_reprefixize_spec_cargs(params, execution)
    ret = v__suma_reprefixize_spec_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__suma_reprefixize_spec(
    input_file: InputPathType,
    prefix: str,
    output_dir: str,
    work_dir: str,
    no_clean: bool = False,
    runner: Runner | None = None,
) -> VSumaReprefixizeSpecOutputs:
    """
    @suma_reprefixize_spec
    
    A tool for prefixing and working with SUMA specification files.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_file: Input SUMA specification file.
        prefix: Prefix to be added to the file names.
        output_dir: Output directory where the prefixed files will be saved.
        work_dir: Working directory for temporary files.
        no_clean: Flag to avoid cleaning temporary files.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VSumaReprefixizeSpecOutputs`).
    """
    params = v__suma_reprefixize_spec_params(
        input_file=input_file,
        prefix=prefix,
        output_dir=output_dir,
        work_dir=work_dir,
        no_clean=no_clean,
    )
    return v__suma_reprefixize_spec_execute(params, runner)


__all__ = [
    "VSumaReprefixizeSpecOutputs",
    "V__SUMA_REPREFIXIZE_SPEC_METADATA",
    "v__suma_reprefixize_spec",
    "v__suma_reprefixize_spec_execute",
    "v__suma_reprefixize_spec_params",
]
