# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__T1SCALE_METADATA = Metadata(
    id="47d59aac1ea3196ec67f51d01cd720d77bd6e68c.boutiques",
    name="@T1scale",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VT1scaleParameters = typing.TypedDict('VT1scaleParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@T1scale"]],
    "t1_volume": InputPathType,
    "pd_volume": typing.NotRequired[InputPathType | None],
    "output_directory": typing.NotRequired[str | None],
    "align": bool,
    "mask": typing.NotRequired[InputPathType | None],
    "head_mask": bool,
    "unmasked_uni": bool,
    "masked_uni": bool,
    "echo": bool,
    "help": bool,
    "h_web": bool,
    "h_view": bool,
    "all_opts": bool,
    "h_find_word": typing.NotRequired[str | None],
})
VT1scaleParametersTagged = typing.TypedDict('VT1scaleParametersTagged', {
    "@type": typing.Literal["afni/@T1scale"],
    "t1_volume": InputPathType,
    "pd_volume": typing.NotRequired[InputPathType | None],
    "output_directory": typing.NotRequired[str | None],
    "align": bool,
    "mask": typing.NotRequired[InputPathType | None],
    "head_mask": bool,
    "unmasked_uni": bool,
    "masked_uni": bool,
    "echo": bool,
    "help": bool,
    "h_web": bool,
    "h_view": bool,
    "all_opts": bool,
    "h_find_word": typing.NotRequired[str | None],
})


class VT1scaleOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VT1scaleParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    uniformized_t1_output: OutputPathType
    """Uniformized T1 volume output file"""
    masked_uniformized_t1_output: OutputPathType
    """Masked Uniformized T1 volume output file"""
    aligned_pd_output: OutputPathType
    """Aligned PD volume output file in alignment with T1+orig"""


def v__t1scale_params(
    t1_volume: InputPathType,
    pd_volume: InputPathType | None = None,
    output_directory: str | None = None,
    align: bool = False,
    mask: InputPathType | None = None,
    head_mask: bool = False,
    unmasked_uni: bool = False,
    masked_uni: bool = False,
    echo: bool = False,
    help_: bool = False,
    h_web: bool = False,
    h_view: bool = False,
    all_opts: bool = False,
    h_find_word: str | None = None,
) -> VT1scaleParametersTagged:
    """
    Build parameters.
    
    Args:
        t1_volume: The T1 volume.
        pd_volume: The PD volume (aligned to T1).
        output_directory: Directory where output gets dumped. Default is\
            T1scale/.
        align: Align PD volume to T1. Without this option, PDvol is assumed in\
            alignment with T1vol.
        mask: Create mask for the output. If not specified, the script will\
            generate one with 3dAutomask on fattened PDvol.
        head_mask: Create mask using 3dSkullStrip's -head option.
        unmasked_uni: Do not apply masking to uniformized volume (default).
        masked_uni: Apply masking to uniformized volume.
        echo: Set echo.
        help_: Display this help message and exit.
        h_web: Open webpage with help for this program.
        h_view: Open -help output in a GUI editor.
        all_opts: List all of the options for this script.
        h_find_word: Search for lines containing WORD in -help output. Search\
            is approximate.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@T1scale",
        "t1_volume": t1_volume,
        "align": align,
        "head_mask": head_mask,
        "unmasked_uni": unmasked_uni,
        "masked_uni": masked_uni,
        "echo": echo,
        "help": help_,
        "h_web": h_web,
        "h_view": h_view,
        "all_opts": all_opts,
    }
    if pd_volume is not None:
        params["pd_volume"] = pd_volume
    if output_directory is not None:
        params["output_directory"] = output_directory
    if mask is not None:
        params["mask"] = mask
    if h_find_word is not None:
        params["h_find_word"] = h_find_word
    return params


def v__t1scale_cargs(
    params: VT1scaleParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@T1scale")
    cargs.extend([
        "-T1",
        execution.input_file(params.get("t1_volume", None))
    ])
    if params.get("pd_volume", None) is not None:
        cargs.extend([
            "-PD",
            execution.input_file(params.get("pd_volume", None))
        ])
    if params.get("output_directory", None) is not None:
        cargs.extend([
            "-odir",
            params.get("output_directory", None)
        ])
    if params.get("align", False):
        cargs.append("-align")
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask", None))
        ])
    if params.get("head_mask", False):
        cargs.append("-head_mask")
    if params.get("unmasked_uni", False):
        cargs.append("-unmasked_uni")
    if params.get("masked_uni", False):
        cargs.append("-masked_uni")
    if params.get("echo", False):
        cargs.append("-echo")
    if params.get("help", False):
        cargs.append("-help")
    if params.get("h_web", False):
        cargs.append("-h_web")
    if params.get("h_view", False):
        cargs.append("-hview")
    if params.get("all_opts", False):
        cargs.append("-all_opts")
    if params.get("h_find_word", None) is not None:
        cargs.extend([
            "-h_find",
            params.get("h_find_word", None)
        ])
    return cargs


def v__t1scale_outputs(
    params: VT1scaleParameters,
    execution: Execution,
) -> VT1scaleOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VT1scaleOutputs(
        root=execution.output_file("."),
        uniformized_t1_output=execution.output_file("T1.uni+orig"),
        masked_uniformized_t1_output=execution.output_file("T1_uni_masked+orig"),
        aligned_pd_output=execution.output_file("PD+orig"),
    )
    return ret


def v__t1scale_execute(
    params: VT1scaleParameters,
    runner: Runner | None = None,
) -> VT1scaleOutputs:
    """
    @T1scale
    
    Fix bias field shading in T1 by scaling it with PD image. You can also get a
    decent result even without the PD volume.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VT1scaleOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__T1SCALE_METADATA)
    params = execution.params(params)
    cargs = v__t1scale_cargs(params, execution)
    ret = v__t1scale_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__t1scale(
    t1_volume: InputPathType,
    pd_volume: InputPathType | None = None,
    output_directory: str | None = None,
    align: bool = False,
    mask: InputPathType | None = None,
    head_mask: bool = False,
    unmasked_uni: bool = False,
    masked_uni: bool = False,
    echo: bool = False,
    help_: bool = False,
    h_web: bool = False,
    h_view: bool = False,
    all_opts: bool = False,
    h_find_word: str | None = None,
    runner: Runner | None = None,
) -> VT1scaleOutputs:
    """
    @T1scale
    
    Fix bias field shading in T1 by scaling it with PD image. You can also get a
    decent result even without the PD volume.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        t1_volume: The T1 volume.
        pd_volume: The PD volume (aligned to T1).
        output_directory: Directory where output gets dumped. Default is\
            T1scale/.
        align: Align PD volume to T1. Without this option, PDvol is assumed in\
            alignment with T1vol.
        mask: Create mask for the output. If not specified, the script will\
            generate one with 3dAutomask on fattened PDvol.
        head_mask: Create mask using 3dSkullStrip's -head option.
        unmasked_uni: Do not apply masking to uniformized volume (default).
        masked_uni: Apply masking to uniformized volume.
        echo: Set echo.
        help_: Display this help message and exit.
        h_web: Open webpage with help for this program.
        h_view: Open -help output in a GUI editor.
        all_opts: List all of the options for this script.
        h_find_word: Search for lines containing WORD in -help output. Search\
            is approximate.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VT1scaleOutputs`).
    """
    params = v__t1scale_params(
        t1_volume=t1_volume,
        pd_volume=pd_volume,
        output_directory=output_directory,
        align=align,
        mask=mask,
        head_mask=head_mask,
        unmasked_uni=unmasked_uni,
        masked_uni=masked_uni,
        echo=echo,
        help_=help_,
        h_web=h_web,
        h_view=h_view,
        all_opts=all_opts,
        h_find_word=h_find_word,
    )
    return v__t1scale_execute(params, runner)


__all__ = [
    "VT1scaleOutputs",
    "V__T1SCALE_METADATA",
    "v__t1scale",
    "v__t1scale_execute",
    "v__t1scale_params",
]
