# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__TIME_DIFF_METADATA = Metadata(
    id="7e8bc6e92b918a3b7096b6a3812790f55706dc50.boutiques",
    name="@TimeDiff",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VTimeDiffParameters = typing.TypedDict('VTimeDiffParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@TimeDiff"]],
    "file1": InputPathType,
    "file2": InputPathType,
})
VTimeDiffParametersTagged = typing.TypedDict('VTimeDiffParametersTagged', {
    "@type": typing.Literal["afni/@TimeDiff"],
    "file1": InputPathType,
    "file2": InputPathType,
})


class VTimeDiffOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VTimeDiffParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v__time_diff_params(
    file1: InputPathType,
    file2: InputPathType,
) -> VTimeDiffParametersTagged:
    """
    Build parameters.
    
    Args:
        file1: First file to compare (e.g., file1.txt).
        file2: Second file to compare (e.g., file2.txt).
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@TimeDiff",
        "file1": file1,
        "file2": file2,
    }
    return params


def v__time_diff_cargs(
    params: VTimeDiffParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@TimeDiff")
    cargs.append(execution.input_file(params.get("file1", None)))
    cargs.append(execution.input_file(params.get("file2", None)))
    return cargs


def v__time_diff_outputs(
    params: VTimeDiffParameters,
    execution: Execution,
) -> VTimeDiffOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VTimeDiffOutputs(
        root=execution.output_file("."),
    )
    return ret


def v__time_diff_execute(
    params: VTimeDiffParameters,
    runner: Runner | None = None,
) -> VTimeDiffOutputs:
    """
    @TimeDiff
    
    A tool to compare the modification times of two files.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VTimeDiffOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__TIME_DIFF_METADATA)
    params = execution.params(params)
    cargs = v__time_diff_cargs(params, execution)
    ret = v__time_diff_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__time_diff(
    file1: InputPathType,
    file2: InputPathType,
    runner: Runner | None = None,
) -> VTimeDiffOutputs:
    """
    @TimeDiff
    
    A tool to compare the modification times of two files.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        file1: First file to compare (e.g., file1.txt).
        file2: Second file to compare (e.g., file2.txt).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VTimeDiffOutputs`).
    """
    params = v__time_diff_params(
        file1=file1,
        file2=file2,
    )
    return v__time_diff_execute(params, runner)


__all__ = [
    "VTimeDiffOutputs",
    "V__TIME_DIFF_METADATA",
    "v__time_diff",
    "v__time_diff_execute",
    "v__time_diff_params",
]
