# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__TO_MNI_AWARP_METADATA = Metadata(
    id="b6d7b0fa8121b6538d215cd65437e4218af3eeba.boutiques",
    name="@toMNI_Awarp",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VToMniAwarpParameters = typing.TypedDict('VToMniAwarpParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@toMNI_Awarp"]],
    "directory": str,
    "datasets": list[InputPathType],
})
VToMniAwarpParametersTagged = typing.TypedDict('VToMniAwarpParametersTagged', {
    "@type": typing.Literal["afni/@toMNI_Awarp"],
    "directory": str,
    "datasets": list[InputPathType],
})


class VToMniAwarpOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VToMniAwarpParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v__to_mni_awarp_params(
    directory: str,
    datasets: list[InputPathType],
) -> VToMniAwarpParametersTagged:
    """
    Build parameters.
    
    Args:
        directory: Name of the directory to be created where results will be\
            stored.
        datasets: List of datasets to be transformed.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@toMNI_Awarp",
        "directory": directory,
        "datasets": datasets,
    }
    return params


def v__to_mni_awarp_cargs(
    params: VToMniAwarpParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@toMNI_Awarp")
    cargs.append(params.get("directory", None))
    cargs.extend([execution.input_file(f) for f in params.get("datasets", None)])
    return cargs


def v__to_mni_awarp_outputs(
    params: VToMniAwarpParameters,
    execution: Execution,
) -> VToMniAwarpOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VToMniAwarpOutputs(
        root=execution.output_file("."),
    )
    return ret


def v__to_mni_awarp_execute(
    params: VToMniAwarpParameters,
    runner: Runner | None = None,
) -> VToMniAwarpOutputs:
    """
    @toMNI_Awarp
    
    Transforms skull-stripped datasets to 1x1x1 mm MNI space using an affine
    transformation.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VToMniAwarpOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__TO_MNI_AWARP_METADATA)
    params = execution.params(params)
    cargs = v__to_mni_awarp_cargs(params, execution)
    ret = v__to_mni_awarp_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__to_mni_awarp(
    directory: str,
    datasets: list[InputPathType],
    runner: Runner | None = None,
) -> VToMniAwarpOutputs:
    """
    @toMNI_Awarp
    
    Transforms skull-stripped datasets to 1x1x1 mm MNI space using an affine
    transformation.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        directory: Name of the directory to be created where results will be\
            stored.
        datasets: List of datasets to be transformed.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VToMniAwarpOutputs`).
    """
    params = v__to_mni_awarp_params(
        directory=directory,
        datasets=datasets,
    )
    return v__to_mni_awarp_execute(params, runner)


__all__ = [
    "VToMniAwarpOutputs",
    "V__TO_MNI_AWARP_METADATA",
    "v__to_mni_awarp",
    "v__to_mni_awarp_execute",
    "v__to_mni_awarp_params",
]
