# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__TO_MNI_QWARPAR_METADATA = Metadata(
    id="1ce3dc3cb10706fa779cd607ed5bb0e310f90806.boutiques",
    name="@toMNI_Qwarpar",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VToMniQwarparParameters = typing.TypedDict('VToMniQwarparParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@toMNI_Qwarpar"]],
    "numcpu": float,
    "numjob": float,
})
VToMniQwarparParametersTagged = typing.TypedDict('VToMniQwarparParametersTagged', {
    "@type": typing.Literal["afni/@toMNI_Qwarpar"],
    "numcpu": float,
    "numjob": float,
})


class VToMniQwarparOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VToMniQwarparParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType
    """Output dataset created after processing."""


def v__to_mni_qwarpar_params(
    numcpu: float,
    numjob: float,
) -> VToMniQwarparParametersTagged:
    """
    Build parameters.
    
    Args:
        numcpu: TOTAL NUMBER OF CPUS TO USE; should not exceed the number of\
            CPUs (cores) on the system.
        numjob: MAX NUMBER OF JOBS TO USE; often set to the same value as\
            numcpu so that 1 dataset is processed in 1 core.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@toMNI_Qwarpar",
        "numcpu": numcpu,
        "numjob": numjob,
    }
    return params


def v__to_mni_qwarpar_cargs(
    params: VToMniQwarparParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@toMNI_Qwarpar")
    cargs.append(str(params.get("numcpu", None)))
    cargs.append(str(params.get("numjob", None)))
    return cargs


def v__to_mni_qwarpar_outputs(
    params: VToMniQwarparParameters,
    execution: Execution,
) -> VToMniQwarparOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VToMniQwarparOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file("uni+tlrc.HEAD"),
    )
    return ret


def v__to_mni_qwarpar_execute(
    params: VToMniQwarparParameters,
    runner: Runner | None = None,
) -> VToMniQwarparOutputs:
    """
    @toMNI_Qwarpar
    
    Transforms datasets to MNI space, then collectively re-transforms them to
    produce a refined average.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VToMniQwarparOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__TO_MNI_QWARPAR_METADATA)
    params = execution.params(params)
    cargs = v__to_mni_qwarpar_cargs(params, execution)
    ret = v__to_mni_qwarpar_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__to_mni_qwarpar(
    numcpu: float,
    numjob: float,
    runner: Runner | None = None,
) -> VToMniQwarparOutputs:
    """
    @toMNI_Qwarpar
    
    Transforms datasets to MNI space, then collectively re-transforms them to
    produce a refined average.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        numcpu: TOTAL NUMBER OF CPUS TO USE; should not exceed the number of\
            CPUs (cores) on the system.
        numjob: MAX NUMBER OF JOBS TO USE; often set to the same value as\
            numcpu so that 1 dataset is processed in 1 core.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VToMniQwarparOutputs`).
    """
    params = v__to_mni_qwarpar_params(
        numcpu=numcpu,
        numjob=numjob,
    )
    return v__to_mni_qwarpar_execute(params, runner)


__all__ = [
    "VToMniQwarparOutputs",
    "V__TO_MNI_QWARPAR_METADATA",
    "v__to_mni_qwarpar",
    "v__to_mni_qwarpar_execute",
    "v__to_mni_qwarpar_params",
]
