# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__TO_RAI_METADATA = Metadata(
    id="024583cd57fcfddfb771a0c795047e59fba1411f.boutiques",
    name="@ToRAI",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VToRaiParameters = typing.TypedDict('VToRaiParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@ToRAI"]],
    "coordinates": list[float],
    "orientation": str,
})
VToRaiParametersTagged = typing.TypedDict('VToRaiParametersTagged', {
    "@type": typing.Literal["afni/@ToRAI"],
    "coordinates": list[float],
    "orientation": str,
})


class VToRaiOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VToRaiParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v__to_rai_params(
    coordinates: list[float],
    orientation: str,
) -> VToRaiParametersTagged:
    """
    Build parameters.
    
    Args:
        coordinates: Specify the X, Y, and Z coordinates.
        orientation: Specify the orientation.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@ToRAI",
        "coordinates": coordinates,
        "orientation": orientation,
    }
    return params


def v__to_rai_cargs(
    params: VToRaiParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@ToRAI")
    cargs.extend([
        "-xyz",
        *map(str, params.get("coordinates", None))
    ])
    cargs.extend([
        "-or",
        params.get("orientation", None)
    ])
    return cargs


def v__to_rai_outputs(
    params: VToRaiParameters,
    execution: Execution,
) -> VToRaiOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VToRaiOutputs(
        root=execution.output_file("."),
    )
    return ret


def v__to_rai_execute(
    params: VToRaiParameters,
    runner: Runner | None = None,
) -> VToRaiOutputs:
    """
    @ToRAI
    
    Tool to change the ORIENT coordinates to RAI.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VToRaiOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__TO_RAI_METADATA)
    params = execution.params(params)
    cargs = v__to_rai_cargs(params, execution)
    ret = v__to_rai_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__to_rai(
    coordinates: list[float],
    orientation: str,
    runner: Runner | None = None,
) -> VToRaiOutputs:
    """
    @ToRAI
    
    Tool to change the ORIENT coordinates to RAI.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        coordinates: Specify the X, Y, and Z coordinates.
        orientation: Specify the orientation.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VToRaiOutputs`).
    """
    params = v__to_rai_params(
        coordinates=coordinates,
        orientation=orientation,
    )
    return v__to_rai_execute(params, runner)


__all__ = [
    "VToRaiOutputs",
    "V__TO_RAI_METADATA",
    "v__to_rai",
    "v__to_rai_execute",
    "v__to_rai_params",
]
