# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__VOL_CENTER_METADATA = Metadata(
    id="6057d3213d321732bc8f15f10b6aef3f38c82e7d.boutiques",
    name="@VolCenter",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VVolCenterParameters = typing.TypedDict('VVolCenterParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@VolCenter"]],
    "dset": InputPathType,
    "orient": typing.NotRequired[str | None],
})
VVolCenterParametersTagged = typing.TypedDict('VVolCenterParametersTagged', {
    "@type": typing.Literal["afni/@VolCenter"],
    "dset": InputPathType,
    "orient": typing.NotRequired[str | None],
})


class VVolCenterOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VVolCenterParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v__vol_center_params(
    dset: InputPathType,
    orient: str | None = None,
) -> VVolCenterParametersTagged:
    """
    Build parameters.
    
    Args:
        dset: Input volume dataset.
        orient: Output coordinate system orientation (e.g., RAI).
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@VolCenter",
        "dset": dset,
    }
    if orient is not None:
        params["orient"] = orient
    return params


def v__vol_center_cargs(
    params: VVolCenterParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@VolCenter")
    cargs.extend([
        "-dset",
        execution.input_file(params.get("dset", None))
    ])
    if params.get("orient", None) is not None:
        cargs.extend([
            "-or",
            params.get("orient", None)
        ])
    return cargs


def v__vol_center_outputs(
    params: VVolCenterParameters,
    execution: Execution,
) -> VVolCenterOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VVolCenterOutputs(
        root=execution.output_file("."),
    )
    return ret


def v__vol_center_execute(
    params: VVolCenterParameters,
    runner: Runner | None = None,
) -> VVolCenterOutputs:
    """
    @VolCenter
    
    Tool to return the center of volume for a given dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VVolCenterOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__VOL_CENTER_METADATA)
    params = execution.params(params)
    cargs = v__vol_center_cargs(params, execution)
    ret = v__vol_center_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__vol_center(
    dset: InputPathType,
    orient: str | None = None,
    runner: Runner | None = None,
) -> VVolCenterOutputs:
    """
    @VolCenter
    
    Tool to return the center of volume for a given dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dset: Input volume dataset.
        orient: Output coordinate system orientation (e.g., RAI).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VVolCenterOutputs`).
    """
    params = v__vol_center_params(
        dset=dset,
        orient=orient,
    )
    return v__vol_center_execute(params, runner)


__all__ = [
    "VVolCenterOutputs",
    "V__VOL_CENTER_METADATA",
    "v__vol_center",
    "v__vol_center_execute",
    "v__vol_center_params",
]
