# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

VECWARP_METADATA = Metadata(
    id="eee2d3334c6ced0ad01d689ccca832cba4f16ad5.boutiques",
    name="Vecwarp",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VecwarpParameters = typing.TypedDict('VecwarpParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/Vecwarp"]],
    "apar": typing.NotRequired[InputPathType | None],
    "matvec": typing.NotRequired[InputPathType | None],
    "forward": bool,
    "backward": bool,
    "input": typing.NotRequired[InputPathType | None],
    "output": typing.NotRequired[str | None],
    "force": bool,
})
VecwarpParametersTagged = typing.TypedDict('VecwarpParametersTagged', {
    "@type": typing.Literal["afni/Vecwarp"],
    "apar": typing.NotRequired[InputPathType | None],
    "matvec": typing.NotRequired[InputPathType | None],
    "forward": bool,
    "backward": bool,
    "input": typing.NotRequired[InputPathType | None],
    "output": typing.NotRequired[str | None],
    "force": bool,
})


class VecwarpOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VecwarpParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType | None
    """The output file containing the transformed 3-vectors."""


def vecwarp_params(
    apar: InputPathType | None = None,
    matvec: InputPathType | None = None,
    forward: bool = False,
    backward: bool = False,
    input_: InputPathType | None = None,
    output: str | None = None,
    force: bool = False,
) -> VecwarpParametersTagged:
    """
    Build parameters.
    
    Args:
        apar: Use the AFNI dataset 'aaa' as the source of the transformation;\
            this dataset must be in +acpc or +tlrc coordinates, and must contain\
            the attributes WARP_TYPE and WARP_DATA which describe the forward\
            transformation from +orig coordinates to the 'aaa' coordinate system.
        matvec: Read an affine transformation matrix-vector from file 'mmm',\
            which must be in the specified format.
        forward: To apply the forward transformation. If neither -forward nor\
            -backward is given, -forward is the default.
        backward: To apply the backward transformation.
        input_: Read input 3-vectors from the file 'iii' (from stdin if 'iii'\
            is '-' or the -input option is missing).
        output: Write the output to file 'ooo' (to stdout if 'ooo' is '-', or\
            if the -output option is missing).
        force: If the output file already exists, use -force to overwrite it.\
            If -force is used, it must come before -output on the command line.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/Vecwarp",
        "forward": forward,
        "backward": backward,
        "force": force,
    }
    if apar is not None:
        params["apar"] = apar
    if matvec is not None:
        params["matvec"] = matvec
    if input_ is not None:
        params["input"] = input_
    if output is not None:
        params["output"] = output
    return params


def vecwarp_cargs(
    params: VecwarpParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("Vecwarp")
    if params.get("apar", None) is not None:
        cargs.extend([
            "-apar",
            execution.input_file(params.get("apar", None))
        ])
    if params.get("matvec", None) is not None:
        cargs.extend([
            "-matvec",
            execution.input_file(params.get("matvec", None))
        ])
    if params.get("forward", False):
        cargs.append("-forward")
    if params.get("backward", False):
        cargs.append("-backward")
    if params.get("input", None) is not None:
        cargs.extend([
            "-input",
            execution.input_file(params.get("input", None))
        ])
    if params.get("output", None) is not None:
        cargs.extend([
            "-output",
            params.get("output", None)
        ])
    if params.get("force", False):
        cargs.append("-force")
    return cargs


def vecwarp_outputs(
    params: VecwarpParameters,
    execution: Execution,
) -> VecwarpOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VecwarpOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file(params.get("output", None)) if (params.get("output") is not None) else None,
    )
    return ret


def vecwarp_execute(
    params: VecwarpParameters,
    runner: Runner | None = None,
) -> VecwarpOutputs:
    """
    Vecwarp
    
    Transforms (warps) a list of 3-vectors into another list of 3-vectors
    according to the specified options.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VecwarpOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(VECWARP_METADATA)
    params = execution.params(params)
    cargs = vecwarp_cargs(params, execution)
    ret = vecwarp_outputs(params, execution)
    execution.run(cargs)
    return ret


def vecwarp(
    apar: InputPathType | None = None,
    matvec: InputPathType | None = None,
    forward: bool = False,
    backward: bool = False,
    input_: InputPathType | None = None,
    output: str | None = None,
    force: bool = False,
    runner: Runner | None = None,
) -> VecwarpOutputs:
    """
    Vecwarp
    
    Transforms (warps) a list of 3-vectors into another list of 3-vectors
    according to the specified options.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        apar: Use the AFNI dataset 'aaa' as the source of the transformation;\
            this dataset must be in +acpc or +tlrc coordinates, and must contain\
            the attributes WARP_TYPE and WARP_DATA which describe the forward\
            transformation from +orig coordinates to the 'aaa' coordinate system.
        matvec: Read an affine transformation matrix-vector from file 'mmm',\
            which must be in the specified format.
        forward: To apply the forward transformation. If neither -forward nor\
            -backward is given, -forward is the default.
        backward: To apply the backward transformation.
        input_: Read input 3-vectors from the file 'iii' (from stdin if 'iii'\
            is '-' or the -input option is missing).
        output: Write the output to file 'ooo' (to stdout if 'ooo' is '-', or\
            if the -output option is missing).
        force: If the output file already exists, use -force to overwrite it.\
            If -force is used, it must come before -output on the command line.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VecwarpOutputs`).
    """
    params = vecwarp_params(
        apar=apar,
        matvec=matvec,
        forward=forward,
        backward=backward,
        input_=input_,
        output=output,
        force=force,
    )
    return vecwarp_execute(params, runner)


__all__ = [
    "VECWARP_METADATA",
    "VecwarpOutputs",
    "vecwarp",
    "vecwarp_execute",
    "vecwarp_params",
]
