# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

WAVER_METADATA = Metadata(
    id="87f8c0d04d3c90a12e2c0e2447ae75e4bde1b7e0.boutiques",
    name="waver",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


WaverParameters = typing.TypedDict('WaverParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/waver"]],
    "wav": bool,
    "gam": bool,
    "expr": typing.NotRequired[str | None],
    "file_opt": typing.NotRequired[str | None],
    "delay_time": typing.NotRequired[float | None],
    "rise_time": typing.NotRequired[float | None],
    "fall_time": typing.NotRequired[float | None],
    "undershoot": typing.NotRequired[float | None],
    "restore_time": typing.NotRequired[float | None],
    "gamb": typing.NotRequired[float | None],
    "gamc": typing.NotRequired[float | None],
    "gamd": typing.NotRequired[float | None],
    "peak": typing.NotRequired[float | None],
    "dt": typing.NotRequired[float | None],
    "tr": typing.NotRequired[float | None],
    "xyout": bool,
    "input_file": typing.NotRequired[InputPathType | None],
    "inline_data": typing.NotRequired[str | None],
    "tstim_data": typing.NotRequired[str | None],
    "when_data": typing.NotRequired[str | None],
    "numout": typing.NotRequired[int | None],
    "ver_flag": bool,
})
WaverParametersTagged = typing.TypedDict('WaverParametersTagged', {
    "@type": typing.Literal["afni/waver"],
    "wav": bool,
    "gam": bool,
    "expr": typing.NotRequired[str | None],
    "file_opt": typing.NotRequired[str | None],
    "delay_time": typing.NotRequired[float | None],
    "rise_time": typing.NotRequired[float | None],
    "fall_time": typing.NotRequired[float | None],
    "undershoot": typing.NotRequired[float | None],
    "restore_time": typing.NotRequired[float | None],
    "gamb": typing.NotRequired[float | None],
    "gamc": typing.NotRequired[float | None],
    "gamd": typing.NotRequired[float | None],
    "peak": typing.NotRequired[float | None],
    "dt": typing.NotRequired[float | None],
    "tr": typing.NotRequired[float | None],
    "xyout": bool,
    "input_file": typing.NotRequired[InputPathType | None],
    "inline_data": typing.NotRequired[str | None],
    "tstim_data": typing.NotRequired[str | None],
    "when_data": typing.NotRequired[str | None],
    "numout": typing.NotRequired[int | None],
    "ver_flag": bool,
})


class WaverOutputs(typing.NamedTuple):
    """
    Output object returned when calling `WaverParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_filename: OutputPathType
    """The output filename for the result of the waveform."""


def waver_params(
    wav: bool = False,
    gam: bool = False,
    expr: str | None = None,
    file_opt: str | None = None,
    delay_time: float | None = None,
    rise_time: float | None = None,
    fall_time: float | None = None,
    undershoot: float | None = None,
    restore_time: float | None = None,
    gamb: float | None = None,
    gamc: float | None = None,
    gamd: float | None = None,
    peak: float | None = None,
    dt: float | None = None,
    tr: float | None = None,
    xyout: bool = False,
    input_file: InputPathType | None = None,
    inline_data: str | None = None,
    tstim_data: str | None = None,
    when_data: str | None = None,
    numout: int | None = None,
    ver_flag: bool = False,
) -> WaverParametersTagged:
    """
    Build parameters.
    
    Args:
        wav: Sets waveform to Cox special [default].
        gam: Sets waveform to form t^b * exp(-t/c) (cf. Mark Cohen).
        expr: Sets waveform to the expression given, which should depend on the\
            variable 't'.
        file_opt: Sets waveform to the values read from the file wname, which\
            should be a single column .1D file. The dt value is the time step (in\
            seconds) between lines in wname.
        delay_time: Sets delay time to # seconds [2].
        rise_time: Sets rise time to # seconds [4].
        fall_time: Sets fall time to # seconds [6].
        undershoot: Sets undershoot to # times the peak [0.2].
        restore_time: Sets time to restore from undershoot [2].
        gamb: Sets the parameter 'b' to # [8.6].
        gamc: Sets the parameter 'c' to # [0.547].
        gamd: Sets the delay time to # seconds [0.0].
        peak: Sets peak value to # [100].
        dt: Sets time step of output AND input [0.1].
        tr: '-TR' is equivalent to '-dt'.
        xyout: Output data in 2 columns: 1=time 2=waveform (useful for\
            graphing) [default is 1 column=waveform].
        input_file: Read timeseries from *.1D formatted 'infile'; convolve with\
            waveform to produce output.
        inline_data: Read timeseries from command line DATA; convolve with\
            waveform to produce output.
        tstim_data: Read discrete stimulation times from the command line and\
            convolve the waveform with delta-functions at those times.
        when_data: Read time blocks when stimulus is 'on' (=1) from the command\
            line and convolve the waveform with with a zero-one input.
        numout: Output a timeseries with NN points; if this option is not\
            given, then enough points are output to let the result tail back down\
            to zero.
        ver_flag: Output version information and exit.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/waver",
        "wav": wav,
        "gam": gam,
        "xyout": xyout,
        "ver_flag": ver_flag,
    }
    if expr is not None:
        params["expr"] = expr
    if file_opt is not None:
        params["file_opt"] = file_opt
    if delay_time is not None:
        params["delay_time"] = delay_time
    if rise_time is not None:
        params["rise_time"] = rise_time
    if fall_time is not None:
        params["fall_time"] = fall_time
    if undershoot is not None:
        params["undershoot"] = undershoot
    if restore_time is not None:
        params["restore_time"] = restore_time
    if gamb is not None:
        params["gamb"] = gamb
    if gamc is not None:
        params["gamc"] = gamc
    if gamd is not None:
        params["gamd"] = gamd
    if peak is not None:
        params["peak"] = peak
    if dt is not None:
        params["dt"] = dt
    if tr is not None:
        params["tr"] = tr
    if input_file is not None:
        params["input_file"] = input_file
    if inline_data is not None:
        params["inline_data"] = inline_data
    if tstim_data is not None:
        params["tstim_data"] = tstim_data
    if when_data is not None:
        params["when_data"] = when_data
    if numout is not None:
        params["numout"] = numout
    return params


def waver_cargs(
    params: WaverParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("waver")
    if params.get("wav", False):
        cargs.append("-WAV")
    if params.get("gam", False):
        cargs.append("-GAM")
    if params.get("expr", None) is not None:
        cargs.extend([
            "-EXPR",
            params.get("expr", None)
        ])
    if params.get("file_opt", None) is not None:
        cargs.extend([
            "-FILE",
            params.get("file_opt", None)
        ])
    if params.get("delay_time", None) is not None:
        cargs.extend([
            "-delaytime",
            str(params.get("delay_time", None))
        ])
    if params.get("rise_time", None) is not None:
        cargs.extend([
            "-risetime",
            str(params.get("rise_time", None))
        ])
    if params.get("fall_time", None) is not None:
        cargs.extend([
            "-falltime",
            str(params.get("fall_time", None))
        ])
    if params.get("undershoot", None) is not None:
        cargs.extend([
            "-undershoot",
            str(params.get("undershoot", None))
        ])
    if params.get("restore_time", None) is not None:
        cargs.extend([
            "-restoretime",
            str(params.get("restore_time", None))
        ])
    if params.get("gamb", None) is not None:
        cargs.extend([
            "-gamb",
            str(params.get("gamb", None))
        ])
    if params.get("gamc", None) is not None:
        cargs.extend([
            "-gamc",
            str(params.get("gamc", None))
        ])
    if params.get("gamd", None) is not None:
        cargs.extend([
            "-gamd",
            str(params.get("gamd", None))
        ])
    if params.get("peak", None) is not None:
        cargs.extend([
            "-peak",
            str(params.get("peak", None))
        ])
    if params.get("dt", None) is not None:
        cargs.extend([
            "-dt",
            str(params.get("dt", None))
        ])
    if params.get("tr", None) is not None:
        cargs.extend([
            "-TR",
            str(params.get("tr", None))
        ])
    if params.get("xyout", False):
        cargs.append("-xyout")
    if params.get("input_file", None) is not None:
        cargs.extend([
            "-input",
            execution.input_file(params.get("input_file", None))
        ])
    if params.get("inline_data", None) is not None:
        cargs.extend([
            "-inline",
            params.get("inline_data", None)
        ])
    if params.get("tstim_data", None) is not None:
        cargs.extend([
            "-tstim",
            params.get("tstim_data", None)
        ])
    if params.get("when_data", None) is not None:
        cargs.extend([
            "-when",
            params.get("when_data", None)
        ])
    if params.get("numout", None) is not None:
        cargs.extend([
            "-numout",
            str(params.get("numout", None))
        ])
    if params.get("ver_flag", False):
        cargs.append("-ver")
    return cargs


def waver_outputs(
    params: WaverParameters,
    execution: Execution,
) -> WaverOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = WaverOutputs(
        root=execution.output_file("."),
        output_filename=execution.output_file("output_filename"),
    )
    return ret


def waver_execute(
    params: WaverParameters,
    runner: Runner | None = None,
) -> WaverOutputs:
    """
    waver
    
    Creates an ideal waveform timeseries file.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `WaverOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(WAVER_METADATA)
    params = execution.params(params)
    cargs = waver_cargs(params, execution)
    ret = waver_outputs(params, execution)
    execution.run(cargs)
    return ret


def waver(
    wav: bool = False,
    gam: bool = False,
    expr: str | None = None,
    file_opt: str | None = None,
    delay_time: float | None = None,
    rise_time: float | None = None,
    fall_time: float | None = None,
    undershoot: float | None = None,
    restore_time: float | None = None,
    gamb: float | None = None,
    gamc: float | None = None,
    gamd: float | None = None,
    peak: float | None = None,
    dt: float | None = None,
    tr: float | None = None,
    xyout: bool = False,
    input_file: InputPathType | None = None,
    inline_data: str | None = None,
    tstim_data: str | None = None,
    when_data: str | None = None,
    numout: int | None = None,
    ver_flag: bool = False,
    runner: Runner | None = None,
) -> WaverOutputs:
    """
    waver
    
    Creates an ideal waveform timeseries file.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        wav: Sets waveform to Cox special [default].
        gam: Sets waveform to form t^b * exp(-t/c) (cf. Mark Cohen).
        expr: Sets waveform to the expression given, which should depend on the\
            variable 't'.
        file_opt: Sets waveform to the values read from the file wname, which\
            should be a single column .1D file. The dt value is the time step (in\
            seconds) between lines in wname.
        delay_time: Sets delay time to # seconds [2].
        rise_time: Sets rise time to # seconds [4].
        fall_time: Sets fall time to # seconds [6].
        undershoot: Sets undershoot to # times the peak [0.2].
        restore_time: Sets time to restore from undershoot [2].
        gamb: Sets the parameter 'b' to # [8.6].
        gamc: Sets the parameter 'c' to # [0.547].
        gamd: Sets the delay time to # seconds [0.0].
        peak: Sets peak value to # [100].
        dt: Sets time step of output AND input [0.1].
        tr: '-TR' is equivalent to '-dt'.
        xyout: Output data in 2 columns: 1=time 2=waveform (useful for\
            graphing) [default is 1 column=waveform].
        input_file: Read timeseries from *.1D formatted 'infile'; convolve with\
            waveform to produce output.
        inline_data: Read timeseries from command line DATA; convolve with\
            waveform to produce output.
        tstim_data: Read discrete stimulation times from the command line and\
            convolve the waveform with delta-functions at those times.
        when_data: Read time blocks when stimulus is 'on' (=1) from the command\
            line and convolve the waveform with with a zero-one input.
        numout: Output a timeseries with NN points; if this option is not\
            given, then enough points are output to let the result tail back down\
            to zero.
        ver_flag: Output version information and exit.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `WaverOutputs`).
    """
    params = waver_params(
        wav=wav,
        gam=gam,
        expr=expr,
        file_opt=file_opt,
        delay_time=delay_time,
        rise_time=rise_time,
        fall_time=fall_time,
        undershoot=undershoot,
        restore_time=restore_time,
        gamb=gamb,
        gamc=gamc,
        gamd=gamd,
        peak=peak,
        dt=dt,
        tr=tr,
        xyout=xyout,
        input_file=input_file,
        inline_data=inline_data,
        tstim_data=tstim_data,
        when_data=when_data,
        numout=numout,
        ver_flag=ver_flag,
    )
    return waver_execute(params, runner)


__all__ = [
    "WAVER_METADATA",
    "WaverOutputs",
    "waver",
    "waver_execute",
    "waver_params",
]
