Module blaxel.core.sandbox.client.models
========================================
Contains all the data models used in inputs/outputs

Sub-modules
-----------
* blaxel.core.sandbox.client.models.delete_network_process_pid_monitor_response_200
* blaxel.core.sandbox.client.models.directory
* blaxel.core.sandbox.client.models.error_response
* blaxel.core.sandbox.client.models.file
* blaxel.core.sandbox.client.models.file_request
* blaxel.core.sandbox.client.models.file_with_content
* blaxel.core.sandbox.client.models.get_network_process_pid_ports_response_200
* blaxel.core.sandbox.client.models.port_monitor_request
* blaxel.core.sandbox.client.models.post_network_process_pid_monitor_response_200
* blaxel.core.sandbox.client.models.process_logs
* blaxel.core.sandbox.client.models.process_request
* blaxel.core.sandbox.client.models.process_request_env
* blaxel.core.sandbox.client.models.process_response
* blaxel.core.sandbox.client.models.process_response_status
* blaxel.core.sandbox.client.models.subdirectory
* blaxel.core.sandbox.client.models.success_response

Classes
-------

`DeleteNetworkProcessPidMonitorResponse200()`
:   Method generated by attrs for class DeleteNetworkProcessPidMonitorResponse200.

    ### Static methods

    `from_dict(src_dict: dict[str, typing.Any]) ‑> ~T`
    :

    ### Instance variables

    `additional_keys: list[str]`
    :

    `additional_properties: dict[str, typing.Any]`
    :

    ### Methods

    `to_dict(self) ‑> dict[str, typing.Any]`
    :

`Directory(files: list['File'], name: str, path: str, subdirectories: list['Subdirectory'])`
:   Attributes:
        files (list['File']):
        name (str):
        path (str):
        subdirectories (list['Subdirectory']): @name Subdirectories
    
    Method generated by attrs for class Directory.

    ### Static methods

    `from_dict(src_dict: dict[str, typing.Any]) ‑> ~T`
    :

    ### Instance variables

    `additional_keys: list[str]`
    :

    `additional_properties`
    :

    `files`
    :

    `name`
    :

    `path`
    :

    `subdirectories`
    :

    ### Methods

    `to_dict(self) ‑> dict[str, typing.Any]`
    :

`ErrorResponse(error: str)`
:   Attributes:
        error (str):  Example: Error message.
    
    Method generated by attrs for class ErrorResponse.

    ### Static methods

    `from_dict(src_dict: dict[str, typing.Any]) ‑> ~T`
    :

    ### Instance variables

    `additional_keys: list[str]`
    :

    `additional_properties: dict[str, typing.Any]`
    :

    `error: str`
    :

    ### Methods

    `to_dict(self) ‑> dict[str, typing.Any]`
    :

`File(group: str, last_modified: str, name: str, owner: str, path: str, permissions: str, size: int)`
:   Attributes:
        group (str):
        last_modified (str):
        name (str):
        owner (str):
        path (str):
        permissions (str):
        size (int):
    
    Method generated by attrs for class File.

    ### Static methods

    `from_dict(src_dict: dict[str, typing.Any]) ‑> ~T`
    :

    ### Instance variables

    `additional_keys: list[str]`
    :

    `additional_properties: dict[str, typing.Any]`
    :

    `group: str`
    :

    `last_modified: str`
    :

    `name: str`
    :

    `owner: str`
    :

    `path: str`
    :

    `permissions: str`
    :

    `size: int`
    :

    ### Methods

    `to_dict(self) ‑> dict[str, typing.Any]`
    :

`FileRequest(content: blaxel.core.sandbox.client.types.Unset | str = <blaxel.core.sandbox.client.types.Unset object>, is_directory: blaxel.core.sandbox.client.types.Unset | bool = <blaxel.core.sandbox.client.types.Unset object>, permissions: blaxel.core.sandbox.client.types.Unset | str = <blaxel.core.sandbox.client.types.Unset object>)`
:   Attributes:
        content (Union[Unset, str]):  Example: file contents here.
        is_directory (Union[Unset, bool]):
        permissions (Union[Unset, str]):  Example: 0644.
    
    Method generated by attrs for class FileRequest.

    ### Static methods

    `from_dict(src_dict: dict[str, typing.Any]) ‑> ~T`
    :

    ### Instance variables

    `additional_keys: list[str]`
    :

    `additional_properties: dict[str, typing.Any]`
    :

    `content: blaxel.core.sandbox.client.types.Unset | str`
    :

    `is_directory: blaxel.core.sandbox.client.types.Unset | bool`
    :

    `permissions: blaxel.core.sandbox.client.types.Unset | str`
    :

    ### Methods

    `to_dict(self) ‑> dict[str, typing.Any]`
    :

`FileWithContent(content: str, group: str, last_modified: str, name: str, owner: str, path: str, permissions: str, size: int)`
:   Attributes:
        content (str):
        group (str):
        last_modified (str):
        name (str):
        owner (str):
        path (str):
        permissions (str):
        size (int):
    
    Method generated by attrs for class FileWithContent.

    ### Static methods

    `from_dict(src_dict: dict[str, typing.Any]) ‑> ~T`
    :

    ### Instance variables

    `additional_keys: list[str]`
    :

    `additional_properties: dict[str, typing.Any]`
    :

    `content: str`
    :

    `group: str`
    :

    `last_modified: str`
    :

    `name: str`
    :

    `owner: str`
    :

    `path: str`
    :

    `permissions: str`
    :

    `size: int`
    :

    ### Methods

    `to_dict(self) ‑> dict[str, typing.Any]`
    :

`GetNetworkProcessPidPortsResponse200()`
:   Method generated by attrs for class GetNetworkProcessPidPortsResponse200.

    ### Static methods

    `from_dict(src_dict: dict[str, typing.Any]) ‑> ~T`
    :

    ### Instance variables

    `additional_keys: list[str]`
    :

    `additional_properties: dict[str, typing.Any]`
    :

    ### Methods

    `to_dict(self) ‑> dict[str, typing.Any]`
    :

`PortMonitorRequest(callback: blaxel.core.sandbox.client.types.Unset | str = <blaxel.core.sandbox.client.types.Unset object>)`
:   Attributes:
        callback (Union[Unset, str]): URL to call when a new port is detected Example: http://localhost:3000/callback.
    
    Method generated by attrs for class PortMonitorRequest.

    ### Static methods

    `from_dict(src_dict: dict[str, typing.Any]) ‑> ~T`
    :

    ### Instance variables

    `additional_keys: list[str]`
    :

    `additional_properties: dict[str, typing.Any]`
    :

    `callback: blaxel.core.sandbox.client.types.Unset | str`
    :

    ### Methods

    `to_dict(self) ‑> dict[str, typing.Any]`
    :

`PostNetworkProcessPidMonitorResponse200()`
:   Method generated by attrs for class PostNetworkProcessPidMonitorResponse200.

    ### Static methods

    `from_dict(src_dict: dict[str, typing.Any]) ‑> ~T`
    :

    ### Instance variables

    `additional_keys: list[str]`
    :

    `additional_properties: dict[str, typing.Any]`
    :

    ### Methods

    `to_dict(self) ‑> dict[str, typing.Any]`
    :

`ProcessLogs(logs: str, stderr: str, stdout: str)`
:   Attributes:
        logs (str):  Example: logs output.
        stderr (str):  Example: stderr output.
        stdout (str):  Example: stdout output.
    
    Method generated by attrs for class ProcessLogs.

    ### Static methods

    `from_dict(src_dict: dict[str, typing.Any]) ‑> ~T`
    :

    ### Instance variables

    `additional_keys: list[str]`
    :

    `additional_properties: dict[str, typing.Any]`
    :

    `logs: str`
    :

    `stderr: str`
    :

    `stdout: str`
    :

    ### Methods

    `to_dict(self) ‑> dict[str, typing.Any]`
    :

`ProcessRequest(command: str, env: blaxel.core.sandbox.client.types.Unset | ForwardRef('ProcessRequestEnv') = <blaxel.core.sandbox.client.types.Unset object>, name: blaxel.core.sandbox.client.types.Unset | str = <blaxel.core.sandbox.client.types.Unset object>, timeout: blaxel.core.sandbox.client.types.Unset | int = <blaxel.core.sandbox.client.types.Unset object>, wait_for_completion: blaxel.core.sandbox.client.types.Unset | bool = <blaxel.core.sandbox.client.types.Unset object>, wait_for_ports: blaxel.core.sandbox.client.types.Unset | list[int] = <blaxel.core.sandbox.client.types.Unset object>, working_dir: blaxel.core.sandbox.client.types.Unset | str = <blaxel.core.sandbox.client.types.Unset object>)`
:   Attributes:
        command (str):  Example: ls -la.
        env (Union[Unset, ProcessRequestEnv]):  Example: {'{"PORT"': ' "3000"}'}.
        name (Union[Unset, str]):  Example: my-process.
        timeout (Union[Unset, int]):  Example: 30.
        wait_for_completion (Union[Unset, bool]):
        wait_for_ports (Union[Unset, list[int]]):  Example: [3000, 8080].
        working_dir (Union[Unset, str]):  Example: /home/user.
    
    Method generated by attrs for class ProcessRequest.

    ### Descendants

    * blaxel.core.sandbox.types.ProcessRequestWithLog

    ### Static methods

    `from_dict(src_dict: dict[str, typing.Any]) ‑> ~T`
    :

    ### Instance variables

    `additional_keys: list[str]`
    :

    `additional_properties`
    :

    `command`
    :

    `env`
    :

    `name`
    :

    `timeout`
    :

    `wait_for_completion`
    :

    `wait_for_ports`
    :

    `working_dir`
    :

    ### Methods

    `to_dict(self) ‑> dict[str, typing.Any]`
    :

`ProcessRequestEnv()`
:   Example:
        {'{"PORT"': ' "3000"}'}
    
    Method generated by attrs for class ProcessRequestEnv.

    ### Static methods

    `from_dict(src_dict: dict[str, typing.Any]) ‑> ~T`
    :

    ### Instance variables

    `additional_keys: list[str]`
    :

    `additional_properties: dict[str, str]`
    :

    ### Methods

    `to_dict(self) ‑> dict[str, typing.Any]`
    :

`ProcessResponse(command: str, completed_at: str, exit_code: int, logs: str, name: str, pid: str, started_at: str, status: blaxel.core.sandbox.client.models.process_response_status.ProcessResponseStatus, working_dir: str)`
:   Attributes:
        command (str):  Example: ls -la.
        completed_at (str):  Example: Wed, 01 Jan 2023 12:01:00 GMT.
        exit_code (int):
        logs (str):  Example: logs output.
        name (str):  Example: my-process.
        pid (str):  Example: 1234.
        started_at (str):  Example: Wed, 01 Jan 2023 12:00:00 GMT.
        status (ProcessResponseStatus):  Example: running.
        working_dir (str):  Example: /home/user.
    
    Method generated by attrs for class ProcessResponse.

    ### Static methods

    `from_dict(src_dict: dict[str, typing.Any]) ‑> ~T`
    :

    ### Instance variables

    `additional_keys: list[str]`
    :

    `additional_properties: dict[str, typing.Any]`
    :

    `command: str`
    :

    `completed_at: str`
    :

    `exit_code: int`
    :

    `logs: str`
    :

    `name: str`
    :

    `pid: str`
    :

    `started_at: str`
    :

    `status: blaxel.core.sandbox.client.models.process_response_status.ProcessResponseStatus`
    :

    `working_dir: str`
    :

    ### Methods

    `to_dict(self) ‑> dict[str, typing.Any]`
    :

`ProcessResponseStatus(*args, **kwds)`
:   str(object='') -> str
    str(bytes_or_buffer[, encoding[, errors]]) -> str
    
    Create a new string object from the given object. If encoding or
    errors is specified, then the object must expose a data buffer
    that will be decoded using the given encoding and error handler.
    Otherwise, returns the result of object.__str__() (if defined)
    or repr(object).
    encoding defaults to 'utf-8'.
    errors defaults to 'strict'.

    ### Ancestors (in MRO)

    * builtins.str
    * enum.Enum

    ### Class variables

    `COMPLETED`
    :   The type of the None singleton.

    `FAILED`
    :   The type of the None singleton.

    `KILLED`
    :   The type of the None singleton.

    `RUNNING`
    :   The type of the None singleton.

    `STOPPED`
    :   The type of the None singleton.

`Subdirectory(name: str, path: str)`
:   Attributes:
        name (str):
        path (str):
    
    Method generated by attrs for class Subdirectory.

    ### Static methods

    `from_dict(src_dict: dict[str, typing.Any]) ‑> ~T`
    :

    ### Instance variables

    `additional_keys: list[str]`
    :

    `additional_properties: dict[str, typing.Any]`
    :

    `name: str`
    :

    `path: str`
    :

    ### Methods

    `to_dict(self) ‑> dict[str, typing.Any]`
    :

`SuccessResponse(message: str, path: blaxel.core.sandbox.client.types.Unset | str = <blaxel.core.sandbox.client.types.Unset object>)`
:   Attributes:
        message (str):  Example: File created successfully.
        path (Union[Unset, str]):  Example: /path/to/file.
    
    Method generated by attrs for class SuccessResponse.

    ### Static methods

    `from_dict(src_dict: dict[str, typing.Any]) ‑> ~T`
    :

    ### Instance variables

    `additional_keys: list[str]`
    :

    `additional_properties: dict[str, typing.Any]`
    :

    `message: str`
    :

    `path: blaxel.core.sandbox.client.types.Unset | str`
    :

    ### Methods

    `to_dict(self) ‑> dict[str, typing.Any]`
    :