Module blaxel.core.sandbox.types
================================

Classes
-------

`CopyResponse(message: str, source: str, destination: str)`
:   

`ProcessRequestWithLog(command: str, env: blaxel.core.sandbox.client.types.Unset | ForwardRef('ProcessRequestEnv') = <blaxel.core.sandbox.client.types.Unset object>, name: blaxel.core.sandbox.client.types.Unset | str = <blaxel.core.sandbox.client.types.Unset object>, timeout: blaxel.core.sandbox.client.types.Unset | int = <blaxel.core.sandbox.client.types.Unset object>, wait_for_completion: blaxel.core.sandbox.client.types.Unset | bool = <blaxel.core.sandbox.client.types.Unset object>, wait_for_ports: blaxel.core.sandbox.client.types.Unset | list[int] = <blaxel.core.sandbox.client.types.Unset object>, working_dir: blaxel.core.sandbox.client.types.Unset | str = <blaxel.core.sandbox.client.types.Unset object>, on_log: Callable[[str], None] = None)`
:   Attributes:
        command (str):  Example: ls -la.
        env (Union[Unset, ProcessRequestEnv]):  Example: {'{"PORT"': ' "3000"}'}.
        name (Union[Unset, str]):  Example: my-process.
        timeout (Union[Unset, int]):  Example: 30.
        wait_for_completion (Union[Unset, bool]):
        wait_for_ports (Union[Unset, list[int]]):  Example: [3000, 8080].
        working_dir (Union[Unset, str]):  Example: /home/user.
    
    Method generated by attrs for class ProcessRequestWithLog.

    ### Ancestors (in MRO)

    * blaxel.core.sandbox.client.models.process_request.ProcessRequest

    ### Instance variables

    `on_log`
    :

`ProcessResponseWithLog(process_response: blaxel.core.sandbox.client.models.process_response.ProcessResponse, close_func: Callable[[], None])`
:   A process response with additional close functionality for stream management.

    ### Methods

    `close(self) ‑> None`
    :   Close the log stream without terminating the process.

`SandboxConfiguration(sandbox: blaxel.core.client.models.sandbox.Sandbox, force_url: str | None = None, headers: Dict[str, str] | None = None, params: Dict[str, str] | None = None)`
:   

    ### Instance variables

    `metadata`
    :

    `spec`
    :

    `status`
    :

`SandboxCreateConfiguration(name: str | None = None, image: str | None = None, memory: int | None = None, ports: List[blaxel.core.client.models.port.Port] | List[Dict[str, Any]] | None = None, envs: List[Dict[str, str]] | None = None, volumes: List[blaxel.core.sandbox.types.VolumeBinding] | List[blaxel.core.client.models.volume_attachment.VolumeAttachment] | List[Dict[str, Any]] | None = None, ttl: str | None = None, expires: datetime.datetime | None = None, region: str | None = None, lifecycle: blaxel.core.client.models.sandbox_lifecycle.SandboxLifecycle | Dict[str, Any] | None = None)`
:   Simplified configuration for creating sandboxes with default values.

    ### Static methods

    `from_dict(data: Dict[str, Any]) ‑> blaxel.core.sandbox.types.SandboxCreateConfiguration`
    :

`SandboxFilesystemFile(path: str, content: str)`
:   

    ### Static methods

    `from_dict(data: Dict[str, Any]) ‑> blaxel.core.sandbox.types.SandboxFilesystemFile`
    :

`SandboxUpdateMetadata(labels: Dict[str, str] | None = None, display_name: str | None = None)`
:   Configuration for updating sandbox metadata.

`SessionCreateOptions(expires_at: datetime.datetime | None = None, response_headers: Dict[str, str] | None = None, request_headers: Dict[str, str] | None = None)`
:   

    ### Static methods

    `from_dict(data: Dict[str, Any]) ‑> blaxel.core.sandbox.types.SessionCreateOptions`
    :

`SessionWithToken(name: str, url: str, token: str, expires_at: datetime.datetime)`
:   

    ### Static methods

    `from_dict(data: Dict[str, Any]) ‑> blaxel.core.sandbox.types.SessionWithToken`
    :

`VolumeBinding(name: str, mount_path: str, read_only: bool | None = False)`
:   Volume binding configuration for sandbox.

    ### Static methods

    `from_dict(data: Dict[str, Any]) ‑> blaxel.core.sandbox.types.VolumeBinding`
    :

`WatchEvent(op: str, path: str, name: str, content: str | None = None)`
: