from typing import Any, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="CreateApiKeyForServiceAccountBody")


@_attrs_define
class CreateApiKeyForServiceAccountBody:
    """ 
        Attributes:
            expires_in (Union[Unset, str]): Expiration period for the API key
            name (Union[Unset, str]): Name for the API key
     """

    expires_in: Union[Unset, str] = UNSET
    name: Union[Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)


    def to_dict(self) -> dict[str, Any]:
        expires_in = self.expires_in

        name = self.name


        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({
        })
        if expires_in is not UNSET:
            field_dict["expires_in"] = expires_in
        if name is not UNSET:
            field_dict["name"] = name

        return field_dict



    @classmethod
    def from_dict(cls: type[T], src_dict: dict[str, Any]) -> T:
        if not src_dict:
            return None
        d = src_dict.copy()
        expires_in = d.pop("expires_in", UNSET)

        name = d.pop("name", UNSET)

        create_api_key_for_service_account_body = cls(
            expires_in=expires_in,
            name=name,
        )


        create_api_key_for_service_account_body.additional_properties = d
        return create_api_key_for_service_account_body

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
