from typing import Any, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="PendingInvitation")


@_attrs_define
class PendingInvitation:
    """ Pending invitation in workspace

        Attributes:
            created_at (Union[Unset, str]): The date and time when the resource was created
            updated_at (Union[Unset, str]): The date and time when the resource was updated
            created_by (Union[Unset, str]): The user or service account who created the resource
            updated_by (Union[Unset, str]): The user or service account who updated the resource
            email (Union[Unset, str]): User email
            invited_by (Union[Unset, str]): User sub
            role (Union[Unset, str]): ACL role
            workspace (Union[Unset, str]): Workspace name
     """

    created_at: Union[Unset, str] = UNSET
    updated_at: Union[Unset, str] = UNSET
    created_by: Union[Unset, str] = UNSET
    updated_by: Union[Unset, str] = UNSET
    email: Union[Unset, str] = UNSET
    invited_by: Union[Unset, str] = UNSET
    role: Union[Unset, str] = UNSET
    workspace: Union[Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)


    def to_dict(self) -> dict[str, Any]:
        created_at = self.created_at

        updated_at = self.updated_at

        created_by = self.created_by

        updated_by = self.updated_by

        email = self.email

        invited_by = self.invited_by

        role = self.role

        workspace = self.workspace


        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({
        })
        if created_at is not UNSET:
            field_dict["createdAt"] = created_at
        if updated_at is not UNSET:
            field_dict["updatedAt"] = updated_at
        if created_by is not UNSET:
            field_dict["createdBy"] = created_by
        if updated_by is not UNSET:
            field_dict["updatedBy"] = updated_by
        if email is not UNSET:
            field_dict["email"] = email
        if invited_by is not UNSET:
            field_dict["invitedBy"] = invited_by
        if role is not UNSET:
            field_dict["role"] = role
        if workspace is not UNSET:
            field_dict["workspace"] = workspace

        return field_dict



    @classmethod
    def from_dict(cls: type[T], src_dict: dict[str, Any]) -> T:
        if not src_dict:
            return None
        d = src_dict.copy()
        created_at = d.pop("createdAt", UNSET)

        updated_at = d.pop("updatedAt", UNSET)

        created_by = d.pop("createdBy", UNSET)

        updated_by = d.pop("updatedBy", UNSET)

        email = d.pop("email", UNSET)

        invited_by = d.pop("invitedBy", UNSET)

        role = d.pop("role", UNSET)

        workspace = d.pop("workspace", UNSET)

        pending_invitation = cls(
            created_at=created_at,
            updated_at=updated_at,
            created_by=created_by,
            updated_by=updated_by,
            email=email,
            invited_by=invited_by,
            role=role,
            workspace=workspace,
        )


        pending_invitation.additional_properties = d
        return pending_invitation

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
