from typing import Any, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="PreviewMetadata")


@_attrs_define
class PreviewMetadata:
    """ PreviewMetadata

        Attributes:
            created_at (Union[Unset, str]): The date and time when the resource was created
            updated_at (Union[Unset, str]): The date and time when the resource was updated
            created_by (Union[Unset, str]): The user or service account who created the resource
            updated_by (Union[Unset, str]): The user or service account who updated the resource
            display_name (Union[Unset, str]): Model display name
            name (Union[Unset, str]): Preview name
            resource_name (Union[Unset, str]): Resource name
            resource_type (Union[Unset, str]): Resource type
            workspace (Union[Unset, str]): Workspace name
     """

    created_at: Union[Unset, str] = UNSET
    updated_at: Union[Unset, str] = UNSET
    created_by: Union[Unset, str] = UNSET
    updated_by: Union[Unset, str] = UNSET
    display_name: Union[Unset, str] = UNSET
    name: Union[Unset, str] = UNSET
    resource_name: Union[Unset, str] = UNSET
    resource_type: Union[Unset, str] = UNSET
    workspace: Union[Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)


    def to_dict(self) -> dict[str, Any]:
        created_at = self.created_at

        updated_at = self.updated_at

        created_by = self.created_by

        updated_by = self.updated_by

        display_name = self.display_name

        name = self.name

        resource_name = self.resource_name

        resource_type = self.resource_type

        workspace = self.workspace


        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({
        })
        if created_at is not UNSET:
            field_dict["createdAt"] = created_at
        if updated_at is not UNSET:
            field_dict["updatedAt"] = updated_at
        if created_by is not UNSET:
            field_dict["createdBy"] = created_by
        if updated_by is not UNSET:
            field_dict["updatedBy"] = updated_by
        if display_name is not UNSET:
            field_dict["displayName"] = display_name
        if name is not UNSET:
            field_dict["name"] = name
        if resource_name is not UNSET:
            field_dict["resourceName"] = resource_name
        if resource_type is not UNSET:
            field_dict["resourceType"] = resource_type
        if workspace is not UNSET:
            field_dict["workspace"] = workspace

        return field_dict



    @classmethod
    def from_dict(cls: type[T], src_dict: dict[str, Any]) -> T:
        if not src_dict:
            return None
        d = src_dict.copy()
        created_at = d.pop("createdAt", UNSET)

        updated_at = d.pop("updatedAt", UNSET)

        created_by = d.pop("createdBy", UNSET)

        updated_by = d.pop("updatedBy", UNSET)

        display_name = d.pop("displayName", UNSET)

        name = d.pop("name", UNSET)

        resource_name = d.pop("resourceName", UNSET)

        resource_type = d.pop("resourceType", UNSET)

        workspace = d.pop("workspace", UNSET)

        preview_metadata = cls(
            created_at=created_at,
            updated_at=updated_at,
            created_by=created_by,
            updated_by=updated_by,
            display_name=display_name,
            name=name,
            resource_name=resource_name,
            resource_type=resource_type,
            workspace=workspace,
        )


        preview_metadata.additional_properties = d
        return preview_metadata

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
