from typing import TYPE_CHECKING, Any, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
  from ..models.metadata import Metadata





T = TypeVar("T", bound="StartSandbox")


@_attrs_define
class StartSandbox:
    """ Response when starting a Sandbox

        Attributes:
            message (Union[Unset, str]): Human readable message about the start operation
            metadata (Union[Unset, Metadata]): Metadata
            status (Union[Unset, str]): Status of the Sandbox start operation
     """

    message: Union[Unset, str] = UNSET
    metadata: Union[Unset, 'Metadata'] = UNSET
    status: Union[Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)


    def to_dict(self) -> dict[str, Any]:
        message = self.message

        metadata: Union[Unset, dict[str, Any]] = UNSET
        if self.metadata and not isinstance(self.metadata, Unset) and not isinstance(self.metadata, dict):
            metadata = self.metadata.to_dict()
        elif self.metadata and isinstance(self.metadata, dict):
            metadata = self.metadata

        status = self.status


        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({
        })
        if message is not UNSET:
            field_dict["message"] = message
        if metadata is not UNSET:
            field_dict["metadata"] = metadata
        if status is not UNSET:
            field_dict["status"] = status

        return field_dict



    @classmethod
    def from_dict(cls: type[T], src_dict: dict[str, Any]) -> T:
        from ..models.metadata import Metadata
        if not src_dict:
            return None
        d = src_dict.copy()
        message = d.pop("message", UNSET)

        _metadata = d.pop("metadata", UNSET)
        metadata: Union[Unset, Metadata]
        if isinstance(_metadata,  Unset):
            metadata = UNSET
        else:
            metadata = Metadata.from_dict(_metadata)




        status = d.pop("status", UNSET)

        start_sandbox = cls(
            message=message,
            metadata=metadata,
            status=status,
        )


        start_sandbox.additional_properties = d
        return start_sandbox

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
