# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from __future__ import annotations

from weakincentives.examples.code_review_prompt import build_code_review_prompt
from weakincentives.session import Session
from weakincentives.tools import PlanningToolsSection, VfsToolsSection


def test_build_code_review_prompt_includes_planning_section() -> None:
    prompt = build_code_review_prompt(Session())

    assert prompt.ns == "examples/code-review"
    assert any(
        isinstance(node.section, PlanningToolsSection) for node in prompt.sections
    )
    assert any(isinstance(node.section, VfsToolsSection) for node in prompt.sections)
