# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSecretResult',
    'AwaitableGetSecretResult',
    'get_secret',
    'get_secret_output',
]

@pulumi.output_type
class GetSecretResult:
    """
    A collection of values returned by getSecret.
    """
    def __init__(__self__, aws=None, azure_connectors=None, azure_sdk=None, cpln_id=None, description=None, dictionary=None, dictionary_as_envs=None, docker=None, ecrs=None, gcp=None, id=None, keypairs=None, name=None, nats_accounts=None, opaques=None, secret_link=None, self_link=None, tags=None, tls=None, userpasses=None):
        if aws and not isinstance(aws, list):
            raise TypeError("Expected argument 'aws' to be a list")
        pulumi.set(__self__, "aws", aws)
        if azure_connectors and not isinstance(azure_connectors, list):
            raise TypeError("Expected argument 'azure_connectors' to be a list")
        pulumi.set(__self__, "azure_connectors", azure_connectors)
        if azure_sdk and not isinstance(azure_sdk, str):
            raise TypeError("Expected argument 'azure_sdk' to be a str")
        pulumi.set(__self__, "azure_sdk", azure_sdk)
        if cpln_id and not isinstance(cpln_id, str):
            raise TypeError("Expected argument 'cpln_id' to be a str")
        pulumi.set(__self__, "cpln_id", cpln_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if dictionary and not isinstance(dictionary, dict):
            raise TypeError("Expected argument 'dictionary' to be a dict")
        pulumi.set(__self__, "dictionary", dictionary)
        if dictionary_as_envs and not isinstance(dictionary_as_envs, dict):
            raise TypeError("Expected argument 'dictionary_as_envs' to be a dict")
        pulumi.set(__self__, "dictionary_as_envs", dictionary_as_envs)
        if docker and not isinstance(docker, str):
            raise TypeError("Expected argument 'docker' to be a str")
        pulumi.set(__self__, "docker", docker)
        if ecrs and not isinstance(ecrs, list):
            raise TypeError("Expected argument 'ecrs' to be a list")
        pulumi.set(__self__, "ecrs", ecrs)
        if gcp and not isinstance(gcp, str):
            raise TypeError("Expected argument 'gcp' to be a str")
        pulumi.set(__self__, "gcp", gcp)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if keypairs and not isinstance(keypairs, list):
            raise TypeError("Expected argument 'keypairs' to be a list")
        pulumi.set(__self__, "keypairs", keypairs)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if nats_accounts and not isinstance(nats_accounts, list):
            raise TypeError("Expected argument 'nats_accounts' to be a list")
        pulumi.set(__self__, "nats_accounts", nats_accounts)
        if opaques and not isinstance(opaques, list):
            raise TypeError("Expected argument 'opaques' to be a list")
        pulumi.set(__self__, "opaques", opaques)
        if secret_link and not isinstance(secret_link, str):
            raise TypeError("Expected argument 'secret_link' to be a str")
        pulumi.set(__self__, "secret_link", secret_link)
        if self_link and not isinstance(self_link, str):
            raise TypeError("Expected argument 'self_link' to be a str")
        pulumi.set(__self__, "self_link", self_link)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if tls and not isinstance(tls, list):
            raise TypeError("Expected argument 'tls' to be a list")
        pulumi.set(__self__, "tls", tls)
        if userpasses and not isinstance(userpasses, list):
            raise TypeError("Expected argument 'userpasses' to be a list")
        pulumi.set(__self__, "userpasses", userpasses)

    @property
    @pulumi.getter
    def aws(self) -> Optional[Sequence['outputs.GetSecretAwResult']]:
        return pulumi.get(self, "aws")

    @property
    @pulumi.getter(name="azureConnectors")
    def azure_connectors(self) -> Optional[Sequence['outputs.GetSecretAzureConnectorResult']]:
        return pulumi.get(self, "azure_connectors")

    @property
    @pulumi.getter(name="azureSdk")
    def azure_sdk(self) -> builtins.str:
        return pulumi.get(self, "azure_sdk")

    @property
    @pulumi.getter(name="cplnId")
    def cpln_id(self) -> builtins.str:
        return pulumi.get(self, "cpln_id")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def dictionary(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "dictionary")

    @property
    @pulumi.getter(name="dictionaryAsEnvs")
    def dictionary_as_envs(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "dictionary_as_envs")

    @property
    @pulumi.getter
    def docker(self) -> builtins.str:
        return pulumi.get(self, "docker")

    @property
    @pulumi.getter
    def ecrs(self) -> Optional[Sequence['outputs.GetSecretEcrResult']]:
        return pulumi.get(self, "ecrs")

    @property
    @pulumi.getter
    def gcp(self) -> builtins.str:
        return pulumi.get(self, "gcp")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def keypairs(self) -> Optional[Sequence['outputs.GetSecretKeypairResult']]:
        return pulumi.get(self, "keypairs")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="natsAccounts")
    def nats_accounts(self) -> Optional[Sequence['outputs.GetSecretNatsAccountResult']]:
        return pulumi.get(self, "nats_accounts")

    @property
    @pulumi.getter
    def opaques(self) -> Optional[Sequence['outputs.GetSecretOpaqueResult']]:
        return pulumi.get(self, "opaques")

    @property
    @pulumi.getter(name="secretLink")
    def secret_link(self) -> builtins.str:
        return pulumi.get(self, "secret_link")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> builtins.str:
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def tls(self) -> Optional[Sequence['outputs.GetSecretTlResult']]:
        return pulumi.get(self, "tls")

    @property
    @pulumi.getter
    def userpasses(self) -> Optional[Sequence['outputs.GetSecretUserpassResult']]:
        return pulumi.get(self, "userpasses")


class AwaitableGetSecretResult(GetSecretResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecretResult(
            aws=self.aws,
            azure_connectors=self.azure_connectors,
            azure_sdk=self.azure_sdk,
            cpln_id=self.cpln_id,
            description=self.description,
            dictionary=self.dictionary,
            dictionary_as_envs=self.dictionary_as_envs,
            docker=self.docker,
            ecrs=self.ecrs,
            gcp=self.gcp,
            id=self.id,
            keypairs=self.keypairs,
            name=self.name,
            nats_accounts=self.nats_accounts,
            opaques=self.opaques,
            secret_link=self.secret_link,
            self_link=self.self_link,
            tags=self.tags,
            tls=self.tls,
            userpasses=self.userpasses)


def get_secret(aws: Optional[Sequence[Union['GetSecretAwArgs', 'GetSecretAwArgsDict']]] = None,
               azure_connectors: Optional[Sequence[Union['GetSecretAzureConnectorArgs', 'GetSecretAzureConnectorArgsDict']]] = None,
               ecrs: Optional[Sequence[Union['GetSecretEcrArgs', 'GetSecretEcrArgsDict']]] = None,
               keypairs: Optional[Sequence[Union['GetSecretKeypairArgs', 'GetSecretKeypairArgsDict']]] = None,
               name: Optional[builtins.str] = None,
               nats_accounts: Optional[Sequence[Union['GetSecretNatsAccountArgs', 'GetSecretNatsAccountArgsDict']]] = None,
               opaques: Optional[Sequence[Union['GetSecretOpaqueArgs', 'GetSecretOpaqueArgsDict']]] = None,
               tls: Optional[Sequence[Union['GetSecretTlArgs', 'GetSecretTlArgsDict']]] = None,
               userpasses: Optional[Sequence[Union['GetSecretUserpassArgs', 'GetSecretUserpassArgsDict']]] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecretResult:
    """
    Use this data source to access information about a [Secret](https://docs.controlplane.com/reference/secret) within Control Plane.

    ## Required

    - **name** (String) Name of the secret.

    ## Outputs

    The following attributes are exported:

    - **cpln_id** (String) The ID, in GUID format, of the secret.
    - **name** (String) Name of the secret.
    - **description** (String) Description of the secret.
    - **tags** (Map of String) Key-value map of resource tags.
    - **self_link** (String) Full link to this resource. Can be referenced by other resources.
    - **secret_link** (String) Output used when linking a secret to an environment variable or volume, in the format: `cpln://secret/SECRET_NAME`.
    - **dictionary_as_envs** (Map of String) If a dictionary secret is defined, this output will be a key-value map in the following format: `key = cpln://secret/SECRET_NAME.key`.
    - **aws** (Block List, Max: 1) (see below) [Reference Page](https://docs.controlplane.com/reference/secret#aws).
    - **azure_connector** (Block List, Max: 1) (see below) [Reference Page](https://docs.controlplane.com/reference/secret#azure-connector).
    - **azure_sdk** (String, Sensitive) JSON string containing the Docker secret. [Reference Page](https://docs.controlplane.com/reference/secret#azure).
    - **dictionary** (Map of String) List of unique key-value pairs. [Reference Page](https://docs.controlplane.com/reference/secret#dictionary).
    - **docker** (String, Sensitive) JSON string containing the Docker secret. [Reference Page](https://docs.controlplane.com/reference/secret#docker).
    - **ecr** (Block List, Max: 1) (see below).
    - **gcp** (String, Sensitive) JSON string containing the GCP secret. [Reference Page](https://docs.controlplane.com/reference/secret#gcp)
    - **keypair** (Block List, Max: 1) (see below) [Reference Page](https://docs.controlplane.com/reference/secret#keypair).
    - **nats_account** (Block List, Max: 1) (see below) [Reference Page](https://docs.controlplane.com/reference/secret#nats-account).
    - **opaque** (Block List, Max: 1) (see below) [Reference Page](https://docs.controlplane.com/reference/secret#opaque).
    - **tls** (Block List, Max: 1) (see below) [Reference Page](https://docs.controlplane.com/reference/secret#tls).
    - **userpass** (Block List, Max: 1) (see below) [Reference Page](https://docs.controlplane.com/reference/secret#username).

    <a id="nestedblock--aws"></a>

    ### `aws`

    Optional:

    - **access_key** (String, Sensitive) Access Key provided by AWS.
    - **role_arn** (String) Role ARN provided by AWS.
    - **secret_key** (String, Sensitive) Secret Key provided by AWS.
    - **external_id** (String) AWS IAM Role External ID.

    <a id="nestedblock--azure_connector"></a>

    ### `azure_connector`

    Optional:

    - **code** (String, Sensitive) Code/Key to authenticate to deployment URL.
    - **url** (String, Sensitive) Deployment URL.

    <a id="nestedblock--ecr"></a>

    ### `ecr`

    [Reference Page](https://docs.controlplane.com/reference/secret#ecr)

    Optional:

    - **access_key** (String) Access Key provided by AWS.
    - **repos** (Set of String) List of ECR repositories.
    - **role_arn** (String) Role ARN provided by AWS.
    - **secret_key** (String, Sensitive) Secret Key provided by AWS.
    - **external_id** (String) AWS IAM Role External ID. Used when setting up cross-account access to your ECR repositories.

    <a id="nestedblock--keypair"></a>

    ### `keypair`

    Optional:

    - **passphrase** (String, Sensitive) Passphrase for private key.
    - **public_key** (String) Public Key.
    - **secret_key** (String, Sensitive) Secret/Private Key.

    <a id="nestedblock--nats-account"></a>

    ### `nats_account`

    Required:

    - **account_id** (String) Account ID.
    - **private_key** (String) Private Key.

    <a id="nestedblock--opaque"></a>

    ### `opaque`

    Optional:

    - **encoding** (String) Available encodings: `plain`, `base64`. Default: `plain`.
    - **payload** (String, Sensitive) Plain text or base64 encoded string. Use `encoding` attribute to specify encoding.

    <a id="nestedblock--tls"></a>

    ### `tls`

    Optional:

    - **cert** (String) Public Certificate.
    - **chain** (String) Chain Certificate.
    - **key** (String, Sensitive) Private Certificate.

    <a id="nestedblock--userpass"></a>

    ### `userpass`

    Optional:

    - **encoding** (String) Available encodings: `plain`, `base64`. Default: `plain`.
    - **password** (String, Sensitive) Password.
    - **username** (String) Username.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cpln as cpln

    example = cpln.get_secret(name="example-secret-opaque")
    pulumi.export("example-secret-payload", example.opaques.payload)
    ```
    """
    __args__ = dict()
    __args__['aws'] = aws
    __args__['azureConnectors'] = azure_connectors
    __args__['ecrs'] = ecrs
    __args__['keypairs'] = keypairs
    __args__['name'] = name
    __args__['natsAccounts'] = nats_accounts
    __args__['opaques'] = opaques
    __args__['tls'] = tls
    __args__['userpasses'] = userpasses
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cpln:index/getSecret:getSecret', __args__, opts=opts, typ=GetSecretResult).value

    return AwaitableGetSecretResult(
        aws=pulumi.get(__ret__, 'aws'),
        azure_connectors=pulumi.get(__ret__, 'azure_connectors'),
        azure_sdk=pulumi.get(__ret__, 'azure_sdk'),
        cpln_id=pulumi.get(__ret__, 'cpln_id'),
        description=pulumi.get(__ret__, 'description'),
        dictionary=pulumi.get(__ret__, 'dictionary'),
        dictionary_as_envs=pulumi.get(__ret__, 'dictionary_as_envs'),
        docker=pulumi.get(__ret__, 'docker'),
        ecrs=pulumi.get(__ret__, 'ecrs'),
        gcp=pulumi.get(__ret__, 'gcp'),
        id=pulumi.get(__ret__, 'id'),
        keypairs=pulumi.get(__ret__, 'keypairs'),
        name=pulumi.get(__ret__, 'name'),
        nats_accounts=pulumi.get(__ret__, 'nats_accounts'),
        opaques=pulumi.get(__ret__, 'opaques'),
        secret_link=pulumi.get(__ret__, 'secret_link'),
        self_link=pulumi.get(__ret__, 'self_link'),
        tags=pulumi.get(__ret__, 'tags'),
        tls=pulumi.get(__ret__, 'tls'),
        userpasses=pulumi.get(__ret__, 'userpasses'))
def get_secret_output(aws: Optional[pulumi.Input[Optional[Sequence[Union['GetSecretAwArgs', 'GetSecretAwArgsDict']]]]] = None,
                      azure_connectors: Optional[pulumi.Input[Optional[Sequence[Union['GetSecretAzureConnectorArgs', 'GetSecretAzureConnectorArgsDict']]]]] = None,
                      ecrs: Optional[pulumi.Input[Optional[Sequence[Union['GetSecretEcrArgs', 'GetSecretEcrArgsDict']]]]] = None,
                      keypairs: Optional[pulumi.Input[Optional[Sequence[Union['GetSecretKeypairArgs', 'GetSecretKeypairArgsDict']]]]] = None,
                      name: Optional[pulumi.Input[builtins.str]] = None,
                      nats_accounts: Optional[pulumi.Input[Optional[Sequence[Union['GetSecretNatsAccountArgs', 'GetSecretNatsAccountArgsDict']]]]] = None,
                      opaques: Optional[pulumi.Input[Optional[Sequence[Union['GetSecretOpaqueArgs', 'GetSecretOpaqueArgsDict']]]]] = None,
                      tls: Optional[pulumi.Input[Optional[Sequence[Union['GetSecretTlArgs', 'GetSecretTlArgsDict']]]]] = None,
                      userpasses: Optional[pulumi.Input[Optional[Sequence[Union['GetSecretUserpassArgs', 'GetSecretUserpassArgsDict']]]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecretResult]:
    """
    Use this data source to access information about a [Secret](https://docs.controlplane.com/reference/secret) within Control Plane.

    ## Required

    - **name** (String) Name of the secret.

    ## Outputs

    The following attributes are exported:

    - **cpln_id** (String) The ID, in GUID format, of the secret.
    - **name** (String) Name of the secret.
    - **description** (String) Description of the secret.
    - **tags** (Map of String) Key-value map of resource tags.
    - **self_link** (String) Full link to this resource. Can be referenced by other resources.
    - **secret_link** (String) Output used when linking a secret to an environment variable or volume, in the format: `cpln://secret/SECRET_NAME`.
    - **dictionary_as_envs** (Map of String) If a dictionary secret is defined, this output will be a key-value map in the following format: `key = cpln://secret/SECRET_NAME.key`.
    - **aws** (Block List, Max: 1) (see below) [Reference Page](https://docs.controlplane.com/reference/secret#aws).
    - **azure_connector** (Block List, Max: 1) (see below) [Reference Page](https://docs.controlplane.com/reference/secret#azure-connector).
    - **azure_sdk** (String, Sensitive) JSON string containing the Docker secret. [Reference Page](https://docs.controlplane.com/reference/secret#azure).
    - **dictionary** (Map of String) List of unique key-value pairs. [Reference Page](https://docs.controlplane.com/reference/secret#dictionary).
    - **docker** (String, Sensitive) JSON string containing the Docker secret. [Reference Page](https://docs.controlplane.com/reference/secret#docker).
    - **ecr** (Block List, Max: 1) (see below).
    - **gcp** (String, Sensitive) JSON string containing the GCP secret. [Reference Page](https://docs.controlplane.com/reference/secret#gcp)
    - **keypair** (Block List, Max: 1) (see below) [Reference Page](https://docs.controlplane.com/reference/secret#keypair).
    - **nats_account** (Block List, Max: 1) (see below) [Reference Page](https://docs.controlplane.com/reference/secret#nats-account).
    - **opaque** (Block List, Max: 1) (see below) [Reference Page](https://docs.controlplane.com/reference/secret#opaque).
    - **tls** (Block List, Max: 1) (see below) [Reference Page](https://docs.controlplane.com/reference/secret#tls).
    - **userpass** (Block List, Max: 1) (see below) [Reference Page](https://docs.controlplane.com/reference/secret#username).

    <a id="nestedblock--aws"></a>

    ### `aws`

    Optional:

    - **access_key** (String, Sensitive) Access Key provided by AWS.
    - **role_arn** (String) Role ARN provided by AWS.
    - **secret_key** (String, Sensitive) Secret Key provided by AWS.
    - **external_id** (String) AWS IAM Role External ID.

    <a id="nestedblock--azure_connector"></a>

    ### `azure_connector`

    Optional:

    - **code** (String, Sensitive) Code/Key to authenticate to deployment URL.
    - **url** (String, Sensitive) Deployment URL.

    <a id="nestedblock--ecr"></a>

    ### `ecr`

    [Reference Page](https://docs.controlplane.com/reference/secret#ecr)

    Optional:

    - **access_key** (String) Access Key provided by AWS.
    - **repos** (Set of String) List of ECR repositories.
    - **role_arn** (String) Role ARN provided by AWS.
    - **secret_key** (String, Sensitive) Secret Key provided by AWS.
    - **external_id** (String) AWS IAM Role External ID. Used when setting up cross-account access to your ECR repositories.

    <a id="nestedblock--keypair"></a>

    ### `keypair`

    Optional:

    - **passphrase** (String, Sensitive) Passphrase for private key.
    - **public_key** (String) Public Key.
    - **secret_key** (String, Sensitive) Secret/Private Key.

    <a id="nestedblock--nats-account"></a>

    ### `nats_account`

    Required:

    - **account_id** (String) Account ID.
    - **private_key** (String) Private Key.

    <a id="nestedblock--opaque"></a>

    ### `opaque`

    Optional:

    - **encoding** (String) Available encodings: `plain`, `base64`. Default: `plain`.
    - **payload** (String, Sensitive) Plain text or base64 encoded string. Use `encoding` attribute to specify encoding.

    <a id="nestedblock--tls"></a>

    ### `tls`

    Optional:

    - **cert** (String) Public Certificate.
    - **chain** (String) Chain Certificate.
    - **key** (String, Sensitive) Private Certificate.

    <a id="nestedblock--userpass"></a>

    ### `userpass`

    Optional:

    - **encoding** (String) Available encodings: `plain`, `base64`. Default: `plain`.
    - **password** (String, Sensitive) Password.
    - **username** (String) Username.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cpln as cpln

    example = cpln.get_secret(name="example-secret-opaque")
    pulumi.export("example-secret-payload", example.opaques.payload)
    ```
    """
    __args__ = dict()
    __args__['aws'] = aws
    __args__['azureConnectors'] = azure_connectors
    __args__['ecrs'] = ecrs
    __args__['keypairs'] = keypairs
    __args__['name'] = name
    __args__['natsAccounts'] = nats_accounts
    __args__['opaques'] = opaques
    __args__['tls'] = tls
    __args__['userpasses'] = userpasses
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cpln:index/getSecret:getSecret', __args__, opts=opts, typ=GetSecretResult)
    return __ret__.apply(lambda __response__: GetSecretResult(
        aws=pulumi.get(__response__, 'aws'),
        azure_connectors=pulumi.get(__response__, 'azure_connectors'),
        azure_sdk=pulumi.get(__response__, 'azure_sdk'),
        cpln_id=pulumi.get(__response__, 'cpln_id'),
        description=pulumi.get(__response__, 'description'),
        dictionary=pulumi.get(__response__, 'dictionary'),
        dictionary_as_envs=pulumi.get(__response__, 'dictionary_as_envs'),
        docker=pulumi.get(__response__, 'docker'),
        ecrs=pulumi.get(__response__, 'ecrs'),
        gcp=pulumi.get(__response__, 'gcp'),
        id=pulumi.get(__response__, 'id'),
        keypairs=pulumi.get(__response__, 'keypairs'),
        name=pulumi.get(__response__, 'name'),
        nats_accounts=pulumi.get(__response__, 'nats_accounts'),
        opaques=pulumi.get(__response__, 'opaques'),
        secret_link=pulumi.get(__response__, 'secret_link'),
        self_link=pulumi.get(__response__, 'self_link'),
        tags=pulumi.get(__response__, 'tags'),
        tls=pulumi.get(__response__, 'tls'),
        userpasses=pulumi.get(__response__, 'userpasses')))
