# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IdentityArgs', 'Identity']

@pulumi.input_type
class IdentityArgs:
    def __init__(__self__, *,
                 gvc: pulumi.Input[builtins.str],
                 aws_access_policy: Optional[pulumi.Input['IdentityAwsAccessPolicyArgs']] = None,
                 azure_access_policy: Optional[pulumi.Input['IdentityAzureAccessPolicyArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 gcp_access_policy: Optional[pulumi.Input['IdentityGcpAccessPolicyArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 native_network_resources: Optional[pulumi.Input[Sequence[pulumi.Input['IdentityNativeNetworkResourceArgs']]]] = None,
                 network_resources: Optional[pulumi.Input[Sequence[pulumi.Input['IdentityNetworkResourceArgs']]]] = None,
                 ngs_access_policy: Optional[pulumi.Input['IdentityNgsAccessPolicyArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Identity resource.
        :param pulumi.Input[builtins.str] gvc: The GVC to which this identity belongs.
        :param pulumi.Input['IdentityAwsAccessPolicyArgs'] aws_access_policy: A set of access policy rules that defines the actions and resources that an identity can access within an AWS
               environment.
        :param pulumi.Input['IdentityAzureAccessPolicyArgs'] azure_access_policy: A set of access policy rules that defines the actions and resources that an identity can access within an Azure
               environment.
        :param pulumi.Input[builtins.str] description: Description of the identity.
        :param pulumi.Input['IdentityGcpAccessPolicyArgs'] gcp_access_policy: The GCP access policy can either contain an existing service_account or multiple bindings.
        :param pulumi.Input[builtins.str] name: Name of the identity.
        :param pulumi.Input[Sequence[pulumi.Input['IdentityNativeNetworkResourceArgs']]] native_network_resources: > **NOTE** The configuration of a native network resource requires the assistance of Control Plane support.
        :param pulumi.Input[Sequence[pulumi.Input['IdentityNetworkResourceArgs']]] network_resources: A network resource can be configured with: - A fully qualified domain name (FQDN) and ports. - An FQDN, resolver IP, and
               ports. - IP's and ports.
        :param pulumi.Input['IdentityNgsAccessPolicyArgs'] ngs_access_policy: A set of access policy rules that defines the actions and resources that an identity can access within an NGA
               environment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        """
        pulumi.set(__self__, "gvc", gvc)
        if aws_access_policy is not None:
            pulumi.set(__self__, "aws_access_policy", aws_access_policy)
        if azure_access_policy is not None:
            pulumi.set(__self__, "azure_access_policy", azure_access_policy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if gcp_access_policy is not None:
            pulumi.set(__self__, "gcp_access_policy", gcp_access_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if native_network_resources is not None:
            pulumi.set(__self__, "native_network_resources", native_network_resources)
        if network_resources is not None:
            pulumi.set(__self__, "network_resources", network_resources)
        if ngs_access_policy is not None:
            pulumi.set(__self__, "ngs_access_policy", ngs_access_policy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def gvc(self) -> pulumi.Input[builtins.str]:
        """
        The GVC to which this identity belongs.
        """
        return pulumi.get(self, "gvc")

    @gvc.setter
    def gvc(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "gvc", value)

    @property
    @pulumi.getter(name="awsAccessPolicy")
    def aws_access_policy(self) -> Optional[pulumi.Input['IdentityAwsAccessPolicyArgs']]:
        """
        A set of access policy rules that defines the actions and resources that an identity can access within an AWS
        environment.
        """
        return pulumi.get(self, "aws_access_policy")

    @aws_access_policy.setter
    def aws_access_policy(self, value: Optional[pulumi.Input['IdentityAwsAccessPolicyArgs']]):
        pulumi.set(self, "aws_access_policy", value)

    @property
    @pulumi.getter(name="azureAccessPolicy")
    def azure_access_policy(self) -> Optional[pulumi.Input['IdentityAzureAccessPolicyArgs']]:
        """
        A set of access policy rules that defines the actions and resources that an identity can access within an Azure
        environment.
        """
        return pulumi.get(self, "azure_access_policy")

    @azure_access_policy.setter
    def azure_access_policy(self, value: Optional[pulumi.Input['IdentityAzureAccessPolicyArgs']]):
        pulumi.set(self, "azure_access_policy", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the identity.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="gcpAccessPolicy")
    def gcp_access_policy(self) -> Optional[pulumi.Input['IdentityGcpAccessPolicyArgs']]:
        """
        The GCP access policy can either contain an existing service_account or multiple bindings.
        """
        return pulumi.get(self, "gcp_access_policy")

    @gcp_access_policy.setter
    def gcp_access_policy(self, value: Optional[pulumi.Input['IdentityGcpAccessPolicyArgs']]):
        pulumi.set(self, "gcp_access_policy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the identity.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nativeNetworkResources")
    def native_network_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IdentityNativeNetworkResourceArgs']]]]:
        """
        > **NOTE** The configuration of a native network resource requires the assistance of Control Plane support.
        """
        return pulumi.get(self, "native_network_resources")

    @native_network_resources.setter
    def native_network_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IdentityNativeNetworkResourceArgs']]]]):
        pulumi.set(self, "native_network_resources", value)

    @property
    @pulumi.getter(name="networkResources")
    def network_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IdentityNetworkResourceArgs']]]]:
        """
        A network resource can be configured with: - A fully qualified domain name (FQDN) and ports. - An FQDN, resolver IP, and
        ports. - IP's and ports.
        """
        return pulumi.get(self, "network_resources")

    @network_resources.setter
    def network_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IdentityNetworkResourceArgs']]]]):
        pulumi.set(self, "network_resources", value)

    @property
    @pulumi.getter(name="ngsAccessPolicy")
    def ngs_access_policy(self) -> Optional[pulumi.Input['IdentityNgsAccessPolicyArgs']]:
        """
        A set of access policy rules that defines the actions and resources that an identity can access within an NGA
        environment.
        """
        return pulumi.get(self, "ngs_access_policy")

    @ngs_access_policy.setter
    def ngs_access_policy(self, value: Optional[pulumi.Input['IdentityNgsAccessPolicyArgs']]):
        pulumi.set(self, "ngs_access_policy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _IdentityState:
    def __init__(__self__, *,
                 aws_access_policy: Optional[pulumi.Input['IdentityAwsAccessPolicyArgs']] = None,
                 azure_access_policy: Optional[pulumi.Input['IdentityAzureAccessPolicyArgs']] = None,
                 cpln_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 gcp_access_policy: Optional[pulumi.Input['IdentityGcpAccessPolicyArgs']] = None,
                 gvc: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 native_network_resources: Optional[pulumi.Input[Sequence[pulumi.Input['IdentityNativeNetworkResourceArgs']]]] = None,
                 network_resources: Optional[pulumi.Input[Sequence[pulumi.Input['IdentityNetworkResourceArgs']]]] = None,
                 ngs_access_policy: Optional[pulumi.Input['IdentityNgsAccessPolicyArgs']] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Identity resources.
        :param pulumi.Input['IdentityAwsAccessPolicyArgs'] aws_access_policy: A set of access policy rules that defines the actions and resources that an identity can access within an AWS
               environment.
        :param pulumi.Input['IdentityAzureAccessPolicyArgs'] azure_access_policy: A set of access policy rules that defines the actions and resources that an identity can access within an Azure
               environment.
        :param pulumi.Input[builtins.str] cpln_id: The ID, in GUID format, of the identity.
        :param pulumi.Input[builtins.str] description: Description of the identity.
        :param pulumi.Input['IdentityGcpAccessPolicyArgs'] gcp_access_policy: The GCP access policy can either contain an existing service_account or multiple bindings.
        :param pulumi.Input[builtins.str] gvc: The GVC to which this identity belongs.
        :param pulumi.Input[builtins.str] name: Name of the identity.
        :param pulumi.Input[Sequence[pulumi.Input['IdentityNativeNetworkResourceArgs']]] native_network_resources: > **NOTE** The configuration of a native network resource requires the assistance of Control Plane support.
        :param pulumi.Input[Sequence[pulumi.Input['IdentityNetworkResourceArgs']]] network_resources: A network resource can be configured with: - A fully qualified domain name (FQDN) and ports. - An FQDN, resolver IP, and
               ports. - IP's and ports.
        :param pulumi.Input['IdentityNgsAccessPolicyArgs'] ngs_access_policy: A set of access policy rules that defines the actions and resources that an identity can access within an NGA
               environment.
        :param pulumi.Input[builtins.str] self_link: Full link to this resource. Can be referenced by other resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] status: Key-value map of identity status. Available fields: `objectName`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        """
        if aws_access_policy is not None:
            pulumi.set(__self__, "aws_access_policy", aws_access_policy)
        if azure_access_policy is not None:
            pulumi.set(__self__, "azure_access_policy", azure_access_policy)
        if cpln_id is not None:
            pulumi.set(__self__, "cpln_id", cpln_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if gcp_access_policy is not None:
            pulumi.set(__self__, "gcp_access_policy", gcp_access_policy)
        if gvc is not None:
            pulumi.set(__self__, "gvc", gvc)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if native_network_resources is not None:
            pulumi.set(__self__, "native_network_resources", native_network_resources)
        if network_resources is not None:
            pulumi.set(__self__, "network_resources", network_resources)
        if ngs_access_policy is not None:
            pulumi.set(__self__, "ngs_access_policy", ngs_access_policy)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="awsAccessPolicy")
    def aws_access_policy(self) -> Optional[pulumi.Input['IdentityAwsAccessPolicyArgs']]:
        """
        A set of access policy rules that defines the actions and resources that an identity can access within an AWS
        environment.
        """
        return pulumi.get(self, "aws_access_policy")

    @aws_access_policy.setter
    def aws_access_policy(self, value: Optional[pulumi.Input['IdentityAwsAccessPolicyArgs']]):
        pulumi.set(self, "aws_access_policy", value)

    @property
    @pulumi.getter(name="azureAccessPolicy")
    def azure_access_policy(self) -> Optional[pulumi.Input['IdentityAzureAccessPolicyArgs']]:
        """
        A set of access policy rules that defines the actions and resources that an identity can access within an Azure
        environment.
        """
        return pulumi.get(self, "azure_access_policy")

    @azure_access_policy.setter
    def azure_access_policy(self, value: Optional[pulumi.Input['IdentityAzureAccessPolicyArgs']]):
        pulumi.set(self, "azure_access_policy", value)

    @property
    @pulumi.getter(name="cplnId")
    def cpln_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID, in GUID format, of the identity.
        """
        return pulumi.get(self, "cpln_id")

    @cpln_id.setter
    def cpln_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cpln_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the identity.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="gcpAccessPolicy")
    def gcp_access_policy(self) -> Optional[pulumi.Input['IdentityGcpAccessPolicyArgs']]:
        """
        The GCP access policy can either contain an existing service_account or multiple bindings.
        """
        return pulumi.get(self, "gcp_access_policy")

    @gcp_access_policy.setter
    def gcp_access_policy(self, value: Optional[pulumi.Input['IdentityGcpAccessPolicyArgs']]):
        pulumi.set(self, "gcp_access_policy", value)

    @property
    @pulumi.getter
    def gvc(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The GVC to which this identity belongs.
        """
        return pulumi.get(self, "gvc")

    @gvc.setter
    def gvc(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gvc", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the identity.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nativeNetworkResources")
    def native_network_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IdentityNativeNetworkResourceArgs']]]]:
        """
        > **NOTE** The configuration of a native network resource requires the assistance of Control Plane support.
        """
        return pulumi.get(self, "native_network_resources")

    @native_network_resources.setter
    def native_network_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IdentityNativeNetworkResourceArgs']]]]):
        pulumi.set(self, "native_network_resources", value)

    @property
    @pulumi.getter(name="networkResources")
    def network_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IdentityNetworkResourceArgs']]]]:
        """
        A network resource can be configured with: - A fully qualified domain name (FQDN) and ports. - An FQDN, resolver IP, and
        ports. - IP's and ports.
        """
        return pulumi.get(self, "network_resources")

    @network_resources.setter
    def network_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IdentityNetworkResourceArgs']]]]):
        pulumi.set(self, "network_resources", value)

    @property
    @pulumi.getter(name="ngsAccessPolicy")
    def ngs_access_policy(self) -> Optional[pulumi.Input['IdentityNgsAccessPolicyArgs']]:
        """
        A set of access policy rules that defines the actions and resources that an identity can access within an NGA
        environment.
        """
        return pulumi.get(self, "ngs_access_policy")

    @ngs_access_policy.setter
    def ngs_access_policy(self, value: Optional[pulumi.Input['IdentityNgsAccessPolicyArgs']]):
        pulumi.set(self, "ngs_access_policy", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Full link to this resource. Can be referenced by other resources.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of identity status. Available fields: `objectName`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("cpln:index/identity:Identity")
class Identity(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_access_policy: Optional[pulumi.Input[Union['IdentityAwsAccessPolicyArgs', 'IdentityAwsAccessPolicyArgsDict']]] = None,
                 azure_access_policy: Optional[pulumi.Input[Union['IdentityAzureAccessPolicyArgs', 'IdentityAzureAccessPolicyArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 gcp_access_policy: Optional[pulumi.Input[Union['IdentityGcpAccessPolicyArgs', 'IdentityGcpAccessPolicyArgsDict']]] = None,
                 gvc: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 native_network_resources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IdentityNativeNetworkResourceArgs', 'IdentityNativeNetworkResourceArgsDict']]]]] = None,
                 network_resources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IdentityNetworkResourceArgs', 'IdentityNetworkResourceArgsDict']]]]] = None,
                 ngs_access_policy: Optional[pulumi.Input[Union['IdentityNgsAccessPolicyArgs', 'IdentityNgsAccessPolicyArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Create a Identity resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['IdentityAwsAccessPolicyArgs', 'IdentityAwsAccessPolicyArgsDict']] aws_access_policy: A set of access policy rules that defines the actions and resources that an identity can access within an AWS
               environment.
        :param pulumi.Input[Union['IdentityAzureAccessPolicyArgs', 'IdentityAzureAccessPolicyArgsDict']] azure_access_policy: A set of access policy rules that defines the actions and resources that an identity can access within an Azure
               environment.
        :param pulumi.Input[builtins.str] description: Description of the identity.
        :param pulumi.Input[Union['IdentityGcpAccessPolicyArgs', 'IdentityGcpAccessPolicyArgsDict']] gcp_access_policy: The GCP access policy can either contain an existing service_account or multiple bindings.
        :param pulumi.Input[builtins.str] gvc: The GVC to which this identity belongs.
        :param pulumi.Input[builtins.str] name: Name of the identity.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IdentityNativeNetworkResourceArgs', 'IdentityNativeNetworkResourceArgsDict']]]] native_network_resources: > **NOTE** The configuration of a native network resource requires the assistance of Control Plane support.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IdentityNetworkResourceArgs', 'IdentityNetworkResourceArgsDict']]]] network_resources: A network resource can be configured with: - A fully qualified domain name (FQDN) and ports. - An FQDN, resolver IP, and
               ports. - IP's and ports.
        :param pulumi.Input[Union['IdentityNgsAccessPolicyArgs', 'IdentityNgsAccessPolicyArgsDict']] ngs_access_policy: A set of access policy rules that defines the actions and resources that an identity can access within an NGA
               environment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IdentityArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Identity resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param IdentityArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IdentityArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_access_policy: Optional[pulumi.Input[Union['IdentityAwsAccessPolicyArgs', 'IdentityAwsAccessPolicyArgsDict']]] = None,
                 azure_access_policy: Optional[pulumi.Input[Union['IdentityAzureAccessPolicyArgs', 'IdentityAzureAccessPolicyArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 gcp_access_policy: Optional[pulumi.Input[Union['IdentityGcpAccessPolicyArgs', 'IdentityGcpAccessPolicyArgsDict']]] = None,
                 gvc: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 native_network_resources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IdentityNativeNetworkResourceArgs', 'IdentityNativeNetworkResourceArgsDict']]]]] = None,
                 network_resources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IdentityNetworkResourceArgs', 'IdentityNetworkResourceArgsDict']]]]] = None,
                 ngs_access_policy: Optional[pulumi.Input[Union['IdentityNgsAccessPolicyArgs', 'IdentityNgsAccessPolicyArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IdentityArgs.__new__(IdentityArgs)

            __props__.__dict__["aws_access_policy"] = aws_access_policy
            __props__.__dict__["azure_access_policy"] = azure_access_policy
            __props__.__dict__["description"] = description
            __props__.__dict__["gcp_access_policy"] = gcp_access_policy
            if gvc is None and not opts.urn:
                raise TypeError("Missing required property 'gvc'")
            __props__.__dict__["gvc"] = gvc
            __props__.__dict__["name"] = name
            __props__.__dict__["native_network_resources"] = native_network_resources
            __props__.__dict__["network_resources"] = network_resources
            __props__.__dict__["ngs_access_policy"] = ngs_access_policy
            __props__.__dict__["tags"] = tags
            __props__.__dict__["cpln_id"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["status"] = None
        super(Identity, __self__).__init__(
            'cpln:index/identity:Identity',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws_access_policy: Optional[pulumi.Input[Union['IdentityAwsAccessPolicyArgs', 'IdentityAwsAccessPolicyArgsDict']]] = None,
            azure_access_policy: Optional[pulumi.Input[Union['IdentityAzureAccessPolicyArgs', 'IdentityAzureAccessPolicyArgsDict']]] = None,
            cpln_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            gcp_access_policy: Optional[pulumi.Input[Union['IdentityGcpAccessPolicyArgs', 'IdentityGcpAccessPolicyArgsDict']]] = None,
            gvc: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            native_network_resources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IdentityNativeNetworkResourceArgs', 'IdentityNativeNetworkResourceArgsDict']]]]] = None,
            network_resources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IdentityNetworkResourceArgs', 'IdentityNetworkResourceArgsDict']]]]] = None,
            ngs_access_policy: Optional[pulumi.Input[Union['IdentityNgsAccessPolicyArgs', 'IdentityNgsAccessPolicyArgsDict']]] = None,
            self_link: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'Identity':
        """
        Get an existing Identity resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['IdentityAwsAccessPolicyArgs', 'IdentityAwsAccessPolicyArgsDict']] aws_access_policy: A set of access policy rules that defines the actions and resources that an identity can access within an AWS
               environment.
        :param pulumi.Input[Union['IdentityAzureAccessPolicyArgs', 'IdentityAzureAccessPolicyArgsDict']] azure_access_policy: A set of access policy rules that defines the actions and resources that an identity can access within an Azure
               environment.
        :param pulumi.Input[builtins.str] cpln_id: The ID, in GUID format, of the identity.
        :param pulumi.Input[builtins.str] description: Description of the identity.
        :param pulumi.Input[Union['IdentityGcpAccessPolicyArgs', 'IdentityGcpAccessPolicyArgsDict']] gcp_access_policy: The GCP access policy can either contain an existing service_account or multiple bindings.
        :param pulumi.Input[builtins.str] gvc: The GVC to which this identity belongs.
        :param pulumi.Input[builtins.str] name: Name of the identity.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IdentityNativeNetworkResourceArgs', 'IdentityNativeNetworkResourceArgsDict']]]] native_network_resources: > **NOTE** The configuration of a native network resource requires the assistance of Control Plane support.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IdentityNetworkResourceArgs', 'IdentityNetworkResourceArgsDict']]]] network_resources: A network resource can be configured with: - A fully qualified domain name (FQDN) and ports. - An FQDN, resolver IP, and
               ports. - IP's and ports.
        :param pulumi.Input[Union['IdentityNgsAccessPolicyArgs', 'IdentityNgsAccessPolicyArgsDict']] ngs_access_policy: A set of access policy rules that defines the actions and resources that an identity can access within an NGA
               environment.
        :param pulumi.Input[builtins.str] self_link: Full link to this resource. Can be referenced by other resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] status: Key-value map of identity status. Available fields: `objectName`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IdentityState.__new__(_IdentityState)

        __props__.__dict__["aws_access_policy"] = aws_access_policy
        __props__.__dict__["azure_access_policy"] = azure_access_policy
        __props__.__dict__["cpln_id"] = cpln_id
        __props__.__dict__["description"] = description
        __props__.__dict__["gcp_access_policy"] = gcp_access_policy
        __props__.__dict__["gvc"] = gvc
        __props__.__dict__["name"] = name
        __props__.__dict__["native_network_resources"] = native_network_resources
        __props__.__dict__["network_resources"] = network_resources
        __props__.__dict__["ngs_access_policy"] = ngs_access_policy
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        return Identity(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsAccessPolicy")
    def aws_access_policy(self) -> pulumi.Output[Optional['outputs.IdentityAwsAccessPolicy']]:
        """
        A set of access policy rules that defines the actions and resources that an identity can access within an AWS
        environment.
        """
        return pulumi.get(self, "aws_access_policy")

    @property
    @pulumi.getter(name="azureAccessPolicy")
    def azure_access_policy(self) -> pulumi.Output[Optional['outputs.IdentityAzureAccessPolicy']]:
        """
        A set of access policy rules that defines the actions and resources that an identity can access within an Azure
        environment.
        """
        return pulumi.get(self, "azure_access_policy")

    @property
    @pulumi.getter(name="cplnId")
    def cpln_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID, in GUID format, of the identity.
        """
        return pulumi.get(self, "cpln_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Description of the identity.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="gcpAccessPolicy")
    def gcp_access_policy(self) -> pulumi.Output[Optional['outputs.IdentityGcpAccessPolicy']]:
        """
        The GCP access policy can either contain an existing service_account or multiple bindings.
        """
        return pulumi.get(self, "gcp_access_policy")

    @property
    @pulumi.getter
    def gvc(self) -> pulumi.Output[builtins.str]:
        """
        The GVC to which this identity belongs.
        """
        return pulumi.get(self, "gvc")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the identity.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nativeNetworkResources")
    def native_network_resources(self) -> pulumi.Output[Optional[Sequence['outputs.IdentityNativeNetworkResource']]]:
        """
        > **NOTE** The configuration of a native network resource requires the assistance of Control Plane support.
        """
        return pulumi.get(self, "native_network_resources")

    @property
    @pulumi.getter(name="networkResources")
    def network_resources(self) -> pulumi.Output[Optional[Sequence['outputs.IdentityNetworkResource']]]:
        """
        A network resource can be configured with: - A fully qualified domain name (FQDN) and ports. - An FQDN, resolver IP, and
        ports. - IP's and ports.
        """
        return pulumi.get(self, "network_resources")

    @property
    @pulumi.getter(name="ngsAccessPolicy")
    def ngs_access_policy(self) -> pulumi.Output[Optional['outputs.IdentityNgsAccessPolicy']]:
        """
        A set of access policy rules that defines the actions and resources that an identity can access within an NGA
        environment.
        """
        return pulumi.get(self, "ngs_access_policy")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[builtins.str]:
        """
        Full link to this resource. Can be referenced by other resources.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Key-value map of identity status. Available fields: `objectName`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

