# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 org: Optional[pulumi.Input[builtins.str]] = None,
                 profile: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_token: Optional[pulumi.Input[builtins.str]] = None,
                 token: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[builtins.str] endpoint: The Control Plane Data Service API endpoint. Default is: https://api.cpln.io. Can be specified with the CPLN_ENDPOINT
               environment variable.
        :param pulumi.Input[builtins.str] org: The Control Plane org that this provider will perform actions against. Can be specified with the CPLN_ORG environment
               variable.
        :param pulumi.Input[builtins.str] profile: The user/service account profile that this provider will use to authenticate to the data service. Can be specified with
               the CPLN_PROFILE environment variable.
        :param pulumi.Input[builtins.str] refresh_token: A generated token that can be used to authenticate to the data service API. Can be specified with the CPLN_REFRESH_TOKEN
               environment variable. Used when the provider is required to create an org or update the auth_config property. Refer to
               the section above on how to obtain the refresh token.
        :param pulumi.Input[builtins.str] token: A generated token that can be used to authenticate to the data service API. Can be specified with the CPLN_TOKEN
               environment variable.
        """
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if org is not None:
            pulumi.set(__self__, "org", org)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Control Plane Data Service API endpoint. Default is: https://api.cpln.io. Can be specified with the CPLN_ENDPOINT
        environment variable.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def org(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Control Plane org that this provider will perform actions against. Can be specified with the CPLN_ORG environment
        variable.
        """
        return pulumi.get(self, "org")

    @org.setter
    def org(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user/service account profile that this provider will use to authenticate to the data service. Can be specified with
        the CPLN_PROFILE environment variable.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A generated token that can be used to authenticate to the data service API. Can be specified with the CPLN_REFRESH_TOKEN
        environment variable. Used when the provider is required to create an org or update the auth_config property. Refer to
        the section above on how to obtain the refresh token.
        """
        return pulumi.get(self, "refresh_token")

    @refresh_token.setter
    def refresh_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "refresh_token", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A generated token that can be used to authenticate to the data service API. Can be specified with the CPLN_TOKEN
        environment variable.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "token", value)


@pulumi.type_token("pulumi:providers:cpln")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 org: Optional[pulumi.Input[builtins.str]] = None,
                 profile: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_token: Optional[pulumi.Input[builtins.str]] = None,
                 token: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The provider type for the cpln package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] endpoint: The Control Plane Data Service API endpoint. Default is: https://api.cpln.io. Can be specified with the CPLN_ENDPOINT
               environment variable.
        :param pulumi.Input[builtins.str] org: The Control Plane org that this provider will perform actions against. Can be specified with the CPLN_ORG environment
               variable.
        :param pulumi.Input[builtins.str] profile: The user/service account profile that this provider will use to authenticate to the data service. Can be specified with
               the CPLN_PROFILE environment variable.
        :param pulumi.Input[builtins.str] refresh_token: A generated token that can be used to authenticate to the data service API. Can be specified with the CPLN_REFRESH_TOKEN
               environment variable. Used when the provider is required to create an org or update the auth_config property. Refer to
               the section above on how to obtain the refresh token.
        :param pulumi.Input[builtins.str] token: A generated token that can be used to authenticate to the data service API. Can be specified with the CPLN_TOKEN
               environment variable.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the cpln package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 org: Optional[pulumi.Input[builtins.str]] = None,
                 profile: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_token: Optional[pulumi.Input[builtins.str]] = None,
                 token: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["endpoint"] = endpoint
            __props__.__dict__["org"] = org
            __props__.__dict__["profile"] = profile
            __props__.__dict__["refresh_token"] = None if refresh_token is None else pulumi.Output.secret(refresh_token)
            __props__.__dict__["token"] = None if token is None else pulumi.Output.secret(token)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["refreshToken", "token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Provider, __self__).__init__(
            'cpln',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Control Plane Data Service API endpoint. Default is: https://api.cpln.io. Can be specified with the CPLN_ENDPOINT
        environment variable.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def org(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Control Plane org that this provider will perform actions against. Can be specified with the CPLN_ORG environment
        variable.
        """
        return pulumi.get(self, "org")

    @property
    @pulumi.getter
    def profile(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The user/service account profile that this provider will use to authenticate to the data service. Can be specified with
        the CPLN_PROFILE environment variable.
        """
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A generated token that can be used to authenticate to the data service API. Can be specified with the CPLN_REFRESH_TOKEN
        environment variable. Used when the provider is required to create an org or update the auth_config property. Refer to
        the section above on how to obtain the refresh token.
        """
        return pulumi.get(self, "refresh_token")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A generated token that can be used to authenticate to the data service API. Can be specified with the CPLN_TOKEN
        environment variable.
        """
        return pulumi.get(self, "token")

    @pulumi.output_type
    class TerraformConfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, dict):
                raise TypeError("Expected argument 'result' to be a dict")
            pulumi.set(__self__, "result", result)

        @property
        @pulumi.getter
        def result(self) -> Mapping[str, Any]:
            return pulumi.get(self, "result")

    def terraform_config(__self__) -> pulumi.Output['Provider.TerraformConfigResult']:
        """
        This function returns a Terraform config object with terraform-namecased keys,to be used with the Terraform Module Provider.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        return pulumi.runtime.call('pulumi:providers:cpln/terraformConfig', __args__, res=__self__, typ=Provider.TerraformConfigResult)

