// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.29.0
// source: queries.sql

package log

import (
	"context"
)

const deleteCollection = `-- name: DeleteCollection :exec
DELETE FROM collection c where c.id = ANY($1::text[])
`

func (q *Queries) DeleteCollection(ctx context.Context, collectionIds []string) error {
	_, err := q.db.Exec(ctx, deleteCollection, collectionIds)
	return err
}

const deleteRecordsRange = `-- name: DeleteRecordsRange :exec
DELETE FROM record_log r where r.collection_id = $1 and r.offset >= $2 and r.offset <= $3
`

type DeleteRecordsRangeParams struct {
	CollectionID string
	MinOffset    int64
	MaxOffset    int64
}

func (q *Queries) DeleteRecordsRange(ctx context.Context, arg DeleteRecordsRangeParams) error {
	_, err := q.db.Exec(ctx, deleteRecordsRange, arg.CollectionID, arg.MinOffset, arg.MaxOffset)
	return err
}

const forkCollectionRecord = `-- name: ForkCollectionRecord :exec
INSERT INTO record_log ("offset", collection_id, timestamp, record)
    SELECT record_log.offset, $2, record_log.timestamp, record_log.record
    FROM record_log
    WHERE record_log.collection_id = $1
`

type ForkCollectionRecordParams struct {
	CollectionID   string
	CollectionID_2 string
}

func (q *Queries) ForkCollectionRecord(ctx context.Context, arg ForkCollectionRecordParams) error {
	_, err := q.db.Exec(ctx, forkCollectionRecord, arg.CollectionID, arg.CollectionID_2)
	return err
}

const getAllCollections = `-- name: GetAllCollections :many
SELECT id FROM collection
`

func (q *Queries) GetAllCollections(ctx context.Context) ([]string, error) {
	rows, err := q.db.Query(ctx, getAllCollections)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []string
	for rows.Next() {
		var id string
		if err := rows.Scan(&id); err != nil {
			return nil, err
		}
		items = append(items, id)
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getAllCollectionsToCompact = `-- name: GetAllCollectionsToCompact :many
with summary as (
    select r.collection_id, r.offset, r.timestamp, row_number() over(partition by r.collection_id order by r.offset) as rank
    from record_log r, collection c
    where r.collection_id = c.id
    and (c.record_enumeration_offset_position - c.record_compaction_offset_position) >= $1
    and not c.is_sealed
    and r.offset > c.record_compaction_offset_position
)
select collection_id, "offset", timestamp, rank from summary
where rank=1
order by timestamp
`

type GetAllCollectionsToCompactRow struct {
	CollectionID string
	Offset       int64
	Timestamp    int64
	Rank         int64
}

func (q *Queries) GetAllCollectionsToCompact(ctx context.Context, minCompactionSize int64) ([]GetAllCollectionsToCompactRow, error) {
	rows, err := q.db.Query(ctx, getAllCollectionsToCompact, minCompactionSize)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []GetAllCollectionsToCompactRow
	for rows.Next() {
		var i GetAllCollectionsToCompactRow
		if err := rows.Scan(
			&i.CollectionID,
			&i.Offset,
			&i.Timestamp,
			&i.Rank,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getBoundsForCollection = `-- name: GetBoundsForCollection :one
SELECT CAST(COALESCE(MIN(record_compaction_offset_position), 0) as bigint) AS record_compaction_offset_position, CAST(COALESCE(MAX(record_enumeration_offset_position), 0) as bigint) AS record_enumeration_offset_position, CAST(COALESCE(BOOL_OR(is_sealed), false) AS bool) AS is_sealed
FROM collection
WHERE id = $1
`

type GetBoundsForCollectionRow struct {
	RecordCompactionOffsetPosition  int64
	RecordEnumerationOffsetPosition int64
	IsSealed                        bool
}

func (q *Queries) GetBoundsForCollection(ctx context.Context, id string) (GetBoundsForCollectionRow, error) {
	row := q.db.QueryRow(ctx, getBoundsForCollection, id)
	var i GetBoundsForCollectionRow
	err := row.Scan(&i.RecordCompactionOffsetPosition, &i.RecordEnumerationOffsetPosition, &i.IsSealed)
	return i, err
}

const getCollection = `-- name: GetCollection :one
SELECT id, record_compaction_offset_position, record_enumeration_offset_position, is_sealed
FROM collection
WHERE id = $1
`

func (q *Queries) GetCollection(ctx context.Context, id string) (Collection, error) {
	row := q.db.QueryRow(ctx, getCollection, id)
	var i Collection
	err := row.Scan(
		&i.ID,
		&i.RecordCompactionOffsetPosition,
		&i.RecordEnumerationOffsetPosition,
		&i.IsSealed,
	)
	return i, err
}

const getCollectionForUpdate = `-- name: GetCollectionForUpdate :one
SELECT id, record_compaction_offset_position, record_enumeration_offset_position, is_sealed
FROM collection
WHERE id = $1
FOR UPDATE
`

func (q *Queries) GetCollectionForUpdate(ctx context.Context, id string) (Collection, error) {
	row := q.db.QueryRow(ctx, getCollectionForUpdate, id)
	var i Collection
	err := row.Scan(
		&i.ID,
		&i.RecordCompactionOffsetPosition,
		&i.RecordEnumerationOffsetPosition,
		&i.IsSealed,
	)
	return i, err
}

const getLastCompactedOffset = `-- name: GetLastCompactedOffset :one
SELECT record_compaction_offset_position FROM collection c WHERE c.id = $1
`

func (q *Queries) GetLastCompactedOffset(ctx context.Context, id string) (int64, error) {
	row := q.db.QueryRow(ctx, getLastCompactedOffset, id)
	var record_compaction_offset_position int64
	err := row.Scan(&record_compaction_offset_position)
	return record_compaction_offset_position, err
}

const getMinimumMaximumOffsetForCollection = `-- name: GetMinimumMaximumOffsetForCollection :one
SELECT CAST(COALESCE(MIN(r.offset), 0) as bigint) AS min_offset, CAST(COALESCE(MAX(r.offset), 0) as bigint) AS max_offset
FROM record_log r
WHERE r.collection_id = $1
`

type GetMinimumMaximumOffsetForCollectionRow struct {
	MinOffset int64
	MaxOffset int64
}

func (q *Queries) GetMinimumMaximumOffsetForCollection(ctx context.Context, collectionID string) (GetMinimumMaximumOffsetForCollectionRow, error) {
	row := q.db.QueryRow(ctx, getMinimumMaximumOffsetForCollection, collectionID)
	var i GetMinimumMaximumOffsetForCollectionRow
	err := row.Scan(&i.MinOffset, &i.MaxOffset)
	return i, err
}

const getRecordsForCollection = `-- name: GetRecordsForCollection :many
SELECT "offset", collection_id, timestamp, record FROM record_log r WHERE r.collection_id = $1 AND r.offset >= $2 and r.timestamp <= $4  ORDER BY r.offset ASC limit $3
`

type GetRecordsForCollectionParams struct {
	CollectionID string
	Offset       int64
	Limit        int32
	Timestamp    int64
}

func (q *Queries) GetRecordsForCollection(ctx context.Context, arg GetRecordsForCollectionParams) ([]RecordLog, error) {
	rows, err := q.db.Query(ctx, getRecordsForCollection,
		arg.CollectionID,
		arg.Offset,
		arg.Limit,
		arg.Timestamp,
	)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []RecordLog
	for rows.Next() {
		var i RecordLog
		if err := rows.Scan(
			&i.Offset,
			&i.CollectionID,
			&i.Timestamp,
			&i.Record,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getTotalUncompactedRecordsCount = `-- name: GetTotalUncompactedRecordsCount :one
SELECT CAST(COALESCE(SUM(record_enumeration_offset_position - record_compaction_offset_position), 0) AS bigint) AS total_uncompacted_depth FROM collection
`

func (q *Queries) GetTotalUncompactedRecordsCount(ctx context.Context) (int64, error) {
	row := q.db.QueryRow(ctx, getTotalUncompactedRecordsCount)
	var total_uncompacted_depth int64
	err := row.Scan(&total_uncompacted_depth)
	return total_uncompacted_depth, err
}

const insertCollection = `-- name: InsertCollection :one
INSERT INTO collection (id, record_enumeration_offset_position, record_compaction_offset_position, is_sealed) values($1, $2, $3, $4) returning id, record_compaction_offset_position, record_enumeration_offset_position, is_sealed
`

type InsertCollectionParams struct {
	ID                              string
	RecordEnumerationOffsetPosition int64
	RecordCompactionOffsetPosition  int64
	IsSealed                        bool
}

func (q *Queries) InsertCollection(ctx context.Context, arg InsertCollectionParams) (Collection, error) {
	row := q.db.QueryRow(ctx, insertCollection,
		arg.ID,
		arg.RecordEnumerationOffsetPosition,
		arg.RecordCompactionOffsetPosition,
		arg.IsSealed,
	)
	var i Collection
	err := row.Scan(
		&i.ID,
		&i.RecordCompactionOffsetPosition,
		&i.RecordEnumerationOffsetPosition,
		&i.IsSealed,
	)
	return i, err
}

type InsertRecordParams struct {
	CollectionID string
	Offset       int64
	Record       []byte
	Timestamp    int64
}

const purgeRecords = `-- name: PurgeRecords :exec
DELETE FROM record_log r using collection c where r.collection_id = c.id and r.offset <= c.record_compaction_offset_position
`

func (q *Queries) PurgeRecords(ctx context.Context) error {
	_, err := q.db.Exec(ctx, purgeRecords)
	return err
}

const sealLog = `-- name: SealLog :one
UPDATE collection SET is_sealed = true WHERE id = $1 returning id, record_compaction_offset_position, record_enumeration_offset_position, is_sealed
`

func (q *Queries) SealLog(ctx context.Context, id string) (Collection, error) {
	row := q.db.QueryRow(ctx, sealLog, id)
	var i Collection
	err := row.Scan(
		&i.ID,
		&i.RecordCompactionOffsetPosition,
		&i.RecordEnumerationOffsetPosition,
		&i.IsSealed,
	)
	return i, err
}

const sealLogInsert = `-- name: SealLogInsert :one
INSERT INTO collection(id, is_sealed, record_compaction_offset_position, record_enumeration_offset_position) VALUES ($1, true, 0, 0) returning id, record_compaction_offset_position, record_enumeration_offset_position, is_sealed
`

func (q *Queries) SealLogInsert(ctx context.Context, id string) (Collection, error) {
	row := q.db.QueryRow(ctx, sealLogInsert, id)
	var i Collection
	err := row.Scan(
		&i.ID,
		&i.RecordCompactionOffsetPosition,
		&i.RecordEnumerationOffsetPosition,
		&i.IsSealed,
	)
	return i, err
}

const updateCollectionCompactionOffsetPosition = `-- name: UpdateCollectionCompactionOffsetPosition :exec
UPDATE collection set record_compaction_offset_position = $2 where id = $1
`

type UpdateCollectionCompactionOffsetPositionParams struct {
	ID                             string
	RecordCompactionOffsetPosition int64
}

func (q *Queries) UpdateCollectionCompactionOffsetPosition(ctx context.Context, arg UpdateCollectionCompactionOffsetPositionParams) error {
	_, err := q.db.Exec(ctx, updateCollectionCompactionOffsetPosition, arg.ID, arg.RecordCompactionOffsetPosition)
	return err
}

const updateCollectionEnumerationOffsetPosition = `-- name: UpdateCollectionEnumerationOffsetPosition :exec
UPDATE collection set record_enumeration_offset_position = $2 where id = $1
`

type UpdateCollectionEnumerationOffsetPositionParams struct {
	ID                              string
	RecordEnumerationOffsetPosition int64
}

func (q *Queries) UpdateCollectionEnumerationOffsetPosition(ctx context.Context, arg UpdateCollectionEnumerationOffsetPositionParams) error {
	_, err := q.db.Exec(ctx, updateCollectionEnumerationOffsetPosition, arg.ID, arg.RecordEnumerationOffsetPosition)
	return err
}
