from langdetect import detect
import eng_to_ipa
import epitran

language_dict = {
    "aa": "aar-Latn",
    "aii": "aii-Syrc",
    "am": "amh-Ethi",
    "am-pp": "amh-Ethi-pp",
    "am-red": "amh-Ethi-red",
    "ar": "ara-Arab",
    "av": "ava-Cyrl",
    "az": "aze-Latn",
    "az-cyr": "aze-Cyrl",
    "bn": "ben-Beng",
    "bn-red": "ben-Beng-red",
    "bux": "bxk-Latn",
    "ca": "cat-Latn",
    "ceb": "ceb-Latn",
    "cs": "ces-Latn",
    "cjy": "cjy-Latn",
    "cmn": "cmn-Latn",
    "cmn-hans": "cmn-Hans",
    "cmn-hant": "cmn-Hant",
    "ckb": "ckb-Arab",
    "csb": "csb-Latn",
    "de": "deu-Latn",
    "de-np": "deu-Latn-np",
    "de-nar": "deu-Latn-nar",
    "en": "eng-Latn",
    "eo": "epo-Latn",
    "fa": "fas-Arab",
    "fr": "fra-Latn",
    "fr-np": "fra-Latn-np",
    "fr-p": "fra-Latn-p",
    "ff": "ful-Latn",
    "gan": "gan-Latn",
    "got": "got-Latn",
    "hak": "hak-Latn",
    "ha": "hau-Latn",
    "hi": "hin-Deva",
    "hmn": "hmn-Latn",
    "hr": "hrv-Latn",
    "hsn": "hsn-Latn",
    "hu": "hun-Latn",
    "ilo": "ilo-Latn",
    "id": "ind-Latn",
    "it": "ita-Latn",
    "jam": "jam-Latn",
    "jv": "jav-Latn",
    "kk": "kaz-Cyrl",
    "kk-bab": "kaz-Cyrl-bab",
    "kk-latn": "kaz-Latn",
    "kbd": "kbd-Cyrl",
    "km": "khm-Khmr",
    "rw": "kin-Latn",
    "ky": "kir-Cyrl",
    "ky-arab": "kir-Arab",
    "ky-latn": "kir-Latn",
    "ku": "kmr-Latn",
    "ku-red": "kmr-Latn-red",
    "lo": "lao-Laoo",
    "lij": "lij-Latn",
    "sm": "lsm-Latn",
    "lzh": "ltc-Latn-bax",
    "ml": "mal-Mlym",
    "mr": "mar-Deva",
    "mt": "mlt-Latn",
    "mn": "mon-Cyrl-bab",
    "mi": "mri-Latn",
    "ms": "msa-Latn",
    "my": "mya-Mymr",
    "nan": "nan-Latn",
    "nan-tl": "nan-Latn-tl",
    "nl": "nld-Latn",
    "ny": "nya-Latn",
    "ood": "ood-Latn-sax",
    "or": "ori-Orya",
    "om": "orm-Latn",
    "pa": "pan-Guru",
    "pl": "pol-Latn",
    "pt": "por-Latn",
    "qu": "quy-Latn",
    "ro": "ron-Latn",
    "rn": "run-Latn",
    "ru": "rus-Cyrl",
    "sg": "sag-Latn",
    "si": "sin-Sinh",
    "sn": "sna-Latn",
    "so": "som-Latn",
    "es": "spa-Latn",
    "es-eu": "spa-Latn-eu",
    "sq": "sqi-Latn",
    "sr": "srp-Latn",
    "sw": "swa-Latn",
    "sw-red": "swa-Latn-red",
    "sv": "swe-Latn",
    "ta": "tam-Taml",
    "ta-red": "tam-Taml-red",
    "te": "tel-Telu",
    "tg": "tgk-Cyrl",
    "tl": "tgl-Latn",
    "tl-red": "tgl-Latn-red",
    "th": "tha-Thai",
    "ti": "tir-Ethi",
    "ti-pp": "tir-Ethi-pp",
    "ti-red": "tir-Ethi-red",
    "tpi": "tpi-Latn",
    "tk": "tuk-Latn",
    "tk-cyr": "tuk-Cyrl",
    "tr": "tur-Latn",
    "tr-bab": "tur-Latn-bab",
    "tr-red": "tur-Latn-red",
    "uk": "ukr-Cyrl",
    "ur": "urd-Arab",
    "ug": "uig-Arab",
    "uz": "uzb-Latn",
    "uz-suf": "uzb-Latn-suf",
    "vi": "vie-Latn",
    "wuu": "wuu-Latn",
    "xh": "xho-Latn",
    "yo": "yor-Latn",
    "yue": "yue-Latn",
    "za": "zha-Latn",
    "zu": "zul-Latn"
}


class Transcriber:
    def __init__(self, text: str, lang: str | None = None):
        self.text = text
        if lang is None:
            lang = self.definition_lang()
        self.lang = language_dict.get(lang, "en")

    def transcribe(self):
        if self.lang == "eng-Latn":
            return eng_to_ipa.convert(self.text)
        return epitran.Epitran(self.lang).transliterate(self.text)

    def definition_lang(self) -> str:
        return detect(self.text)
