"""Agent Client protocol (ACP) implementation."""

from acp.client import DefaultACPClient, ClientSideConnection
from acp.agent import AgentSideConnection
from acp.debug_server import cli
from acp.filesystem import ACPFileSystem, ACPPath
from acp.agent.protocol import Agent
from acp.client.protocol import Client
from acp.terminal_handle import TerminalHandle
from acp.schema import (
    AuthenticateRequest,
    AuthenticateResponse,
    CancelNotification,
    CreateTerminalRequest,
    ClientCapabilities,
    SessionMode,
    FileSystemCapability,
    AgentMessageChunk,
    UserMessageChunk,
    TextContentBlock,
    SessionModeState,
    Implementation,
    ToolCallLocation,
    EnvVariable,
    StdioMcpServer,
    SseMcpServer,
    HttpMcpServer,
    CreateTerminalResponse,
    InitializeRequest,
    PlanEntryPriority,
    PlanEntryStatus,
    InitializeResponse,
    KillTerminalCommandRequest,
    KillTerminalCommandResponse,
    LoadSessionRequest,
    LoadSessionResponse,
    ModelInfo,
    AllowedOutcome,
    DeniedOutcome,
    NewSessionRequest,
    NewSessionResponse,
    PromptRequest,
    PromptResponse,
    ReadTextFileRequest,
    ReadTextFileResponse,
    ReleaseTerminalRequest,
    ReleaseTerminalResponse,
    RequestPermissionRequest,
    RequestPermissionResponse,
    SessionModelState,
    SessionNotification,
    SetSessionModelRequest,
    SetSessionModelResponse,
    SetSessionModeRequest,
    SetSessionModeResponse,
    TerminalOutputRequest,
    TerminalOutputResponse,
    WaitForTerminalExitRequest,
    WaitForTerminalExitResponse,
    WriteTextFileRequest,
    WriteTextFileResponse,
    PermissionOption,
    PROTOCOL_VERSION,
    AgentMethod,
    ClientMethod,
    Annotations,
    AvailableCommand,
    PlanEntry,
    ToolCallContent,
    ToolCallKind,
    ToolCallStatus,
    ToolCall,
)
from acp.stdio import stdio_streams, run_agent, connect_to_agent
from acp.exceptions import RequestError

__version__ = "0.0.1"

__all__ = [  # noqa: RUF022
    # constants
    "PROTOCOL_VERSION",
    # literal types
    "AgentMethod",
    "ClientMethod",
    # types
    "Annotations",
    "AvailableCommand",
    "PlanEntry",
    "AllowedOutcome",
    "ToolCall",
    "DeniedOutcome",
    "ToolCallContent",
    "PermissionOption",
    "ToolCallKind",
    "PlanEntryPriority",
    "PlanEntryStatus",
    "ToolCallStatus",
    "InitializeRequest",
    "ToolCallLocation",
    "InitializeResponse",
    "EnvVariable",
    "HttpMcpServer",
    "StdioMcpServer",
    "SseMcpServer",
    "NewSessionRequest",
    "AgentMessageChunk",
    "UserMessageChunk",
    "TextContentBlock",
    "NewSessionResponse",
    "LoadSessionRequest",
    "LoadSessionResponse",
    "AuthenticateRequest",
    "AuthenticateResponse",
    "PromptRequest",
    "ClientCapabilities",
    "SessionModeState",
    "SessionMode",
    "Implementation",
    "PromptResponse",
    "WriteTextFileRequest",
    "WriteTextFileResponse",
    "ReadTextFileRequest",
    "ReadTextFileResponse",
    "RequestPermissionRequest",
    "RequestPermissionResponse",
    "CancelNotification",
    "SessionNotification",
    "SetSessionModeRequest",
    "SetSessionModeResponse",
    # model types
    "ModelInfo",
    "SessionModelState",
    "SetSessionModelRequest",
    "SetSessionModelResponse",
    # terminal types
    "CreateTerminalRequest",
    "CreateTerminalResponse",
    "TerminalOutputRequest",
    "TerminalOutputResponse",
    "WaitForTerminalExitRequest",
    "WaitForTerminalExitResponse",
    "KillTerminalCommandRequest",
    "KillTerminalCommandResponse",
    "ReleaseTerminalRequest",
    "ReleaseTerminalResponse",
    # core
    "AgentSideConnection",
    "ClientSideConnection",
    "RequestError",
    "Agent",
    "Client",
    "DefaultACPClient",
    "TerminalHandle",
    # connection helpers (recommended)
    "run_agent",
    "connect_to_agent",
    # split protocols
    "FileSystemCapability",
    # stdio helper
    "stdio_streams",
    # filesystem
    "ACPFileSystem",
    "ACPPath",
    # cli
    "cli",
]
