"""Schema definitions for the ACP protocol."""

from acp.schema.agent_plan import PlanEntry, PlanEntryPriority, PlanEntryStatus
from acp.schema.agent_requests import (
    ReadTextFileRequest,
    ReleaseTerminalRequest,
    RequestPermissionRequest,
    CreateTerminalRequest,
    TerminalOutputRequest,
    KillTerminalCommandRequest,
    WaitForTerminalExitRequest,
    WriteTextFileRequest,
    AgentRequest,
)
from acp.schema.client_responses import (
    CreateTerminalResponse,
    KillTerminalCommandResponse,
    ReadTextFileResponse,
    WriteTextFileResponse,
    ReleaseTerminalResponse,
    RequestPermissionResponse,
    TerminalOutputResponse,
    WaitForTerminalExitResponse,
    ClientResponse,
)
from acp.schema.client_requests import (
    InitializeRequest,
    AuthenticateRequest,
    LoadSessionRequest,
    NewSessionRequest,
    SetSessionModeRequest,
    SetSessionModelRequest,
    PromptRequest,
    CustomRequest,
    ClientRequest,
)
from acp.schema.agent_responses import (
    InitializeResponse,
    AuthenticateResponse,
    LoadSessionResponse,
    NewSessionResponse,
    SetSessionModeResponse,
    SetSessionModelResponse,
    PromptResponse,
    CustomResponse,
    StopReason,
    AgentResponse,
)
from acp.schema.capabilities import (
    AgentCapabilities,
    ClientCapabilities,
    McpCapabilities,
    PromptCapabilities,
    FileSystemCapability,
)
from acp.schema.mcp import (
    SseMcpServer,
    StdioMcpServer,
    HttpHeader,
    HttpMcpServer,
    McpServer,
)
from acp.schema.messages import AgentMethod, ClientMethod
from acp.schema.notifications import CancelNotification, SessionNotification
from acp.schema.common import EnvVariable, Implementation, AuthMethod
from acp.schema.session_state import (
    SessionMode,
    SessionModeState,
    SessionModelState,
    ModelInfo,
)
from acp.schema.slash_commands import (
    AvailableCommand,
    AvailableCommandInput,
    CommandInputHint,
)
from acp.schema.tool_call import (
    ToolCall,
    ToolCallLocation,
    ToolCallKind,
    ContentToolCallContent,
    FileEditToolCallContent,
    TerminalToolCallContent,
    ToolCallContent,
    PermissionKind,
    PermissionOption,
    ToolCallStatus,
    AllowedOutcome,
    DeniedOutcome,
)
from acp.schema.session_updates import (
    AgentMessageChunk,
    AgentThoughtChunk,
    AgentPlanUpdate,
    UserMessageChunk,
    CurrentModeUpdate,
    AvailableCommandsUpdate,
    ToolCallStart,
    ToolCallProgress,
    SessionUpdate,
)
from acp.schema.content_blocks import (
    TextContentBlock,
    AudioContentBlock,
    ImageContentBlock,
    ResourceContentBlock,
    EmbeddedResourceContentBlock,
    Annotations,
    TextResourceContents,
    BlobResourceContents,
    ContentBlock,
    Audience,
)

PROTOCOL_VERSION = 1

__all__ = [
    "PROTOCOL_VERSION",
    "AgentCapabilities",
    "AgentMessageChunk",
    "AgentMethod",
    "AgentPlanUpdate",
    "AgentRequest",
    "AgentResponse",
    "AgentThoughtChunk",
    "AllowedOutcome",
    "Annotations",
    "Audience",
    "AudioContentBlock",
    "AuthMethod",
    "AuthenticateRequest",
    "AuthenticateResponse",
    "AvailableCommand",
    "AvailableCommandInput",
    "AvailableCommandsUpdate",
    "BlobResourceContents",
    "CancelNotification",
    "ClientCapabilities",
    "ClientMethod",
    "ClientRequest",
    "ClientResponse",
    "CommandInputHint",
    "ContentBlock",
    "ContentToolCallContent",
    "CreateTerminalRequest",
    "CreateTerminalResponse",
    "CurrentModeUpdate",
    "CustomRequest",
    "CustomResponse",
    "DeniedOutcome",
    "EmbeddedResourceContentBlock",
    "EnvVariable",
    "FileEditToolCallContent",
    "FileSystemCapability",
    "HttpHeader",
    "HttpMcpServer",
    "ImageContentBlock",
    "Implementation",
    "InitializeRequest",
    "InitializeResponse",
    "KillTerminalCommandRequest",
    "KillTerminalCommandResponse",
    "LoadSessionRequest",
    "LoadSessionResponse",
    "McpCapabilities",
    "McpServer",
    "ModelInfo",
    "NewSessionRequest",
    "NewSessionResponse",
    "PermissionKind",
    "PermissionOption",
    "PlanEntry",
    "PlanEntryPriority",
    "PlanEntryStatus",
    "PromptCapabilities",
    "PromptRequest",
    "PromptResponse",
    "ReadTextFileRequest",
    "ReadTextFileResponse",
    "ReleaseTerminalRequest",
    "ReleaseTerminalResponse",
    "RequestPermissionRequest",
    "RequestPermissionResponse",
    "ResourceContentBlock",
    "SessionMode",
    "SessionModeState",
    "SessionModelState",
    "SessionNotification",
    "SessionUpdate",
    "SetSessionModeRequest",
    "SetSessionModeResponse",
    "SetSessionModelRequest",
    "SetSessionModelResponse",
    "SseMcpServer",
    "StdioMcpServer",
    "StopReason",
    "TerminalOutputRequest",
    "TerminalOutputResponse",
    "TerminalToolCallContent",
    "TextContentBlock",
    "TextResourceContents",
    "ToolCall",
    "ToolCallContent",
    "ToolCallKind",
    "ToolCallLocation",
    "ToolCallProgress",
    "ToolCallStart",
    "ToolCallStatus",
    "UserMessageChunk",
    "WaitForTerminalExitRequest",
    "WaitForTerminalExitResponse",
    "WriteTextFileRequest",
    "WriteTextFileResponse",
]
