from enum import Enum, auto


class TokenType(Enum):
    JIKA = auto()
    KALAU = auto()
    MAKA = auto()
    TIDAK = auto()
    LAINNYA = auto()
    SELESAI = auto()
    SELAMA = auto()
    ULANGI = auto()
    KALI = auto()
    UNTUK = auto()
    SETIAP = auto()
    DARI = auto()
    SAMPAI = auto()
    LANJUT = auto()
    BERHENTI = auto()
    LEWATI = auto()
    COBA = auto()
    TANGKAP = auto()
    AKHIRNYA = auto()
    COCOK = auto()
    KASUS = auto()
    BAWAAN = auto()
    SIMPAN = auto()
    KE = auto()
    DALAM = auto()
    ITU = auto()
    ADALAH = auto()
    SEBAGAI = auto()
    TAMPILKAN = auto()
    TULIS = auto()
    CETAK = auto()
    TUNJUKKAN = auto()
    TANYA = auto()
    BUAT = auto()
    FUNGSI = auto()
    DENGAN = auto()
    PARAMETER = auto()
    PANGGIL = auto()
    JALANKAN = auto()
    KEMBALI = auto()
    HASIL = auto()
    KELAS = auto()
    METODE = auto()
    KONSTRUKTOR = auto()
    WARISI = auto()
    GUNAKAN = auto()
    IMPOR = auto()
    IMPOR_PYTHON = auto()
    PANGGIL_PYTHON = auto()
    MODUL = auto()
    PAKET = auto()
    LAMBDA = auto()
    ASYNC = auto()
    AWAIT = auto()
    YIELD = auto()
    YIELD_FROM = auto()
    DEKORATOR = auto()
    PROPERTI = auto()
    METODE_STATIS = auto()
    METODE_KELAS = auto()
    TIPE = auto()
    JENIS_DATA = auto()
    GENERATOR = auto()
    ASINKRON = auto()
    TAMBAH = auto()
    KURANG = auto()
    KALI_OP = auto()
    BAGI = auto()
    SISA_BAGI = auto()
    PANGKAT = auto()
    PEMBAGIAN_BULAT = auto()
    BIT_DAN = auto()
    BIT_ATAU = auto()
    BIT_XOR = auto()
    BIT_NOT = auto()
    GESER_KIRI = auto()
    GESER_KANAN = auto()
    TAMBAH_SAMA_DENGAN = auto()
    KURANG_SAMA_DENGAN = auto()
    KALI_SAMA_DENGAN = auto()
    BAGI_SAMA_DENGAN = auto()
    SISA_SAMA_DENGAN = auto()
    PANGKAT_SAMA_DENGAN = auto()
    PEMBAGIAN_BULAT_SAMA_DENGAN = auto()
    BIT_DAN_SAMA_DENGAN = auto()
    BIT_ATAU_SAMA_DENGAN = auto()
    BIT_XOR_SAMA_DENGAN = auto()
    GESER_KIRI_SAMA_DENGAN = auto()
    GESER_KANAN_SAMA_DENGAN = auto()
    SAMA_DENGAN = auto()
    TIDAK_SAMA = auto()
    LEBIH_DARI = auto()
    KURANG_DARI = auto()
    LEBIH_SAMA = auto()
    KURANG_SAMA = auto()
    DAN = auto()
    ATAU = auto()
    DALAM_OP = auto()
    TIDAK_DALAM = auto()
    ADALAH_OP = auto()
    BUKAN = auto()
    BENAR = auto()
    SALAH = auto()
    WALRUS = auto()
    ARROW = auto()
    ELLIPSIS = auto()
    AT = auto()
    ANGKA = auto()
    TEKS = auto()
    BOOLEAN = auto()
    DAFTAR_AWAL = auto()
    DAFTAR_AKHIR = auto()
    KAMUS_AWAL = auto()
    KAMUS_AKHIR = auto()
    HIMPUNAN_AWAL = auto()
    HIMPUNAN_AKHIR = auto()
    KOMA = auto()
    TITIK_DUA = auto()
    TITIK_KOMA = auto()
    TITIK = auto()
    IDENTIFIER = auto()
    SELF = auto()
    EOF = auto()
    FORMAT_STRING = auto()
    FORMAT_EXPR_START = auto()
    FORMAT_EXPR_END = auto()

    STRING_CONST = auto()
    INTEGER_CONST = auto()
    FLOAT_CONST = auto()
    F_STRING = auto()
    LPAREN = auto()
    RPAREN = auto()
    LBRACKET = auto()
    RBRACKET = auto()
    LBRACE = auto()
    RBRACE = auto()
    COMMA = auto()
    COLON = auto()
    DOT = auto()
    SEMICOLON = auto()

    BITWISE_AND = auto()
    BITWISE_OR = auto()
    BITWISE_XOR = auto()
    BITWISE_NOT = auto()
    BITWISE_AND_SAMA_DENGAN = auto()
    BITWISE_OR_SAMA_DENGAN = auto()
    BITWISE_XOR_SAMA_DENGAN = auto()

    NOT = auto()

    UNTUK_DALAM = auto()
    JIKA_KONDISI = auto()
    NEWLINE = auto()
    KURUNG_AWAL = auto()
    KURUNG_AKHIR = auto()
    TUPLE_AWAL = auto()
    TUPLE_AKHIR = auto()
    ASSIGNMENT = auto()
    TITIK_TITIK = auto()
    TIGA_TITIK = auto()
    TANYA_MARK = auto()
    SERU = auto()
    HASH = auto()
    DOLLAR = auto()
    BACKTICK = auto()
    PIPE = auto()
    PIPE_PIPE = auto()
    AMPERSAND = auto()
    AMPERSAND_AMPERSAND = auto()
    CARET = auto()
    TILDE = auto()
    SHIFT_LEFT = auto()
    SHIFT_RIGHT = auto()
    OR_SAMA_DENGAN = auto()
    AND_SAMA_DENGAN = auto()
    XOR_SAMA_DENGAN = auto()
    SHIFT_LEFT_SAMA_DENGAN = auto()
    SHIFT_RIGHT_SAMA_DENGAN = auto()
    NULLISH_ASSIGNMENT = auto()
    RAW_STRING = auto()
    BYTE_STRING = auto()
    UNICODE_STRING = auto()
    CHAR_LITERAL = auto()
    TRIPLE_QUOTE = auto()
    SINGLE_COMMENT = auto()
    MULTI_COMMENT_START = auto()
    MULTI_COMMENT_END = auto()
    DOC_COMMENT = auto()
    TYPE_HINT = auto()
    UNION_TYPE = auto()
    GENERIC_START = auto()
    GENERIC_END = auto()
    NULLABLE = auto()
    MATCH = auto()
    CASE = auto()
    GUARD = auto()
    WILDCARD = auto()
    ROUTE = auto()
    GET = auto()
    POST = auto()
    PUT = auto()
    DELETE = auto()
    API = auto()
    ENDPOINT = auto()
    SELECT = auto()
    WHERE = auto()
    ORDER = auto()
    GROUP = auto()
    JOIN = auto()
    AWAIT_SEMUA = auto()
    PARALLEL = auto()
    STREAM = auto()
    OBSERVE = auto()
    EMIT = auto()
    LISTEN = auto()
    SWITCH = auto()
    DEFAULT = auto()
    FALLTHROUGH = auto()
    LOOP = auto()
    REPEAT_UNTIL = auto()
    WEAK = auto()
    STRONG = auto()
    LAZY = auto()
    CACHE = auto()
    MAP = auto()
    FILTER = auto()
    REDUCE = auto()
    COMPOSE = auto()
    CURRY = auto()
    RESULT = auto()
    OPTION = auto()
    SOME = auto()
    NONE = auto()
    OK = auto()
    ERROR = auto()
    JSON_START = auto()
    JSON_END = auto()
    ARRAY_LITERAL = auto()
    OBJECT_LITERAL = auto()
    REGEX_START = auto()
    REGEX_END = auto()
    REGEX_FLAGS = auto()
    LOCALE = auto()
    TRANSLATE = auto()
    CURRENCY = auto()
    DATE_FORMAT = auto()


class Token:

    def __init__(self, type, value, line=0, column=0):
        self.type = type
        self.value = value
        self.line = line
        self.column = column

    def __str__(self):
        return f"Token({self.type}, {repr(self.value)}, line={self.line}, column={self.column})"

    def __repr__(self):
        return self.__str__()
