# SemanticScout

A language-aware semantic code search MCP server with intelligent filtering and enhanced dependency analysis.

[![Python 3.12+](https://img.shields.io/badge/python-3.12+-blue.svg)](https://www.python.org/downloads/)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)
[![GPU Support](https://img.shields.io/badge/GPU-CUDA%20Accelerated-green.svg)](https://pytorch.org/get-started/locally/)

## 🚀 Features

- **🧠 Semantic Search**: Natural language understanding of code functionality
- **🔍 Symbol Resolution**: Precise function/class/variable lookup with AST parsing
- **📊 Dependency Tracking**: Advanced dependency graph analysis (9.3x better than v3.1.4)
- **🎯 Context Expansion**: Intelligent code context retrieval with multiple expansion levels
- **⚡ GPU Acceleration**: 5-10x faster embedding generation with CUDA support
- **🔧 Language Support**: Python, JavaScript, TypeScript, Java, C#, Go, Rust, and more
- **🎛️ Query Intent Tracking**: Meta-learning system for search optimization
- **🚀 High Performance**: Optimized indexing with parallel processing

## 📋 Prerequisites

- **Python 3.12 or higher** (required)
- 4GB+ RAM recommended
- SSD storage for best performance
- **Optional**: NVIDIA GPU with CUDA support for 5-10x acceleration
- **Optional**: Ollama with `nomic-embed-text` model (alternative embedding provider)

## 🛠️ Installation

### Python 3.12 Setup

**macOS (Homebrew)**:
```bash
brew install python@3.12
```

**Windows**:
- Download from [python.org](https://www.python.org/downloads/windows/)
- Or use winget: `winget install Python.Python.3.12`

**Linux (Ubuntu/Debian)**:
```bash
sudo apt update
sudo apt install python3.12 python3.12-venv python3.12-pip
```

**Linux (CentOS/RHEL/Fedora)**:
```bash
sudo dnf install python3.12 python3.12-pip
```

### SemanticScout Installation

1. **Install SemanticScout**:
   ```bash
   # Basic installation (uses sentence-transformers by default)
   pip install semanticscout

   # With GPU support (recommended for 5-10x performance boost)
   pip install semanticscout[gpu]
   ```

2. **Verify Installation**:
   ```bash
   python -c "import semanticscout; print('✅ SemanticScout installed')"
   ```

3. **Optional: Install Ollama** (alternative embedding provider):
   ```bash
   # Download from https://ollama.ai
   ollama pull nomic-embed-text
   ```

### 🎮 GPU Support (Recommended for Performance)

SemanticScout uses **sentence-transformers by default** and supports GPU acceleration for 5-10x faster embedding generation.

**Two ways to enable GPU support:**

**Option 1: Install with GPU extras (easiest)**:
```bash
pip install semanticscout[gpu]
```

**Option 2: Manual PyTorch GPU installation**:
```bash
# For CUDA 12.4 (recommended)
pip install torch torchvision torchaudio --index-url https://download.pytorch.org/whl/cu124

# For CUDA 11.8
pip install torch torchvision torchaudio --index-url https://download.pytorch.org/whl/cu118
```

**Verify GPU Support**:
```bash
python -c "import torch; print(f'CUDA available: {torch.cuda.is_available()}'); print(f'GPU devices: {torch.cuda.device_count()}')"
```

**Performance Comparison**:
- **CPU**: ~100-200 embeddings/second
- **GPU**: ~1000-2000 embeddings/second (RTX 3090/4090)
- **Large codebases**: 5-10x faster indexing
- **Auto-detection**: GPU used automatically if available, graceful CPU fallback

## ⚙️ Configuration

Configure SemanticScout in your MCP client (e.g., Claude Desktop's `claude_desktop_config.json`):

```json
{
  "mcpServers": {
    "semanticscout": {
      "command": "uvx",
      "args": ["--python", "3.12", "semanticscout@latest"],
      "env": {
        "EMBEDDING_PROVIDER": "sentence-transformers",
        "DEVICE_PREFERENCE": "auto",
        "GPU_BATCH_SIZE": "64",
        "SEMANTICSCOUT_ENABLE_ENHANCEMENTS": "true"
      }
    }
  }
}
```

**For Ollama (alternative embedding provider)**:
```json
{
  "mcpServers": {
    "semanticscout": {
      "command": "uvx",
      "args": ["--python", "3.12", "semanticscout@latest"],
      "env": {
        "EMBEDDING_PROVIDER": "ollama",
        "OLLAMA_BASE_URL": "http://localhost:11434",
        "OLLAMA_MODEL": "nomic-embed-text"
      }
    }
  }
}
```

### GPU Configuration Options

```bash
# Auto-detect GPU (default)
DEVICE_PREFERENCE=auto

# Force GPU usage
DEVICE_PREFERENCE=cuda

# Force CPU usage
DEVICE_PREFERENCE=cpu

# Customize batch sizes
GPU_BATCH_SIZE=128
CPU_BATCH_SIZE=32

# Enable GPU memory monitoring
GPU_MEMORY_MONITORING=true
```

## 🚀 Quick Start

1. **Index your codebase**:
   ```bash
   # Index current directory
   index_codebase()
   
   # Index specific path
   index_codebase(path="/path/to/your/project")
   ```

2. **Search your code**:
   ```bash
   # Natural language search
   search_code("authentication functions", collection_name="your_project")
   
   # Find specific symbols
   find_symbol("UserController", collection_name="your_project")
   ```

3. **Check GPU status**:
   ```bash
   get_gpu_status()
   ```

## 📚 Documentation

- [User Guide](docs/USER_GUIDE.md) - Complete usage guide
- [API Reference](docs/API_REFERENCE.md) - Detailed API documentation
- [Configuration](docs/CONFIGURATION.md) - Advanced configuration options
- [Performance Tuning](docs/PERFORMANCE_TUNING.md) - Optimization tips
- [Architecture](docs/ARCHITECTURE.md) - Technical architecture details

## 🤝 Contributing

We welcome contributions! Please see our [Contributing Guide](CONTRIBUTING.md) for details.

## 📄 License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

## 🙏 Acknowledgments

- Built with [FastMCP](https://github.com/pydantic/fastmcp) framework
- Powered by [ChromaDB](https://www.trychroma.com/) vector database
- Uses [tree-sitter](https://tree-sitter.github.io/) for AST parsing
- GPU acceleration via [PyTorch](https://pytorch.org/)
- Embeddings by [Ollama](https://ollama.ai/) and [sentence-transformers](https://www.sbert.net/)

---

**Made with ❤️ for developers who want smarter code search**
