"""English (US) translations for LangBot Plugin CLI"""

messages = {
    # General messages
    "version_info": "LangBot Plugin CLI v{}",
    "unknown_command": "Unknown command: {}",
    "running_plugin": "Running plugin in current directory",
    # Plugin initialization
    "no_plugin_name": "No plugin name specified, generating content in current directory",
    "invalid_plugin_name": "Invalid plugin name: {}",
    "invalid_name_format": "Please use a valid name, which only contains letters, numbers, underscores and hyphens.",
    "directory_not_empty": "Directory {} is not empty, use a different name or empty it",
    "creating_plugin": "Creating plugin {}, anything you input can be modified later.",
    "creating_files": "Creating files in {}...",
    "git_repo_initialized": "Initialized Git repository in {}",
    "git_init_warning": "Warning: Failed to initialize Git repository: {}",
    "git_not_found": "Git not found, skipping Git repository initialization.",
    "plugin_created": "Plugin {} created successfully (directory: {})",
    # Component generation
    "run_in_plugin_root": "Please run this command in the root directory of the plugin.",
    "generating_component": "Generating component {}...",
    "component_not_found": "Component type {} not found.",
    "available_components": "Please use one of the following component types:",
    "component_generated": "Component {} generated successfully.",
    # Build
    "manifest_not_found": "Plugin manifest not found",
    "building_plugin": "Building plugin to {}...",
    "skipping_ignored_dir": "  - Skipping ignored directory: {}",
    "skipping_ignored_file": "  - Skipping ignored file: {}",
    "skipping_excluded_file": "  - Skipping excluded file: {}",
    "file_added": "  - Added: {}",
    "file_add_error": "  - Error adding {}: {}",
    "plugin_built": "Plugin built successfully: {}",
    # Login
    "starting_login": "Starting LangBot CLI login process...",
    "generating_device_code": "Generating device code...",
    "device_code_failed": "Failed to generate device code: {}",
    "copy_user_code": "Please copy the user code and complete verification in your browser:",
    "user_code_label": "User Code: {}",
    "verification_url_label": "Verification URL: {}",
    "code_expires_label": "Device code expires in: {} seconds",
    "waiting_verification": "Waiting for verification...",
    "login_timeout": "Login timeout or failed, please try again",
    "login_successful": "✅ Login successful!",
    "token_saved": "Access token saved to: {}",
    "token_type_label": "Token type: {}",
    "expires_in_label": "Expires in: {} seconds",
    "login_cancelled": "Login cancelled",
    "login_error": "Error occurred during login: {}",
    "network_request_failed": "Network request failed: {}",
    "token_get_failed": "Failed to get token: {}",
    "token_check_failed": "Failed to check token status: {}",
    "token_refresh_failed": "Failed to refresh token: {}",
    # Form
    "invalid_format_error": "Invalid plugin author, please use a valid name, which only contains letters, numbers, underscores and hyphens.",
    "plugin_author": "Plugin author",
    "plugin_description": "Plugin description",
    # Runtime
    "plugin_process_cancelled": "Plugin process cancelled",
    "keyboard_interrupt": "Keyboard interrupt, exiting...",
    "debug_url_not_set": "DEBUG_RUNTIME_WS_URL is not set in .env file",
    # Logout
    "logout_successful": "✅ Logout successful!",
    "config_file_removed": "Configuration file removed: {}",
    "already_logged_out": "Already logged out - no configuration file found",
    "logout_error": "Error occurred during logout: {}",
    # Publish
    "not_logged_in": "Not logged in, please login first with `lbp login`",
    "publish_failed": "!!! Failed to publish plugin: {}",
    "publish_successful": "✅ Plugin published successfully. You can check it on {}/market",
    "publish_successful_new_plugin": "⚠️ Plugin draft published successfully. You need to upload usage screenshots on {}/market to complete the submission.",
}
