# MIDAS CIVIL NX Python

![MIDAS PYTHON](https://midas-rnd.github.io/midasapi-python/assets/banner.png)

---

[![PyPI Downloads](https://static.pepy.tech/badge/midas-civil)](https://pepy.tech/projects/midas-civil)

**`midas-civil`** is a Python library that provides an interface to interact with MIDAS Civil NX using Python scripts.  
This library allows engineers and developers to automate tasks, extract structural analysis results, manipulate model data, and integrate MIDAS Civil NX with other tools or pipelines using Python.



## Features

* **Model Interaction**: Create, modify, and query elements, nodes, materials, sections, and boundary conditions.

* **Automation**: Run simulations and extract results automatically using Python scripts.

* **Data Extraction**: Access analysis results including forces, displacements, reactions, stresses, etc.

* **Integration**: Seamlessly connect MIDAS Civil NX with data analysis tools like pandas, NumPy, and visualization tools like matplotlib.


## Installation
You can install the library using pip:

```py
pip install midas-civil
```


**Requirements:**
* Python 3+
* MIDAS Civil NX


## Documentation
Python Documentation: [Documentation](https://midas-rnd.github.io/midasapi-python/)   
API Reference: [JSON Manual](https://support.midasuser.com/hc/en-us/articles/33016922742937-MIDAS-API-Online-Manual)


## License
This project is licensed under the MIT License.