# Generated by Django 4.0.3 on 2022-04-10 19:40

from django.db import migrations, models

def change_to(apps, schema_editor, fromto=('horizontal', 'tabular')):
    CollectionBlock = apps.get_model('formative', 'CollectionBlock')
    for block in CollectionBlock.objects.all():
        if block.align_type == fromto[0]:
            block.align_type = fromto[1]
            block.save()

def change_to_tabular(apps, schema_editor):
    return change_to(apps, schema_editor)
def change_to_horizontal(apps, schema_editor):
    return change_to(apps, schema_editor, fromto=('tabular', 'horizontal'))


class Migration(migrations.Migration):

    dependencies = [
        ('formative', '0006_alter_formblock__rank'),
    ]

    operations = [
        migrations.AlterField(
            model_name='collectionblock',
            name='align_type',
            field=models.CharField(choices=[('tabular', 'tabular'), ('stacked', 'stacked')], default='tabular', max_length=16),
        ),
        migrations.RunPython(change_to_tabular, change_to_horizontal)
    ]
