# These are the valid SO terms with corresponding severity rank
SO_TERMS = {
    "transcript_ablation": {"rank": 1, "region": "exonic"},
    "splice_donor_variant": {"rank": 2, "region": "splicing"},
    "splice_acceptor_variant": {"rank": 3, "region": "splicing"},
    "stop_gained": {"rank": 4, "region": "exonic"},
    "frameshift_variant": {"rank": 5, "region": "exonic"},
    "stop_lost": {"rank": 6, "region": "exonic"},
    "start_lost": {"rank": 7, "region": "exonic"},
    "initiator_codon_variant": {"rank": 8, "region": "exonic"},
    "inframe_insertion": {"rank": 9, "region": "exonic"},
    "inframe_deletion": {"rank": 10, "region": "exonic"},
    "missense_variant": {"rank": 11, "region": "exonic"},
    "protein_altering_variant": {"rank": 12, "region": "exonic"},
    "transcript_amplification": {"rank": 13, "region": "exonic"},
    "regulatory_region_ablation": {"rank": 14, "region": "regulatory_region"},
    "splice_region_variant": {"rank": 15, "region": "splicing"},
    "splice_donor_5th_base_variant": {"rank": 16, "region": "splicing"},
    "splice_donor_region_variant": {"rank": 17, "region": "splicing"},
    "splice_polypyrimidine_tract_variant": {"rank": 18, "region": "splicing"},
    "incomplete_terminal_codon_variant": {"rank": 19, "region": "exonic"},
    "synonymous_variant": {"rank": 20, "region": "exonic"},
    "start_retained_variant": {"rank": 21, "region": "exonic"},
    "stop_retained_variant": {"rank": 22, "region": "exonic"},
    "coding_sequence_variant": {"rank": 23, "region": "exonic"},
    "mature_miRNA_variant": {"rank": 24, "region": "ncRNA_exonic"},
    "5_prime_UTR_variant": {"rank": 25, "region": "5UTR"},
    "3_prime_UTR_variant": {"rank": 26, "region": "3UTR"},
    "non_coding_transcript_exon_variant": {"rank": 27, "region": "ncRNA_exonic"},
    "non_coding_exon_variant": {"rank": 28, "region": "ncRNA_exonic"},
    "non_coding_transcript_variant": {"rank": 29, "region": "ncRNA_exonic"},
    "nc_transcript_variant": {"rank": 30, "region": "ncRNA_exonic"},
    "intron_variant": {"rank": 31, "region": "intronic"},
    "NMD_transcript_variant": {"rank": 32, "region": "ncRNA"},
    "coding_transcript_variant": {"rank": 33, "region": "exonic"},
    "upstream_gene_variant": {"rank": 34, "region": "upstream"},
    "downstream_gene_variant": {"rank": 35, "region": "downstream"},
    "TFBS_ablation": {"rank": 36, "region": "TFBS"},
    "TFBS_amplification": {"rank": 37, "region": "TFBS"},
    "TF_binding_site_variant": {"rank": 38, "region": "TFBS"},
    "regulatory_region_amplification": {"rank": 39, "region": "regulatory_region"},
    "regulatory_region_variant": {"rank": 40, "region": "regulatory_region"},
    "feature_elongation": {"rank": 41, "region": "genomic_feature"},
    "feature_truncation": {"rank": 42, "region": "genomic_feature"},
    "intergenic_variant": {"rank": 43, "region": "intergenic_variant"},
    "sequence_variant": {"rank": 44, "region": "genomic_feature"},
}

SO_TERM_KEYS = list(SO_TERMS.keys())

SEVERE_SO_TERMS = (
    "transcript_ablation",
    "splice_donor_variant",
    "splice_acceptor_variant",
    "stop_gained",
    "frameshift_variant",
    "stop_lost",
    "start_lost",
    "initiator_codon_variant",
    "inframe_insertion",
    "inframe_deletion",
    "missense_variant",
    "protein_altering_variant",
    "transcript_amplification",
    "splice_region_variant",
    "splice_donor_5th_base_variant",
    "splice_donor_region_variant",
    "splice_polypyrimidine_tract_variant",
    "incomplete_terminal_codon_variant",
    "synonymous_variant",
    "start_retained_variant",
    "stop_retained_variant",
    "coding_sequence_variant",
)

SEVERE_SO_TERMS_SV = (
    "transcript_ablation",
    "splice_donor_variant",
    "splice_acceptor_variant",
    "stop_gained",
    "frameshift_variant",
    "stop_lost",
    "start_lost",
    "initiator_codon_variant",
    "inframe_insertion",
    "inframe_deletion",
    "missense_variant",
    "protein_altering_variant",
    "transcript_amplification",
    "splice_region_variant",
    "splice_donor_5th_base_variant",
    "splice_donor_region_variant",
    "splice_polypyrimidine_tract_variant",
    "incomplete_terminal_codon_variant",
    "synonymous_variant",
    "start_retained_variant",
    "stop_retained_variant",
    "coding_sequence_variant",
)
