from hyperscale.kite.checks.core import CheckResult
from hyperscale.kite.checks.core import CheckStatus


class VulnerabilityScanningInCICDPipelinesCheck:
    def __init__(self):
        self.check_id = "vulnerability-scanning-in-cicd-pipelines"
        self.check_name = "Vulnerability Scanning in CI/CD Pipelines"

    @property
    def question(self) -> str:
        return "Are vulnerability scanning tools integrated into your CI/CD pipelines?"

    @property
    def description(self) -> str:
        return (
            "This check verifies that vulnerability scanning tools are integrated "
            "into your CI/CD pipelines to scan for vulnerabilities in code, "
            "dependencies, and container images."
        )

    def run(self) -> CheckResult:
        context = (
            "Please confirm whether tools (such as Snyk, Trivy, "
            "AWS Inspector, AWS CodeGuru Security, or similar) are integrated into "
            "your CI/CD pipelines to scan for vulnerabilities in code, dependencies, "
            "and container images."
        )

        return CheckResult(
            status=CheckStatus.MANUAL,
            context=context,
        )
