"""A list of all BigQuery SQL key words."""

# https://cloud.google.com/bigquery/docs/reference/standard-sql/lexical#reserved_keywords
bigquery_reserved_keywords = """ALL
AND
ANY
ARRAY
AS
ASC
ASSERT_ROWS_MODIFIED
AT
BETWEEN
BY
CASE
CAST
COLLATE
CONTAINS
CREATE
CROSS
CUBE
CURRENT
DEFAULT
DEFINE
DESC
DISTINCT
ELSE
END
ENUM
ESCAPE
EXCEPT
EXCLUDE
EXISTS
EXTRACT
FALSE
FETCH
FOLLOWING
FOR
FROM
FULL
GROUP
GROUPING
GROUPS
HASH
HAVING
IF
IGNORE
IN
INNER
INTERSECT
INTERVAL
INTO
IS
JOIN
LATERAL
LEFT
LIKE
LIMIT
LOOKUP
MERGE
NATURAL
NEW
NO
NOT
NULL
NULLS
OF
ON
OR
ORDER
OUTER
OVER
PARTITION
PRECEDING
PROTO
RANGE
RECURSIVE
RESPECT
RIGHT
ROLLUP
ROWS
SELECT
SET
SOME
STRUCT
TABLESAMPLE
THEN
TO
TREAT
TRUE
UNBOUNDED
UNION
UNNEST
USING
WHEN
WHERE
WINDOW
WITH
WITHIN"""

# Note BigQuery doesn't have a list of Unreserved Keywords
# so these are just ones we need to allow parsing to work
bigquery_unreserved_keywords = """ALTER
BEGIN
CLUSTER
COMMENT
COMMIT
CONSTRAINT
DAY
DATABASE
DATE
DATETIME
DECLARE
DELETE
DESCRIBE
DETERMINISTIC
DROP
EXPLAIN
EXTENSION
FILTER
FOREIGN
FUNCTION
GRANT
ILIKE
INDEX
INSERT
LANGUAGE
MINUS
ML
MODEL
MONTH
NAN
OFFSET
OPTIONS
ORDINAL
OVERLAPS
PRIMARY
PRIOR
REPLACE
RETURNS
REVOKE
RLIKE
ROLE
ROLLBACK
QUALIFY
QUARTER
SCHEMA
SEPARATOR
START
SYSTEM_TIME
TABLE
TEMP
TEMPORARY
TIME
TIMESTAMP
TRANSIENT
TRUNCATE
TYPE
UNIQUE
UPDATE
USE
VALUE
VALUES
VIEW
YEAR"""
