# Copyright 2025 The EasyDeL/eFormer Author @erfanzar (Erfan Zare Chavoshi).
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from ._ejit import ejit, load_cached_functions
from ._suppress_triton import disable_cpp_logs
from ._triton_call import cdiv, get_triton_type, next_power_of_2, normalize_grid, strides_from_shape, triton_call

__all__ = (
    "cdiv",
    "compile_function",
    "disable_cpp_logs",
    "ejit",
    "get_triton_type",
    "load_cached_functions",
    "lower_function",
    "next_power_of_2",
    "normalize_grid",
    "strides_from_shape",
    "triton_call",
)
