LIFECYCLE_KERNEL_INIT = 0
LIFECYCLE_KERNEL_PRECLI = 20
LIFECYCLE_KERNEL_CLI = 25
LIFECYCLE_KERNEL_INVALIDATE = 50
LIFECYCLE_KERNEL_PREREGISTER = 100
LIFECYCLE_KERNEL_REGISTER = 101
LIFECYCLE_KERNEL_CONFIGURE = 102
LIFECYCLE_KERNEL_PREBOOT = 200
LIFECYCLE_KERNEL_BOOT = 201
LIFECYCLE_KERNEL_POSTBOOT = 202
LIFECYCLE_KERNEL_PRESTART = 300
LIFECYCLE_KERNEL_START = 301
LIFECYCLE_KERNEL_POSTSTART = 302
LIFECYCLE_KERNEL_READY = 303
LIFECYCLE_KERNEL_FINISHED = 304
LIFECYCLE_KERNEL_PREMAIN = 400
LIFECYCLE_KERNEL_MAINLOOP = 401
LIFECYCLE_KERNEL_POSTMAIN = 402
LIFECYCLE_KERNEL_PRESHUTDOWN = 900
LIFECYCLE_KERNEL_SHUTDOWN = 1000

LIFECYCLE_SERVICE_INIT = 0
LIFECYCLE_SERVICE_ADDED = 50
LIFECYCLE_SERVICE_ATTACHED = 100
LIFECYCLE_SERVICE_ASSIGNED = 101
LIFECYCLE_SERVICE_DETACHED = 200
LIFECYCLE_SERVICE_SHUTDOWN = 1000

LIFECYCLE_MODULE_OPENED = 100
LIFECYCLE_MODULE_CLOSED = 200

KERNEL_LIFECYCLE_NAMES = {
    LIFECYCLE_KERNEL_INIT: "init",
    LIFECYCLE_KERNEL_PRECLI: "precli",
    LIFECYCLE_KERNEL_CLI: "cli",
    LIFECYCLE_KERNEL_INVALIDATE: "invalidate",
    LIFECYCLE_KERNEL_PREREGISTER: "preregister",
    LIFECYCLE_KERNEL_REGISTER: "register",
    LIFECYCLE_KERNEL_CONFIGURE: "configure",
    LIFECYCLE_KERNEL_PREBOOT: "preboot",
    LIFECYCLE_KERNEL_BOOT: "boot",
    LIFECYCLE_KERNEL_POSTBOOT: "postboot",
    LIFECYCLE_KERNEL_PRESTART: "prestart",
    LIFECYCLE_KERNEL_START: "start",
    LIFECYCLE_KERNEL_POSTSTART: "poststart",
    LIFECYCLE_KERNEL_READY: "ready",
    LIFECYCLE_KERNEL_FINISHED: "finished",
    LIFECYCLE_KERNEL_PREMAIN: "premain",
    LIFECYCLE_KERNEL_MAINLOOP: "mainloop",
    LIFECYCLE_KERNEL_POSTMAIN: "postmain",
    LIFECYCLE_KERNEL_PRESHUTDOWN: "preshutdown",
    LIFECYCLE_KERNEL_SHUTDOWN: "shutdown",
}


def kernel_lifecycle_name(lifecycle):
    return KERNEL_LIFECYCLE_NAMES[lifecycle]


SERVICE_LIFECYCLE_NAMES = {
    LIFECYCLE_SERVICE_INIT: "init",
    LIFECYCLE_SERVICE_ADDED: "added",
    LIFECYCLE_SERVICE_ATTACHED: "attached",
    LIFECYCLE_SERVICE_ASSIGNED: "assigned",
    LIFECYCLE_SERVICE_DETACHED: "detached",
    LIFECYCLE_SERVICE_SHUTDOWN: "shutdown",
}


def service_lifecycle_name(lifecycle):
    return SERVICE_LIFECYCLE_NAMES[lifecycle]
