#
# generated by wxGlade 0.9.3 on Fri Jun 28 16:25:14 2019
#
import threading

import wx

from meerk40t.gui.icons import (
    get_default_icon_size,
    icons8_connected,
    icons8_disconnected,
)
from meerk40t.gui.mwindow import MWindow
from meerk40t.gui.wxutils import (
    ScrolledPanel,
    StaticBoxSizer,
    TextCtrl,
    dip_size,
    wxButton,
    wxCheckBox,
    wxStaticText,
)
from meerk40t.kernel import signal_listener

_ = wx.GetTranslation

_simple_width = 565
_advanced_width = 952
_default_height = 570


class LihuiyuControllerPanel(ScrolledPanel):
    def __init__(self, *args, context=None, **kwds):
        kwds["style"] = kwds.get("style", 0) | wx.TAB_TRAVERSAL
        wx.Panel.__init__(self, *args, **kwds)
        self.context = context.device
        self.SetHelpText("k40controller")

        self.button_device_connect = wxButton(self, wx.ID_ANY, _("Connection"))
        if self.context.mock:
            connectivity = "Mock-Device"
        elif self.context.networked:
            connectivity = f"Network: {self.context.address}:{self.context.port}"
        else:
            connectivity = "USB"
        self.text_connection_status = TextCtrl(
            self, wx.ID_ANY, connectivity, style=wx.TE_READONLY
        )
        # self.button_controller_control = wxButton(
        #     self, wx.ID_ANY, _("Start Controller")
        # )
        # self.button_controller_control.function = lambda: self.context("start\n")
        # self.text_controller_status = TextCtrl(
        #     self, wx.ID_ANY, "", style=wx.TE_READONLY
        # )
        self.packet_count_text = TextCtrl(self, wx.ID_ANY, "", style=wx.TE_READONLY)
        self.rejected_packet_count_text = TextCtrl(
            self, wx.ID_ANY, "", style=wx.TE_READONLY
        )
        self.text_packet_info = TextCtrl(self, wx.ID_ANY, "", style=wx.TE_READONLY)
        self.text_byte_0 = TextCtrl(self, wx.ID_ANY, "", style=wx.TE_READONLY)
        self.text_byte_1 = TextCtrl(self, wx.ID_ANY, "", style=wx.TE_READONLY)
        self.text_desc = TextCtrl(self, wx.ID_ANY, "", style=wx.TE_READONLY)
        self.text_byte_2 = TextCtrl(self, wx.ID_ANY, "", style=wx.TE_READONLY)
        self.text_byte_3 = TextCtrl(self, wx.ID_ANY, "", style=wx.TE_READONLY)
        self.text_byte_4 = TextCtrl(self, wx.ID_ANY, "", style=wx.TE_READONLY)
        self.text_byte_5 = TextCtrl(self, wx.ID_ANY, "", style=wx.TE_READONLY)
        self.checkbox_show_usb_log = wxCheckBox(self, wx.ID_ANY, _("Show USB Log"))
        self.text_usb_log = TextCtrl(
            self, wx.ID_ANY, "", style=wx.TE_MULTILINE | wx.TE_READONLY
        )
        self.button_clear_stats = wxButton(self, wx.ID_ANY, _("Reset\nstatistics"))
        self.logged_packets = []
        self.text_status_log = TextCtrl(
            self, wx.ID_ANY, "", style=wx.TE_MULTILINE | wx.TE_READONLY
        )
        self.button_clear_status_log = wxButton(self, wx.ID_ANY, _("Clear Status-Log"))
        # self.button_clear_status_log.function = lambda: self.context("clear\n")

        self.__set_properties()
        self.__do_layout()

        self.Bind(wx.EVT_BUTTON, self.on_button_start_usb, self.button_device_connect)
        self.Bind(wx.EVT_BUTTON, self.on_button_reset_stats, self.button_clear_stats)
        # self.Bind(
        #     wx.EVT_BUTTON,
        #     self.on_button_start_controller,
        #     self.button_controller_control,
        # )
        self.Bind(
            wx.EVT_CHECKBOX, self.on_check_show_usb_log, self.checkbox_show_usb_log
        )

        # Test the color combos...
        # self.Bind(wx.EVT_RIGHT_DOWN, self.debug_colors)
        # self._debug_counter = 0
        def clear_log(event=None):
            self.logged_packets.clear()
            self.text_status_log.SetValue("")

        self.button_clear_status_log.Bind(wx.EVT_BUTTON, clear_log)
        self.last_control_state = None
        self.retries = 0
        self._buffer = ""
        self._buffer_lock = threading.Lock()
        self.set_widgets()
        self.SetupScrolling()
        self._channel_watching = None

    # def debug_colors(self, event):
    #     states = (
    #         "STATE_CONNECTION_FAILED",
    #         "STATE_FAILED_RETRYING",
    #         "STATE_FAILED_SUSPENDED",
    #         "STATE_DRIVER_NO_BACKEND",
    #         "STATE_UNINITIALIZED",
    #         "STATE_USB_DISCONNECTED",
    #         "STATE_USB_SET_DISCONNECTING",
    #         "STATE_USB_CONNECTED",
    #         "STATE_CONNECTED",
    #         "STATE_CONNECTING",
    #     )
    #     if self._debug_counter >= len(states):
    #         self._debug_counter = 0
    #     self.context.signal("pipe;state", states[self._debug_counter])
    #     self._debug_counter += 1

    def __set_properties(self):
        self.SetFont(
            wx.Font(
                9,
                wx.FONTFAMILY_DEFAULT,
                wx.FONTSTYLE_NORMAL,
                wx.FONTWEIGHT_NORMAL,
                0,
                "Segoe UI",
            )
        )
        self.set_color_according_to_state("", self.button_device_connect)
        self.button_device_connect.SetFont(
            wx.Font(
                11,
                wx.FONTFAMILY_DEFAULT,
                wx.FONTSTYLE_NORMAL,
                wx.FONTWEIGHT_NORMAL,
                0,
                "Segoe UI",
            )
        )
        self.button_device_connect.SetToolTip(
            _("Force connection/disconnection from the device.")
        )
        self.text_connection_status.SetToolTip(_("Connection status"))

        # self.button_controller_control.SetBackgroundColour(wx.Colour(102, 255, 102))
        # self.button_controller_control.SetForegroundColour(wx.BLACK)
        # self.button_controller_control.SetFont(
        #     wx.Font(
        #         11,
        #         wx.FONTFAMILY_DEFAULT,
        #         wx.FONTSTYLE_NORMAL,
        #         wx.FONTWEIGHT_NORMAL,
        #         0,
        #         "Segoe UI",
        #     )
        # )
        # self.button_controller_control.SetToolTip(
        #     _("Change the currently performed operation.")
        # )
        # self.text_controller_status.SetToolTip(
        #     _("Displays the controller's current process.")
        # )
        self.packet_count_text.SetMinSize(dip_size(self, 35, -1))
        self.packet_count_text.SetToolTip(_("Total number of packets sent"))
        self.rejected_packet_count_text.SetMinSize(dip_size(self, 35, -1))
        self.rejected_packet_count_text.SetToolTip(
            _("Total number of packets rejected")
        )
        self.text_packet_info.SetToolTip(_("Last packet information sent"))
        self.text_byte_0.SetMinSize(dip_size(self, 35, -1))
        self.text_byte_1.SetMinSize(dip_size(self, 35, -1))
        self.text_desc.SetMinSize(dip_size(self, 35, -1))
        self.text_desc.SetToolTip(_("The meaning of Byte 1"))
        self.text_byte_2.SetMinSize(dip_size(self, 35, -1))
        self.text_byte_3.SetMinSize(dip_size(self, 35, -1))
        self.text_byte_4.SetMinSize(dip_size(self, 35, -1))
        self.text_byte_5.SetMinSize(dip_size(self, 35, -1))
        self.checkbox_show_usb_log.SetValue(1)
        self.button_device_connect.SetBitmap(
            icons8_disconnected.GetBitmap(
                use_theme=False, resize=0.75 * get_default_icon_size(self.context)
            )
        )
        # self.button_controller_control.SetBitmap(
        #     icons8_circled_play.GetBitmap(
        #         use_theme=False, resize=0.75 * get_default_icon_size(self.context)
        #     )
        # )
        # end wxGlade

    def __do_layout(self):
        sizer_main = wx.BoxSizer(wx.HORIZONTAL)
        sizer_main_vertical = wx.BoxSizer(wx.VERTICAL)
        sizer_show_usb_log = wx.BoxSizer(wx.VERTICAL)
        packet_count = StaticBoxSizer(self, wx.ID_ANY, _("Packet Info"), wx.VERTICAL)
        byte_data_sizer = StaticBoxSizer(
            self, wx.ID_ANY, _("Byte Data Status"), wx.VERTICAL
        )
        byte_data_status = wx.BoxSizer(wx.HORIZONTAL)
        byte5sizer = wx.BoxSizer(wx.VERTICAL)
        byte4sizer = wx.BoxSizer(wx.VERTICAL)
        byte3sizer = wx.BoxSizer(wx.VERTICAL)
        byte2sizer = wx.BoxSizer(wx.VERTICAL)
        byte1sizer = wx.BoxSizer(wx.VERTICAL)
        byte0sizer = wx.BoxSizer(wx.VERTICAL)
        packet_info = StaticBoxSizer(self, wx.ID_ANY, _("Last Packet"), wx.HORIZONTAL)
        sizer_statistics = wx.BoxSizer(wx.HORIZONTAL)
        sizer_count_rejected = StaticBoxSizer(
            self, wx.ID_ANY, _("Rejected Packets"), wx.VERTICAL
        )
        sizer_count_packets = StaticBoxSizer(
            self, wx.ID_ANY, _("Packet Count"), wx.VERTICAL
        )
        # sizer_controller = StaticBoxSizer(self, wx.ID_ANY, _("Controller"), wx.VERTICAL)
        # sizer_usb_settings = StaticBoxSizer(
        #     self, wx.ID_ANY, _("USB Settings"), wx.VERTICAL
        # )
        # sizer_23 = wx.BoxSizer(wx.HORIZONTAL)
        # sizer_12 = StaticBoxSizer(self, wx.ID_ANY, _("Chip Version"), wx.HORIZONTAL)
        # sizer_11 = StaticBoxSizer(self, wx.ID_ANY, _("Device Bus:"), wx.HORIZONTAL)
        # sizer_10 = StaticBoxSizer(self, wx.ID_ANY, _("Device Address:"), wx.HORIZONTAL)
        # sizer_3 = StaticBoxSizer(self, wx.ID_ANY, _("Device Index:"), wx.HORIZONTAL)
        button_sizer = wx.BoxSizer(wx.HORIZONTAL)
        sizer_usb_connect = StaticBoxSizer(
            self, wx.ID_ANY, _("USB Connection"), wx.VERTICAL
        )
        sizer_usb_connect.Add(self.button_device_connect, 0, wx.EXPAND, 0)
        sizer_usb_connect.Add(self.text_connection_status, 0, wx.EXPAND, 0)
        button_sizer.Add(sizer_usb_connect, 1, wx.EXPAND, 0)

        # sizer_controller.Add(self.button_controller_control, 0, wx.EXPAND, 0)
        # sizer_controller.Add(self.text_controller_status, 0, wx.EXPAND, 0)
        # button_sizer.Add(sizer_controller, 1, wx.EXPAND, 0)

        sizer_main_vertical.Add(button_sizer, 0, wx.EXPAND, 0)

        sizer_count_packets.Add(self.packet_count_text, 0, wx.EXPAND, 0)
        sizer_statistics.Add(sizer_count_packets, 1, wx.EXPAND, 0)
        sizer_count_rejected.Add(self.rejected_packet_count_text, 0, wx.EXPAND, 0)
        sizer_statistics.Add(sizer_count_rejected, 1, wx.EXPAND, 0)
        sizer_statistics.Add(self.button_clear_stats, 0, wx.EXPAND, 0)
        packet_count.Add(sizer_statistics, 1, wx.EXPAND, 0)
        packet_info.Add(self.text_packet_info, 11, wx.EXPAND, 0)
        packet_count.Add(packet_info, 0, wx.EXPAND, 0)
        byte0sizer.Add(self.text_byte_0, 0, wx.EXPAND, 0)
        label_1 = wxStaticText(self, wx.ID_ANY, _("Byte 0"))
        byte0sizer.Add(label_1, 0, wx.EXPAND, 0)
        byte_data_status.Add(byte0sizer, 1, wx.EXPAND, 0)
        byte1sizer.Add(self.text_byte_1, 0, wx.EXPAND, 0)
        label_2 = wxStaticText(self, wx.ID_ANY, _("Byte 1"))
        byte1sizer.Add(label_2, 0, wx.EXPAND, 0)
        byte1sizer.Add(self.text_desc, 0, wx.EXPAND, 0)
        byte_data_status.Add(byte1sizer, 1, wx.EXPAND, 0)
        byte2sizer.Add(self.text_byte_2, 0, wx.EXPAND, 0)
        label_3 = wxStaticText(self, wx.ID_ANY, _("Byte 2"))
        byte2sizer.Add(label_3, 0, wx.EXPAND, 0)
        byte_data_status.Add(byte2sizer, 1, wx.EXPAND, 0)
        byte3sizer.Add(self.text_byte_3, 0, wx.EXPAND, 0)
        label_4 = wxStaticText(self, wx.ID_ANY, _("Byte 3"))
        byte3sizer.Add(label_4, 0, wx.EXPAND, 0)
        byte_data_status.Add(byte3sizer, 1, wx.EXPAND, 0)
        byte4sizer.Add(self.text_byte_4, 0, wx.EXPAND, 0)
        label_5 = wxStaticText(self, wx.ID_ANY, _("Byte 4"))
        byte4sizer.Add(label_5, 0, wx.EXPAND, 0)
        byte_data_status.Add(byte4sizer, 1, wx.EXPAND, 0)
        byte5sizer.Add(self.text_byte_5, 0, wx.EXPAND, 0)
        label_18 = wxStaticText(self, wx.ID_ANY, _("Byte 5"))
        byte5sizer.Add(label_18, 0, wx.EXPAND, 0)
        byte_data_status.Add(byte5sizer, 1, wx.EXPAND, 0)

        byte_data_sizer.Add(byte_data_status, 0, wx.EXPAND, 0)
        byte_data_sizer.Add(self.text_status_log, 1, wx.EXPAND, 0)
        byte_data_sizer.Add(self.button_clear_status_log, 0, wx.EXPAND, 0)

        sizer_main_vertical.Add(packet_count, 0, wx.EXPAND, 0)
        sizer_main_vertical.Add(byte_data_sizer, 1, wx.EXPAND, 0)
        # label_6 = wxStaticText(self, wx.ID_ANY, "")
        # sizer_show_usb_log.Add(label_6, 10, wx.EXPAND, 0)
        sizer_show_usb_log.Add(self.checkbox_show_usb_log, 0, wx.ALIGN_RIGHT, 0)
        sizer_main_vertical.Add(sizer_show_usb_log, 0, wx.EXPAND, 0)
        sizer_main.Add(sizer_main_vertical, 1, wx.EXPAND, 0)
        sizer_main.Add(self.text_usb_log, 1, wx.EXPAND, 0)
        self.SetSizer(sizer_main)
        sizer_main.Fit(self)
        self.Layout()
        # end wxGlade

    def set_color_according_to_state(self, stateval, control):
        def color_distance(c1, c2):
            from math import sqrt

            red_mean = int((c1.red + c2.red) / 2.0)
            r = c1.red - c2.red
            g = c1.green - c2.green
            b = c1.blue - c2.blue
            distance_sq = (
                (((512 + red_mean) * r * r) >> 8)
                + (4 * g * g)
                + (((767 - red_mean) * b * b) >> 8)
            )
            return sqrt(distance_sq)

        state_colors = {
            "STATE_CONNECTION_FAILED": wx.Colour("#dfdf00"),
            "STATE_FAILED_RETRYING": wx.Colour("#df0000"),
            "STATE_FAILED_SUSPENDED": wx.Colour("#0000df"),
            "STATE_DRIVER_NO_BACKEND": wx.Colour("#dfdf00"),
            "STATE_UNINITIALIZED": wx.Colour("#ffff00"),
            "STATE_USB_DISCONNECTED": wx.Colour("#ffff00"),
            "STATE_USB_SET_DISCONNECTING": wx.Colour("#ffff00"),
            "STATE_USB_CONNECTED": wx.Colour("#00ff00"),
            "STATE_CONNECTED": wx.Colour("#00ff00"),
            "STATE_CONNECTING": wx.Colour("#ffff00"),
        }
        if stateval in state_colors:
            bgcol = state_colors[stateval]
        else:
            bgcol = wx.Colour("#66ff66")
        d1 = color_distance(bgcol, wx.BLACK)
        d2 = color_distance(bgcol, wx.WHITE)
        # print(f"state={stateval}, to black={d1}, to_white={d2}")
        if d1 <= d2:
            fgcol = wx.WHITE
        else:
            fgcol = wx.BLACK
        control.SetBackgroundColour(bgcol)
        control.SetForegroundColour(fgcol)

    def module_open(self, *args, **kwargs):
        self.pane_show()

    def module_close(self, *args, **kwargs):
        self.pane_hide()

    def pane_show(self):
        # Channel watching is to make sure we unwatch the channel we watched even if label changes.
        self._channel_watching = f"{self.context.safe_label}/usb"
        self.context.channel(self._channel_watching, buffer_size=500).watch(
            self.update_text
        )
        self.on_network_update()

    def pane_hide(self):
        self.context.channel(self._channel_watching).unwatch(self.update_text)

    def on_button_reset_stats(self, event):
        self.context.packet_count = 0
        self.context.rejected_count = 0
        self.packet_count_text.SetValue(str(self.context.packet_count))
        self.rejected_packet_count_text.SetValue(str(self.context.rejected_count))

    @signal_listener("network_update")
    def on_network_update(self, origin=None, *args):
        try:
            if self.context.networked:
                self.button_device_connect.Enable(False)
            else:
                self.button_device_connect.Enable(True)
        except AttributeError:
            pass

    def restore(self, *args, **kwargs):
        self.set_widgets()

    def update_text(self, text):
        with self._buffer_lock:
            self._buffer += f"{text}\n"
        self.context.signal("lihuiyu_controller_update", True)

    @signal_listener("lihuiyu_controller_update")
    def update_text_gui(self, origin, *args):
        try:
            with self._buffer_lock:
                buffer = self._buffer
                self._buffer = ""
            if self.text_usb_log.IsShown():
                self.text_usb_log.AppendText(buffer)
        except RuntimeError:
            pass

    def set_widgets(self):
        try:
            show_log = self.context.show_usb_log
        except AttributeError:
            show_log = True
        self.checkbox_show_usb_log.SetValue(show_log)
        self.on_check_show_usb_log()

    def device_execute(self, control_name):
        def menu_element(event=None):
            self.context.execute(control_name)

        return menu_element

    @signal_listener("pipe;status")
    def update_status(self, origin, status_data, code_string):
        if origin != self.context.path:
            return
        try:
            if status_data is not None:
                if isinstance(status_data, int):
                    self.text_desc.SetValue(str(status_data))
                    self.text_desc.SetValue(code_string)
                else:
                    if len(status_data) == 6:
                        self.text_byte_0.SetValue(str(status_data[0]))
                        self.text_byte_1.SetValue(str(status_data[1]))
                        self.text_byte_2.SetValue(str(status_data[2]))
                        self.text_byte_3.SetValue(str(status_data[3]))
                        self.text_byte_4.SetValue(str(status_data[4]))
                        self.text_byte_5.SetValue(str(status_data[5]))
                        self.text_desc.SetValue(code_string)
                self.add_to_status_log(f"{status_data} - {code_string}")
            self.packet_count_text.SetValue(str(self.context.packet_count))
            self.rejected_packet_count_text.SetValue(str(self.context.rejected_count))
        except RuntimeError:
            # This should be handled when the controller window is closed.
            pass

    def add_to_status_log(self, string_data):
        """Add a string to the status log."""
        if len(self.logged_packets) == 0:
            self.logged_packets.append((1, string_data))
        else:
            count, oldstring_data = self.logged_packets[-1]
            if oldstring_data == string_data:
                # If the last entry is the same, just increase the count.
                self.logged_packets[-1] = (count + 1, oldstring_data)
            else:
                # Otherwise, add a new entry.
                if len(self.logged_packets) > 750:
                    self.logged_packets = self.logged_packets[-750:]
                self.logged_packets.append((1, string_data))
        text_data = []
        for count, data in self.logged_packets:
            if count > 1:
                text_data.append(f"{data} (x{count})")
            else:
                text_data.append(data)
        self.text_status_log.SetValue("\n".join(text_data))

    @signal_listener("pipe;packet_text")
    def update_packet_text(self, origin, string_data):
        if origin != self.context._path:
            return
        if string_data is not None and len(string_data) != 0:
            self.text_packet_info.SetValue(str(string_data))
            self.add_to_status_log(f">> {string_data}")

    @signal_listener("pipe;usb_status")
    def on_connection_status_change(self, origin, status):
        if origin != self.context._path:
            return
        try:
            self.text_connection_status.SetValue(str(status))
        except RuntimeError:
            pass

    @signal_listener("pipe;state")
    def on_connection_state_change(self, origin, state):
        if origin != self.context._path:
            return
        self.set_color_according_to_state(state, self.button_device_connect)
        if state == "STATE_CONNECTION_FAILED":
            self.button_device_connect.SetLabel(_("Connect failed"))
            self.button_device_connect.SetBitmap(
                icons8_disconnected.GetBitmap(
                    use_theme=False, resize=0.75 * get_default_icon_size(self.context)
                )
            )
            self.button_device_connect.Enable()
        elif state == "STATE_FAILED_RETRYING":
            self.button_device_connect.SetLabel(_("Retrying..."))
            self.button_device_connect.SetBitmap(
                icons8_disconnected.GetBitmap(
                    use_theme=False, resize=0.75 * get_default_icon_size(self.context)
                )
            )
            self.button_device_connect.Enable()
        elif state == "STATE_FAILED_SUSPENDED":
            self.button_device_connect.SetLabel(_("Suspended Retrying"))
            self.button_device_connect.SetBitmap(
                icons8_disconnected.GetBitmap(
                    use_theme=False, resize=0.75 * get_default_icon_size(self.context)
                )
            )
            self.button_device_connect.Enable()
        elif state == "STATE_DRIVER_NO_BACKEND":
            self.button_device_connect.SetLabel(_("No Backend"))
            self.button_device_connect.SetBitmap(
                icons8_disconnected.GetBitmap(
                    use_theme=False, resize=0.75 * get_default_icon_size(self.context)
                )
            )
            self.button_device_connect.Enable()
        elif state == "STATE_UNINITIALIZED" or state == "STATE_USB_DISCONNECTED":
            self.button_device_connect.SetLabel(_("Connect"))
            self.button_device_connect.SetBitmap(
                icons8_connected.GetBitmap(
                    use_theme=False, resize=0.75 * get_default_icon_size(self.context)
                )
            )
            self.button_device_connect.Enable()
        elif state == "STATE_USB_SET_DISCONNECTING":
            self.button_device_connect.SetLabel(_("Disconnecting..."))
            self.button_device_connect.SetBitmap(
                icons8_disconnected.GetBitmap(
                    use_theme=False, resize=0.75 * get_default_icon_size(self.context)
                )
            )
            self.button_device_connect.Disable()
        elif state == "STATE_USB_CONNECTED" or state == "STATE_CONNECTED":
            self.button_device_connect.SetLabel(_("Disconnect"))
            self.button_device_connect.SetBitmap(
                icons8_connected.GetBitmap(
                    use_theme=False, resize=0.75 * get_default_icon_size(self.context)
                )
            )
            self.button_device_connect.Enable()
        elif state == "STATE_CONNECTING":
            self.button_device_connect.SetLabel(_("Connecting..."))
            self.button_device_connect.SetBitmap(
                icons8_connected.GetBitmap(
                    use_theme=False, resize=0.75 * get_default_icon_size(self.context)
                )
            )
            self.button_device_connect.Disable()

    def on_button_start_usb(self, event=None):  # wxGlade: Controller.<event_handler>
        origin, state = self.context.last_signal("pipe;state")
        if state is not None and isinstance(state, tuple):
            state = state[0]

        if state == "STATE_FAILED_RETRYING":
            self.retries = 0
            self.context("usb_abort\n")
        elif state == "STATE_FAILED_SUSPENDED":
            self.context("usb_continue\n")
        elif state in (
            "STATE_USB_DISCONNECTED",
            "STATE_UNINITIALIZED",
            "STATE_CONNECTION_FAILED",
            "STATE_DRIVER_MOCK",
            None,
        ):
            try:
                self.context("usb_connect\n")
            except ConnectionRefusedError:
                dlg = wx.MessageDialog(
                    None,
                    _("Connection Refused. See USB Log for detailed information."),
                    _("Manual Connection"),
                    wx.OK | wx.ICON_WARNING,
                )
                result = dlg.ShowModal()
                dlg.Destroy()
            except NotImplementedError:
                dlg = wx.MessageDialog(
                    None,
                    _("Connection Refused. See USB Log for detailed information.")
                    + "\n"
                    + _(
                        "You may run an incompatible version of libusb, have you tried the 32-bit version?"
                    ),
                    _("Manual Connection"),
                    wx.OK | wx.ICON_WARNING,
                )
                result = dlg.ShowModal()
                dlg.Destroy()
        elif state in ("STATE_CONNECTED", "STATE_USB_CONNECTED"):
            self.context("usb_disconnect\n")

    # @signal_listener("pipe;thread")
    # def on_control_state(self, origin, state):
    #     if origin != self.context._path:
    #         return
    #
    #     if self.last_control_state == state:
    #         return
    #     self.last_control_state = state
    #     button = self.button_controller_control
    #     if self.text_controller_status is None:
    #         return
    #     value = self.context.kernel.get_text_thread_state(state)
    #     self.text_controller_status.SetValue(str(value))
    #     if state in ("init", "end", "idle"):
    #
    #         def f(event=None):
    #             self.context("start\n")
    #             self.context("hold\n")
    #
    #         button.function = f
    #         button.SetBackgroundColour("#009900")
    #         button.SetLabel(_("Hold Controller"))
    #         button.SetBitmap(
    #             icons8_circled_play.GetBitmap(
    #                 use_theme=False, resize=0.75 * get_default_icon_size(self.context)
    #             )
    #         )
    #         button.Enable(True)
    #     elif state == "busy":
    #         button.SetBackgroundColour("#00dd00")
    #         button.SetLabel(_("LOCKED"))
    #         button.SetBitmap(
    #             icons8_circled_play.GetBitmap(
    #                 use_theme=False, resize=0.75 * get_default_icon_size(self.context)
    #             )
    #         )
    #         button.Enable(False)
    #     elif state == "wait":
    #
    #         def f(event=None):
    #             self.context("continue\n")
    #
    #         button.function = f
    #         button.SetBackgroundColour("#dddd00")
    #         button.SetLabel(_("Force Continue"))
    #         button.SetBitmap(
    #             icons8_laser_beam_hazard.GetBitmap(
    #                 use_theme=False, resize=0.75 * get_default_icon_size(self.context)
    #             )
    #         )
    #         button.Enable(True)
    #     elif state == "pause":
    #
    #         def f(event=None):
    #             self.context("resume\n")
    #
    #         button.function = f
    #         button.SetBackgroundColour("#00dd00")
    #         button.SetLabel(_("Resume Controller"))
    #         button.SetBitmap(
    #             icons8_circled_play.GetBitmap(
    #                 use_theme=False, resize=0.75 * get_default_icon_size(self.context)
    #             )
    #         )
    #         button.Enable(True)
    #     elif state == "active":
    #
    #         def f(event=None):
    #             self.context("hold\n")
    #
    #         button.function = f
    #         button.SetBackgroundColour("#00ff00")
    #         button.SetLabel(_("Pause Controller"))
    #         button.SetBitmap(
    #             icons8_pause.GetBitmap(use_theme=False, resize=0.75 * get_default_icon_size(self.context))
    #         )
    #         button.Enable(True)
    #     elif state == "terminate":
    #
    #         def f(event=None):
    #             self.context("abort\n")
    #
    #         button.function = f
    #         button.SetBackgroundColour("#00ffff")
    #         button.SetLabel(_("Manual Reset"))
    #         button.SetBitmap(
    #             icons8_emergency_stop_button.GetBitmap(
    #                 use_theme=False, resize=0.75 * get_default_icon_size(self.context)
    #             )
    #         )
    #         button.Enable(True)

    @signal_listener("pipe;failing")
    def on_usb_failing(self, origin, count):
        self.retries = count

    # def on_button_start_controller(self, event=None):
    #     event.Skip()
    #     self.button_controller_control.function()

    def on_check_show_usb_log(self, event=None):
        on = self.checkbox_show_usb_log.GetValue()
        self.text_usb_log.Show(on)
        self.context.show_usb_log = bool(on)
        if on:
            self.GetParent().SetSize((_advanced_width, _default_height))
        else:
            self.GetParent().SetSize((_simple_width, _default_height))


class LihuiyuControllerGui(MWindow):
    def __init__(self, *args, **kwds):
        super().__init__(_simple_width, _default_height, *args, **kwds)

        # ==========
        # MENU BAR
        # ==========
        from platform import system as _sys

        if _sys() != "Darwin":
            self.LihuiyuController_menubar = wx.MenuBar()
            self.create_menu(self.LihuiyuController_menubar.Append)
            self.SetMenuBar(self.LihuiyuController_menubar)
        # ==========
        # MENUBAR END
        # ==========
        self.restore_aspect(honor_initial_values=True)
        self.panel = LihuiyuControllerPanel(self, wx.ID_ANY, context=self.context)
        self.sizer.Add(self.panel, 1, wx.EXPAND, 0)
        self.add_module_delegate(self.panel)
        _icon = wx.NullIcon
        _icon.CopyFromBitmap(icons8_connected.GetBitmap())
        self.SetIcon(_icon)
        self.SetTitle(_("Lihuiyu-Controller"))
        self.Layout()

    def create_menu(self, append):
        wxglade_tmp_menu = wx.Menu()
        item = wxglade_tmp_menu.Append(
            wx.ID_ANY, _("Reset USB"), _("Reset USB connection")
        )
        self.Bind(wx.EVT_MENU, self.on_menu_usb_reset, id=item.GetId())
        item = wxglade_tmp_menu.Append(
            wx.ID_ANY, _("Release USB"), _("Release USB resources")
        )
        self.Bind(wx.EVT_MENU, self.on_menu_usb_release, id=item.GetId())
        append(wxglade_tmp_menu, _("Tools"))
        wxglade_tmp_menu = wx.Menu()
        item = wxglade_tmp_menu.Append(wx.ID_ANY, _("Pause"), "")
        self.Bind(wx.EVT_MENU, self.on_menu_pause, id=item.GetId())
        item = wxglade_tmp_menu.Append(wx.ID_ANY, _("Stop"), "")
        self.Bind(wx.EVT_MENU, self.on_menu_stop, id=item.GetId())
        wxglade_tmp_menu.AppendSeparator()
        item = wxglade_tmp_menu.Append(wx.ID_ANY, _("Configuration"), "")
        self.Bind(wx.EVT_MENU, self.on_menu_config, id=item.GetId())

        append(wxglade_tmp_menu, _("Commands"))
        wxglade_tmp_menu = wx.Menu()
        item = wxglade_tmp_menu.Append(
            wx.ID_ANY, _("BufferView"), _("Views the Controller Buffer")
        )
        self.Bind(wx.EVT_MENU, self.on_menu_bufferview, id=item.GetId())
        append(wxglade_tmp_menu, _("Views"))

    def window_preserve(self):
        return False

    def on_menu_config(self, event):
        self.context("window open Configuration\n")

    def on_menu_usb_reset(self, event):
        try:
            self.context("usb_reset\n")
        except AttributeError:
            pass

    def on_menu_usb_release(self, event):
        try:
            self.context("usb_release\n")
        except AttributeError:
            pass

    def on_menu_pause(self, event=None):
        try:
            self.context("pause\n")
        except AttributeError:
            pass

    def on_menu_stop(self, event=None):
        try:
            self.context("estop\n")
        except AttributeError:
            pass

    def on_menu_bufferview(self, event=None):
        self.context("window open BufferView\n")

    @staticmethod
    def submenu():
        # Hint for translation: _("Device-Control"), _("Controller")
        return "Device-Control", "Controller"

    @staticmethod
    def helptext():
        return _("Display the device controller window")
