# AI 模块生成指南

使用本指南，你可以通过AI快速生成符合ErisPulse规范的模块代码，无需从零开始编写。

## AI开发物料下载

根据你的生成需求选择适合的文档：

| 文档类型 | 适用场景 |
|---------|----------|
| **Core.md** | 核心功能开发与贡献 |
| **Module.md** | 模块开发 |
| **Adapter.md** | 适配器开发 |
| **Full.md** | 完整开发参考（大模型推荐） |

上述文档均包含在[docs/AIDocs](docs/AIDocs)目录下。如果你正在文档站，你可以点击上方的`下载AI物料`卡片对应的文档进行下载

💡 **提示**：对于大多数AI模型，推荐使用专用的 Module/Adapter/Core 文档而非 Full 文档，除非你的AI模型有超长上下文处理能力。

## 快速开始

1. **获取开发文档**  
   根据你的需求类型（模块/适配器/核心功能），下载上方对应的开发文档

2. **明确你的需求**  
   确定模块功能、使用的适配器、依赖关系等核心要素

3. **向AI描述需求**  
   使用下面的标准格式清晰地描述你的模块需求

## 需求描述规范

请按照以下格式描述你的模块需求：

```markdown
我需要一个天气查询模块 WeatherBot，当用户在群聊中发送"weather 上海"时：
1. 调用 OpenWeatherMap API 查询天气
2. 返回中文格式的天气信息卡片
3. 特别支持一下YunhuAdapter的`button`特性

请根据ErisPulse Module规范生成完整模块代码
```


## 测试与验证

生成后使用以下命令测试模块：

```bash
# 安装模块依赖
epsdk install <你的模块包目录>

# 运行测试
epsdk run main.py --reload
```

## 常见问题

**Q: 推荐如何生成模块？**  
A: 推荐使用VS Code + GitHub Copilot或Cursor等AI编码工具，它们能直接操作文件系统

**Q: 可以发布我的AI生成模块吗？**  
A: 当然！但请确保：
1. 代码符合ErisPulse规范
2. 包含完整文档
3. 通过基础测试用例
