# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRuleVmResult',
    'AwaitableGetRuleVmResult',
    'get_rule_vm',
    'get_rule_vm_output',
]

@pulumi.output_type
class GetRuleVmResult:
    """
    A collection of values returned by getRuleVm.
    """
    def __init__(__self__, cloud_connector_id=None, custom_domains=None, depends=None, filter=None, https=None, id=None, identifier=None, idle_time_mins=None, name=None, tcps=None, use_spot=None):
        if cloud_connector_id and not isinstance(cloud_connector_id, str):
            raise TypeError("Expected argument 'cloud_connector_id' to be a str")
        pulumi.set(__self__, "cloud_connector_id", cloud_connector_id)
        if custom_domains and not isinstance(custom_domains, list):
            raise TypeError("Expected argument 'custom_domains' to be a list")
        pulumi.set(__self__, "custom_domains", custom_domains)
        if depends and not isinstance(depends, list):
            raise TypeError("Expected argument 'depends' to be a list")
        pulumi.set(__self__, "depends", depends)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if https and not isinstance(https, list):
            raise TypeError("Expected argument 'https' to be a list")
        pulumi.set(__self__, "https", https)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, float):
            raise TypeError("Expected argument 'identifier' to be a float")
        pulumi.set(__self__, "identifier", identifier)
        if idle_time_mins and not isinstance(idle_time_mins, int):
            raise TypeError("Expected argument 'idle_time_mins' to be a int")
        pulumi.set(__self__, "idle_time_mins", idle_time_mins)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if tcps and not isinstance(tcps, list):
            raise TypeError("Expected argument 'tcps' to be a list")
        pulumi.set(__self__, "tcps", tcps)
        if use_spot and not isinstance(use_spot, bool):
            raise TypeError("Expected argument 'use_spot' to be a bool")
        pulumi.set(__self__, "use_spot", use_spot)

    @property
    @pulumi.getter(name="cloudConnectorId")
    def cloud_connector_id(self) -> builtins.str:
        """
        Id of the cloud connector
        """
        return pulumi.get(self, "cloud_connector_id")

    @property
    @pulumi.getter(name="customDomains")
    def custom_domains(self) -> Optional[Sequence[builtins.str]]:
        """
        Custom URLs used to access the instances
        """
        return pulumi.get(self, "custom_domains")

    @property
    @pulumi.getter
    def depends(self) -> Optional[Sequence['outputs.GetRuleVmDependResult']]:
        """
        Dependent rules
        """
        return pulumi.get(self, "depends")

    @property
    @pulumi.getter
    def filter(self) -> 'outputs.GetRuleVmFilterResult':
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def https(self) -> Optional[Sequence['outputs.GetRuleVmHttpResult']]:
        """
        Http routing configuration
        """
        return pulumi.get(self, "https")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifier(self) -> builtins.float:
        """
        Unique identifier of the resource
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="idleTimeMins")
    def idle_time_mins(self) -> Optional[builtins.int]:
        """
        Idle time in minutes. This is the time that the AutoStopping rule waits before stopping the idle instances.
        """
        return pulumi.get(self, "idle_time_mins")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the rule
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tcps(self) -> Optional[Sequence['outputs.GetRuleVmTcpResult']]:
        """
        TCP routing configuration
        """
        return pulumi.get(self, "tcps")

    @property
    @pulumi.getter(name="useSpot")
    def use_spot(self) -> Optional[builtins.bool]:
        """
        Boolean that indicates whether the selected instances should be converted to spot vm
        """
        return pulumi.get(self, "use_spot")


class AwaitableGetRuleVmResult(GetRuleVmResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRuleVmResult(
            cloud_connector_id=self.cloud_connector_id,
            custom_domains=self.custom_domains,
            depends=self.depends,
            filter=self.filter,
            https=self.https,
            id=self.id,
            identifier=self.identifier,
            idle_time_mins=self.idle_time_mins,
            name=self.name,
            tcps=self.tcps,
            use_spot=self.use_spot)


def get_rule_vm(cloud_connector_id: Optional[builtins.str] = None,
                custom_domains: Optional[Sequence[builtins.str]] = None,
                depends: Optional[Sequence[Union['GetRuleVmDependArgs', 'GetRuleVmDependArgsDict']]] = None,
                filter: Optional[Union['GetRuleVmFilterArgs', 'GetRuleVmFilterArgsDict']] = None,
                https: Optional[Sequence[Union['GetRuleVmHttpArgs', 'GetRuleVmHttpArgsDict']]] = None,
                idle_time_mins: Optional[builtins.int] = None,
                name: Optional[builtins.str] = None,
                tcps: Optional[Sequence[Union['GetRuleVmTcpArgs', 'GetRuleVmTcpArgsDict']]] = None,
                use_spot: Optional[builtins.bool] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRuleVmResult:
    """
    Data source for retrieving a Harness Variable.


    :param builtins.str cloud_connector_id: Id of the cloud connector
    :param Sequence[builtins.str] custom_domains: Custom URLs used to access the instances
    :param Sequence[Union['GetRuleVmDependArgs', 'GetRuleVmDependArgsDict']] depends: Dependent rules
    :param Sequence[Union['GetRuleVmHttpArgs', 'GetRuleVmHttpArgsDict']] https: Http routing configuration
    :param builtins.int idle_time_mins: Idle time in minutes. This is the time that the AutoStopping rule waits before stopping the idle instances.
    :param builtins.str name: Name of the rule
    :param Sequence[Union['GetRuleVmTcpArgs', 'GetRuleVmTcpArgsDict']] tcps: TCP routing configuration
    :param builtins.bool use_spot: Boolean that indicates whether the selected instances should be converted to spot vm
    """
    __args__ = dict()
    __args__['cloudConnectorId'] = cloud_connector_id
    __args__['customDomains'] = custom_domains
    __args__['depends'] = depends
    __args__['filter'] = filter
    __args__['https'] = https
    __args__['idleTimeMins'] = idle_time_mins
    __args__['name'] = name
    __args__['tcps'] = tcps
    __args__['useSpot'] = use_spot
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:autostopping/getRuleVm:getRuleVm', __args__, opts=opts, typ=GetRuleVmResult).value

    return AwaitableGetRuleVmResult(
        cloud_connector_id=pulumi.get(__ret__, 'cloud_connector_id'),
        custom_domains=pulumi.get(__ret__, 'custom_domains'),
        depends=pulumi.get(__ret__, 'depends'),
        filter=pulumi.get(__ret__, 'filter'),
        https=pulumi.get(__ret__, 'https'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        idle_time_mins=pulumi.get(__ret__, 'idle_time_mins'),
        name=pulumi.get(__ret__, 'name'),
        tcps=pulumi.get(__ret__, 'tcps'),
        use_spot=pulumi.get(__ret__, 'use_spot'))
def get_rule_vm_output(cloud_connector_id: Optional[pulumi.Input[builtins.str]] = None,
                       custom_domains: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                       depends: Optional[pulumi.Input[Optional[Sequence[Union['GetRuleVmDependArgs', 'GetRuleVmDependArgsDict']]]]] = None,
                       filter: Optional[pulumi.Input[Union['GetRuleVmFilterArgs', 'GetRuleVmFilterArgsDict']]] = None,
                       https: Optional[pulumi.Input[Optional[Sequence[Union['GetRuleVmHttpArgs', 'GetRuleVmHttpArgsDict']]]]] = None,
                       idle_time_mins: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                       name: Optional[pulumi.Input[builtins.str]] = None,
                       tcps: Optional[pulumi.Input[Optional[Sequence[Union['GetRuleVmTcpArgs', 'GetRuleVmTcpArgsDict']]]]] = None,
                       use_spot: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRuleVmResult]:
    """
    Data source for retrieving a Harness Variable.


    :param builtins.str cloud_connector_id: Id of the cloud connector
    :param Sequence[builtins.str] custom_domains: Custom URLs used to access the instances
    :param Sequence[Union['GetRuleVmDependArgs', 'GetRuleVmDependArgsDict']] depends: Dependent rules
    :param Sequence[Union['GetRuleVmHttpArgs', 'GetRuleVmHttpArgsDict']] https: Http routing configuration
    :param builtins.int idle_time_mins: Idle time in minutes. This is the time that the AutoStopping rule waits before stopping the idle instances.
    :param builtins.str name: Name of the rule
    :param Sequence[Union['GetRuleVmTcpArgs', 'GetRuleVmTcpArgsDict']] tcps: TCP routing configuration
    :param builtins.bool use_spot: Boolean that indicates whether the selected instances should be converted to spot vm
    """
    __args__ = dict()
    __args__['cloudConnectorId'] = cloud_connector_id
    __args__['customDomains'] = custom_domains
    __args__['depends'] = depends
    __args__['filter'] = filter
    __args__['https'] = https
    __args__['idleTimeMins'] = idle_time_mins
    __args__['name'] = name
    __args__['tcps'] = tcps
    __args__['useSpot'] = use_spot
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:autostopping/getRuleVm:getRuleVm', __args__, opts=opts, typ=GetRuleVmResult)
    return __ret__.apply(lambda __response__: GetRuleVmResult(
        cloud_connector_id=pulumi.get(__response__, 'cloud_connector_id'),
        custom_domains=pulumi.get(__response__, 'custom_domains'),
        depends=pulumi.get(__response__, 'depends'),
        filter=pulumi.get(__response__, 'filter'),
        https=pulumi.get(__response__, 'https'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        idle_time_mins=pulumi.get(__response__, 'idle_time_mins'),
        name=pulumi.get(__response__, 'name'),
        tcps=pulumi.get(__response__, 'tcps'),
        use_spot=pulumi.get(__response__, 'use_spot')))
