# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RuleEcsArgs', 'RuleEcs']

@pulumi.input_type
class RuleEcsArgs:
    def __init__(__self__, *,
                 cloud_connector_id: pulumi.Input[builtins.str],
                 container: Optional[pulumi.Input['RuleEcsContainerArgs']] = None,
                 custom_domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 depends: Optional[pulumi.Input[Sequence[pulumi.Input['RuleEcsDependArgs']]]] = None,
                 dry_run: Optional[pulumi.Input[builtins.bool]] = None,
                 https: Optional[pulumi.Input[Sequence[pulumi.Input['RuleEcsHttpArgs']]]] = None,
                 idle_time_mins: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a RuleEcs resource.
        :param pulumi.Input[builtins.str] cloud_connector_id: Id of the cloud connector
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] custom_domains: Custom URLs used to access the instances
        :param pulumi.Input[Sequence[pulumi.Input['RuleEcsDependArgs']]] depends: Dependent rules
        :param pulumi.Input[builtins.bool] dry_run: Boolean that indicates whether the AutoStopping rule should be created in DryRun mode
        :param pulumi.Input[Sequence[pulumi.Input['RuleEcsHttpArgs']]] https: Http routing configuration
        :param pulumi.Input[builtins.int] idle_time_mins: Idle time in minutes. This is the time that the AutoStopping rule waits before stopping the idle instances.
        :param pulumi.Input[builtins.str] name: Name of the rule
        """
        pulumi.set(__self__, "cloud_connector_id", cloud_connector_id)
        if container is not None:
            pulumi.set(__self__, "container", container)
        if custom_domains is not None:
            pulumi.set(__self__, "custom_domains", custom_domains)
        if depends is not None:
            pulumi.set(__self__, "depends", depends)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if https is not None:
            pulumi.set(__self__, "https", https)
        if idle_time_mins is not None:
            pulumi.set(__self__, "idle_time_mins", idle_time_mins)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="cloudConnectorId")
    def cloud_connector_id(self) -> pulumi.Input[builtins.str]:
        """
        Id of the cloud connector
        """
        return pulumi.get(self, "cloud_connector_id")

    @cloud_connector_id.setter
    def cloud_connector_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cloud_connector_id", value)

    @property
    @pulumi.getter
    def container(self) -> Optional[pulumi.Input['RuleEcsContainerArgs']]:
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: Optional[pulumi.Input['RuleEcsContainerArgs']]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter(name="customDomains")
    def custom_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Custom URLs used to access the instances
        """
        return pulumi.get(self, "custom_domains")

    @custom_domains.setter
    def custom_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "custom_domains", value)

    @property
    @pulumi.getter
    def depends(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleEcsDependArgs']]]]:
        """
        Dependent rules
        """
        return pulumi.get(self, "depends")

    @depends.setter
    def depends(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleEcsDependArgs']]]]):
        pulumi.set(self, "depends", value)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean that indicates whether the AutoStopping rule should be created in DryRun mode
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @property
    @pulumi.getter
    def https(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleEcsHttpArgs']]]]:
        """
        Http routing configuration
        """
        return pulumi.get(self, "https")

    @https.setter
    def https(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleEcsHttpArgs']]]]):
        pulumi.set(self, "https", value)

    @property
    @pulumi.getter(name="idleTimeMins")
    def idle_time_mins(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Idle time in minutes. This is the time that the AutoStopping rule waits before stopping the idle instances.
        """
        return pulumi.get(self, "idle_time_mins")

    @idle_time_mins.setter
    def idle_time_mins(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "idle_time_mins", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _RuleEcsState:
    def __init__(__self__, *,
                 cloud_connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 container: Optional[pulumi.Input['RuleEcsContainerArgs']] = None,
                 custom_domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 depends: Optional[pulumi.Input[Sequence[pulumi.Input['RuleEcsDependArgs']]]] = None,
                 dry_run: Optional[pulumi.Input[builtins.bool]] = None,
                 https: Optional[pulumi.Input[Sequence[pulumi.Input['RuleEcsHttpArgs']]]] = None,
                 identifier: Optional[pulumi.Input[builtins.float]] = None,
                 idle_time_mins: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering RuleEcs resources.
        :param pulumi.Input[builtins.str] cloud_connector_id: Id of the cloud connector
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] custom_domains: Custom URLs used to access the instances
        :param pulumi.Input[Sequence[pulumi.Input['RuleEcsDependArgs']]] depends: Dependent rules
        :param pulumi.Input[builtins.bool] dry_run: Boolean that indicates whether the AutoStopping rule should be created in DryRun mode
        :param pulumi.Input[Sequence[pulumi.Input['RuleEcsHttpArgs']]] https: Http routing configuration
        :param pulumi.Input[builtins.float] identifier: Unique identifier of the resource
        :param pulumi.Input[builtins.int] idle_time_mins: Idle time in minutes. This is the time that the AutoStopping rule waits before stopping the idle instances.
        :param pulumi.Input[builtins.str] name: Name of the rule
        """
        if cloud_connector_id is not None:
            pulumi.set(__self__, "cloud_connector_id", cloud_connector_id)
        if container is not None:
            pulumi.set(__self__, "container", container)
        if custom_domains is not None:
            pulumi.set(__self__, "custom_domains", custom_domains)
        if depends is not None:
            pulumi.set(__self__, "depends", depends)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if https is not None:
            pulumi.set(__self__, "https", https)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if idle_time_mins is not None:
            pulumi.set(__self__, "idle_time_mins", idle_time_mins)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="cloudConnectorId")
    def cloud_connector_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Id of the cloud connector
        """
        return pulumi.get(self, "cloud_connector_id")

    @cloud_connector_id.setter
    def cloud_connector_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cloud_connector_id", value)

    @property
    @pulumi.getter
    def container(self) -> Optional[pulumi.Input['RuleEcsContainerArgs']]:
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: Optional[pulumi.Input['RuleEcsContainerArgs']]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter(name="customDomains")
    def custom_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Custom URLs used to access the instances
        """
        return pulumi.get(self, "custom_domains")

    @custom_domains.setter
    def custom_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "custom_domains", value)

    @property
    @pulumi.getter
    def depends(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleEcsDependArgs']]]]:
        """
        Dependent rules
        """
        return pulumi.get(self, "depends")

    @depends.setter
    def depends(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleEcsDependArgs']]]]):
        pulumi.set(self, "depends", value)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean that indicates whether the AutoStopping rule should be created in DryRun mode
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @property
    @pulumi.getter
    def https(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleEcsHttpArgs']]]]:
        """
        Http routing configuration
        """
        return pulumi.get(self, "https")

    @https.setter
    def https(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleEcsHttpArgs']]]]):
        pulumi.set(self, "https", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Unique identifier of the resource
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="idleTimeMins")
    def idle_time_mins(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Idle time in minutes. This is the time that the AutoStopping rule waits before stopping the idle instances.
        """
        return pulumi.get(self, "idle_time_mins")

    @idle_time_mins.setter
    def idle_time_mins(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "idle_time_mins", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("harness:autostopping/ruleEcs:RuleEcs")
class RuleEcs(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 container: Optional[pulumi.Input[Union['RuleEcsContainerArgs', 'RuleEcsContainerArgsDict']]] = None,
                 custom_domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 depends: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleEcsDependArgs', 'RuleEcsDependArgsDict']]]]] = None,
                 dry_run: Optional[pulumi.Input[builtins.bool]] = None,
                 https: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleEcsHttpArgs', 'RuleEcsHttpArgsDict']]]]] = None,
                 idle_time_mins: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource for creating a Harness Variables.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cloud_connector_id: Id of the cloud connector
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] custom_domains: Custom URLs used to access the instances
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleEcsDependArgs', 'RuleEcsDependArgsDict']]]] depends: Dependent rules
        :param pulumi.Input[builtins.bool] dry_run: Boolean that indicates whether the AutoStopping rule should be created in DryRun mode
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleEcsHttpArgs', 'RuleEcsHttpArgsDict']]]] https: Http routing configuration
        :param pulumi.Input[builtins.int] idle_time_mins: Idle time in minutes. This is the time that the AutoStopping rule waits before stopping the idle instances.
        :param pulumi.Input[builtins.str] name: Name of the rule
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuleEcsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating a Harness Variables.

        :param str resource_name: The name of the resource.
        :param RuleEcsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleEcsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 container: Optional[pulumi.Input[Union['RuleEcsContainerArgs', 'RuleEcsContainerArgsDict']]] = None,
                 custom_domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 depends: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleEcsDependArgs', 'RuleEcsDependArgsDict']]]]] = None,
                 dry_run: Optional[pulumi.Input[builtins.bool]] = None,
                 https: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleEcsHttpArgs', 'RuleEcsHttpArgsDict']]]]] = None,
                 idle_time_mins: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleEcsArgs.__new__(RuleEcsArgs)

            if cloud_connector_id is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_connector_id'")
            __props__.__dict__["cloud_connector_id"] = cloud_connector_id
            __props__.__dict__["container"] = container
            __props__.__dict__["custom_domains"] = custom_domains
            __props__.__dict__["depends"] = depends
            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["https"] = https
            __props__.__dict__["idle_time_mins"] = idle_time_mins
            __props__.__dict__["name"] = name
            __props__.__dict__["identifier"] = None
        super(RuleEcs, __self__).__init__(
            'harness:autostopping/ruleEcs:RuleEcs',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloud_connector_id: Optional[pulumi.Input[builtins.str]] = None,
            container: Optional[pulumi.Input[Union['RuleEcsContainerArgs', 'RuleEcsContainerArgsDict']]] = None,
            custom_domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            depends: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleEcsDependArgs', 'RuleEcsDependArgsDict']]]]] = None,
            dry_run: Optional[pulumi.Input[builtins.bool]] = None,
            https: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleEcsHttpArgs', 'RuleEcsHttpArgsDict']]]]] = None,
            identifier: Optional[pulumi.Input[builtins.float]] = None,
            idle_time_mins: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None) -> 'RuleEcs':
        """
        Get an existing RuleEcs resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cloud_connector_id: Id of the cloud connector
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] custom_domains: Custom URLs used to access the instances
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleEcsDependArgs', 'RuleEcsDependArgsDict']]]] depends: Dependent rules
        :param pulumi.Input[builtins.bool] dry_run: Boolean that indicates whether the AutoStopping rule should be created in DryRun mode
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleEcsHttpArgs', 'RuleEcsHttpArgsDict']]]] https: Http routing configuration
        :param pulumi.Input[builtins.float] identifier: Unique identifier of the resource
        :param pulumi.Input[builtins.int] idle_time_mins: Idle time in minutes. This is the time that the AutoStopping rule waits before stopping the idle instances.
        :param pulumi.Input[builtins.str] name: Name of the rule
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuleEcsState.__new__(_RuleEcsState)

        __props__.__dict__["cloud_connector_id"] = cloud_connector_id
        __props__.__dict__["container"] = container
        __props__.__dict__["custom_domains"] = custom_domains
        __props__.__dict__["depends"] = depends
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["https"] = https
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["idle_time_mins"] = idle_time_mins
        __props__.__dict__["name"] = name
        return RuleEcs(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cloudConnectorId")
    def cloud_connector_id(self) -> pulumi.Output[builtins.str]:
        """
        Id of the cloud connector
        """
        return pulumi.get(self, "cloud_connector_id")

    @property
    @pulumi.getter
    def container(self) -> pulumi.Output[Optional['outputs.RuleEcsContainer']]:
        return pulumi.get(self, "container")

    @property
    @pulumi.getter(name="customDomains")
    def custom_domains(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Custom URLs used to access the instances
        """
        return pulumi.get(self, "custom_domains")

    @property
    @pulumi.getter
    def depends(self) -> pulumi.Output[Optional[Sequence['outputs.RuleEcsDepend']]]:
        """
        Dependent rules
        """
        return pulumi.get(self, "depends")

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Boolean that indicates whether the AutoStopping rule should be created in DryRun mode
        """
        return pulumi.get(self, "dry_run")

    @property
    @pulumi.getter
    def https(self) -> pulumi.Output[Optional[Sequence['outputs.RuleEcsHttp']]]:
        """
        Http routing configuration
        """
        return pulumi.get(self, "https")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[builtins.float]:
        """
        Unique identifier of the resource
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="idleTimeMins")
    def idle_time_mins(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Idle time in minutes. This is the time that the AutoStopping rule waits before stopping the idle instances.
        """
        return pulumi.get(self, "idle_time_mins")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the rule
        """
        return pulumi.get(self, "name")

