# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RuleRdsArgs', 'RuleRds']

@pulumi.input_type
class RuleRdsArgs:
    def __init__(__self__, *,
                 cloud_connector_id: pulumi.Input[builtins.str],
                 database: pulumi.Input['RuleRdsDatabaseArgs'],
                 depends: Optional[pulumi.Input[Sequence[pulumi.Input['RuleRdsDependArgs']]]] = None,
                 dry_run: Optional[pulumi.Input[builtins.bool]] = None,
                 idle_time_mins: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tcps: Optional[pulumi.Input[Sequence[pulumi.Input['RuleRdsTcpArgs']]]] = None):
        """
        The set of arguments for constructing a RuleRds resource.
        :param pulumi.Input[builtins.str] cloud_connector_id: Id of the cloud connector
        :param pulumi.Input[Sequence[pulumi.Input['RuleRdsDependArgs']]] depends: Dependent rules
        :param pulumi.Input[builtins.bool] dry_run: Boolean that indicates whether the AutoStopping rule should be created in DryRun mode
        :param pulumi.Input[builtins.int] idle_time_mins: Idle time in minutes. This is the time that the AutoStopping rule waits before stopping the idle instances.
        :param pulumi.Input[builtins.str] name: Name of the rule
        :param pulumi.Input[Sequence[pulumi.Input['RuleRdsTcpArgs']]] tcps: TCP routing configuration
        """
        pulumi.set(__self__, "cloud_connector_id", cloud_connector_id)
        pulumi.set(__self__, "database", database)
        if depends is not None:
            pulumi.set(__self__, "depends", depends)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if idle_time_mins is not None:
            pulumi.set(__self__, "idle_time_mins", idle_time_mins)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tcps is not None:
            pulumi.set(__self__, "tcps", tcps)

    @property
    @pulumi.getter(name="cloudConnectorId")
    def cloud_connector_id(self) -> pulumi.Input[builtins.str]:
        """
        Id of the cloud connector
        """
        return pulumi.get(self, "cloud_connector_id")

    @cloud_connector_id.setter
    def cloud_connector_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cloud_connector_id", value)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Input['RuleRdsDatabaseArgs']:
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input['RuleRdsDatabaseArgs']):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def depends(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleRdsDependArgs']]]]:
        """
        Dependent rules
        """
        return pulumi.get(self, "depends")

    @depends.setter
    def depends(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleRdsDependArgs']]]]):
        pulumi.set(self, "depends", value)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean that indicates whether the AutoStopping rule should be created in DryRun mode
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @property
    @pulumi.getter(name="idleTimeMins")
    def idle_time_mins(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Idle time in minutes. This is the time that the AutoStopping rule waits before stopping the idle instances.
        """
        return pulumi.get(self, "idle_time_mins")

    @idle_time_mins.setter
    def idle_time_mins(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "idle_time_mins", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tcps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleRdsTcpArgs']]]]:
        """
        TCP routing configuration
        """
        return pulumi.get(self, "tcps")

    @tcps.setter
    def tcps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleRdsTcpArgs']]]]):
        pulumi.set(self, "tcps", value)


@pulumi.input_type
class _RuleRdsState:
    def __init__(__self__, *,
                 cloud_connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 database: Optional[pulumi.Input['RuleRdsDatabaseArgs']] = None,
                 depends: Optional[pulumi.Input[Sequence[pulumi.Input['RuleRdsDependArgs']]]] = None,
                 dry_run: Optional[pulumi.Input[builtins.bool]] = None,
                 identifier: Optional[pulumi.Input[builtins.float]] = None,
                 idle_time_mins: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tcps: Optional[pulumi.Input[Sequence[pulumi.Input['RuleRdsTcpArgs']]]] = None):
        """
        Input properties used for looking up and filtering RuleRds resources.
        :param pulumi.Input[builtins.str] cloud_connector_id: Id of the cloud connector
        :param pulumi.Input[Sequence[pulumi.Input['RuleRdsDependArgs']]] depends: Dependent rules
        :param pulumi.Input[builtins.bool] dry_run: Boolean that indicates whether the AutoStopping rule should be created in DryRun mode
        :param pulumi.Input[builtins.float] identifier: Unique identifier of the resource
        :param pulumi.Input[builtins.int] idle_time_mins: Idle time in minutes. This is the time that the AutoStopping rule waits before stopping the idle instances.
        :param pulumi.Input[builtins.str] name: Name of the rule
        :param pulumi.Input[Sequence[pulumi.Input['RuleRdsTcpArgs']]] tcps: TCP routing configuration
        """
        if cloud_connector_id is not None:
            pulumi.set(__self__, "cloud_connector_id", cloud_connector_id)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if depends is not None:
            pulumi.set(__self__, "depends", depends)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if idle_time_mins is not None:
            pulumi.set(__self__, "idle_time_mins", idle_time_mins)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tcps is not None:
            pulumi.set(__self__, "tcps", tcps)

    @property
    @pulumi.getter(name="cloudConnectorId")
    def cloud_connector_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Id of the cloud connector
        """
        return pulumi.get(self, "cloud_connector_id")

    @cloud_connector_id.setter
    def cloud_connector_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cloud_connector_id", value)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input['RuleRdsDatabaseArgs']]:
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input['RuleRdsDatabaseArgs']]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def depends(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleRdsDependArgs']]]]:
        """
        Dependent rules
        """
        return pulumi.get(self, "depends")

    @depends.setter
    def depends(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleRdsDependArgs']]]]):
        pulumi.set(self, "depends", value)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean that indicates whether the AutoStopping rule should be created in DryRun mode
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Unique identifier of the resource
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="idleTimeMins")
    def idle_time_mins(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Idle time in minutes. This is the time that the AutoStopping rule waits before stopping the idle instances.
        """
        return pulumi.get(self, "idle_time_mins")

    @idle_time_mins.setter
    def idle_time_mins(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "idle_time_mins", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tcps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleRdsTcpArgs']]]]:
        """
        TCP routing configuration
        """
        return pulumi.get(self, "tcps")

    @tcps.setter
    def tcps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleRdsTcpArgs']]]]):
        pulumi.set(self, "tcps", value)


@pulumi.type_token("harness:autostopping/ruleRds:RuleRds")
class RuleRds(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 database: Optional[pulumi.Input[Union['RuleRdsDatabaseArgs', 'RuleRdsDatabaseArgsDict']]] = None,
                 depends: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleRdsDependArgs', 'RuleRdsDependArgsDict']]]]] = None,
                 dry_run: Optional[pulumi.Input[builtins.bool]] = None,
                 idle_time_mins: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tcps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleRdsTcpArgs', 'RuleRdsTcpArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource for creating a Harness Variables.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        test = harness.autostopping.RuleRds("test",
            name="name",
            cloud_connector_id="cloud_connector_id",
            idle_time_mins=10,
            dry_run=True,
            database={
                "id": "database_id",
                "region": "region",
            },
            tcps=[{
                "proxy_id": "proxy_id",
                "forward_rules": [{
                    "port": 2233,
                }],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cloud_connector_id: Id of the cloud connector
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleRdsDependArgs', 'RuleRdsDependArgsDict']]]] depends: Dependent rules
        :param pulumi.Input[builtins.bool] dry_run: Boolean that indicates whether the AutoStopping rule should be created in DryRun mode
        :param pulumi.Input[builtins.int] idle_time_mins: Idle time in minutes. This is the time that the AutoStopping rule waits before stopping the idle instances.
        :param pulumi.Input[builtins.str] name: Name of the rule
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleRdsTcpArgs', 'RuleRdsTcpArgsDict']]]] tcps: TCP routing configuration
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuleRdsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating a Harness Variables.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        test = harness.autostopping.RuleRds("test",
            name="name",
            cloud_connector_id="cloud_connector_id",
            idle_time_mins=10,
            dry_run=True,
            database={
                "id": "database_id",
                "region": "region",
            },
            tcps=[{
                "proxy_id": "proxy_id",
                "forward_rules": [{
                    "port": 2233,
                }],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param RuleRdsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleRdsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 database: Optional[pulumi.Input[Union['RuleRdsDatabaseArgs', 'RuleRdsDatabaseArgsDict']]] = None,
                 depends: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleRdsDependArgs', 'RuleRdsDependArgsDict']]]]] = None,
                 dry_run: Optional[pulumi.Input[builtins.bool]] = None,
                 idle_time_mins: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tcps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleRdsTcpArgs', 'RuleRdsTcpArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleRdsArgs.__new__(RuleRdsArgs)

            if cloud_connector_id is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_connector_id'")
            __props__.__dict__["cloud_connector_id"] = cloud_connector_id
            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            __props__.__dict__["depends"] = depends
            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["idle_time_mins"] = idle_time_mins
            __props__.__dict__["name"] = name
            __props__.__dict__["tcps"] = tcps
            __props__.__dict__["identifier"] = None
        super(RuleRds, __self__).__init__(
            'harness:autostopping/ruleRds:RuleRds',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloud_connector_id: Optional[pulumi.Input[builtins.str]] = None,
            database: Optional[pulumi.Input[Union['RuleRdsDatabaseArgs', 'RuleRdsDatabaseArgsDict']]] = None,
            depends: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleRdsDependArgs', 'RuleRdsDependArgsDict']]]]] = None,
            dry_run: Optional[pulumi.Input[builtins.bool]] = None,
            identifier: Optional[pulumi.Input[builtins.float]] = None,
            idle_time_mins: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            tcps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleRdsTcpArgs', 'RuleRdsTcpArgsDict']]]]] = None) -> 'RuleRds':
        """
        Get an existing RuleRds resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cloud_connector_id: Id of the cloud connector
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleRdsDependArgs', 'RuleRdsDependArgsDict']]]] depends: Dependent rules
        :param pulumi.Input[builtins.bool] dry_run: Boolean that indicates whether the AutoStopping rule should be created in DryRun mode
        :param pulumi.Input[builtins.float] identifier: Unique identifier of the resource
        :param pulumi.Input[builtins.int] idle_time_mins: Idle time in minutes. This is the time that the AutoStopping rule waits before stopping the idle instances.
        :param pulumi.Input[builtins.str] name: Name of the rule
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleRdsTcpArgs', 'RuleRdsTcpArgsDict']]]] tcps: TCP routing configuration
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuleRdsState.__new__(_RuleRdsState)

        __props__.__dict__["cloud_connector_id"] = cloud_connector_id
        __props__.__dict__["database"] = database
        __props__.__dict__["depends"] = depends
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["idle_time_mins"] = idle_time_mins
        __props__.__dict__["name"] = name
        __props__.__dict__["tcps"] = tcps
        return RuleRds(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cloudConnectorId")
    def cloud_connector_id(self) -> pulumi.Output[builtins.str]:
        """
        Id of the cloud connector
        """
        return pulumi.get(self, "cloud_connector_id")

    @property
    @pulumi.getter
    def database(self) -> pulumi.Output['outputs.RuleRdsDatabase']:
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def depends(self) -> pulumi.Output[Optional[Sequence['outputs.RuleRdsDepend']]]:
        """
        Dependent rules
        """
        return pulumi.get(self, "depends")

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Boolean that indicates whether the AutoStopping rule should be created in DryRun mode
        """
        return pulumi.get(self, "dry_run")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[builtins.float]:
        """
        Unique identifier of the resource
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="idleTimeMins")
    def idle_time_mins(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Idle time in minutes. This is the time that the AutoStopping rule waits before stopping the idle instances.
        """
        return pulumi.get(self, "idle_time_mins")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the rule
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tcps(self) -> pulumi.Output[Optional[Sequence['outputs.RuleRdsTcp']]]:
        """
        TCP routing configuration
        """
        return pulumi.get(self, "tcps")

