# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDelegateIdsResult',
    'AwaitableGetDelegateIdsResult',
    'get_delegate_ids',
    'get_delegate_ids_output',
]

@pulumi.output_type
class GetDelegateIdsResult:
    """
    A collection of values returned by getDelegateIds.
    """
    def __init__(__self__, delegate_ids=None, id=None, name=None, status=None, type=None):
        if delegate_ids and not isinstance(delegate_ids, list):
            raise TypeError("Expected argument 'delegate_ids' to be a list")
        pulumi.set(__self__, "delegate_ids", delegate_ids)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="delegateIds")
    def delegate_ids(self) -> Sequence[builtins.str]:
        """
        A list of delegate ID's matching the specified search criteria.
        """
        return pulumi.get(self, "delegate_ids")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the delegate to query for.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        The status of the delegate to query for. Valid values are DELETED, ENABLED, WAITING*FOR*APPROVAL
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The type of the delegate to query for. Valid values are DOCKER, ECS, HELM*DELEGATE, KUBERNETES, SHELL*SCRIPT
        """
        return pulumi.get(self, "type")


class AwaitableGetDelegateIdsResult(GetDelegateIdsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDelegateIdsResult(
            delegate_ids=self.delegate_ids,
            id=self.id,
            name=self.name,
            status=self.status,
            type=self.type)


def get_delegate_ids(name: Optional[builtins.str] = None,
                     status: Optional[builtins.str] = None,
                     type: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDelegateIdsResult:
    """
    Use this data source to get a list of delegate ID's matching the specified search criteria.


    :param builtins.str name: The name of the delegate to query for.
    :param builtins.str status: The status of the delegate to query for. Valid values are DELETED, ENABLED, WAITING*FOR*APPROVAL
    :param builtins.str type: The type of the delegate to query for. Valid values are DOCKER, ECS, HELM*DELEGATE, KUBERNETES, SHELL*SCRIPT
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['status'] = status
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:cloudprovider/getDelegateIds:getDelegateIds', __args__, opts=opts, typ=GetDelegateIdsResult).value

    return AwaitableGetDelegateIdsResult(
        delegate_ids=pulumi.get(__ret__, 'delegate_ids'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        status=pulumi.get(__ret__, 'status'),
        type=pulumi.get(__ret__, 'type'))
def get_delegate_ids_output(name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            status: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDelegateIdsResult]:
    """
    Use this data source to get a list of delegate ID's matching the specified search criteria.


    :param builtins.str name: The name of the delegate to query for.
    :param builtins.str status: The status of the delegate to query for. Valid values are DELETED, ENABLED, WAITING*FOR*APPROVAL
    :param builtins.str type: The type of the delegate to query for. Valid values are DOCKER, ECS, HELM*DELEGATE, KUBERNETES, SHELL*SCRIPT
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['status'] = status
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:cloudprovider/getDelegateIds:getDelegateIds', __args__, opts=opts, typ=GetDelegateIdsResult)
    return __ret__.apply(lambda __response__: GetDelegateIdsResult(
        delegate_ids=pulumi.get(__response__, 'delegate_ids'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        status=pulumi.get(__response__, 'status'),
        type=pulumi.get(__response__, 'type')))
