# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOrchestratorConfigResult',
    'AwaitableGetOrchestratorConfigResult',
    'get_orchestrator_config',
    'get_orchestrator_config_output',
]

@pulumi.output_type
class GetOrchestratorConfigResult:
    """
    A collection of values returned by getOrchestratorConfig.
    """
    def __init__(__self__, binpacking=None, distribution=None, id=None, node_preferences=None, orchestrator_id=None):
        if binpacking and not isinstance(binpacking, dict):
            raise TypeError("Expected argument 'binpacking' to be a dict")
        pulumi.set(__self__, "binpacking", binpacking)
        if distribution and not isinstance(distribution, dict):
            raise TypeError("Expected argument 'distribution' to be a dict")
        pulumi.set(__self__, "distribution", distribution)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if node_preferences and not isinstance(node_preferences, dict):
            raise TypeError("Expected argument 'node_preferences' to be a dict")
        pulumi.set(__self__, "node_preferences", node_preferences)
        if orchestrator_id and not isinstance(orchestrator_id, str):
            raise TypeError("Expected argument 'orchestrator_id' to be a str")
        pulumi.set(__self__, "orchestrator_id", orchestrator_id)

    @property
    @pulumi.getter
    def binpacking(self) -> Optional['outputs.GetOrchestratorConfigBinpackingResult']:
        """
        Binpacking preferences for Cluster Orchestrator
        """
        return pulumi.get(self, "binpacking")

    @property
    @pulumi.getter
    def distribution(self) -> Optional['outputs.GetOrchestratorConfigDistributionResult']:
        """
        Spot and Ondemand Distribution Preferences for workload replicas
        """
        return pulumi.get(self, "distribution")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="nodePreferences")
    def node_preferences(self) -> Optional['outputs.GetOrchestratorConfigNodePreferencesResult']:
        """
        Node preferences for Cluster Orchestrator
        """
        return pulumi.get(self, "node_preferences")

    @property
    @pulumi.getter(name="orchestratorId")
    def orchestrator_id(self) -> builtins.str:
        """
        ID of the Cluster Orchestrator Object
        """
        return pulumi.get(self, "orchestrator_id")


class AwaitableGetOrchestratorConfigResult(GetOrchestratorConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrchestratorConfigResult(
            binpacking=self.binpacking,
            distribution=self.distribution,
            id=self.id,
            node_preferences=self.node_preferences,
            orchestrator_id=self.orchestrator_id)


def get_orchestrator_config(binpacking: Optional[Union['GetOrchestratorConfigBinpackingArgs', 'GetOrchestratorConfigBinpackingArgsDict']] = None,
                            distribution: Optional[Union['GetOrchestratorConfigDistributionArgs', 'GetOrchestratorConfigDistributionArgsDict']] = None,
                            node_preferences: Optional[Union['GetOrchestratorConfigNodePreferencesArgs', 'GetOrchestratorConfigNodePreferencesArgsDict']] = None,
                            orchestrator_id: Optional[builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrchestratorConfigResult:
    """
    Resource for ClusterOrchestrator Config.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.cluster.get_orchestrator_config(orchestrator_id="identifier")
    ```


    :param Union['GetOrchestratorConfigBinpackingArgs', 'GetOrchestratorConfigBinpackingArgsDict'] binpacking: Binpacking preferences for Cluster Orchestrator
    :param Union['GetOrchestratorConfigDistributionArgs', 'GetOrchestratorConfigDistributionArgsDict'] distribution: Spot and Ondemand Distribution Preferences for workload replicas
    :param Union['GetOrchestratorConfigNodePreferencesArgs', 'GetOrchestratorConfigNodePreferencesArgsDict'] node_preferences: Node preferences for Cluster Orchestrator
    :param builtins.str orchestrator_id: ID of the Cluster Orchestrator Object
    """
    __args__ = dict()
    __args__['binpacking'] = binpacking
    __args__['distribution'] = distribution
    __args__['nodePreferences'] = node_preferences
    __args__['orchestratorId'] = orchestrator_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:cluster/getOrchestratorConfig:getOrchestratorConfig', __args__, opts=opts, typ=GetOrchestratorConfigResult).value

    return AwaitableGetOrchestratorConfigResult(
        binpacking=pulumi.get(__ret__, 'binpacking'),
        distribution=pulumi.get(__ret__, 'distribution'),
        id=pulumi.get(__ret__, 'id'),
        node_preferences=pulumi.get(__ret__, 'node_preferences'),
        orchestrator_id=pulumi.get(__ret__, 'orchestrator_id'))
def get_orchestrator_config_output(binpacking: Optional[pulumi.Input[Optional[Union['GetOrchestratorConfigBinpackingArgs', 'GetOrchestratorConfigBinpackingArgsDict']]]] = None,
                                   distribution: Optional[pulumi.Input[Optional[Union['GetOrchestratorConfigDistributionArgs', 'GetOrchestratorConfigDistributionArgsDict']]]] = None,
                                   node_preferences: Optional[pulumi.Input[Optional[Union['GetOrchestratorConfigNodePreferencesArgs', 'GetOrchestratorConfigNodePreferencesArgsDict']]]] = None,
                                   orchestrator_id: Optional[pulumi.Input[builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOrchestratorConfigResult]:
    """
    Resource for ClusterOrchestrator Config.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.cluster.get_orchestrator_config(orchestrator_id="identifier")
    ```


    :param Union['GetOrchestratorConfigBinpackingArgs', 'GetOrchestratorConfigBinpackingArgsDict'] binpacking: Binpacking preferences for Cluster Orchestrator
    :param Union['GetOrchestratorConfigDistributionArgs', 'GetOrchestratorConfigDistributionArgsDict'] distribution: Spot and Ondemand Distribution Preferences for workload replicas
    :param Union['GetOrchestratorConfigNodePreferencesArgs', 'GetOrchestratorConfigNodePreferencesArgsDict'] node_preferences: Node preferences for Cluster Orchestrator
    :param builtins.str orchestrator_id: ID of the Cluster Orchestrator Object
    """
    __args__ = dict()
    __args__['binpacking'] = binpacking
    __args__['distribution'] = distribution
    __args__['nodePreferences'] = node_preferences
    __args__['orchestratorId'] = orchestrator_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:cluster/getOrchestratorConfig:getOrchestratorConfig', __args__, opts=opts, typ=GetOrchestratorConfigResult)
    return __ret__.apply(lambda __response__: GetOrchestratorConfigResult(
        binpacking=pulumi.get(__response__, 'binpacking'),
        distribution=pulumi.get(__response__, 'distribution'),
        id=pulumi.get(__response__, 'id'),
        node_preferences=pulumi.get(__response__, 'node_preferences'),
        orchestrator_id=pulumi.get(__response__, 'orchestrator_id')))
