# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'OrchestratorConfigBinpacking',
    'OrchestratorConfigBinpackingDisruption',
    'OrchestratorConfigBinpackingDisruptionBudget',
    'OrchestratorConfigBinpackingDisruptionBudgetSchedule',
    'OrchestratorConfigBinpackingPodEviction',
    'OrchestratorConfigBinpackingPodEvictionThreshold',
    'OrchestratorConfigDistribution',
    'OrchestratorConfigNodePreferences',
    'GetOrchestratorConfigBinpackingResult',
    'GetOrchestratorConfigBinpackingDisruptionResult',
    'GetOrchestratorConfigBinpackingDisruptionBudgetResult',
    'GetOrchestratorConfigBinpackingDisruptionBudgetScheduleResult',
    'GetOrchestratorConfigBinpackingPodEvictionResult',
    'GetOrchestratorConfigBinpackingPodEvictionThresholdResult',
    'GetOrchestratorConfigDistributionResult',
    'GetOrchestratorConfigNodePreferencesResult',
]

@pulumi.output_type
class OrchestratorConfigBinpacking(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "podEviction":
            suggest = "pod_eviction"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrchestratorConfigBinpacking. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrchestratorConfigBinpacking.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrchestratorConfigBinpacking.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disruption: Optional['outputs.OrchestratorConfigBinpackingDisruption'] = None,
                 pod_eviction: Optional['outputs.OrchestratorConfigBinpackingPodEviction'] = None):
        """
        :param 'OrchestratorConfigBinpackingDisruptionArgs' disruption: Harness disruption configuration
        :param 'OrchestratorConfigBinpackingPodEvictionArgs' pod_eviction: Harness Pod Evictor Configuration
        """
        if disruption is not None:
            pulumi.set(__self__, "disruption", disruption)
        if pod_eviction is not None:
            pulumi.set(__self__, "pod_eviction", pod_eviction)

    @property
    @pulumi.getter
    def disruption(self) -> Optional['outputs.OrchestratorConfigBinpackingDisruption']:
        """
        Harness disruption configuration
        """
        return pulumi.get(self, "disruption")

    @property
    @pulumi.getter(name="podEviction")
    def pod_eviction(self) -> Optional['outputs.OrchestratorConfigBinpackingPodEviction']:
        """
        Harness Pod Evictor Configuration
        """
        return pulumi.get(self, "pod_eviction")


@pulumi.output_type
class OrchestratorConfigBinpackingDisruption(dict):
    def __init__(__self__, *,
                 budgets: Optional[Sequence['outputs.OrchestratorConfigBinpackingDisruptionBudget']] = None,
                 criteria: Optional[builtins.str] = None,
                 delay: Optional[builtins.str] = None):
        """
        :param Sequence['OrchestratorConfigBinpackingDisruptionBudgetArgs'] budgets: Budgets for disruption
        :param builtins.str criteria: Criteria for considering a nodes for disruption
        :param builtins.str delay: Deletion delay
        """
        if budgets is not None:
            pulumi.set(__self__, "budgets", budgets)
        if criteria is not None:
            pulumi.set(__self__, "criteria", criteria)
        if delay is not None:
            pulumi.set(__self__, "delay", delay)

    @property
    @pulumi.getter
    def budgets(self) -> Optional[Sequence['outputs.OrchestratorConfigBinpackingDisruptionBudget']]:
        """
        Budgets for disruption
        """
        return pulumi.get(self, "budgets")

    @property
    @pulumi.getter
    def criteria(self) -> Optional[builtins.str]:
        """
        Criteria for considering a nodes for disruption
        """
        return pulumi.get(self, "criteria")

    @property
    @pulumi.getter
    def delay(self) -> Optional[builtins.str]:
        """
        Deletion delay
        """
        return pulumi.get(self, "delay")


@pulumi.output_type
class OrchestratorConfigBinpackingDisruptionBudget(dict):
    def __init__(__self__, *,
                 nodes: builtins.str,
                 reasons: Optional[Sequence[builtins.str]] = None,
                 schedule: Optional['outputs.OrchestratorConfigBinpackingDisruptionBudgetSchedule'] = None):
        """
        :param builtins.str nodes: Number or percentage of Nodes to consider for disruption
        :param Sequence[builtins.str] reasons: Reasons for disruption
        :param 'OrchestratorConfigBinpackingDisruptionBudgetScheduleArgs' schedule: Schedule for disruption budget
        """
        pulumi.set(__self__, "nodes", nodes)
        if reasons is not None:
            pulumi.set(__self__, "reasons", reasons)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter
    def nodes(self) -> builtins.str:
        """
        Number or percentage of Nodes to consider for disruption
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter
    def reasons(self) -> Optional[Sequence[builtins.str]]:
        """
        Reasons for disruption
        """
        return pulumi.get(self, "reasons")

    @property
    @pulumi.getter
    def schedule(self) -> Optional['outputs.OrchestratorConfigBinpackingDisruptionBudgetSchedule']:
        """
        Schedule for disruption budget
        """
        return pulumi.get(self, "schedule")


@pulumi.output_type
class OrchestratorConfigBinpackingDisruptionBudgetSchedule(dict):
    def __init__(__self__, *,
                 duration: builtins.str,
                 frequency: builtins.str):
        """
        :param builtins.str duration: Duration for disruption budget
        :param builtins.str frequency: Frequency for disruption budget
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "frequency", frequency)

    @property
    @pulumi.getter
    def duration(self) -> builtins.str:
        """
        Duration for disruption budget
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def frequency(self) -> builtins.str:
        """
        Frequency for disruption budget
        """
        return pulumi.get(self, "frequency")


@pulumi.output_type
class OrchestratorConfigBinpackingPodEviction(dict):
    def __init__(__self__, *,
                 threshold: 'outputs.OrchestratorConfigBinpackingPodEvictionThreshold'):
        """
        :param 'OrchestratorConfigBinpackingPodEvictionThresholdArgs' threshold: Minimum Threshold for considering a node as underutilized
        """
        pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter
    def threshold(self) -> 'outputs.OrchestratorConfigBinpackingPodEvictionThreshold':
        """
        Minimum Threshold for considering a node as underutilized
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class OrchestratorConfigBinpackingPodEvictionThreshold(dict):
    def __init__(__self__, *,
                 cpu: builtins.float,
                 memory: builtins.float):
        """
        :param builtins.float cpu: CPU percentage for considering a node as underutilized
        :param builtins.float memory: Memory percentage for considering a node as underutilized
        """
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "memory", memory)

    @property
    @pulumi.getter
    def cpu(self) -> builtins.float:
        """
        CPU percentage for considering a node as underutilized
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter
    def memory(self) -> builtins.float:
        """
        Memory percentage for considering a node as underutilized
        """
        return pulumi.get(self, "memory")


@pulumi.output_type
class OrchestratorConfigDistribution(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ondemandReplicaPercentage":
            suggest = "ondemand_replica_percentage"
        elif key == "baseOndemandCapacity":
            suggest = "base_ondemand_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrchestratorConfigDistribution. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrchestratorConfigDistribution.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrchestratorConfigDistribution.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ondemand_replica_percentage: builtins.float,
                 base_ondemand_capacity: Optional[builtins.int] = None,
                 selector: Optional[builtins.str] = None,
                 strategy: Optional[builtins.str] = None):
        """
        :param builtins.float ondemand_replica_percentage: Percentage of on-demand replicas required for workloads
        :param builtins.int base_ondemand_capacity: Number of minimum ondemand replicas required for workloads
        :param builtins.str selector: Selector for choosing workloads for distribution
        :param builtins.str strategy: Strategy for choosing spot nodes for cluster
        """
        pulumi.set(__self__, "ondemand_replica_percentage", ondemand_replica_percentage)
        if base_ondemand_capacity is not None:
            pulumi.set(__self__, "base_ondemand_capacity", base_ondemand_capacity)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)

    @property
    @pulumi.getter(name="ondemandReplicaPercentage")
    def ondemand_replica_percentage(self) -> builtins.float:
        """
        Percentage of on-demand replicas required for workloads
        """
        return pulumi.get(self, "ondemand_replica_percentage")

    @property
    @pulumi.getter(name="baseOndemandCapacity")
    def base_ondemand_capacity(self) -> Optional[builtins.int]:
        """
        Number of minimum ondemand replicas required for workloads
        """
        return pulumi.get(self, "base_ondemand_capacity")

    @property
    @pulumi.getter
    def selector(self) -> Optional[builtins.str]:
        """
        Selector for choosing workloads for distribution
        """
        return pulumi.get(self, "selector")

    @property
    @pulumi.getter
    def strategy(self) -> Optional[builtins.str]:
        """
        Strategy for choosing spot nodes for cluster
        """
        return pulumi.get(self, "strategy")


@pulumi.output_type
class OrchestratorConfigNodePreferences(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "reverseFallbackInterval":
            suggest = "reverse_fallback_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrchestratorConfigNodePreferences. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrchestratorConfigNodePreferences.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrchestratorConfigNodePreferences.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 reverse_fallback_interval: Optional[builtins.str] = None,
                 ttl: Optional[builtins.str] = None):
        """
        :param builtins.str reverse_fallback_interval: Reverse fallback interval
        :param builtins.str ttl: TTL for nodes
        """
        if reverse_fallback_interval is not None:
            pulumi.set(__self__, "reverse_fallback_interval", reverse_fallback_interval)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter(name="reverseFallbackInterval")
    def reverse_fallback_interval(self) -> Optional[builtins.str]:
        """
        Reverse fallback interval
        """
        return pulumi.get(self, "reverse_fallback_interval")

    @property
    @pulumi.getter
    def ttl(self) -> Optional[builtins.str]:
        """
        TTL for nodes
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class GetOrchestratorConfigBinpackingResult(dict):
    def __init__(__self__, *,
                 disruption: Optional['outputs.GetOrchestratorConfigBinpackingDisruptionResult'] = None,
                 pod_eviction: Optional['outputs.GetOrchestratorConfigBinpackingPodEvictionResult'] = None):
        """
        :param 'GetOrchestratorConfigBinpackingDisruptionArgs' disruption: Harness disruption configuration
        :param 'GetOrchestratorConfigBinpackingPodEvictionArgs' pod_eviction: Harness Pod Evictor Configuration
        """
        if disruption is not None:
            pulumi.set(__self__, "disruption", disruption)
        if pod_eviction is not None:
            pulumi.set(__self__, "pod_eviction", pod_eviction)

    @property
    @pulumi.getter
    def disruption(self) -> Optional['outputs.GetOrchestratorConfigBinpackingDisruptionResult']:
        """
        Harness disruption configuration
        """
        return pulumi.get(self, "disruption")

    @property
    @pulumi.getter(name="podEviction")
    def pod_eviction(self) -> Optional['outputs.GetOrchestratorConfigBinpackingPodEvictionResult']:
        """
        Harness Pod Evictor Configuration
        """
        return pulumi.get(self, "pod_eviction")


@pulumi.output_type
class GetOrchestratorConfigBinpackingDisruptionResult(dict):
    def __init__(__self__, *,
                 budgets: Optional[Sequence['outputs.GetOrchestratorConfigBinpackingDisruptionBudgetResult']] = None,
                 criteria: Optional[builtins.str] = None,
                 delay: Optional[builtins.str] = None):
        """
        :param Sequence['GetOrchestratorConfigBinpackingDisruptionBudgetArgs'] budgets: Budgets for disruption
        :param builtins.str criteria: Criteria for considering a nodes for disruption
        :param builtins.str delay: Deletion delay
        """
        if budgets is not None:
            pulumi.set(__self__, "budgets", budgets)
        if criteria is not None:
            pulumi.set(__self__, "criteria", criteria)
        if delay is not None:
            pulumi.set(__self__, "delay", delay)

    @property
    @pulumi.getter
    def budgets(self) -> Optional[Sequence['outputs.GetOrchestratorConfigBinpackingDisruptionBudgetResult']]:
        """
        Budgets for disruption
        """
        return pulumi.get(self, "budgets")

    @property
    @pulumi.getter
    def criteria(self) -> Optional[builtins.str]:
        """
        Criteria for considering a nodes for disruption
        """
        return pulumi.get(self, "criteria")

    @property
    @pulumi.getter
    def delay(self) -> Optional[builtins.str]:
        """
        Deletion delay
        """
        return pulumi.get(self, "delay")


@pulumi.output_type
class GetOrchestratorConfigBinpackingDisruptionBudgetResult(dict):
    def __init__(__self__, *,
                 nodes: builtins.str,
                 reasons: Optional[Sequence[builtins.str]] = None,
                 schedule: Optional['outputs.GetOrchestratorConfigBinpackingDisruptionBudgetScheduleResult'] = None):
        """
        :param builtins.str nodes: Number or percentage of Nodes to consider for disruption
        :param Sequence[builtins.str] reasons: Reasons for disruption
        :param 'GetOrchestratorConfigBinpackingDisruptionBudgetScheduleArgs' schedule: Schedule for disruption budget
        """
        pulumi.set(__self__, "nodes", nodes)
        if reasons is not None:
            pulumi.set(__self__, "reasons", reasons)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter
    def nodes(self) -> builtins.str:
        """
        Number or percentage of Nodes to consider for disruption
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter
    def reasons(self) -> Optional[Sequence[builtins.str]]:
        """
        Reasons for disruption
        """
        return pulumi.get(self, "reasons")

    @property
    @pulumi.getter
    def schedule(self) -> Optional['outputs.GetOrchestratorConfigBinpackingDisruptionBudgetScheduleResult']:
        """
        Schedule for disruption budget
        """
        return pulumi.get(self, "schedule")


@pulumi.output_type
class GetOrchestratorConfigBinpackingDisruptionBudgetScheduleResult(dict):
    def __init__(__self__, *,
                 duration: builtins.str,
                 frequency: builtins.str):
        """
        :param builtins.str duration: Duration for disruption budget
        :param builtins.str frequency: Frequency for disruption budget
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "frequency", frequency)

    @property
    @pulumi.getter
    def duration(self) -> builtins.str:
        """
        Duration for disruption budget
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def frequency(self) -> builtins.str:
        """
        Frequency for disruption budget
        """
        return pulumi.get(self, "frequency")


@pulumi.output_type
class GetOrchestratorConfigBinpackingPodEvictionResult(dict):
    def __init__(__self__, *,
                 threshold: 'outputs.GetOrchestratorConfigBinpackingPodEvictionThresholdResult'):
        """
        :param 'GetOrchestratorConfigBinpackingPodEvictionThresholdArgs' threshold: Minimum Threshold for considering a node as underutilized
        """
        pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter
    def threshold(self) -> 'outputs.GetOrchestratorConfigBinpackingPodEvictionThresholdResult':
        """
        Minimum Threshold for considering a node as underutilized
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class GetOrchestratorConfigBinpackingPodEvictionThresholdResult(dict):
    def __init__(__self__, *,
                 cpu: builtins.float,
                 memory: builtins.float):
        """
        :param builtins.float cpu: CPU percentage for considering a node as underutilized
        :param builtins.float memory: Memory percentage for considering a node as underutilized
        """
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "memory", memory)

    @property
    @pulumi.getter
    def cpu(self) -> builtins.float:
        """
        CPU percentage for considering a node as underutilized
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter
    def memory(self) -> builtins.float:
        """
        Memory percentage for considering a node as underutilized
        """
        return pulumi.get(self, "memory")


@pulumi.output_type
class GetOrchestratorConfigDistributionResult(dict):
    def __init__(__self__, *,
                 ondemand_replica_percentage: builtins.float,
                 base_ondemand_capacity: Optional[builtins.int] = None,
                 selector: Optional[builtins.str] = None,
                 strategy: Optional[builtins.str] = None):
        """
        :param builtins.float ondemand_replica_percentage: Percentage of on-demand replicas required for workloads
        :param builtins.int base_ondemand_capacity: Number of minimum ondemand replicas required for workloads
        :param builtins.str selector: Selector for choosing workloads for distribution
        :param builtins.str strategy: Strategy for choosing spot nodes for cluster
        """
        pulumi.set(__self__, "ondemand_replica_percentage", ondemand_replica_percentage)
        if base_ondemand_capacity is not None:
            pulumi.set(__self__, "base_ondemand_capacity", base_ondemand_capacity)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)

    @property
    @pulumi.getter(name="ondemandReplicaPercentage")
    def ondemand_replica_percentage(self) -> builtins.float:
        """
        Percentage of on-demand replicas required for workloads
        """
        return pulumi.get(self, "ondemand_replica_percentage")

    @property
    @pulumi.getter(name="baseOndemandCapacity")
    def base_ondemand_capacity(self) -> Optional[builtins.int]:
        """
        Number of minimum ondemand replicas required for workloads
        """
        return pulumi.get(self, "base_ondemand_capacity")

    @property
    @pulumi.getter
    def selector(self) -> Optional[builtins.str]:
        """
        Selector for choosing workloads for distribution
        """
        return pulumi.get(self, "selector")

    @property
    @pulumi.getter
    def strategy(self) -> Optional[builtins.str]:
        """
        Strategy for choosing spot nodes for cluster
        """
        return pulumi.get(self, "strategy")


@pulumi.output_type
class GetOrchestratorConfigNodePreferencesResult(dict):
    def __init__(__self__, *,
                 reverse_fallback_interval: Optional[builtins.str] = None,
                 ttl: Optional[builtins.str] = None):
        """
        :param builtins.str reverse_fallback_interval: Reverse fallback interval
        :param builtins.str ttl: TTL for nodes
        """
        if reverse_fallback_interval is not None:
            pulumi.set(__self__, "reverse_fallback_interval", reverse_fallback_interval)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter(name="reverseFallbackInterval")
    def reverse_fallback_interval(self) -> Optional[builtins.str]:
        """
        Reverse fallback interval
        """
        return pulumi.get(self, "reverse_fallback_interval")

    @property
    @pulumi.getter
    def ttl(self) -> Optional[builtins.str]:
        """
        TTL for nodes
        """
        return pulumi.get(self, "ttl")


