# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetApplicationResult',
    'AwaitableGetApplicationResult',
    'get_application',
    'get_application_output',
]

@pulumi.output_type
class GetApplicationResult:
    """
    A collection of values returned by getApplication.
    """
    def __init__(__self__, description=None, git_sync_connector_id=None, git_sync_enabled=None, id=None, is_manual_trigger_authorized=None, name=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if git_sync_connector_id and not isinstance(git_sync_connector_id, str):
            raise TypeError("Expected argument 'git_sync_connector_id' to be a str")
        pulumi.set(__self__, "git_sync_connector_id", git_sync_connector_id)
        if git_sync_enabled and not isinstance(git_sync_enabled, bool):
            raise TypeError("Expected argument 'git_sync_enabled' to be a bool")
        pulumi.set(__self__, "git_sync_enabled", git_sync_enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_manual_trigger_authorized and not isinstance(is_manual_trigger_authorized, bool):
            raise TypeError("Expected argument 'is_manual_trigger_authorized' to be a bool")
        pulumi.set(__self__, "is_manual_trigger_authorized", is_manual_trigger_authorized)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The application description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="gitSyncConnectorId")
    def git_sync_connector_id(self) -> Optional[builtins.str]:
        """
        The id of the git sync connector
        """
        return pulumi.get(self, "git_sync_connector_id")

    @property
    @pulumi.getter(name="gitSyncEnabled")
    def git_sync_enabled(self) -> Optional[builtins.bool]:
        """
        True if git sync is enabled on this application
        """
        return pulumi.get(self, "git_sync_enabled")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        Unique identifier of the application
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isManualTriggerAuthorized")
    def is_manual_trigger_authorized(self) -> Optional[builtins.bool]:
        """
        When this is set to true, all manual triggers will require API Key authorization
        """
        return pulumi.get(self, "is_manual_trigger_authorized")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the application
        """
        return pulumi.get(self, "name")


class AwaitableGetApplicationResult(GetApplicationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApplicationResult(
            description=self.description,
            git_sync_connector_id=self.git_sync_connector_id,
            git_sync_enabled=self.git_sync_enabled,
            id=self.id,
            is_manual_trigger_authorized=self.is_manual_trigger_authorized,
            name=self.name)


def get_application(description: Optional[builtins.str] = None,
                    git_sync_connector_id: Optional[builtins.str] = None,
                    git_sync_enabled: Optional[builtins.bool] = None,
                    id: Optional[builtins.str] = None,
                    is_manual_trigger_authorized: Optional[builtins.bool] = None,
                    name: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApplicationResult:
    """
    Data source for retrieving a Harness application


    :param builtins.str description: The application description
    :param builtins.str git_sync_connector_id: The id of the git sync connector
    :param builtins.bool git_sync_enabled: True if git sync is enabled on this application
    :param builtins.str id: Unique identifier of the application
    :param builtins.bool is_manual_trigger_authorized: When this is set to true, all manual triggers will require API Key authorization
    :param builtins.str name: The name of the application
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['gitSyncConnectorId'] = git_sync_connector_id
    __args__['gitSyncEnabled'] = git_sync_enabled
    __args__['id'] = id
    __args__['isManualTriggerAuthorized'] = is_manual_trigger_authorized
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:index/getApplication:getApplication', __args__, opts=opts, typ=GetApplicationResult).value

    return AwaitableGetApplicationResult(
        description=pulumi.get(__ret__, 'description'),
        git_sync_connector_id=pulumi.get(__ret__, 'git_sync_connector_id'),
        git_sync_enabled=pulumi.get(__ret__, 'git_sync_enabled'),
        id=pulumi.get(__ret__, 'id'),
        is_manual_trigger_authorized=pulumi.get(__ret__, 'is_manual_trigger_authorized'),
        name=pulumi.get(__ret__, 'name'))
def get_application_output(description: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           git_sync_connector_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           git_sync_enabled: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                           id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           is_manual_trigger_authorized: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                           name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApplicationResult]:
    """
    Data source for retrieving a Harness application


    :param builtins.str description: The application description
    :param builtins.str git_sync_connector_id: The id of the git sync connector
    :param builtins.bool git_sync_enabled: True if git sync is enabled on this application
    :param builtins.str id: Unique identifier of the application
    :param builtins.bool is_manual_trigger_authorized: When this is set to true, all manual triggers will require API Key authorization
    :param builtins.str name: The name of the application
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['gitSyncConnectorId'] = git_sync_connector_id
    __args__['gitSyncEnabled'] = git_sync_enabled
    __args__['id'] = id
    __args__['isManualTriggerAuthorized'] = is_manual_trigger_authorized
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:index/getApplication:getApplication', __args__, opts=opts, typ=GetApplicationResult)
    return __ret__.apply(lambda __response__: GetApplicationResult(
        description=pulumi.get(__response__, 'description'),
        git_sync_connector_id=pulumi.get(__response__, 'git_sync_connector_id'),
        git_sync_enabled=pulumi.get(__response__, 'git_sync_enabled'),
        id=pulumi.get(__response__, 'id'),
        is_manual_trigger_authorized=pulumi.get(__response__, 'is_manual_trigger_authorized'),
        name=pulumi.get(__response__, 'name')))
