# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetChaosInfrastructureResult',
    'AwaitableGetChaosInfrastructureResult',
    'get_chaos_infrastructure',
    'get_chaos_infrastructure_output',
]

@pulumi.output_type
class GetChaosInfrastructureResult:
    """
    A collection of values returned by getChaosInfrastructure.
    """
    def __init__(__self__, environment_id=None, id=None, identifier=None, org_id=None, project_id=None):
        if environment_id and not isinstance(environment_id, str):
            raise TypeError("Expected argument 'environment_id' to be a str")
        pulumi.set(__self__, "environment_id", environment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> builtins.str:
        """
        Environment identifier of the chaos infrastructure.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifier(self) -> builtins.str:
        """
        Identifier of the chaos infrastructure.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> builtins.str:
        """
        Identifier of the organization in which the chaos infrastructure is configured.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        Identifier of the project in which the chaos infrastructure is configured.
        """
        return pulumi.get(self, "project_id")


class AwaitableGetChaosInfrastructureResult(GetChaosInfrastructureResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetChaosInfrastructureResult(
            environment_id=self.environment_id,
            id=self.id,
            identifier=self.identifier,
            org_id=self.org_id,
            project_id=self.project_id)


def get_chaos_infrastructure(environment_id: Optional[builtins.str] = None,
                             identifier: Optional[builtins.str] = None,
                             org_id: Optional[builtins.str] = None,
                             project_id: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetChaosInfrastructureResult:
    """
    Data source for retrieving a chaos infrastructure.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.get_chaos_infrastructure(identifier="identifier",
        org_id="org_id",
        project_id="project_id",
        environment_id="env_id")
    ```


    :param builtins.str environment_id: Environment identifier of the chaos infrastructure.
    :param builtins.str identifier: Identifier of the chaos infrastructure.
    :param builtins.str org_id: Identifier of the organization in which the chaos infrastructure is configured.
    :param builtins.str project_id: Identifier of the project in which the chaos infrastructure is configured.
    """
    __args__ = dict()
    __args__['environmentId'] = environment_id
    __args__['identifier'] = identifier
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:index/getChaosInfrastructure:getChaosInfrastructure', __args__, opts=opts, typ=GetChaosInfrastructureResult).value

    return AwaitableGetChaosInfrastructureResult(
        environment_id=pulumi.get(__ret__, 'environment_id'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        org_id=pulumi.get(__ret__, 'org_id'),
        project_id=pulumi.get(__ret__, 'project_id'))
def get_chaos_infrastructure_output(environment_id: Optional[pulumi.Input[builtins.str]] = None,
                                    identifier: Optional[pulumi.Input[builtins.str]] = None,
                                    org_id: Optional[pulumi.Input[builtins.str]] = None,
                                    project_id: Optional[pulumi.Input[builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetChaosInfrastructureResult]:
    """
    Data source for retrieving a chaos infrastructure.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.get_chaos_infrastructure(identifier="identifier",
        org_id="org_id",
        project_id="project_id",
        environment_id="env_id")
    ```


    :param builtins.str environment_id: Environment identifier of the chaos infrastructure.
    :param builtins.str identifier: Identifier of the chaos infrastructure.
    :param builtins.str org_id: Identifier of the organization in which the chaos infrastructure is configured.
    :param builtins.str project_id: Identifier of the project in which the chaos infrastructure is configured.
    """
    __args__ = dict()
    __args__['environmentId'] = environment_id
    __args__['identifier'] = identifier
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:index/getChaosInfrastructure:getChaosInfrastructure', __args__, opts=opts, typ=GetChaosInfrastructureResult)
    return __ret__.apply(lambda __response__: GetChaosInfrastructureResult(
        environment_id=pulumi.get(__response__, 'environment_id'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        org_id=pulumi.get(__response__, 'org_id'),
        project_id=pulumi.get(__response__, 'project_id')))
