# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSshCredentialResult',
    'AwaitableGetSshCredentialResult',
    'get_ssh_credential',
    'get_ssh_credential_output',
]

@pulumi.output_type
class GetSshCredentialResult:
    """
    A collection of values returned by getSshCredential.
    """
    def __init__(__self__, id=None, name=None, usage_scopes=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if usage_scopes and not isinstance(usage_scopes, list):
            raise TypeError("Expected argument 'usage_scopes' to be a list")
        pulumi.set(__self__, "usage_scopes", usage_scopes)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        Unique identifier of the secret manager
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the secret manager
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="usageScopes")
    def usage_scopes(self) -> Optional[Sequence['outputs.GetSshCredentialUsageScopeResult']]:
        """
        This block is used for scoping the resource to a specific set of applications or environments.
        """
        return pulumi.get(self, "usage_scopes")


class AwaitableGetSshCredentialResult(GetSshCredentialResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSshCredentialResult(
            id=self.id,
            name=self.name,
            usage_scopes=self.usage_scopes)


def get_ssh_credential(id: Optional[builtins.str] = None,
                       name: Optional[builtins.str] = None,
                       usage_scopes: Optional[Sequence[Union['GetSshCredentialUsageScopeArgs', 'GetSshCredentialUsageScopeArgsDict']]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSshCredentialResult:
    """
    Data source for retrieving an SSH credential.


    :param builtins.str id: Unique identifier of the secret manager
    :param builtins.str name: The name of the secret manager
    :param Sequence[Union['GetSshCredentialUsageScopeArgs', 'GetSshCredentialUsageScopeArgsDict']] usage_scopes: This block is used for scoping the resource to a specific set of applications or environments.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['usageScopes'] = usage_scopes
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:index/getSshCredential:getSshCredential', __args__, opts=opts, typ=GetSshCredentialResult).value

    return AwaitableGetSshCredentialResult(
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        usage_scopes=pulumi.get(__ret__, 'usage_scopes'))
def get_ssh_credential_output(id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              usage_scopes: Optional[pulumi.Input[Optional[Sequence[Union['GetSshCredentialUsageScopeArgs', 'GetSshCredentialUsageScopeArgsDict']]]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSshCredentialResult]:
    """
    Data source for retrieving an SSH credential.


    :param builtins.str id: Unique identifier of the secret manager
    :param builtins.str name: The name of the secret manager
    :param Sequence[Union['GetSshCredentialUsageScopeArgs', 'GetSshCredentialUsageScopeArgsDict']] usage_scopes: This block is used for scoping the resource to a specific set of applications or environments.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['usageScopes'] = usage_scopes
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:index/getSshCredential:getSshCredential', __args__, opts=opts, typ=GetSshCredentialResult)
    return __ret__.apply(lambda __response__: GetSshCredentialResult(
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        usage_scopes=pulumi.get(__response__, 'usage_scopes')))
