# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RuleArgs', 'Rule']

@pulumi.input_type
class RuleArgs:
    def __init__(__self__, *,
                 cloud_provider: pulumi.Input[builtins.str],
                 rules_yaml: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Rule resource.
        :param pulumi.Input[builtins.str] cloud_provider: The cloud provider for the rule. It should be either AWS, AZURE or GCP.
        :param pulumi.Input[builtins.str] rules_yaml: The policy YAML of the rule
        :param pulumi.Input[builtins.str] description: Description for rule.
        :param pulumi.Input[builtins.str] name: Name of the rule.
        """
        pulumi.set(__self__, "cloud_provider", cloud_provider)
        pulumi.set(__self__, "rules_yaml", rules_yaml)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> pulumi.Input[builtins.str]:
        """
        The cloud provider for the rule. It should be either AWS, AZURE or GCP.
        """
        return pulumi.get(self, "cloud_provider")

    @cloud_provider.setter
    def cloud_provider(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cloud_provider", value)

    @property
    @pulumi.getter(name="rulesYaml")
    def rules_yaml(self) -> pulumi.Input[builtins.str]:
        """
        The policy YAML of the rule
        """
        return pulumi.get(self, "rules_yaml")

    @rules_yaml.setter
    def rules_yaml(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "rules_yaml", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description for rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _RuleState:
    def __init__(__self__, *,
                 cloud_provider: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 rule_id: Optional[pulumi.Input[builtins.str]] = None,
                 rules_yaml: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Rule resources.
        :param pulumi.Input[builtins.str] cloud_provider: The cloud provider for the rule. It should be either AWS, AZURE or GCP.
        :param pulumi.Input[builtins.str] description: Description for rule.
        :param pulumi.Input[builtins.str] name: Name of the rule.
        :param pulumi.Input[builtins.str] rule_id: Id of the rule.
        :param pulumi.Input[builtins.str] rules_yaml: The policy YAML of the rule
        """
        if cloud_provider is not None:
            pulumi.set(__self__, "cloud_provider", cloud_provider)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if rules_yaml is not None:
            pulumi.set(__self__, "rules_yaml", rules_yaml)

    @property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The cloud provider for the rule. It should be either AWS, AZURE or GCP.
        """
        return pulumi.get(self, "cloud_provider")

    @cloud_provider.setter
    def cloud_provider(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cloud_provider", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description for rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Id of the rule.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter(name="rulesYaml")
    def rules_yaml(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The policy YAML of the rule
        """
        return pulumi.get(self, "rules_yaml")

    @rules_yaml.setter
    def rules_yaml(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rules_yaml", value)


@pulumi.type_token("harness:governance/rule:Rule")
class Rule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_provider: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 rules_yaml: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource for creating, updating, and managing rule.

        ## Import

        Import governance enforcement

        ```sh
        $ pulumi import harness:governance/rule:Rule example <rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cloud_provider: The cloud provider for the rule. It should be either AWS, AZURE or GCP.
        :param pulumi.Input[builtins.str] description: Description for rule.
        :param pulumi.Input[builtins.str] name: Name of the rule.
        :param pulumi.Input[builtins.str] rules_yaml: The policy YAML of the rule
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating, updating, and managing rule.

        ## Import

        Import governance enforcement

        ```sh
        $ pulumi import harness:governance/rule:Rule example <rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param RuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_provider: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 rules_yaml: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleArgs.__new__(RuleArgs)

            if cloud_provider is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_provider'")
            __props__.__dict__["cloud_provider"] = cloud_provider
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if rules_yaml is None and not opts.urn:
                raise TypeError("Missing required property 'rules_yaml'")
            __props__.__dict__["rules_yaml"] = rules_yaml
            __props__.__dict__["rule_id"] = None
        super(Rule, __self__).__init__(
            'harness:governance/rule:Rule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloud_provider: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            rule_id: Optional[pulumi.Input[builtins.str]] = None,
            rules_yaml: Optional[pulumi.Input[builtins.str]] = None) -> 'Rule':
        """
        Get an existing Rule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cloud_provider: The cloud provider for the rule. It should be either AWS, AZURE or GCP.
        :param pulumi.Input[builtins.str] description: Description for rule.
        :param pulumi.Input[builtins.str] name: Name of the rule.
        :param pulumi.Input[builtins.str] rule_id: Id of the rule.
        :param pulumi.Input[builtins.str] rules_yaml: The policy YAML of the rule
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuleState.__new__(_RuleState)

        __props__.__dict__["cloud_provider"] = cloud_provider
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["rule_id"] = rule_id
        __props__.__dict__["rules_yaml"] = rules_yaml
        return Rule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> pulumi.Output[builtins.str]:
        """
        The cloud provider for the rule. It should be either AWS, AZURE or GCP.
        """
        return pulumi.get(self, "cloud_provider")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description for rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Output[builtins.str]:
        """
        Id of the rule.
        """
        return pulumi.get(self, "rule_id")

    @property
    @pulumi.getter(name="rulesYaml")
    def rules_yaml(self) -> pulumi.Output[builtins.str]:
        """
        The policy YAML of the rule
        """
        return pulumi.get(self, "rules_yaml")

