# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InfrastructureDefinitionArgs', 'InfrastructureDefinition']

@pulumi.input_type
class InfrastructureDefinitionArgs:
    def __init__(__self__, *,
                 app_id: pulumi.Input[builtins.str],
                 cloud_provider_type: pulumi.Input[builtins.str],
                 deployment_type: pulumi.Input[builtins.str],
                 env_id: pulumi.Input[builtins.str],
                 aws_ami: Optional[pulumi.Input['InfrastructureDefinitionAwsAmiArgs']] = None,
                 aws_ecs: Optional[pulumi.Input['InfrastructureDefinitionAwsEcsArgs']] = None,
                 aws_lambda: Optional[pulumi.Input['InfrastructureDefinitionAwsLambdaArgs']] = None,
                 aws_ssh: Optional[pulumi.Input['InfrastructureDefinitionAwsSshArgs']] = None,
                 aws_winrm: Optional[pulumi.Input['InfrastructureDefinitionAwsWinrmArgs']] = None,
                 azure_vmss: Optional[pulumi.Input['InfrastructureDefinitionAzureVmssArgs']] = None,
                 azure_webapp: Optional[pulumi.Input['InfrastructureDefinitionAzureWebappArgs']] = None,
                 custom: Optional[pulumi.Input['InfrastructureDefinitionCustomArgs']] = None,
                 datacenter_ssh: Optional[pulumi.Input['InfrastructureDefinitionDatacenterSshArgs']] = None,
                 datacenter_winrm: Optional[pulumi.Input['InfrastructureDefinitionDatacenterWinrmArgs']] = None,
                 deployment_template_uri: Optional[pulumi.Input[builtins.str]] = None,
                 kubernetes: Optional[pulumi.Input['InfrastructureDefinitionKubernetesArgs']] = None,
                 kubernetes_gcp: Optional[pulumi.Input['InfrastructureDefinitionKubernetesGcpArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 provisioner_name: Optional[pulumi.Input[builtins.str]] = None,
                 scoped_services: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tanzu: Optional[pulumi.Input['InfrastructureDefinitionTanzuArgs']] = None):
        """
        The set of arguments for constructing a InfrastructureDefinition resource.
        :param pulumi.Input[builtins.str] app_id: The id of the application the infrastructure definition belongs to.
        :param pulumi.Input[builtins.str] cloud_provider_type: The type of the cloud provider to connect with. Valid options are AWS, AZURE, CUSTOM, PHYSICAL*DATA*CENTER, KUBERNETES*CLUSTER, PCF, SPOT*INST
        :param pulumi.Input[builtins.str] deployment_type: The type of the deployment to use. Valid options are AMI, AWS*CODEDEPLOY, AWS*LAMBDA, AZURE*VMSS, AZURE*WEBAPP, CUSTOM, ECS, HELM, KUBERNETES, PCF, SSH, WINRM
        :param pulumi.Input[builtins.str] env_id: The id of the environment the infrastructure definition belongs to.
        :param pulumi.Input['InfrastructureDefinitionAwsAmiArgs'] aws_ami: The configuration details for Aws AMI deployments.
        :param pulumi.Input['InfrastructureDefinitionAwsEcsArgs'] aws_ecs: The configuration details for Aws AMI deployments.
        :param pulumi.Input['InfrastructureDefinitionAwsLambdaArgs'] aws_lambda: The configuration details for Aws Lambda deployments.
        :param pulumi.Input['InfrastructureDefinitionAwsSshArgs'] aws_ssh: The configuration details for AWS SSH deployments.
        :param pulumi.Input['InfrastructureDefinitionAwsWinrmArgs'] aws_winrm: The configuration details for AWS WinRM deployments.
        :param pulumi.Input['InfrastructureDefinitionAzureVmssArgs'] azure_vmss: The configuration details for Azure VMSS deployments.
        :param pulumi.Input['InfrastructureDefinitionAzureWebappArgs'] azure_webapp: The configuration details for Azure WebApp deployments.
        :param pulumi.Input['InfrastructureDefinitionCustomArgs'] custom: The configuration details for Custom deployments.
        :param pulumi.Input['InfrastructureDefinitionDatacenterSshArgs'] datacenter_ssh: The configuration details for SSH datacenter deployments.
        :param pulumi.Input['InfrastructureDefinitionDatacenterWinrmArgs'] datacenter_winrm: The configuration details for WinRM datacenter deployments.
        :param pulumi.Input[builtins.str] deployment_template_uri: The URI of the deployment template to use. Only used if deployment_type is `CUSTOM`.
        :param pulumi.Input['InfrastructureDefinitionKubernetesArgs'] kubernetes: The configuration details for Kubernetes deployments.
        :param pulumi.Input['InfrastructureDefinitionKubernetesGcpArgs'] kubernetes_gcp: The configuration details for Kubernetes on GCP deployments.
        :param pulumi.Input[builtins.str] name: The name of the infrastructure definition
        :param pulumi.Input[builtins.str] provisioner_name: The name of the infrastructure provisioner to use.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] scoped_services: The list of service names to scope this infrastructure definition to.
        :param pulumi.Input['InfrastructureDefinitionTanzuArgs'] tanzu: The configuration details for PCF deployments.
        """
        pulumi.set(__self__, "app_id", app_id)
        pulumi.set(__self__, "cloud_provider_type", cloud_provider_type)
        pulumi.set(__self__, "deployment_type", deployment_type)
        pulumi.set(__self__, "env_id", env_id)
        if aws_ami is not None:
            pulumi.set(__self__, "aws_ami", aws_ami)
        if aws_ecs is not None:
            pulumi.set(__self__, "aws_ecs", aws_ecs)
        if aws_lambda is not None:
            pulumi.set(__self__, "aws_lambda", aws_lambda)
        if aws_ssh is not None:
            pulumi.set(__self__, "aws_ssh", aws_ssh)
        if aws_winrm is not None:
            pulumi.set(__self__, "aws_winrm", aws_winrm)
        if azure_vmss is not None:
            pulumi.set(__self__, "azure_vmss", azure_vmss)
        if azure_webapp is not None:
            pulumi.set(__self__, "azure_webapp", azure_webapp)
        if custom is not None:
            pulumi.set(__self__, "custom", custom)
        if datacenter_ssh is not None:
            pulumi.set(__self__, "datacenter_ssh", datacenter_ssh)
        if datacenter_winrm is not None:
            pulumi.set(__self__, "datacenter_winrm", datacenter_winrm)
        if deployment_template_uri is not None:
            pulumi.set(__self__, "deployment_template_uri", deployment_template_uri)
        if kubernetes is not None:
            pulumi.set(__self__, "kubernetes", kubernetes)
        if kubernetes_gcp is not None:
            pulumi.set(__self__, "kubernetes_gcp", kubernetes_gcp)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provisioner_name is not None:
            pulumi.set(__self__, "provisioner_name", provisioner_name)
        if scoped_services is not None:
            pulumi.set(__self__, "scoped_services", scoped_services)
        if tanzu is not None:
            pulumi.set(__self__, "tanzu", tanzu)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Input[builtins.str]:
        """
        The id of the application the infrastructure definition belongs to.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="cloudProviderType")
    def cloud_provider_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of the cloud provider to connect with. Valid options are AWS, AZURE, CUSTOM, PHYSICAL*DATA*CENTER, KUBERNETES*CLUSTER, PCF, SPOT*INST
        """
        return pulumi.get(self, "cloud_provider_type")

    @cloud_provider_type.setter
    def cloud_provider_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cloud_provider_type", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of the deployment to use. Valid options are AMI, AWS*CODEDEPLOY, AWS*LAMBDA, AZURE*VMSS, AZURE*WEBAPP, CUSTOM, ECS, HELM, KUBERNETES, PCF, SSH, WINRM
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter(name="envId")
    def env_id(self) -> pulumi.Input[builtins.str]:
        """
        The id of the environment the infrastructure definition belongs to.
        """
        return pulumi.get(self, "env_id")

    @env_id.setter
    def env_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "env_id", value)

    @property
    @pulumi.getter(name="awsAmi")
    def aws_ami(self) -> Optional[pulumi.Input['InfrastructureDefinitionAwsAmiArgs']]:
        """
        The configuration details for Aws AMI deployments.
        """
        return pulumi.get(self, "aws_ami")

    @aws_ami.setter
    def aws_ami(self, value: Optional[pulumi.Input['InfrastructureDefinitionAwsAmiArgs']]):
        pulumi.set(self, "aws_ami", value)

    @property
    @pulumi.getter(name="awsEcs")
    def aws_ecs(self) -> Optional[pulumi.Input['InfrastructureDefinitionAwsEcsArgs']]:
        """
        The configuration details for Aws AMI deployments.
        """
        return pulumi.get(self, "aws_ecs")

    @aws_ecs.setter
    def aws_ecs(self, value: Optional[pulumi.Input['InfrastructureDefinitionAwsEcsArgs']]):
        pulumi.set(self, "aws_ecs", value)

    @property
    @pulumi.getter(name="awsLambda")
    def aws_lambda(self) -> Optional[pulumi.Input['InfrastructureDefinitionAwsLambdaArgs']]:
        """
        The configuration details for Aws Lambda deployments.
        """
        return pulumi.get(self, "aws_lambda")

    @aws_lambda.setter
    def aws_lambda(self, value: Optional[pulumi.Input['InfrastructureDefinitionAwsLambdaArgs']]):
        pulumi.set(self, "aws_lambda", value)

    @property
    @pulumi.getter(name="awsSsh")
    def aws_ssh(self) -> Optional[pulumi.Input['InfrastructureDefinitionAwsSshArgs']]:
        """
        The configuration details for AWS SSH deployments.
        """
        return pulumi.get(self, "aws_ssh")

    @aws_ssh.setter
    def aws_ssh(self, value: Optional[pulumi.Input['InfrastructureDefinitionAwsSshArgs']]):
        pulumi.set(self, "aws_ssh", value)

    @property
    @pulumi.getter(name="awsWinrm")
    def aws_winrm(self) -> Optional[pulumi.Input['InfrastructureDefinitionAwsWinrmArgs']]:
        """
        The configuration details for AWS WinRM deployments.
        """
        return pulumi.get(self, "aws_winrm")

    @aws_winrm.setter
    def aws_winrm(self, value: Optional[pulumi.Input['InfrastructureDefinitionAwsWinrmArgs']]):
        pulumi.set(self, "aws_winrm", value)

    @property
    @pulumi.getter(name="azureVmss")
    def azure_vmss(self) -> Optional[pulumi.Input['InfrastructureDefinitionAzureVmssArgs']]:
        """
        The configuration details for Azure VMSS deployments.
        """
        return pulumi.get(self, "azure_vmss")

    @azure_vmss.setter
    def azure_vmss(self, value: Optional[pulumi.Input['InfrastructureDefinitionAzureVmssArgs']]):
        pulumi.set(self, "azure_vmss", value)

    @property
    @pulumi.getter(name="azureWebapp")
    def azure_webapp(self) -> Optional[pulumi.Input['InfrastructureDefinitionAzureWebappArgs']]:
        """
        The configuration details for Azure WebApp deployments.
        """
        return pulumi.get(self, "azure_webapp")

    @azure_webapp.setter
    def azure_webapp(self, value: Optional[pulumi.Input['InfrastructureDefinitionAzureWebappArgs']]):
        pulumi.set(self, "azure_webapp", value)

    @property
    @pulumi.getter
    def custom(self) -> Optional[pulumi.Input['InfrastructureDefinitionCustomArgs']]:
        """
        The configuration details for Custom deployments.
        """
        return pulumi.get(self, "custom")

    @custom.setter
    def custom(self, value: Optional[pulumi.Input['InfrastructureDefinitionCustomArgs']]):
        pulumi.set(self, "custom", value)

    @property
    @pulumi.getter(name="datacenterSsh")
    def datacenter_ssh(self) -> Optional[pulumi.Input['InfrastructureDefinitionDatacenterSshArgs']]:
        """
        The configuration details for SSH datacenter deployments.
        """
        return pulumi.get(self, "datacenter_ssh")

    @datacenter_ssh.setter
    def datacenter_ssh(self, value: Optional[pulumi.Input['InfrastructureDefinitionDatacenterSshArgs']]):
        pulumi.set(self, "datacenter_ssh", value)

    @property
    @pulumi.getter(name="datacenterWinrm")
    def datacenter_winrm(self) -> Optional[pulumi.Input['InfrastructureDefinitionDatacenterWinrmArgs']]:
        """
        The configuration details for WinRM datacenter deployments.
        """
        return pulumi.get(self, "datacenter_winrm")

    @datacenter_winrm.setter
    def datacenter_winrm(self, value: Optional[pulumi.Input['InfrastructureDefinitionDatacenterWinrmArgs']]):
        pulumi.set(self, "datacenter_winrm", value)

    @property
    @pulumi.getter(name="deploymentTemplateUri")
    def deployment_template_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI of the deployment template to use. Only used if deployment_type is `CUSTOM`.
        """
        return pulumi.get(self, "deployment_template_uri")

    @deployment_template_uri.setter
    def deployment_template_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deployment_template_uri", value)

    @property
    @pulumi.getter
    def kubernetes(self) -> Optional[pulumi.Input['InfrastructureDefinitionKubernetesArgs']]:
        """
        The configuration details for Kubernetes deployments.
        """
        return pulumi.get(self, "kubernetes")

    @kubernetes.setter
    def kubernetes(self, value: Optional[pulumi.Input['InfrastructureDefinitionKubernetesArgs']]):
        pulumi.set(self, "kubernetes", value)

    @property
    @pulumi.getter(name="kubernetesGcp")
    def kubernetes_gcp(self) -> Optional[pulumi.Input['InfrastructureDefinitionKubernetesGcpArgs']]:
        """
        The configuration details for Kubernetes on GCP deployments.
        """
        return pulumi.get(self, "kubernetes_gcp")

    @kubernetes_gcp.setter
    def kubernetes_gcp(self, value: Optional[pulumi.Input['InfrastructureDefinitionKubernetesGcpArgs']]):
        pulumi.set(self, "kubernetes_gcp", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the infrastructure definition
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="provisionerName")
    def provisioner_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the infrastructure provisioner to use.
        """
        return pulumi.get(self, "provisioner_name")

    @provisioner_name.setter
    def provisioner_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "provisioner_name", value)

    @property
    @pulumi.getter(name="scopedServices")
    def scoped_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of service names to scope this infrastructure definition to.
        """
        return pulumi.get(self, "scoped_services")

    @scoped_services.setter
    def scoped_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "scoped_services", value)

    @property
    @pulumi.getter
    def tanzu(self) -> Optional[pulumi.Input['InfrastructureDefinitionTanzuArgs']]:
        """
        The configuration details for PCF deployments.
        """
        return pulumi.get(self, "tanzu")

    @tanzu.setter
    def tanzu(self, value: Optional[pulumi.Input['InfrastructureDefinitionTanzuArgs']]):
        pulumi.set(self, "tanzu", value)


@pulumi.input_type
class _InfrastructureDefinitionState:
    def __init__(__self__, *,
                 app_id: Optional[pulumi.Input[builtins.str]] = None,
                 aws_ami: Optional[pulumi.Input['InfrastructureDefinitionAwsAmiArgs']] = None,
                 aws_ecs: Optional[pulumi.Input['InfrastructureDefinitionAwsEcsArgs']] = None,
                 aws_lambda: Optional[pulumi.Input['InfrastructureDefinitionAwsLambdaArgs']] = None,
                 aws_ssh: Optional[pulumi.Input['InfrastructureDefinitionAwsSshArgs']] = None,
                 aws_winrm: Optional[pulumi.Input['InfrastructureDefinitionAwsWinrmArgs']] = None,
                 azure_vmss: Optional[pulumi.Input['InfrastructureDefinitionAzureVmssArgs']] = None,
                 azure_webapp: Optional[pulumi.Input['InfrastructureDefinitionAzureWebappArgs']] = None,
                 cloud_provider_type: Optional[pulumi.Input[builtins.str]] = None,
                 custom: Optional[pulumi.Input['InfrastructureDefinitionCustomArgs']] = None,
                 datacenter_ssh: Optional[pulumi.Input['InfrastructureDefinitionDatacenterSshArgs']] = None,
                 datacenter_winrm: Optional[pulumi.Input['InfrastructureDefinitionDatacenterWinrmArgs']] = None,
                 deployment_template_uri: Optional[pulumi.Input[builtins.str]] = None,
                 deployment_type: Optional[pulumi.Input[builtins.str]] = None,
                 env_id: Optional[pulumi.Input[builtins.str]] = None,
                 kubernetes: Optional[pulumi.Input['InfrastructureDefinitionKubernetesArgs']] = None,
                 kubernetes_gcp: Optional[pulumi.Input['InfrastructureDefinitionKubernetesGcpArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 provisioner_name: Optional[pulumi.Input[builtins.str]] = None,
                 scoped_services: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tanzu: Optional[pulumi.Input['InfrastructureDefinitionTanzuArgs']] = None):
        """
        Input properties used for looking up and filtering InfrastructureDefinition resources.
        :param pulumi.Input[builtins.str] app_id: The id of the application the infrastructure definition belongs to.
        :param pulumi.Input['InfrastructureDefinitionAwsAmiArgs'] aws_ami: The configuration details for Aws AMI deployments.
        :param pulumi.Input['InfrastructureDefinitionAwsEcsArgs'] aws_ecs: The configuration details for Aws AMI deployments.
        :param pulumi.Input['InfrastructureDefinitionAwsLambdaArgs'] aws_lambda: The configuration details for Aws Lambda deployments.
        :param pulumi.Input['InfrastructureDefinitionAwsSshArgs'] aws_ssh: The configuration details for AWS SSH deployments.
        :param pulumi.Input['InfrastructureDefinitionAwsWinrmArgs'] aws_winrm: The configuration details for AWS WinRM deployments.
        :param pulumi.Input['InfrastructureDefinitionAzureVmssArgs'] azure_vmss: The configuration details for Azure VMSS deployments.
        :param pulumi.Input['InfrastructureDefinitionAzureWebappArgs'] azure_webapp: The configuration details for Azure WebApp deployments.
        :param pulumi.Input[builtins.str] cloud_provider_type: The type of the cloud provider to connect with. Valid options are AWS, AZURE, CUSTOM, PHYSICAL*DATA*CENTER, KUBERNETES*CLUSTER, PCF, SPOT*INST
        :param pulumi.Input['InfrastructureDefinitionCustomArgs'] custom: The configuration details for Custom deployments.
        :param pulumi.Input['InfrastructureDefinitionDatacenterSshArgs'] datacenter_ssh: The configuration details for SSH datacenter deployments.
        :param pulumi.Input['InfrastructureDefinitionDatacenterWinrmArgs'] datacenter_winrm: The configuration details for WinRM datacenter deployments.
        :param pulumi.Input[builtins.str] deployment_template_uri: The URI of the deployment template to use. Only used if deployment_type is `CUSTOM`.
        :param pulumi.Input[builtins.str] deployment_type: The type of the deployment to use. Valid options are AMI, AWS*CODEDEPLOY, AWS*LAMBDA, AZURE*VMSS, AZURE*WEBAPP, CUSTOM, ECS, HELM, KUBERNETES, PCF, SSH, WINRM
        :param pulumi.Input[builtins.str] env_id: The id of the environment the infrastructure definition belongs to.
        :param pulumi.Input['InfrastructureDefinitionKubernetesArgs'] kubernetes: The configuration details for Kubernetes deployments.
        :param pulumi.Input['InfrastructureDefinitionKubernetesGcpArgs'] kubernetes_gcp: The configuration details for Kubernetes on GCP deployments.
        :param pulumi.Input[builtins.str] name: The name of the infrastructure definition
        :param pulumi.Input[builtins.str] provisioner_name: The name of the infrastructure provisioner to use.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] scoped_services: The list of service names to scope this infrastructure definition to.
        :param pulumi.Input['InfrastructureDefinitionTanzuArgs'] tanzu: The configuration details for PCF deployments.
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if aws_ami is not None:
            pulumi.set(__self__, "aws_ami", aws_ami)
        if aws_ecs is not None:
            pulumi.set(__self__, "aws_ecs", aws_ecs)
        if aws_lambda is not None:
            pulumi.set(__self__, "aws_lambda", aws_lambda)
        if aws_ssh is not None:
            pulumi.set(__self__, "aws_ssh", aws_ssh)
        if aws_winrm is not None:
            pulumi.set(__self__, "aws_winrm", aws_winrm)
        if azure_vmss is not None:
            pulumi.set(__self__, "azure_vmss", azure_vmss)
        if azure_webapp is not None:
            pulumi.set(__self__, "azure_webapp", azure_webapp)
        if cloud_provider_type is not None:
            pulumi.set(__self__, "cloud_provider_type", cloud_provider_type)
        if custom is not None:
            pulumi.set(__self__, "custom", custom)
        if datacenter_ssh is not None:
            pulumi.set(__self__, "datacenter_ssh", datacenter_ssh)
        if datacenter_winrm is not None:
            pulumi.set(__self__, "datacenter_winrm", datacenter_winrm)
        if deployment_template_uri is not None:
            pulumi.set(__self__, "deployment_template_uri", deployment_template_uri)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if env_id is not None:
            pulumi.set(__self__, "env_id", env_id)
        if kubernetes is not None:
            pulumi.set(__self__, "kubernetes", kubernetes)
        if kubernetes_gcp is not None:
            pulumi.set(__self__, "kubernetes_gcp", kubernetes_gcp)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provisioner_name is not None:
            pulumi.set(__self__, "provisioner_name", provisioner_name)
        if scoped_services is not None:
            pulumi.set(__self__, "scoped_services", scoped_services)
        if tanzu is not None:
            pulumi.set(__self__, "tanzu", tanzu)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The id of the application the infrastructure definition belongs to.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="awsAmi")
    def aws_ami(self) -> Optional[pulumi.Input['InfrastructureDefinitionAwsAmiArgs']]:
        """
        The configuration details for Aws AMI deployments.
        """
        return pulumi.get(self, "aws_ami")

    @aws_ami.setter
    def aws_ami(self, value: Optional[pulumi.Input['InfrastructureDefinitionAwsAmiArgs']]):
        pulumi.set(self, "aws_ami", value)

    @property
    @pulumi.getter(name="awsEcs")
    def aws_ecs(self) -> Optional[pulumi.Input['InfrastructureDefinitionAwsEcsArgs']]:
        """
        The configuration details for Aws AMI deployments.
        """
        return pulumi.get(self, "aws_ecs")

    @aws_ecs.setter
    def aws_ecs(self, value: Optional[pulumi.Input['InfrastructureDefinitionAwsEcsArgs']]):
        pulumi.set(self, "aws_ecs", value)

    @property
    @pulumi.getter(name="awsLambda")
    def aws_lambda(self) -> Optional[pulumi.Input['InfrastructureDefinitionAwsLambdaArgs']]:
        """
        The configuration details for Aws Lambda deployments.
        """
        return pulumi.get(self, "aws_lambda")

    @aws_lambda.setter
    def aws_lambda(self, value: Optional[pulumi.Input['InfrastructureDefinitionAwsLambdaArgs']]):
        pulumi.set(self, "aws_lambda", value)

    @property
    @pulumi.getter(name="awsSsh")
    def aws_ssh(self) -> Optional[pulumi.Input['InfrastructureDefinitionAwsSshArgs']]:
        """
        The configuration details for AWS SSH deployments.
        """
        return pulumi.get(self, "aws_ssh")

    @aws_ssh.setter
    def aws_ssh(self, value: Optional[pulumi.Input['InfrastructureDefinitionAwsSshArgs']]):
        pulumi.set(self, "aws_ssh", value)

    @property
    @pulumi.getter(name="awsWinrm")
    def aws_winrm(self) -> Optional[pulumi.Input['InfrastructureDefinitionAwsWinrmArgs']]:
        """
        The configuration details for AWS WinRM deployments.
        """
        return pulumi.get(self, "aws_winrm")

    @aws_winrm.setter
    def aws_winrm(self, value: Optional[pulumi.Input['InfrastructureDefinitionAwsWinrmArgs']]):
        pulumi.set(self, "aws_winrm", value)

    @property
    @pulumi.getter(name="azureVmss")
    def azure_vmss(self) -> Optional[pulumi.Input['InfrastructureDefinitionAzureVmssArgs']]:
        """
        The configuration details for Azure VMSS deployments.
        """
        return pulumi.get(self, "azure_vmss")

    @azure_vmss.setter
    def azure_vmss(self, value: Optional[pulumi.Input['InfrastructureDefinitionAzureVmssArgs']]):
        pulumi.set(self, "azure_vmss", value)

    @property
    @pulumi.getter(name="azureWebapp")
    def azure_webapp(self) -> Optional[pulumi.Input['InfrastructureDefinitionAzureWebappArgs']]:
        """
        The configuration details for Azure WebApp deployments.
        """
        return pulumi.get(self, "azure_webapp")

    @azure_webapp.setter
    def azure_webapp(self, value: Optional[pulumi.Input['InfrastructureDefinitionAzureWebappArgs']]):
        pulumi.set(self, "azure_webapp", value)

    @property
    @pulumi.getter(name="cloudProviderType")
    def cloud_provider_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the cloud provider to connect with. Valid options are AWS, AZURE, CUSTOM, PHYSICAL*DATA*CENTER, KUBERNETES*CLUSTER, PCF, SPOT*INST
        """
        return pulumi.get(self, "cloud_provider_type")

    @cloud_provider_type.setter
    def cloud_provider_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cloud_provider_type", value)

    @property
    @pulumi.getter
    def custom(self) -> Optional[pulumi.Input['InfrastructureDefinitionCustomArgs']]:
        """
        The configuration details for Custom deployments.
        """
        return pulumi.get(self, "custom")

    @custom.setter
    def custom(self, value: Optional[pulumi.Input['InfrastructureDefinitionCustomArgs']]):
        pulumi.set(self, "custom", value)

    @property
    @pulumi.getter(name="datacenterSsh")
    def datacenter_ssh(self) -> Optional[pulumi.Input['InfrastructureDefinitionDatacenterSshArgs']]:
        """
        The configuration details for SSH datacenter deployments.
        """
        return pulumi.get(self, "datacenter_ssh")

    @datacenter_ssh.setter
    def datacenter_ssh(self, value: Optional[pulumi.Input['InfrastructureDefinitionDatacenterSshArgs']]):
        pulumi.set(self, "datacenter_ssh", value)

    @property
    @pulumi.getter(name="datacenterWinrm")
    def datacenter_winrm(self) -> Optional[pulumi.Input['InfrastructureDefinitionDatacenterWinrmArgs']]:
        """
        The configuration details for WinRM datacenter deployments.
        """
        return pulumi.get(self, "datacenter_winrm")

    @datacenter_winrm.setter
    def datacenter_winrm(self, value: Optional[pulumi.Input['InfrastructureDefinitionDatacenterWinrmArgs']]):
        pulumi.set(self, "datacenter_winrm", value)

    @property
    @pulumi.getter(name="deploymentTemplateUri")
    def deployment_template_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI of the deployment template to use. Only used if deployment_type is `CUSTOM`.
        """
        return pulumi.get(self, "deployment_template_uri")

    @deployment_template_uri.setter
    def deployment_template_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deployment_template_uri", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the deployment to use. Valid options are AMI, AWS*CODEDEPLOY, AWS*LAMBDA, AZURE*VMSS, AZURE*WEBAPP, CUSTOM, ECS, HELM, KUBERNETES, PCF, SSH, WINRM
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter(name="envId")
    def env_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The id of the environment the infrastructure definition belongs to.
        """
        return pulumi.get(self, "env_id")

    @env_id.setter
    def env_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "env_id", value)

    @property
    @pulumi.getter
    def kubernetes(self) -> Optional[pulumi.Input['InfrastructureDefinitionKubernetesArgs']]:
        """
        The configuration details for Kubernetes deployments.
        """
        return pulumi.get(self, "kubernetes")

    @kubernetes.setter
    def kubernetes(self, value: Optional[pulumi.Input['InfrastructureDefinitionKubernetesArgs']]):
        pulumi.set(self, "kubernetes", value)

    @property
    @pulumi.getter(name="kubernetesGcp")
    def kubernetes_gcp(self) -> Optional[pulumi.Input['InfrastructureDefinitionKubernetesGcpArgs']]:
        """
        The configuration details for Kubernetes on GCP deployments.
        """
        return pulumi.get(self, "kubernetes_gcp")

    @kubernetes_gcp.setter
    def kubernetes_gcp(self, value: Optional[pulumi.Input['InfrastructureDefinitionKubernetesGcpArgs']]):
        pulumi.set(self, "kubernetes_gcp", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the infrastructure definition
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="provisionerName")
    def provisioner_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the infrastructure provisioner to use.
        """
        return pulumi.get(self, "provisioner_name")

    @provisioner_name.setter
    def provisioner_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "provisioner_name", value)

    @property
    @pulumi.getter(name="scopedServices")
    def scoped_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of service names to scope this infrastructure definition to.
        """
        return pulumi.get(self, "scoped_services")

    @scoped_services.setter
    def scoped_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "scoped_services", value)

    @property
    @pulumi.getter
    def tanzu(self) -> Optional[pulumi.Input['InfrastructureDefinitionTanzuArgs']]:
        """
        The configuration details for PCF deployments.
        """
        return pulumi.get(self, "tanzu")

    @tanzu.setter
    def tanzu(self, value: Optional[pulumi.Input['InfrastructureDefinitionTanzuArgs']]):
        pulumi.set(self, "tanzu", value)


@pulumi.type_token("harness:index/infrastructureDefinition:InfrastructureDefinition")
class InfrastructureDefinition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[builtins.str]] = None,
                 aws_ami: Optional[pulumi.Input[Union['InfrastructureDefinitionAwsAmiArgs', 'InfrastructureDefinitionAwsAmiArgsDict']]] = None,
                 aws_ecs: Optional[pulumi.Input[Union['InfrastructureDefinitionAwsEcsArgs', 'InfrastructureDefinitionAwsEcsArgsDict']]] = None,
                 aws_lambda: Optional[pulumi.Input[Union['InfrastructureDefinitionAwsLambdaArgs', 'InfrastructureDefinitionAwsLambdaArgsDict']]] = None,
                 aws_ssh: Optional[pulumi.Input[Union['InfrastructureDefinitionAwsSshArgs', 'InfrastructureDefinitionAwsSshArgsDict']]] = None,
                 aws_winrm: Optional[pulumi.Input[Union['InfrastructureDefinitionAwsWinrmArgs', 'InfrastructureDefinitionAwsWinrmArgsDict']]] = None,
                 azure_vmss: Optional[pulumi.Input[Union['InfrastructureDefinitionAzureVmssArgs', 'InfrastructureDefinitionAzureVmssArgsDict']]] = None,
                 azure_webapp: Optional[pulumi.Input[Union['InfrastructureDefinitionAzureWebappArgs', 'InfrastructureDefinitionAzureWebappArgsDict']]] = None,
                 cloud_provider_type: Optional[pulumi.Input[builtins.str]] = None,
                 custom: Optional[pulumi.Input[Union['InfrastructureDefinitionCustomArgs', 'InfrastructureDefinitionCustomArgsDict']]] = None,
                 datacenter_ssh: Optional[pulumi.Input[Union['InfrastructureDefinitionDatacenterSshArgs', 'InfrastructureDefinitionDatacenterSshArgsDict']]] = None,
                 datacenter_winrm: Optional[pulumi.Input[Union['InfrastructureDefinitionDatacenterWinrmArgs', 'InfrastructureDefinitionDatacenterWinrmArgsDict']]] = None,
                 deployment_template_uri: Optional[pulumi.Input[builtins.str]] = None,
                 deployment_type: Optional[pulumi.Input[builtins.str]] = None,
                 env_id: Optional[pulumi.Input[builtins.str]] = None,
                 kubernetes: Optional[pulumi.Input[Union['InfrastructureDefinitionKubernetesArgs', 'InfrastructureDefinitionKubernetesArgsDict']]] = None,
                 kubernetes_gcp: Optional[pulumi.Input[Union['InfrastructureDefinitionKubernetesGcpArgs', 'InfrastructureDefinitionKubernetesGcpArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 provisioner_name: Optional[pulumi.Input[builtins.str]] = None,
                 scoped_services: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tanzu: Optional[pulumi.Input[Union['InfrastructureDefinitionTanzuArgs', 'InfrastructureDefinitionTanzuArgsDict']]] = None,
                 __props__=None):
        """
        Resource for creating am infrastructure definition. This resource uses the config-as-code API's. When updating the `name` or `path` of this resource you should typically also set the `create_before_destroy = true` lifecycle setting.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        # Creating a Kubernetes infrastructure definition
        dev = harness.cloudprovider.Kubernetes("dev",
            name="k8s-dev",
            authentication={
                "delegate_selectors": ["k8s"],
            })
        example = harness.Application("example", name="example")
        dev_environment = harness.Environment("dev",
            name="dev",
            app_id=example.id,
            type="NON_PROD")
        # Creating a infrastructure of type KUBERNETES
        k8s = harness.InfrastructureDefinition("k8s",
            name="k8s-eks-us-east-1",
            app_id=example.id,
            env_id=dev_environment.id,
            cloud_provider_type="KUBERNETES_CLUSTER",
            deployment_type="KUBERNETES",
            kubernetes={
                "cloud_provider_name": dev.name,
                "namespace": "dev",
                "release_name": "${service.name}",
            })
        # Creating a Deployment Template for CUSTOM infrastructure type
        example_yaml = harness.YamlConfig("example_yaml",
            path="Setup/Template Library/Example Folder/deployment_template.yaml",
            content=\"\"\"harnessApiVersion: '1.0'
        type: CUSTOM_DEPLOYMENT_TYPE
        fetchInstanceScript: |-
          set -ex
          curl http://${url}/${file_name} > ${INSTANCE_OUTPUT_PATH}
        hostAttributes:
          hostname: host
        hostObjectArrayPath: hosts
        variables:
        - name: url
        - name: file_name
        \"\"\")
        # Creating a infrastructure of type CUSTOM
        custom = harness.InfrastructureDefinition("custom",
            name="custom-infra",
            app_id=example.id,
            env_id=dev_environment.id,
            cloud_provider_type="CUSTOM",
            deployment_type="CUSTOM",
            deployment_template_uri=example_yaml.name.apply(lambda name: f"Example Folder/{name}"),
            custom={
                "deployment_type_template_version": "1",
                "variables": [
                    {
                        "name": "url",
                        "value": "localhost:8081",
                    },
                    {
                        "name": "file_name",
                        "value": "instances.json",
                    },
                ],
            })
        ```

        ## Import

        Import using the Harness application id, environment id, and infrastructure definition id

        ```sh
        $ pulumi import harness:index/infrastructureDefinition:InfrastructureDefinition example <app_id>/<env_id>/<infradef_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] app_id: The id of the application the infrastructure definition belongs to.
        :param pulumi.Input[Union['InfrastructureDefinitionAwsAmiArgs', 'InfrastructureDefinitionAwsAmiArgsDict']] aws_ami: The configuration details for Aws AMI deployments.
        :param pulumi.Input[Union['InfrastructureDefinitionAwsEcsArgs', 'InfrastructureDefinitionAwsEcsArgsDict']] aws_ecs: The configuration details for Aws AMI deployments.
        :param pulumi.Input[Union['InfrastructureDefinitionAwsLambdaArgs', 'InfrastructureDefinitionAwsLambdaArgsDict']] aws_lambda: The configuration details for Aws Lambda deployments.
        :param pulumi.Input[Union['InfrastructureDefinitionAwsSshArgs', 'InfrastructureDefinitionAwsSshArgsDict']] aws_ssh: The configuration details for AWS SSH deployments.
        :param pulumi.Input[Union['InfrastructureDefinitionAwsWinrmArgs', 'InfrastructureDefinitionAwsWinrmArgsDict']] aws_winrm: The configuration details for AWS WinRM deployments.
        :param pulumi.Input[Union['InfrastructureDefinitionAzureVmssArgs', 'InfrastructureDefinitionAzureVmssArgsDict']] azure_vmss: The configuration details for Azure VMSS deployments.
        :param pulumi.Input[Union['InfrastructureDefinitionAzureWebappArgs', 'InfrastructureDefinitionAzureWebappArgsDict']] azure_webapp: The configuration details for Azure WebApp deployments.
        :param pulumi.Input[builtins.str] cloud_provider_type: The type of the cloud provider to connect with. Valid options are AWS, AZURE, CUSTOM, PHYSICAL*DATA*CENTER, KUBERNETES*CLUSTER, PCF, SPOT*INST
        :param pulumi.Input[Union['InfrastructureDefinitionCustomArgs', 'InfrastructureDefinitionCustomArgsDict']] custom: The configuration details for Custom deployments.
        :param pulumi.Input[Union['InfrastructureDefinitionDatacenterSshArgs', 'InfrastructureDefinitionDatacenterSshArgsDict']] datacenter_ssh: The configuration details for SSH datacenter deployments.
        :param pulumi.Input[Union['InfrastructureDefinitionDatacenterWinrmArgs', 'InfrastructureDefinitionDatacenterWinrmArgsDict']] datacenter_winrm: The configuration details for WinRM datacenter deployments.
        :param pulumi.Input[builtins.str] deployment_template_uri: The URI of the deployment template to use. Only used if deployment_type is `CUSTOM`.
        :param pulumi.Input[builtins.str] deployment_type: The type of the deployment to use. Valid options are AMI, AWS*CODEDEPLOY, AWS*LAMBDA, AZURE*VMSS, AZURE*WEBAPP, CUSTOM, ECS, HELM, KUBERNETES, PCF, SSH, WINRM
        :param pulumi.Input[builtins.str] env_id: The id of the environment the infrastructure definition belongs to.
        :param pulumi.Input[Union['InfrastructureDefinitionKubernetesArgs', 'InfrastructureDefinitionKubernetesArgsDict']] kubernetes: The configuration details for Kubernetes deployments.
        :param pulumi.Input[Union['InfrastructureDefinitionKubernetesGcpArgs', 'InfrastructureDefinitionKubernetesGcpArgsDict']] kubernetes_gcp: The configuration details for Kubernetes on GCP deployments.
        :param pulumi.Input[builtins.str] name: The name of the infrastructure definition
        :param pulumi.Input[builtins.str] provisioner_name: The name of the infrastructure provisioner to use.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] scoped_services: The list of service names to scope this infrastructure definition to.
        :param pulumi.Input[Union['InfrastructureDefinitionTanzuArgs', 'InfrastructureDefinitionTanzuArgsDict']] tanzu: The configuration details for PCF deployments.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InfrastructureDefinitionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating am infrastructure definition. This resource uses the config-as-code API's. When updating the `name` or `path` of this resource you should typically also set the `create_before_destroy = true` lifecycle setting.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        # Creating a Kubernetes infrastructure definition
        dev = harness.cloudprovider.Kubernetes("dev",
            name="k8s-dev",
            authentication={
                "delegate_selectors": ["k8s"],
            })
        example = harness.Application("example", name="example")
        dev_environment = harness.Environment("dev",
            name="dev",
            app_id=example.id,
            type="NON_PROD")
        # Creating a infrastructure of type KUBERNETES
        k8s = harness.InfrastructureDefinition("k8s",
            name="k8s-eks-us-east-1",
            app_id=example.id,
            env_id=dev_environment.id,
            cloud_provider_type="KUBERNETES_CLUSTER",
            deployment_type="KUBERNETES",
            kubernetes={
                "cloud_provider_name": dev.name,
                "namespace": "dev",
                "release_name": "${service.name}",
            })
        # Creating a Deployment Template for CUSTOM infrastructure type
        example_yaml = harness.YamlConfig("example_yaml",
            path="Setup/Template Library/Example Folder/deployment_template.yaml",
            content=\"\"\"harnessApiVersion: '1.0'
        type: CUSTOM_DEPLOYMENT_TYPE
        fetchInstanceScript: |-
          set -ex
          curl http://${url}/${file_name} > ${INSTANCE_OUTPUT_PATH}
        hostAttributes:
          hostname: host
        hostObjectArrayPath: hosts
        variables:
        - name: url
        - name: file_name
        \"\"\")
        # Creating a infrastructure of type CUSTOM
        custom = harness.InfrastructureDefinition("custom",
            name="custom-infra",
            app_id=example.id,
            env_id=dev_environment.id,
            cloud_provider_type="CUSTOM",
            deployment_type="CUSTOM",
            deployment_template_uri=example_yaml.name.apply(lambda name: f"Example Folder/{name}"),
            custom={
                "deployment_type_template_version": "1",
                "variables": [
                    {
                        "name": "url",
                        "value": "localhost:8081",
                    },
                    {
                        "name": "file_name",
                        "value": "instances.json",
                    },
                ],
            })
        ```

        ## Import

        Import using the Harness application id, environment id, and infrastructure definition id

        ```sh
        $ pulumi import harness:index/infrastructureDefinition:InfrastructureDefinition example <app_id>/<env_id>/<infradef_id>
        ```

        :param str resource_name: The name of the resource.
        :param InfrastructureDefinitionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InfrastructureDefinitionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[builtins.str]] = None,
                 aws_ami: Optional[pulumi.Input[Union['InfrastructureDefinitionAwsAmiArgs', 'InfrastructureDefinitionAwsAmiArgsDict']]] = None,
                 aws_ecs: Optional[pulumi.Input[Union['InfrastructureDefinitionAwsEcsArgs', 'InfrastructureDefinitionAwsEcsArgsDict']]] = None,
                 aws_lambda: Optional[pulumi.Input[Union['InfrastructureDefinitionAwsLambdaArgs', 'InfrastructureDefinitionAwsLambdaArgsDict']]] = None,
                 aws_ssh: Optional[pulumi.Input[Union['InfrastructureDefinitionAwsSshArgs', 'InfrastructureDefinitionAwsSshArgsDict']]] = None,
                 aws_winrm: Optional[pulumi.Input[Union['InfrastructureDefinitionAwsWinrmArgs', 'InfrastructureDefinitionAwsWinrmArgsDict']]] = None,
                 azure_vmss: Optional[pulumi.Input[Union['InfrastructureDefinitionAzureVmssArgs', 'InfrastructureDefinitionAzureVmssArgsDict']]] = None,
                 azure_webapp: Optional[pulumi.Input[Union['InfrastructureDefinitionAzureWebappArgs', 'InfrastructureDefinitionAzureWebappArgsDict']]] = None,
                 cloud_provider_type: Optional[pulumi.Input[builtins.str]] = None,
                 custom: Optional[pulumi.Input[Union['InfrastructureDefinitionCustomArgs', 'InfrastructureDefinitionCustomArgsDict']]] = None,
                 datacenter_ssh: Optional[pulumi.Input[Union['InfrastructureDefinitionDatacenterSshArgs', 'InfrastructureDefinitionDatacenterSshArgsDict']]] = None,
                 datacenter_winrm: Optional[pulumi.Input[Union['InfrastructureDefinitionDatacenterWinrmArgs', 'InfrastructureDefinitionDatacenterWinrmArgsDict']]] = None,
                 deployment_template_uri: Optional[pulumi.Input[builtins.str]] = None,
                 deployment_type: Optional[pulumi.Input[builtins.str]] = None,
                 env_id: Optional[pulumi.Input[builtins.str]] = None,
                 kubernetes: Optional[pulumi.Input[Union['InfrastructureDefinitionKubernetesArgs', 'InfrastructureDefinitionKubernetesArgsDict']]] = None,
                 kubernetes_gcp: Optional[pulumi.Input[Union['InfrastructureDefinitionKubernetesGcpArgs', 'InfrastructureDefinitionKubernetesGcpArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 provisioner_name: Optional[pulumi.Input[builtins.str]] = None,
                 scoped_services: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tanzu: Optional[pulumi.Input[Union['InfrastructureDefinitionTanzuArgs', 'InfrastructureDefinitionTanzuArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InfrastructureDefinitionArgs.__new__(InfrastructureDefinitionArgs)

            if app_id is None and not opts.urn:
                raise TypeError("Missing required property 'app_id'")
            __props__.__dict__["app_id"] = app_id
            __props__.__dict__["aws_ami"] = aws_ami
            __props__.__dict__["aws_ecs"] = aws_ecs
            __props__.__dict__["aws_lambda"] = aws_lambda
            __props__.__dict__["aws_ssh"] = aws_ssh
            __props__.__dict__["aws_winrm"] = aws_winrm
            __props__.__dict__["azure_vmss"] = azure_vmss
            __props__.__dict__["azure_webapp"] = azure_webapp
            if cloud_provider_type is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_provider_type'")
            __props__.__dict__["cloud_provider_type"] = cloud_provider_type
            __props__.__dict__["custom"] = custom
            __props__.__dict__["datacenter_ssh"] = datacenter_ssh
            __props__.__dict__["datacenter_winrm"] = datacenter_winrm
            __props__.__dict__["deployment_template_uri"] = deployment_template_uri
            if deployment_type is None and not opts.urn:
                raise TypeError("Missing required property 'deployment_type'")
            __props__.__dict__["deployment_type"] = deployment_type
            if env_id is None and not opts.urn:
                raise TypeError("Missing required property 'env_id'")
            __props__.__dict__["env_id"] = env_id
            __props__.__dict__["kubernetes"] = kubernetes
            __props__.__dict__["kubernetes_gcp"] = kubernetes_gcp
            __props__.__dict__["name"] = name
            __props__.__dict__["provisioner_name"] = provisioner_name
            __props__.__dict__["scoped_services"] = scoped_services
            __props__.__dict__["tanzu"] = tanzu
        super(InfrastructureDefinition, __self__).__init__(
            'harness:index/infrastructureDefinition:InfrastructureDefinition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_id: Optional[pulumi.Input[builtins.str]] = None,
            aws_ami: Optional[pulumi.Input[Union['InfrastructureDefinitionAwsAmiArgs', 'InfrastructureDefinitionAwsAmiArgsDict']]] = None,
            aws_ecs: Optional[pulumi.Input[Union['InfrastructureDefinitionAwsEcsArgs', 'InfrastructureDefinitionAwsEcsArgsDict']]] = None,
            aws_lambda: Optional[pulumi.Input[Union['InfrastructureDefinitionAwsLambdaArgs', 'InfrastructureDefinitionAwsLambdaArgsDict']]] = None,
            aws_ssh: Optional[pulumi.Input[Union['InfrastructureDefinitionAwsSshArgs', 'InfrastructureDefinitionAwsSshArgsDict']]] = None,
            aws_winrm: Optional[pulumi.Input[Union['InfrastructureDefinitionAwsWinrmArgs', 'InfrastructureDefinitionAwsWinrmArgsDict']]] = None,
            azure_vmss: Optional[pulumi.Input[Union['InfrastructureDefinitionAzureVmssArgs', 'InfrastructureDefinitionAzureVmssArgsDict']]] = None,
            azure_webapp: Optional[pulumi.Input[Union['InfrastructureDefinitionAzureWebappArgs', 'InfrastructureDefinitionAzureWebappArgsDict']]] = None,
            cloud_provider_type: Optional[pulumi.Input[builtins.str]] = None,
            custom: Optional[pulumi.Input[Union['InfrastructureDefinitionCustomArgs', 'InfrastructureDefinitionCustomArgsDict']]] = None,
            datacenter_ssh: Optional[pulumi.Input[Union['InfrastructureDefinitionDatacenterSshArgs', 'InfrastructureDefinitionDatacenterSshArgsDict']]] = None,
            datacenter_winrm: Optional[pulumi.Input[Union['InfrastructureDefinitionDatacenterWinrmArgs', 'InfrastructureDefinitionDatacenterWinrmArgsDict']]] = None,
            deployment_template_uri: Optional[pulumi.Input[builtins.str]] = None,
            deployment_type: Optional[pulumi.Input[builtins.str]] = None,
            env_id: Optional[pulumi.Input[builtins.str]] = None,
            kubernetes: Optional[pulumi.Input[Union['InfrastructureDefinitionKubernetesArgs', 'InfrastructureDefinitionKubernetesArgsDict']]] = None,
            kubernetes_gcp: Optional[pulumi.Input[Union['InfrastructureDefinitionKubernetesGcpArgs', 'InfrastructureDefinitionKubernetesGcpArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            provisioner_name: Optional[pulumi.Input[builtins.str]] = None,
            scoped_services: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tanzu: Optional[pulumi.Input[Union['InfrastructureDefinitionTanzuArgs', 'InfrastructureDefinitionTanzuArgsDict']]] = None) -> 'InfrastructureDefinition':
        """
        Get an existing InfrastructureDefinition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] app_id: The id of the application the infrastructure definition belongs to.
        :param pulumi.Input[Union['InfrastructureDefinitionAwsAmiArgs', 'InfrastructureDefinitionAwsAmiArgsDict']] aws_ami: The configuration details for Aws AMI deployments.
        :param pulumi.Input[Union['InfrastructureDefinitionAwsEcsArgs', 'InfrastructureDefinitionAwsEcsArgsDict']] aws_ecs: The configuration details for Aws AMI deployments.
        :param pulumi.Input[Union['InfrastructureDefinitionAwsLambdaArgs', 'InfrastructureDefinitionAwsLambdaArgsDict']] aws_lambda: The configuration details for Aws Lambda deployments.
        :param pulumi.Input[Union['InfrastructureDefinitionAwsSshArgs', 'InfrastructureDefinitionAwsSshArgsDict']] aws_ssh: The configuration details for AWS SSH deployments.
        :param pulumi.Input[Union['InfrastructureDefinitionAwsWinrmArgs', 'InfrastructureDefinitionAwsWinrmArgsDict']] aws_winrm: The configuration details for AWS WinRM deployments.
        :param pulumi.Input[Union['InfrastructureDefinitionAzureVmssArgs', 'InfrastructureDefinitionAzureVmssArgsDict']] azure_vmss: The configuration details for Azure VMSS deployments.
        :param pulumi.Input[Union['InfrastructureDefinitionAzureWebappArgs', 'InfrastructureDefinitionAzureWebappArgsDict']] azure_webapp: The configuration details for Azure WebApp deployments.
        :param pulumi.Input[builtins.str] cloud_provider_type: The type of the cloud provider to connect with. Valid options are AWS, AZURE, CUSTOM, PHYSICAL*DATA*CENTER, KUBERNETES*CLUSTER, PCF, SPOT*INST
        :param pulumi.Input[Union['InfrastructureDefinitionCustomArgs', 'InfrastructureDefinitionCustomArgsDict']] custom: The configuration details for Custom deployments.
        :param pulumi.Input[Union['InfrastructureDefinitionDatacenterSshArgs', 'InfrastructureDefinitionDatacenterSshArgsDict']] datacenter_ssh: The configuration details for SSH datacenter deployments.
        :param pulumi.Input[Union['InfrastructureDefinitionDatacenterWinrmArgs', 'InfrastructureDefinitionDatacenterWinrmArgsDict']] datacenter_winrm: The configuration details for WinRM datacenter deployments.
        :param pulumi.Input[builtins.str] deployment_template_uri: The URI of the deployment template to use. Only used if deployment_type is `CUSTOM`.
        :param pulumi.Input[builtins.str] deployment_type: The type of the deployment to use. Valid options are AMI, AWS*CODEDEPLOY, AWS*LAMBDA, AZURE*VMSS, AZURE*WEBAPP, CUSTOM, ECS, HELM, KUBERNETES, PCF, SSH, WINRM
        :param pulumi.Input[builtins.str] env_id: The id of the environment the infrastructure definition belongs to.
        :param pulumi.Input[Union['InfrastructureDefinitionKubernetesArgs', 'InfrastructureDefinitionKubernetesArgsDict']] kubernetes: The configuration details for Kubernetes deployments.
        :param pulumi.Input[Union['InfrastructureDefinitionKubernetesGcpArgs', 'InfrastructureDefinitionKubernetesGcpArgsDict']] kubernetes_gcp: The configuration details for Kubernetes on GCP deployments.
        :param pulumi.Input[builtins.str] name: The name of the infrastructure definition
        :param pulumi.Input[builtins.str] provisioner_name: The name of the infrastructure provisioner to use.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] scoped_services: The list of service names to scope this infrastructure definition to.
        :param pulumi.Input[Union['InfrastructureDefinitionTanzuArgs', 'InfrastructureDefinitionTanzuArgsDict']] tanzu: The configuration details for PCF deployments.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InfrastructureDefinitionState.__new__(_InfrastructureDefinitionState)

        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["aws_ami"] = aws_ami
        __props__.__dict__["aws_ecs"] = aws_ecs
        __props__.__dict__["aws_lambda"] = aws_lambda
        __props__.__dict__["aws_ssh"] = aws_ssh
        __props__.__dict__["aws_winrm"] = aws_winrm
        __props__.__dict__["azure_vmss"] = azure_vmss
        __props__.__dict__["azure_webapp"] = azure_webapp
        __props__.__dict__["cloud_provider_type"] = cloud_provider_type
        __props__.__dict__["custom"] = custom
        __props__.__dict__["datacenter_ssh"] = datacenter_ssh
        __props__.__dict__["datacenter_winrm"] = datacenter_winrm
        __props__.__dict__["deployment_template_uri"] = deployment_template_uri
        __props__.__dict__["deployment_type"] = deployment_type
        __props__.__dict__["env_id"] = env_id
        __props__.__dict__["kubernetes"] = kubernetes
        __props__.__dict__["kubernetes_gcp"] = kubernetes_gcp
        __props__.__dict__["name"] = name
        __props__.__dict__["provisioner_name"] = provisioner_name
        __props__.__dict__["scoped_services"] = scoped_services
        __props__.__dict__["tanzu"] = tanzu
        return InfrastructureDefinition(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[builtins.str]:
        """
        The id of the application the infrastructure definition belongs to.
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="awsAmi")
    def aws_ami(self) -> pulumi.Output[Optional['outputs.InfrastructureDefinitionAwsAmi']]:
        """
        The configuration details for Aws AMI deployments.
        """
        return pulumi.get(self, "aws_ami")

    @property
    @pulumi.getter(name="awsEcs")
    def aws_ecs(self) -> pulumi.Output[Optional['outputs.InfrastructureDefinitionAwsEcs']]:
        """
        The configuration details for Aws AMI deployments.
        """
        return pulumi.get(self, "aws_ecs")

    @property
    @pulumi.getter(name="awsLambda")
    def aws_lambda(self) -> pulumi.Output[Optional['outputs.InfrastructureDefinitionAwsLambda']]:
        """
        The configuration details for Aws Lambda deployments.
        """
        return pulumi.get(self, "aws_lambda")

    @property
    @pulumi.getter(name="awsSsh")
    def aws_ssh(self) -> pulumi.Output[Optional['outputs.InfrastructureDefinitionAwsSsh']]:
        """
        The configuration details for AWS SSH deployments.
        """
        return pulumi.get(self, "aws_ssh")

    @property
    @pulumi.getter(name="awsWinrm")
    def aws_winrm(self) -> pulumi.Output[Optional['outputs.InfrastructureDefinitionAwsWinrm']]:
        """
        The configuration details for AWS WinRM deployments.
        """
        return pulumi.get(self, "aws_winrm")

    @property
    @pulumi.getter(name="azureVmss")
    def azure_vmss(self) -> pulumi.Output[Optional['outputs.InfrastructureDefinitionAzureVmss']]:
        """
        The configuration details for Azure VMSS deployments.
        """
        return pulumi.get(self, "azure_vmss")

    @property
    @pulumi.getter(name="azureWebapp")
    def azure_webapp(self) -> pulumi.Output[Optional['outputs.InfrastructureDefinitionAzureWebapp']]:
        """
        The configuration details for Azure WebApp deployments.
        """
        return pulumi.get(self, "azure_webapp")

    @property
    @pulumi.getter(name="cloudProviderType")
    def cloud_provider_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of the cloud provider to connect with. Valid options are AWS, AZURE, CUSTOM, PHYSICAL*DATA*CENTER, KUBERNETES*CLUSTER, PCF, SPOT*INST
        """
        return pulumi.get(self, "cloud_provider_type")

    @property
    @pulumi.getter
    def custom(self) -> pulumi.Output[Optional['outputs.InfrastructureDefinitionCustom']]:
        """
        The configuration details for Custom deployments.
        """
        return pulumi.get(self, "custom")

    @property
    @pulumi.getter(name="datacenterSsh")
    def datacenter_ssh(self) -> pulumi.Output[Optional['outputs.InfrastructureDefinitionDatacenterSsh']]:
        """
        The configuration details for SSH datacenter deployments.
        """
        return pulumi.get(self, "datacenter_ssh")

    @property
    @pulumi.getter(name="datacenterWinrm")
    def datacenter_winrm(self) -> pulumi.Output[Optional['outputs.InfrastructureDefinitionDatacenterWinrm']]:
        """
        The configuration details for WinRM datacenter deployments.
        """
        return pulumi.get(self, "datacenter_winrm")

    @property
    @pulumi.getter(name="deploymentTemplateUri")
    def deployment_template_uri(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The URI of the deployment template to use. Only used if deployment_type is `CUSTOM`.
        """
        return pulumi.get(self, "deployment_template_uri")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of the deployment to use. Valid options are AMI, AWS*CODEDEPLOY, AWS*LAMBDA, AZURE*VMSS, AZURE*WEBAPP, CUSTOM, ECS, HELM, KUBERNETES, PCF, SSH, WINRM
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="envId")
    def env_id(self) -> pulumi.Output[builtins.str]:
        """
        The id of the environment the infrastructure definition belongs to.
        """
        return pulumi.get(self, "env_id")

    @property
    @pulumi.getter
    def kubernetes(self) -> pulumi.Output[Optional['outputs.InfrastructureDefinitionKubernetes']]:
        """
        The configuration details for Kubernetes deployments.
        """
        return pulumi.get(self, "kubernetes")

    @property
    @pulumi.getter(name="kubernetesGcp")
    def kubernetes_gcp(self) -> pulumi.Output[Optional['outputs.InfrastructureDefinitionKubernetesGcp']]:
        """
        The configuration details for Kubernetes on GCP deployments.
        """
        return pulumi.get(self, "kubernetes_gcp")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the infrastructure definition
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisionerName")
    def provisioner_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the infrastructure provisioner to use.
        """
        return pulumi.get(self, "provisioner_name")

    @property
    @pulumi.getter(name="scopedServices")
    def scoped_services(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The list of service names to scope this infrastructure definition to.
        """
        return pulumi.get(self, "scoped_services")

    @property
    @pulumi.getter
    def tanzu(self) -> pulumi.Output[Optional['outputs.InfrastructureDefinitionTanzu']]:
        """
        The configuration details for PCF deployments.
        """
        return pulumi.get(self, "tanzu")

