# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'EncryptedTextUsageScope',
    'EnvironmentVariableOverride',
    'GitConnectorCommitDetails',
    'GitConnectorUsageScope',
    'InfrastructureDefinitionAwsAmi',
    'InfrastructureDefinitionAwsEcs',
    'InfrastructureDefinitionAwsLambda',
    'InfrastructureDefinitionAwsSsh',
    'InfrastructureDefinitionAwsSshTag',
    'InfrastructureDefinitionAwsWinrm',
    'InfrastructureDefinitionAzureVmss',
    'InfrastructureDefinitionAzureWebapp',
    'InfrastructureDefinitionCustom',
    'InfrastructureDefinitionCustomVariable',
    'InfrastructureDefinitionDatacenterSsh',
    'InfrastructureDefinitionDatacenterWinrm',
    'InfrastructureDefinitionKubernetes',
    'InfrastructureDefinitionKubernetesGcp',
    'InfrastructureDefinitionTanzu',
    'PlatformCcmFiltersFilterProperties',
    'SshCredentialKerberosAuthentication',
    'SshCredentialKerberosAuthenticationTgtGenerationMethod',
    'SshCredentialSshAuthentication',
    'SshCredentialSshAuthenticationInlineSsh',
    'SshCredentialSshAuthenticationServerPassword',
    'SshCredentialSshAuthenticationSshKeyFile',
    'SshCredentialUsageScope',
    'UserGroupLdapSettings',
    'UserGroupNotificationSettings',
    'UserGroupPermissions',
    'UserGroupPermissionsAppPermissions',
    'UserGroupPermissionsAppPermissionsAll',
    'UserGroupPermissionsAppPermissionsDeployment',
    'UserGroupPermissionsAppPermissionsEnvironment',
    'UserGroupPermissionsAppPermissionsPipeline',
    'UserGroupPermissionsAppPermissionsProvisioner',
    'UserGroupPermissionsAppPermissionsService',
    'UserGroupPermissionsAppPermissionsTemplate',
    'UserGroupPermissionsAppPermissionsWorkflow',
    'UserGroupSamlSettings',
    'GetEncryptedTextUsageScopeResult',
    'GetEnvironmentVariableOverrideResult',
    'GetGitConnectorCommitDetailResult',
    'GetSecretManagerUsageScopeResult',
    'GetSshCredentialUsageScopeResult',
    'GetTriggerConditionResult',
    'GetTriggerConditionOnWebhookResult',
    'GetTriggerConditionOnWebhookWebhookDetailResult',
]

@pulumi.output_type
class EncryptedTextUsageScope(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationId":
            suggest = "application_id"
        elif key == "environmentFilterType":
            suggest = "environment_filter_type"
        elif key == "environmentId":
            suggest = "environment_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptedTextUsageScope. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptedTextUsageScope.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptedTextUsageScope.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_id: Optional[builtins.str] = None,
                 environment_filter_type: Optional[builtins.str] = None,
                 environment_id: Optional[builtins.str] = None):
        """
        :param builtins.str application_id: Id of the application to scope to. If empty then this scope applies to all applications.
        :param builtins.str environment_filter_type: Type of environment filter applied. Cannot be used with `environment_id`. Valid options are NON*PRODUCTION*ENVIRONMENTS, PRODUCTION_ENVIRONMENTS.
        :param builtins.str environment_id: Id of the id of the specific environment to scope to. Cannot be used with `environment_filter_type`.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if environment_filter_type is not None:
            pulumi.set(__self__, "environment_filter_type", environment_filter_type)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[builtins.str]:
        """
        Id of the application to scope to. If empty then this scope applies to all applications.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="environmentFilterType")
    def environment_filter_type(self) -> Optional[builtins.str]:
        """
        Type of environment filter applied. Cannot be used with `environment_id`. Valid options are NON*PRODUCTION*ENVIRONMENTS, PRODUCTION_ENVIRONMENTS.
        """
        return pulumi.get(self, "environment_filter_type")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[builtins.str]:
        """
        Id of the id of the specific environment to scope to. Cannot be used with `environment_filter_type`.
        """
        return pulumi.get(self, "environment_id")


@pulumi.output_type
class EnvironmentVariableOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceName":
            suggest = "service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentVariableOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentVariableOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentVariableOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 type: builtins.str,
                 value: builtins.str,
                 service_name: Optional[builtins.str] = None):
        """
        :param builtins.str name: The name of the variable
        :param builtins.str type: The type of the service variable. Valid values are `TEXT` and `ENCRYPTED_TEXT`
        :param builtins.str value: The value of the service variable
        :param builtins.str service_name: The name of the service
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the variable
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the service variable. Valid values are `TEXT` and `ENCRYPTED_TEXT`
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the service variable
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[builtins.str]:
        """
        The name of the service
        """
        return pulumi.get(self, "service_name")


@pulumi.output_type
class GitConnectorCommitDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorEmailId":
            suggest = "author_email_id"
        elif key == "authorName":
            suggest = "author_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitConnectorCommitDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitConnectorCommitDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitConnectorCommitDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 author_email_id: Optional[builtins.str] = None,
                 author_name: Optional[builtins.str] = None,
                 message: Optional[builtins.str] = None):
        """
        :param builtins.str author_email_id: The email id of the author
        :param builtins.str author_name: The name of the author
        :param builtins.str message: Commit message
        """
        if author_email_id is not None:
            pulumi.set(__self__, "author_email_id", author_email_id)
        if author_name is not None:
            pulumi.set(__self__, "author_name", author_name)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter(name="authorEmailId")
    def author_email_id(self) -> Optional[builtins.str]:
        """
        The email id of the author
        """
        return pulumi.get(self, "author_email_id")

    @property
    @pulumi.getter(name="authorName")
    def author_name(self) -> Optional[builtins.str]:
        """
        The name of the author
        """
        return pulumi.get(self, "author_name")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        Commit message
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class GitConnectorUsageScope(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationId":
            suggest = "application_id"
        elif key == "environmentFilterType":
            suggest = "environment_filter_type"
        elif key == "environmentId":
            suggest = "environment_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitConnectorUsageScope. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitConnectorUsageScope.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitConnectorUsageScope.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_id: Optional[builtins.str] = None,
                 environment_filter_type: Optional[builtins.str] = None,
                 environment_id: Optional[builtins.str] = None):
        """
        :param builtins.str application_id: Id of the application to scope to. If empty then this scope applies to all applications.
        :param builtins.str environment_filter_type: Type of environment filter applied. Cannot be used with `environment_id`. Valid options are NON*PRODUCTION*ENVIRONMENTS, PRODUCTION_ENVIRONMENTS.
        :param builtins.str environment_id: Id of the id of the specific environment to scope to. Cannot be used with `environment_filter_type`.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if environment_filter_type is not None:
            pulumi.set(__self__, "environment_filter_type", environment_filter_type)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[builtins.str]:
        """
        Id of the application to scope to. If empty then this scope applies to all applications.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="environmentFilterType")
    def environment_filter_type(self) -> Optional[builtins.str]:
        """
        Type of environment filter applied. Cannot be used with `environment_id`. Valid options are NON*PRODUCTION*ENVIRONMENTS, PRODUCTION_ENVIRONMENTS.
        """
        return pulumi.get(self, "environment_filter_type")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[builtins.str]:
        """
        Id of the id of the specific environment to scope to. Cannot be used with `environment_filter_type`.
        """
        return pulumi.get(self, "environment_id")


@pulumi.output_type
class InfrastructureDefinitionAwsAmi(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "amiDeploymentType":
            suggest = "ami_deployment_type"
        elif key == "cloudProviderName":
            suggest = "cloud_provider_name"
        elif key == "asgIdentifiesWorkload":
            suggest = "asg_identifies_workload"
        elif key == "autoscalingGroupName":
            suggest = "autoscaling_group_name"
        elif key == "classicLoadbalancers":
            suggest = "classic_loadbalancers"
        elif key == "hostnameConvention":
            suggest = "hostname_convention"
        elif key == "spotinstCloudProviderName":
            suggest = "spotinst_cloud_provider_name"
        elif key == "spotinstConfigJson":
            suggest = "spotinst_config_json"
        elif key == "stageClassicLoadbalancers":
            suggest = "stage_classic_loadbalancers"
        elif key == "stageTargetGroupArns":
            suggest = "stage_target_group_arns"
        elif key == "targetGroupArns":
            suggest = "target_group_arns"
        elif key == "useTrafficShift":
            suggest = "use_traffic_shift"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureDefinitionAwsAmi. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureDefinitionAwsAmi.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureDefinitionAwsAmi.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ami_deployment_type: builtins.str,
                 cloud_provider_name: builtins.str,
                 region: builtins.str,
                 asg_identifies_workload: Optional[builtins.bool] = None,
                 autoscaling_group_name: Optional[builtins.str] = None,
                 classic_loadbalancers: Optional[Sequence[builtins.str]] = None,
                 hostname_convention: Optional[builtins.str] = None,
                 spotinst_cloud_provider_name: Optional[builtins.str] = None,
                 spotinst_config_json: Optional[builtins.str] = None,
                 stage_classic_loadbalancers: Optional[Sequence[builtins.str]] = None,
                 stage_target_group_arns: Optional[Sequence[builtins.str]] = None,
                 target_group_arns: Optional[Sequence[builtins.str]] = None,
                 use_traffic_shift: Optional[builtins.bool] = None):
        """
        :param builtins.str ami_deployment_type: The ami deployment type to use. Valid options are AWS_ASG, SPOTINST
        :param builtins.str cloud_provider_name: The name of the cloud provider to connect with.
        :param builtins.str region: The region to deploy to.
        :param builtins.bool asg_identifies_workload: Flag to indicate whether the autoscaling group identifies the workload.
        :param builtins.str autoscaling_group_name: The name of the autoscaling group.
        :param Sequence[builtins.str] classic_loadbalancers: The classic load balancers to use.
        :param builtins.str hostname_convention: The naming convention to use for the hostname. Defaults to ${host.ec2Instance.privateDnsName.split('.')[0]}
        :param builtins.str spotinst_cloud_provider_name: The name of the SpotInst cloud provider to connect with.
        :param builtins.str spotinst_config_json: The SpotInst configuration to use.
        :param Sequence[builtins.str] stage_classic_loadbalancers: The staging classic load balancers to use.
        :param Sequence[builtins.str] stage_target_group_arns: The staging classic load balancers to use.
        :param Sequence[builtins.str] target_group_arns: The ARN's of the target groups.
        :param builtins.bool use_traffic_shift: Flag to enable traffic shifting.
        """
        pulumi.set(__self__, "ami_deployment_type", ami_deployment_type)
        pulumi.set(__self__, "cloud_provider_name", cloud_provider_name)
        pulumi.set(__self__, "region", region)
        if asg_identifies_workload is not None:
            pulumi.set(__self__, "asg_identifies_workload", asg_identifies_workload)
        if autoscaling_group_name is not None:
            pulumi.set(__self__, "autoscaling_group_name", autoscaling_group_name)
        if classic_loadbalancers is not None:
            pulumi.set(__self__, "classic_loadbalancers", classic_loadbalancers)
        if hostname_convention is not None:
            pulumi.set(__self__, "hostname_convention", hostname_convention)
        if spotinst_cloud_provider_name is not None:
            pulumi.set(__self__, "spotinst_cloud_provider_name", spotinst_cloud_provider_name)
        if spotinst_config_json is not None:
            pulumi.set(__self__, "spotinst_config_json", spotinst_config_json)
        if stage_classic_loadbalancers is not None:
            pulumi.set(__self__, "stage_classic_loadbalancers", stage_classic_loadbalancers)
        if stage_target_group_arns is not None:
            pulumi.set(__self__, "stage_target_group_arns", stage_target_group_arns)
        if target_group_arns is not None:
            pulumi.set(__self__, "target_group_arns", target_group_arns)
        if use_traffic_shift is not None:
            pulumi.set(__self__, "use_traffic_shift", use_traffic_shift)

    @property
    @pulumi.getter(name="amiDeploymentType")
    def ami_deployment_type(self) -> builtins.str:
        """
        The ami deployment type to use. Valid options are AWS_ASG, SPOTINST
        """
        return pulumi.get(self, "ami_deployment_type")

    @property
    @pulumi.getter(name="cloudProviderName")
    def cloud_provider_name(self) -> builtins.str:
        """
        The name of the cloud provider to connect with.
        """
        return pulumi.get(self, "cloud_provider_name")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        The region to deploy to.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="asgIdentifiesWorkload")
    def asg_identifies_workload(self) -> Optional[builtins.bool]:
        """
        Flag to indicate whether the autoscaling group identifies the workload.
        """
        return pulumi.get(self, "asg_identifies_workload")

    @property
    @pulumi.getter(name="autoscalingGroupName")
    def autoscaling_group_name(self) -> Optional[builtins.str]:
        """
        The name of the autoscaling group.
        """
        return pulumi.get(self, "autoscaling_group_name")

    @property
    @pulumi.getter(name="classicLoadbalancers")
    def classic_loadbalancers(self) -> Optional[Sequence[builtins.str]]:
        """
        The classic load balancers to use.
        """
        return pulumi.get(self, "classic_loadbalancers")

    @property
    @pulumi.getter(name="hostnameConvention")
    def hostname_convention(self) -> Optional[builtins.str]:
        """
        The naming convention to use for the hostname. Defaults to ${host.ec2Instance.privateDnsName.split('.')[0]}
        """
        return pulumi.get(self, "hostname_convention")

    @property
    @pulumi.getter(name="spotinstCloudProviderName")
    def spotinst_cloud_provider_name(self) -> Optional[builtins.str]:
        """
        The name of the SpotInst cloud provider to connect with.
        """
        return pulumi.get(self, "spotinst_cloud_provider_name")

    @property
    @pulumi.getter(name="spotinstConfigJson")
    def spotinst_config_json(self) -> Optional[builtins.str]:
        """
        The SpotInst configuration to use.
        """
        return pulumi.get(self, "spotinst_config_json")

    @property
    @pulumi.getter(name="stageClassicLoadbalancers")
    def stage_classic_loadbalancers(self) -> Optional[Sequence[builtins.str]]:
        """
        The staging classic load balancers to use.
        """
        return pulumi.get(self, "stage_classic_loadbalancers")

    @property
    @pulumi.getter(name="stageTargetGroupArns")
    def stage_target_group_arns(self) -> Optional[Sequence[builtins.str]]:
        """
        The staging classic load balancers to use.
        """
        return pulumi.get(self, "stage_target_group_arns")

    @property
    @pulumi.getter(name="targetGroupArns")
    def target_group_arns(self) -> Optional[Sequence[builtins.str]]:
        """
        The ARN's of the target groups.
        """
        return pulumi.get(self, "target_group_arns")

    @property
    @pulumi.getter(name="useTrafficShift")
    def use_traffic_shift(self) -> Optional[builtins.bool]:
        """
        Flag to enable traffic shifting.
        """
        return pulumi.get(self, "use_traffic_shift")


@pulumi.output_type
class InfrastructureDefinitionAwsEcs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudProviderName":
            suggest = "cloud_provider_name"
        elif key == "clusterName":
            suggest = "cluster_name"
        elif key == "launchType":
            suggest = "launch_type"
        elif key == "assignPublicIp":
            suggest = "assign_public_ip"
        elif key == "executionRole":
            suggest = "execution_role"
        elif key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "subnetIds":
            suggest = "subnet_ids"
        elif key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureDefinitionAwsEcs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureDefinitionAwsEcs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureDefinitionAwsEcs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_provider_name: builtins.str,
                 cluster_name: builtins.str,
                 launch_type: builtins.str,
                 region: builtins.str,
                 assign_public_ip: Optional[builtins.bool] = None,
                 execution_role: Optional[builtins.str] = None,
                 security_group_ids: Optional[Sequence[builtins.str]] = None,
                 subnet_ids: Optional[Sequence[builtins.str]] = None,
                 vpc_id: Optional[builtins.str] = None):
        """
        :param builtins.str cloud_provider_name: The name of the cloud provider to connect with.
        :param builtins.str cluster_name: The name of the ECS cluster to use.
        :param builtins.str launch_type: The type of launch configuration to use. Valid options are FARGATE
        :param builtins.str region: The region to deploy to.
        :param builtins.bool assign_public_ip: Flag to assign a public IP address.
        :param builtins.str execution_role: The ARN of the role to use for execution.
        :param Sequence[builtins.str] security_group_ids: The security group ids to apply to the ecs service.
        :param Sequence[builtins.str] subnet_ids: The subnet ids to apply to the ecs service.
        :param builtins.str vpc_id: The VPC ids to use when selecting the instances.
        """
        pulumi.set(__self__, "cloud_provider_name", cloud_provider_name)
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "launch_type", launch_type)
        pulumi.set(__self__, "region", region)
        if assign_public_ip is not None:
            pulumi.set(__self__, "assign_public_ip", assign_public_ip)
        if execution_role is not None:
            pulumi.set(__self__, "execution_role", execution_role)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="cloudProviderName")
    def cloud_provider_name(self) -> builtins.str:
        """
        The name of the cloud provider to connect with.
        """
        return pulumi.get(self, "cloud_provider_name")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> builtins.str:
        """
        The name of the ECS cluster to use.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="launchType")
    def launch_type(self) -> builtins.str:
        """
        The type of launch configuration to use. Valid options are FARGATE
        """
        return pulumi.get(self, "launch_type")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        The region to deploy to.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="assignPublicIp")
    def assign_public_ip(self) -> Optional[builtins.bool]:
        """
        Flag to assign a public IP address.
        """
        return pulumi.get(self, "assign_public_ip")

    @property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> Optional[builtins.str]:
        """
        The ARN of the role to use for execution.
        """
        return pulumi.get(self, "execution_role")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The security group ids to apply to the ecs service.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The subnet ids to apply to the ecs service.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[builtins.str]:
        """
        The VPC ids to use when selecting the instances.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class InfrastructureDefinitionAwsLambda(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudProviderName":
            suggest = "cloud_provider_name"
        elif key == "iamRole":
            suggest = "iam_role"
        elif key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "subnetIds":
            suggest = "subnet_ids"
        elif key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureDefinitionAwsLambda. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureDefinitionAwsLambda.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureDefinitionAwsLambda.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_provider_name: builtins.str,
                 region: builtins.str,
                 iam_role: Optional[builtins.str] = None,
                 security_group_ids: Optional[Sequence[builtins.str]] = None,
                 subnet_ids: Optional[Sequence[builtins.str]] = None,
                 vpc_id: Optional[builtins.str] = None):
        """
        :param builtins.str cloud_provider_name: The name of the cloud provider to connect with.
        :param builtins.str region: The region to deploy to.
        :param builtins.str iam_role: The IAM role to use.
        :param Sequence[builtins.str] security_group_ids: The security group ids to apply to the ecs service.
        :param Sequence[builtins.str] subnet_ids: The subnet ids to apply to the ecs service.
        :param builtins.str vpc_id: The VPC ids to use when selecting the instances.
        """
        pulumi.set(__self__, "cloud_provider_name", cloud_provider_name)
        pulumi.set(__self__, "region", region)
        if iam_role is not None:
            pulumi.set(__self__, "iam_role", iam_role)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="cloudProviderName")
    def cloud_provider_name(self) -> builtins.str:
        """
        The name of the cloud provider to connect with.
        """
        return pulumi.get(self, "cloud_provider_name")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        The region to deploy to.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="iamRole")
    def iam_role(self) -> Optional[builtins.str]:
        """
        The IAM role to use.
        """
        return pulumi.get(self, "iam_role")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The security group ids to apply to the ecs service.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The subnet ids to apply to the ecs service.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[builtins.str]:
        """
        The VPC ids to use when selecting the instances.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class InfrastructureDefinitionAwsSsh(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudProviderName":
            suggest = "cloud_provider_name"
        elif key == "hostConnectionType":
            suggest = "host_connection_type"
        elif key == "autoscalingGroupName":
            suggest = "autoscaling_group_name"
        elif key == "desiredCapacity":
            suggest = "desired_capacity"
        elif key == "hostConnectionAttrsName":
            suggest = "host_connection_attrs_name"
        elif key == "hostnameConvention":
            suggest = "hostname_convention"
        elif key == "loadbalancerName":
            suggest = "loadbalancer_name"
        elif key == "vpcIds":
            suggest = "vpc_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureDefinitionAwsSsh. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureDefinitionAwsSsh.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureDefinitionAwsSsh.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_provider_name: builtins.str,
                 host_connection_type: builtins.str,
                 region: builtins.str,
                 autoscaling_group_name: Optional[builtins.str] = None,
                 desired_capacity: Optional[builtins.int] = None,
                 host_connection_attrs_name: Optional[builtins.str] = None,
                 hostname_convention: Optional[builtins.str] = None,
                 loadbalancer_name: Optional[builtins.str] = None,
                 tags: Optional[Sequence['outputs.InfrastructureDefinitionAwsSshTag']] = None,
                 vpc_ids: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str cloud_provider_name: The name of the cloud provider to connect with.
        :param builtins.str host_connection_type: The type of host connection to use. Valid options are PRIVATE*DNS, PUBLIC*DNS, PRIVATE*IP, PUBLIC*IP
        :param builtins.str region: The region to deploy to.
        :param builtins.str autoscaling_group_name: The name of the autoscaling group.
        :param builtins.int desired_capacity: The desired capacity of the auto scaling group.
        :param builtins.str host_connection_attrs_name: The name of the host connection attributes to use.
        :param builtins.str hostname_convention: The naming convention to use for the hostname. Defaults to ${host.ec2Instance.privateDnsName.split('.')[0]}
        :param builtins.str loadbalancer_name: The name of the load balancer to use.
        :param Sequence['InfrastructureDefinitionAwsSshTagArgs'] tags: The tags to use when selecting the instances.
        :param Sequence[builtins.str] vpc_ids: The VPC ids to use when selecting the instances.
        """
        pulumi.set(__self__, "cloud_provider_name", cloud_provider_name)
        pulumi.set(__self__, "host_connection_type", host_connection_type)
        pulumi.set(__self__, "region", region)
        if autoscaling_group_name is not None:
            pulumi.set(__self__, "autoscaling_group_name", autoscaling_group_name)
        if desired_capacity is not None:
            pulumi.set(__self__, "desired_capacity", desired_capacity)
        if host_connection_attrs_name is not None:
            pulumi.set(__self__, "host_connection_attrs_name", host_connection_attrs_name)
        if hostname_convention is not None:
            pulumi.set(__self__, "hostname_convention", hostname_convention)
        if loadbalancer_name is not None:
            pulumi.set(__self__, "loadbalancer_name", loadbalancer_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_ids is not None:
            pulumi.set(__self__, "vpc_ids", vpc_ids)

    @property
    @pulumi.getter(name="cloudProviderName")
    def cloud_provider_name(self) -> builtins.str:
        """
        The name of the cloud provider to connect with.
        """
        return pulumi.get(self, "cloud_provider_name")

    @property
    @pulumi.getter(name="hostConnectionType")
    def host_connection_type(self) -> builtins.str:
        """
        The type of host connection to use. Valid options are PRIVATE*DNS, PUBLIC*DNS, PRIVATE*IP, PUBLIC*IP
        """
        return pulumi.get(self, "host_connection_type")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        The region to deploy to.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="autoscalingGroupName")
    def autoscaling_group_name(self) -> Optional[builtins.str]:
        """
        The name of the autoscaling group.
        """
        return pulumi.get(self, "autoscaling_group_name")

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> Optional[builtins.int]:
        """
        The desired capacity of the auto scaling group.
        """
        return pulumi.get(self, "desired_capacity")

    @property
    @pulumi.getter(name="hostConnectionAttrsName")
    def host_connection_attrs_name(self) -> Optional[builtins.str]:
        """
        The name of the host connection attributes to use.
        """
        return pulumi.get(self, "host_connection_attrs_name")

    @property
    @pulumi.getter(name="hostnameConvention")
    def hostname_convention(self) -> Optional[builtins.str]:
        """
        The naming convention to use for the hostname. Defaults to ${host.ec2Instance.privateDnsName.split('.')[0]}
        """
        return pulumi.get(self, "hostname_convention")

    @property
    @pulumi.getter(name="loadbalancerName")
    def loadbalancer_name(self) -> Optional[builtins.str]:
        """
        The name of the load balancer to use.
        """
        return pulumi.get(self, "loadbalancer_name")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.InfrastructureDefinitionAwsSshTag']]:
        """
        The tags to use when selecting the instances.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcIds")
    def vpc_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The VPC ids to use when selecting the instances.
        """
        return pulumi.get(self, "vpc_ids")


@pulumi.output_type
class InfrastructureDefinitionAwsSshTag(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: The key of the tag.
        :param builtins.str value: The value of the tag.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key of the tag.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the tag.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class InfrastructureDefinitionAwsWinrm(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoscalingGroupName":
            suggest = "autoscaling_group_name"
        elif key == "cloudProviderName":
            suggest = "cloud_provider_name"
        elif key == "hostConnectionAttrsName":
            suggest = "host_connection_attrs_name"
        elif key == "hostConnectionType":
            suggest = "host_connection_type"
        elif key == "desiredCapacity":
            suggest = "desired_capacity"
        elif key == "hostnameConvention":
            suggest = "hostname_convention"
        elif key == "loadbalancerName":
            suggest = "loadbalancer_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureDefinitionAwsWinrm. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureDefinitionAwsWinrm.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureDefinitionAwsWinrm.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscaling_group_name: builtins.str,
                 cloud_provider_name: builtins.str,
                 host_connection_attrs_name: builtins.str,
                 host_connection_type: builtins.str,
                 region: builtins.str,
                 desired_capacity: Optional[builtins.int] = None,
                 hostname_convention: Optional[builtins.str] = None,
                 loadbalancer_name: Optional[builtins.str] = None):
        """
        :param builtins.str autoscaling_group_name: The name of the autoscaling group.
        :param builtins.str cloud_provider_name: The name of the cloud provider to connect with.
        :param builtins.str host_connection_attrs_name: The name of the host connection attributes to use.
        :param builtins.str host_connection_type: The type of host connection to use. Valid options are PRIVATE*DNS, PUBLIC*DNS, PRIVATE*IP, PUBLIC*IP
        :param builtins.str region: The region to deploy to.
        :param builtins.int desired_capacity: The desired capacity of the autoscaling group.
        :param builtins.str hostname_convention: The naming convention to use for the hostname. Defaults to ${host.ec2Instance.privateDnsName.split('.')[0]}
        :param builtins.str loadbalancer_name: The name of the load balancer to use.
        """
        pulumi.set(__self__, "autoscaling_group_name", autoscaling_group_name)
        pulumi.set(__self__, "cloud_provider_name", cloud_provider_name)
        pulumi.set(__self__, "host_connection_attrs_name", host_connection_attrs_name)
        pulumi.set(__self__, "host_connection_type", host_connection_type)
        pulumi.set(__self__, "region", region)
        if desired_capacity is not None:
            pulumi.set(__self__, "desired_capacity", desired_capacity)
        if hostname_convention is not None:
            pulumi.set(__self__, "hostname_convention", hostname_convention)
        if loadbalancer_name is not None:
            pulumi.set(__self__, "loadbalancer_name", loadbalancer_name)

    @property
    @pulumi.getter(name="autoscalingGroupName")
    def autoscaling_group_name(self) -> builtins.str:
        """
        The name of the autoscaling group.
        """
        return pulumi.get(self, "autoscaling_group_name")

    @property
    @pulumi.getter(name="cloudProviderName")
    def cloud_provider_name(self) -> builtins.str:
        """
        The name of the cloud provider to connect with.
        """
        return pulumi.get(self, "cloud_provider_name")

    @property
    @pulumi.getter(name="hostConnectionAttrsName")
    def host_connection_attrs_name(self) -> builtins.str:
        """
        The name of the host connection attributes to use.
        """
        return pulumi.get(self, "host_connection_attrs_name")

    @property
    @pulumi.getter(name="hostConnectionType")
    def host_connection_type(self) -> builtins.str:
        """
        The type of host connection to use. Valid options are PRIVATE*DNS, PUBLIC*DNS, PRIVATE*IP, PUBLIC*IP
        """
        return pulumi.get(self, "host_connection_type")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        The region to deploy to.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> Optional[builtins.int]:
        """
        The desired capacity of the autoscaling group.
        """
        return pulumi.get(self, "desired_capacity")

    @property
    @pulumi.getter(name="hostnameConvention")
    def hostname_convention(self) -> Optional[builtins.str]:
        """
        The naming convention to use for the hostname. Defaults to ${host.ec2Instance.privateDnsName.split('.')[0]}
        """
        return pulumi.get(self, "hostname_convention")

    @property
    @pulumi.getter(name="loadbalancerName")
    def loadbalancer_name(self) -> Optional[builtins.str]:
        """
        The name of the load balancer to use.
        """
        return pulumi.get(self, "loadbalancer_name")


@pulumi.output_type
class InfrastructureDefinitionAzureVmss(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"
        elif key == "baseName":
            suggest = "base_name"
        elif key == "cloudProviderName":
            suggest = "cloud_provider_name"
        elif key == "deploymentType":
            suggest = "deployment_type"
        elif key == "resourceGroupName":
            suggest = "resource_group_name"
        elif key == "subscriptionId":
            suggest = "subscription_id"
        elif key == "hostConnectionAttrsName":
            suggest = "host_connection_attrs_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureDefinitionAzureVmss. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureDefinitionAzureVmss.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureDefinitionAzureVmss.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_type: builtins.str,
                 base_name: builtins.str,
                 cloud_provider_name: builtins.str,
                 deployment_type: builtins.str,
                 resource_group_name: builtins.str,
                 subscription_id: builtins.str,
                 username: builtins.str,
                 host_connection_attrs_name: Optional[builtins.str] = None):
        """
        :param builtins.str auth_type: The type of authentication to use. Valid options are SSH*PUBLIC*KEY.
        :param builtins.str base_name: Base name.
        :param builtins.str cloud_provider_name: The name of the cloud provider to connect with.
        :param builtins.str deployment_type: The type of deployment. Valid options are NATIVE_VMSS
        :param builtins.str resource_group_name: The name of the resource group.
        :param builtins.str subscription_id: The unique id of the azure subscription.
        :param builtins.str username: The username to connect with.
        :param builtins.str host_connection_attrs_name: The name of the host connection attributes to use.
        """
        pulumi.set(__self__, "auth_type", auth_type)
        pulumi.set(__self__, "base_name", base_name)
        pulumi.set(__self__, "cloud_provider_name", cloud_provider_name)
        pulumi.set(__self__, "deployment_type", deployment_type)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "subscription_id", subscription_id)
        pulumi.set(__self__, "username", username)
        if host_connection_attrs_name is not None:
            pulumi.set(__self__, "host_connection_attrs_name", host_connection_attrs_name)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> builtins.str:
        """
        The type of authentication to use. Valid options are SSH*PUBLIC*KEY.
        """
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter(name="baseName")
    def base_name(self) -> builtins.str:
        """
        Base name.
        """
        return pulumi.get(self, "base_name")

    @property
    @pulumi.getter(name="cloudProviderName")
    def cloud_provider_name(self) -> builtins.str:
        """
        The name of the cloud provider to connect with.
        """
        return pulumi.get(self, "cloud_provider_name")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> builtins.str:
        """
        The type of deployment. Valid options are NATIVE_VMSS
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        """
        The name of the resource group.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> builtins.str:
        """
        The unique id of the azure subscription.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        """
        The username to connect with.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="hostConnectionAttrsName")
    def host_connection_attrs_name(self) -> Optional[builtins.str]:
        """
        The name of the host connection attributes to use.
        """
        return pulumi.get(self, "host_connection_attrs_name")


@pulumi.output_type
class InfrastructureDefinitionAzureWebapp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudProviderName":
            suggest = "cloud_provider_name"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "subscriptionId":
            suggest = "subscription_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureDefinitionAzureWebapp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureDefinitionAzureWebapp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureDefinitionAzureWebapp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_provider_name: builtins.str,
                 resource_group: builtins.str,
                 subscription_id: builtins.str):
        """
        :param builtins.str cloud_provider_name: The name of the cloud provider to connect with.
        :param builtins.str resource_group: The name of the resource group.
        :param builtins.str subscription_id: The unique id of the azure subscription.
        """
        pulumi.set(__self__, "cloud_provider_name", cloud_provider_name)
        pulumi.set(__self__, "resource_group", resource_group)
        pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="cloudProviderName")
    def cloud_provider_name(self) -> builtins.str:
        """
        The name of the cloud provider to connect with.
        """
        return pulumi.get(self, "cloud_provider_name")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> builtins.str:
        """
        The name of the resource group.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> builtins.str:
        """
        The unique id of the azure subscription.
        """
        return pulumi.get(self, "subscription_id")


@pulumi.output_type
class InfrastructureDefinitionCustom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deploymentTypeTemplateVersion":
            suggest = "deployment_type_template_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureDefinitionCustom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureDefinitionCustom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureDefinitionCustom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deployment_type_template_version: builtins.str,
                 variables: Optional[Sequence['outputs.InfrastructureDefinitionCustomVariable']] = None):
        """
        :param builtins.str deployment_type_template_version: The template version
        :param Sequence['InfrastructureDefinitionCustomVariableArgs'] variables: Variables to be used in the service
        """
        pulumi.set(__self__, "deployment_type_template_version", deployment_type_template_version)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter(name="deploymentTypeTemplateVersion")
    def deployment_type_template_version(self) -> builtins.str:
        """
        The template version
        """
        return pulumi.get(self, "deployment_type_template_version")

    @property
    @pulumi.getter
    def variables(self) -> Optional[Sequence['outputs.InfrastructureDefinitionCustomVariable']]:
        """
        Variables to be used in the service
        """
        return pulumi.get(self, "variables")


@pulumi.output_type
class InfrastructureDefinitionCustomVariable(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: Name of the variable
        :param builtins.str value: Value of the variable
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the variable
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value of the variable
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class InfrastructureDefinitionDatacenterSsh(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudProviderName":
            suggest = "cloud_provider_name"
        elif key == "hostConnectionAttributesName":
            suggest = "host_connection_attributes_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureDefinitionDatacenterSsh. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureDefinitionDatacenterSsh.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureDefinitionDatacenterSsh.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_provider_name: builtins.str,
                 host_connection_attributes_name: builtins.str,
                 hostnames: Sequence[builtins.str]):
        """
        :param builtins.str cloud_provider_name: The name of the cloud provider to connect with.
        :param builtins.str host_connection_attributes_name: The name of the SSH connection attributes to use.
        :param Sequence[builtins.str] hostnames: A list of hosts to deploy to.
        """
        pulumi.set(__self__, "cloud_provider_name", cloud_provider_name)
        pulumi.set(__self__, "host_connection_attributes_name", host_connection_attributes_name)
        pulumi.set(__self__, "hostnames", hostnames)

    @property
    @pulumi.getter(name="cloudProviderName")
    def cloud_provider_name(self) -> builtins.str:
        """
        The name of the cloud provider to connect with.
        """
        return pulumi.get(self, "cloud_provider_name")

    @property
    @pulumi.getter(name="hostConnectionAttributesName")
    def host_connection_attributes_name(self) -> builtins.str:
        """
        The name of the SSH connection attributes to use.
        """
        return pulumi.get(self, "host_connection_attributes_name")

    @property
    @pulumi.getter
    def hostnames(self) -> Sequence[builtins.str]:
        """
        A list of hosts to deploy to.
        """
        return pulumi.get(self, "hostnames")


@pulumi.output_type
class InfrastructureDefinitionDatacenterWinrm(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudProviderName":
            suggest = "cloud_provider_name"
        elif key == "winrmConnectionAttributesName":
            suggest = "winrm_connection_attributes_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureDefinitionDatacenterWinrm. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureDefinitionDatacenterWinrm.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureDefinitionDatacenterWinrm.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_provider_name: builtins.str,
                 hostnames: Sequence[builtins.str],
                 winrm_connection_attributes_name: builtins.str):
        """
        :param builtins.str cloud_provider_name: The name of the cloud provider to connect with.
        :param Sequence[builtins.str] hostnames: A list of hosts to deploy to.
        :param builtins.str winrm_connection_attributes_name: The name of the WinRM connection attributes to use.
        """
        pulumi.set(__self__, "cloud_provider_name", cloud_provider_name)
        pulumi.set(__self__, "hostnames", hostnames)
        pulumi.set(__self__, "winrm_connection_attributes_name", winrm_connection_attributes_name)

    @property
    @pulumi.getter(name="cloudProviderName")
    def cloud_provider_name(self) -> builtins.str:
        """
        The name of the cloud provider to connect with.
        """
        return pulumi.get(self, "cloud_provider_name")

    @property
    @pulumi.getter
    def hostnames(self) -> Sequence[builtins.str]:
        """
        A list of hosts to deploy to.
        """
        return pulumi.get(self, "hostnames")

    @property
    @pulumi.getter(name="winrmConnectionAttributesName")
    def winrm_connection_attributes_name(self) -> builtins.str:
        """
        The name of the WinRM connection attributes to use.
        """
        return pulumi.get(self, "winrm_connection_attributes_name")


@pulumi.output_type
class InfrastructureDefinitionKubernetes(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudProviderName":
            suggest = "cloud_provider_name"
        elif key == "releaseName":
            suggest = "release_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureDefinitionKubernetes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureDefinitionKubernetes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureDefinitionKubernetes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_provider_name: builtins.str,
                 namespace: builtins.str,
                 release_name: builtins.str):
        """
        :param builtins.str cloud_provider_name: The name of the cloud provider to connect with.
        :param builtins.str namespace: The namespace in Kubernetes to deploy to.
        :param builtins.str release_name: The naming convention of the release. When using Helm Native the default is ${infra.kubernetes.infraId}. For standard Kubernetes manifests the default is release-${infra.kubernetes.infraId}
        """
        pulumi.set(__self__, "cloud_provider_name", cloud_provider_name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "release_name", release_name)

    @property
    @pulumi.getter(name="cloudProviderName")
    def cloud_provider_name(self) -> builtins.str:
        """
        The name of the cloud provider to connect with.
        """
        return pulumi.get(self, "cloud_provider_name")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        The namespace in Kubernetes to deploy to.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="releaseName")
    def release_name(self) -> builtins.str:
        """
        The naming convention of the release. When using Helm Native the default is ${infra.kubernetes.infraId}. For standard Kubernetes manifests the default is release-${infra.kubernetes.infraId}
        """
        return pulumi.get(self, "release_name")


@pulumi.output_type
class InfrastructureDefinitionKubernetesGcp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudProviderName":
            suggest = "cloud_provider_name"
        elif key == "clusterName":
            suggest = "cluster_name"
        elif key == "releaseName":
            suggest = "release_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureDefinitionKubernetesGcp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureDefinitionKubernetesGcp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureDefinitionKubernetesGcp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_provider_name: builtins.str,
                 cluster_name: builtins.str,
                 namespace: builtins.str,
                 release_name: builtins.str):
        """
        :param builtins.str cloud_provider_name: The name of the cloud provider to connect with.
        :param builtins.str cluster_name: The name of the cluster being deployed to.
        :param builtins.str namespace: The namespace in Kubernetes to deploy to.
        :param builtins.str release_name: The naming convention of the release.
        """
        pulumi.set(__self__, "cloud_provider_name", cloud_provider_name)
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "release_name", release_name)

    @property
    @pulumi.getter(name="cloudProviderName")
    def cloud_provider_name(self) -> builtins.str:
        """
        The name of the cloud provider to connect with.
        """
        return pulumi.get(self, "cloud_provider_name")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> builtins.str:
        """
        The name of the cluster being deployed to.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        The namespace in Kubernetes to deploy to.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="releaseName")
    def release_name(self) -> builtins.str:
        """
        The naming convention of the release.
        """
        return pulumi.get(self, "release_name")


@pulumi.output_type
class InfrastructureDefinitionTanzu(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudProviderName":
            suggest = "cloud_provider_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfrastructureDefinitionTanzu. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfrastructureDefinitionTanzu.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfrastructureDefinitionTanzu.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_provider_name: builtins.str,
                 organization: builtins.str,
                 space: builtins.str):
        """
        :param builtins.str cloud_provider_name: The name of the cloud provider to connect with.
        :param builtins.str organization: The PCF organization to use.
        :param builtins.str space: The PCF space to deploy to.
        """
        pulumi.set(__self__, "cloud_provider_name", cloud_provider_name)
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "space", space)

    @property
    @pulumi.getter(name="cloudProviderName")
    def cloud_provider_name(self) -> builtins.str:
        """
        The name of the cloud provider to connect with.
        """
        return pulumi.get(self, "cloud_provider_name")

    @property
    @pulumi.getter
    def organization(self) -> builtins.str:
        """
        The PCF organization to use.
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter
    def space(self) -> builtins.str:
        """
        The PCF space to deploy to.
        """
        return pulumi.get(self, "space")


@pulumi.output_type
class PlatformCcmFiltersFilterProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filterType":
            suggest = "filter_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PlatformCcmFiltersFilterProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PlatformCcmFiltersFilterProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PlatformCcmFiltersFilterProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filter_type: builtins.str,
                 tags: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str filter_type: Type of CCM filters.
        :param Sequence[builtins.str] tags: Tags to associate with the resource. Tags should be in the form `name:value`.
        """
        pulumi.set(__self__, "filter_type", filter_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> builtins.str:
        """
        Type of CCM filters.
        """
        return pulumi.get(self, "filter_type")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[builtins.str]]:
        """
        Tags to associate with the resource. Tags should be in the form `name:value`.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class SshCredentialKerberosAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tgtGenerationMethod":
            suggest = "tgt_generation_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SshCredentialKerberosAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SshCredentialKerberosAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SshCredentialKerberosAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: builtins.int,
                 principal: builtins.str,
                 realm: builtins.str,
                 tgt_generation_method: Optional['outputs.SshCredentialKerberosAuthenticationTgtGenerationMethod'] = None):
        """
        :param builtins.int port: Port to use for Kerberos authentication
        :param builtins.str principal: Name of the principal for authentication
        :param builtins.str realm: Realm associated with the Kerberos authentication
        :param 'SshCredentialKerberosAuthenticationTgtGenerationMethodArgs' tgt_generation_method: TGT generation method
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "principal", principal)
        pulumi.set(__self__, "realm", realm)
        if tgt_generation_method is not None:
            pulumi.set(__self__, "tgt_generation_method", tgt_generation_method)

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        Port to use for Kerberos authentication
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def principal(self) -> builtins.str:
        """
        Name of the principal for authentication
        """
        return pulumi.get(self, "principal")

    @property
    @pulumi.getter
    def realm(self) -> builtins.str:
        """
        Realm associated with the Kerberos authentication
        """
        return pulumi.get(self, "realm")

    @property
    @pulumi.getter(name="tgtGenerationMethod")
    def tgt_generation_method(self) -> Optional['outputs.SshCredentialKerberosAuthenticationTgtGenerationMethod']:
        """
        TGT generation method
        """
        return pulumi.get(self, "tgt_generation_method")


@pulumi.output_type
class SshCredentialKerberosAuthenticationTgtGenerationMethod(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kerberosPasswordId":
            suggest = "kerberos_password_id"
        elif key == "keyTabFilePath":
            suggest = "key_tab_file_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SshCredentialKerberosAuthenticationTgtGenerationMethod. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SshCredentialKerberosAuthenticationTgtGenerationMethod.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SshCredentialKerberosAuthenticationTgtGenerationMethod.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kerberos_password_id: Optional[builtins.str] = None,
                 key_tab_file_path: Optional[builtins.str] = None):
        """
        :param builtins.str kerberos_password_id: The id of the encrypted text secret
        :param builtins.str key_tab_file_path: The path to the key tab file
        """
        if kerberos_password_id is not None:
            pulumi.set(__self__, "kerberos_password_id", kerberos_password_id)
        if key_tab_file_path is not None:
            pulumi.set(__self__, "key_tab_file_path", key_tab_file_path)

    @property
    @pulumi.getter(name="kerberosPasswordId")
    def kerberos_password_id(self) -> Optional[builtins.str]:
        """
        The id of the encrypted text secret
        """
        return pulumi.get(self, "kerberos_password_id")

    @property
    @pulumi.getter(name="keyTabFilePath")
    def key_tab_file_path(self) -> Optional[builtins.str]:
        """
        The path to the key tab file
        """
        return pulumi.get(self, "key_tab_file_path")


@pulumi.output_type
class SshCredentialSshAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inlineSsh":
            suggest = "inline_ssh"
        elif key == "serverPassword":
            suggest = "server_password"
        elif key == "sshKeyFile":
            suggest = "ssh_key_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SshCredentialSshAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SshCredentialSshAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SshCredentialSshAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: builtins.int,
                 username: builtins.str,
                 inline_ssh: Optional['outputs.SshCredentialSshAuthenticationInlineSsh'] = None,
                 server_password: Optional['outputs.SshCredentialSshAuthenticationServerPassword'] = None,
                 ssh_key_file: Optional['outputs.SshCredentialSshAuthenticationSshKeyFile'] = None):
        """
        :param builtins.int port: The port to connect to
        :param builtins.str username: The username to use when connecting to ssh
        :param 'SshCredentialSshAuthenticationInlineSshArgs' inline_ssh: Inline SSH authentication configuration. Only ond of `passphrase_secret_id` or `ssh_key_file_id` should be used
        :param 'SshCredentialSshAuthenticationServerPasswordArgs' server_password: Server password authentication configuration
        :param 'SshCredentialSshAuthenticationSshKeyFileArgs' ssh_key_file: Use ssh key file for authentication
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "username", username)
        if inline_ssh is not None:
            pulumi.set(__self__, "inline_ssh", inline_ssh)
        if server_password is not None:
            pulumi.set(__self__, "server_password", server_password)
        if ssh_key_file is not None:
            pulumi.set(__self__, "ssh_key_file", ssh_key_file)

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The port to connect to
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        """
        The username to use when connecting to ssh
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="inlineSsh")
    def inline_ssh(self) -> Optional['outputs.SshCredentialSshAuthenticationInlineSsh']:
        """
        Inline SSH authentication configuration. Only ond of `passphrase_secret_id` or `ssh_key_file_id` should be used
        """
        return pulumi.get(self, "inline_ssh")

    @property
    @pulumi.getter(name="serverPassword")
    def server_password(self) -> Optional['outputs.SshCredentialSshAuthenticationServerPassword']:
        """
        Server password authentication configuration
        """
        return pulumi.get(self, "server_password")

    @property
    @pulumi.getter(name="sshKeyFile")
    def ssh_key_file(self) -> Optional['outputs.SshCredentialSshAuthenticationSshKeyFile']:
        """
        Use ssh key file for authentication
        """
        return pulumi.get(self, "ssh_key_file")


@pulumi.output_type
class SshCredentialSshAuthenticationInlineSsh(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshKeyFileId":
            suggest = "ssh_key_file_id"
        elif key == "passphraseSecretId":
            suggest = "passphrase_secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SshCredentialSshAuthenticationInlineSsh. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SshCredentialSshAuthenticationInlineSsh.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SshCredentialSshAuthenticationInlineSsh.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ssh_key_file_id: builtins.str,
                 passphrase_secret_id: Optional[builtins.str] = None):
        """
        :param builtins.str ssh_key_file_id: The id of the secret containing the SSH key
        :param builtins.str passphrase_secret_id: The id of the encrypted secret to use
        """
        pulumi.set(__self__, "ssh_key_file_id", ssh_key_file_id)
        if passphrase_secret_id is not None:
            pulumi.set(__self__, "passphrase_secret_id", passphrase_secret_id)

    @property
    @pulumi.getter(name="sshKeyFileId")
    def ssh_key_file_id(self) -> builtins.str:
        """
        The id of the secret containing the SSH key
        """
        return pulumi.get(self, "ssh_key_file_id")

    @property
    @pulumi.getter(name="passphraseSecretId")
    def passphrase_secret_id(self) -> Optional[builtins.str]:
        """
        The id of the encrypted secret to use
        """
        return pulumi.get(self, "passphrase_secret_id")


@pulumi.output_type
class SshCredentialSshAuthenticationServerPassword(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordSecretId":
            suggest = "password_secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SshCredentialSshAuthenticationServerPassword. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SshCredentialSshAuthenticationServerPassword.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SshCredentialSshAuthenticationServerPassword.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password_secret_id: builtins.str):
        """
        :param builtins.str password_secret_id: The id of the encrypted secret
        """
        pulumi.set(__self__, "password_secret_id", password_secret_id)

    @property
    @pulumi.getter(name="passwordSecretId")
    def password_secret_id(self) -> builtins.str:
        """
        The id of the encrypted secret
        """
        return pulumi.get(self, "password_secret_id")


@pulumi.output_type
class SshCredentialSshAuthenticationSshKeyFile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passphraseSecretId":
            suggest = "passphrase_secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SshCredentialSshAuthenticationSshKeyFile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SshCredentialSshAuthenticationSshKeyFile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SshCredentialSshAuthenticationSshKeyFile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: builtins.str,
                 passphrase_secret_id: Optional[builtins.str] = None):
        """
        :param builtins.str path: The path to the key file on the delegate
        :param builtins.str passphrase_secret_id: The id of the secret containing the password to use for the ssh key
        """
        pulumi.set(__self__, "path", path)
        if passphrase_secret_id is not None:
            pulumi.set(__self__, "passphrase_secret_id", passphrase_secret_id)

    @property
    @pulumi.getter
    def path(self) -> builtins.str:
        """
        The path to the key file on the delegate
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="passphraseSecretId")
    def passphrase_secret_id(self) -> Optional[builtins.str]:
        """
        The id of the secret containing the password to use for the ssh key
        """
        return pulumi.get(self, "passphrase_secret_id")


@pulumi.output_type
class SshCredentialUsageScope(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationId":
            suggest = "application_id"
        elif key == "environmentFilterType":
            suggest = "environment_filter_type"
        elif key == "environmentId":
            suggest = "environment_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SshCredentialUsageScope. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SshCredentialUsageScope.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SshCredentialUsageScope.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_id: Optional[builtins.str] = None,
                 environment_filter_type: Optional[builtins.str] = None,
                 environment_id: Optional[builtins.str] = None):
        """
        :param builtins.str application_id: Id of the application to scope to. If empty then this scope applies to all applications.
        :param builtins.str environment_filter_type: Type of environment filter applied. Cannot be used with `environment_id`. Valid options are NON*PRODUCTION*ENVIRONMENTS, PRODUCTION_ENVIRONMENTS.
        :param builtins.str environment_id: Id of the id of the specific environment to scope to. Cannot be used with `environment_filter_type`.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if environment_filter_type is not None:
            pulumi.set(__self__, "environment_filter_type", environment_filter_type)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[builtins.str]:
        """
        Id of the application to scope to. If empty then this scope applies to all applications.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="environmentFilterType")
    def environment_filter_type(self) -> Optional[builtins.str]:
        """
        Type of environment filter applied. Cannot be used with `environment_id`. Valid options are NON*PRODUCTION*ENVIRONMENTS, PRODUCTION_ENVIRONMENTS.
        """
        return pulumi.get(self, "environment_filter_type")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[builtins.str]:
        """
        Id of the id of the specific environment to scope to. Cannot be used with `environment_filter_type`.
        """
        return pulumi.get(self, "environment_id")


@pulumi.output_type
class UserGroupLdapSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupDn":
            suggest = "group_dn"
        elif key == "groupName":
            suggest = "group_name"
        elif key == "ssoProviderId":
            suggest = "sso_provider_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserGroupLdapSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserGroupLdapSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserGroupLdapSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_dn: Optional[builtins.str] = None,
                 group_name: Optional[builtins.str] = None,
                 sso_provider_id: Optional[builtins.str] = None):
        """
        :param builtins.str group_dn: The group DN of the LDAP user group.
        :param builtins.str group_name: The group name of the LDAP user group.
        :param builtins.str sso_provider_id: The ID of the SSO provider.
        """
        if group_dn is not None:
            pulumi.set(__self__, "group_dn", group_dn)
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if sso_provider_id is not None:
            pulumi.set(__self__, "sso_provider_id", sso_provider_id)

    @property
    @pulumi.getter(name="groupDn")
    def group_dn(self) -> Optional[builtins.str]:
        """
        The group DN of the LDAP user group.
        """
        return pulumi.get(self, "group_dn")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[builtins.str]:
        """
        The group name of the LDAP user group.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter(name="ssoProviderId")
    def sso_provider_id(self) -> Optional[builtins.str]:
        """
        The ID of the SSO provider.
        """
        return pulumi.get(self, "sso_provider_id")


@pulumi.output_type
class UserGroupNotificationSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupEmailAddresses":
            suggest = "group_email_addresses"
        elif key == "microsoftTeamsWebhookUrl":
            suggest = "microsoft_teams_webhook_url"
        elif key == "sendMailToNewMembers":
            suggest = "send_mail_to_new_members"
        elif key == "sendNotificationsToMembers":
            suggest = "send_notifications_to_members"
        elif key == "slackChannel":
            suggest = "slack_channel"
        elif key == "slackWebhookUrl":
            suggest = "slack_webhook_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserGroupNotificationSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserGroupNotificationSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserGroupNotificationSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_email_addresses: Optional[Sequence[builtins.str]] = None,
                 microsoft_teams_webhook_url: Optional[builtins.str] = None,
                 send_mail_to_new_members: Optional[builtins.bool] = None,
                 send_notifications_to_members: Optional[builtins.bool] = None,
                 slack_channel: Optional[builtins.str] = None,
                 slack_webhook_url: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] group_email_addresses: The email addresses of the user group.
        :param builtins.str microsoft_teams_webhook_url: The Microsoft Teams webhook URL of the user group.
        :param builtins.bool send_mail_to_new_members: Indicates whether an email is sent when a new user is added to the group.
        :param builtins.bool send_notifications_to_members: Enable this setting to have notifications sent to the members of this group.
        :param builtins.str slack_channel: The Slack channel to send notifications to.
        :param builtins.str slack_webhook_url: The Slack webhook URL to send notifications to.
        """
        if group_email_addresses is not None:
            pulumi.set(__self__, "group_email_addresses", group_email_addresses)
        if microsoft_teams_webhook_url is not None:
            pulumi.set(__self__, "microsoft_teams_webhook_url", microsoft_teams_webhook_url)
        if send_mail_to_new_members is not None:
            pulumi.set(__self__, "send_mail_to_new_members", send_mail_to_new_members)
        if send_notifications_to_members is not None:
            pulumi.set(__self__, "send_notifications_to_members", send_notifications_to_members)
        if slack_channel is not None:
            pulumi.set(__self__, "slack_channel", slack_channel)
        if slack_webhook_url is not None:
            pulumi.set(__self__, "slack_webhook_url", slack_webhook_url)

    @property
    @pulumi.getter(name="groupEmailAddresses")
    def group_email_addresses(self) -> Optional[Sequence[builtins.str]]:
        """
        The email addresses of the user group.
        """
        return pulumi.get(self, "group_email_addresses")

    @property
    @pulumi.getter(name="microsoftTeamsWebhookUrl")
    def microsoft_teams_webhook_url(self) -> Optional[builtins.str]:
        """
        The Microsoft Teams webhook URL of the user group.
        """
        return pulumi.get(self, "microsoft_teams_webhook_url")

    @property
    @pulumi.getter(name="sendMailToNewMembers")
    def send_mail_to_new_members(self) -> Optional[builtins.bool]:
        """
        Indicates whether an email is sent when a new user is added to the group.
        """
        return pulumi.get(self, "send_mail_to_new_members")

    @property
    @pulumi.getter(name="sendNotificationsToMembers")
    def send_notifications_to_members(self) -> Optional[builtins.bool]:
        """
        Enable this setting to have notifications sent to the members of this group.
        """
        return pulumi.get(self, "send_notifications_to_members")

    @property
    @pulumi.getter(name="slackChannel")
    def slack_channel(self) -> Optional[builtins.str]:
        """
        The Slack channel to send notifications to.
        """
        return pulumi.get(self, "slack_channel")

    @property
    @pulumi.getter(name="slackWebhookUrl")
    def slack_webhook_url(self) -> Optional[builtins.str]:
        """
        The Slack webhook URL to send notifications to.
        """
        return pulumi.get(self, "slack_webhook_url")


@pulumi.output_type
class UserGroupPermissions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountPermissions":
            suggest = "account_permissions"
        elif key == "appPermissions":
            suggest = "app_permissions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserGroupPermissions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserGroupPermissions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserGroupPermissions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_permissions: Optional[Sequence[builtins.str]] = None,
                 app_permissions: Optional['outputs.UserGroupPermissionsAppPermissions'] = None):
        """
        :param Sequence[builtins.str] account_permissions: The account permissions of the user group. Valid options are ADMINISTER*OTHER*ACCOUNT*FUNCTIONS, CREATE*AND*DELETE*APPLICATION, CREATE*CUSTOM*DASHBOARDS, MANAGE*ALERT*NOTIFICATION*RULES, MANAGE*API*KEYS, MANAGE*APPLICATION*STACKS, MANAGE*AUTHENTICATION*SETTINGS, MANAGE*CLOUD*PROVIDERS, MANAGE*CONFIG*AS*CODE, MANAGE*CONNECTORS, MANAGE*CUSTOM*DASHBOARDS, MANAGE*DELEGATE*PROFILES, MANAGE*DELEGATES, MANAGE*DEPLOYMENT*FREEZES, MANAGE*IP*WHITELIST, MANAGE*PIPELINE*GOVERNANCE*STANDARDS, MANAGE*RESTRICTED*ACCESS, MANAGE*SECRET*MANAGERS, MANAGE*SECRETS, MANAGE*SSH*AND*WINRM, MANAGE*TAGS, MANAGE*TEMPLATE*LIBRARY, MANAGE*USER*AND*USER*GROUPS*AND*API*KEYS, MANAGE*USERS*AND*GROUPS, READ*USERS*AND*GROUPS, VIEW*AUDITS, VIEW*USER*AND*USER*GROUPS*AND*API_KEYS
        :param 'UserGroupPermissionsAppPermissionsArgs' app_permissions: Application specific permissions
        """
        if account_permissions is not None:
            pulumi.set(__self__, "account_permissions", account_permissions)
        if app_permissions is not None:
            pulumi.set(__self__, "app_permissions", app_permissions)

    @property
    @pulumi.getter(name="accountPermissions")
    def account_permissions(self) -> Optional[Sequence[builtins.str]]:
        """
        The account permissions of the user group. Valid options are ADMINISTER*OTHER*ACCOUNT*FUNCTIONS, CREATE*AND*DELETE*APPLICATION, CREATE*CUSTOM*DASHBOARDS, MANAGE*ALERT*NOTIFICATION*RULES, MANAGE*API*KEYS, MANAGE*APPLICATION*STACKS, MANAGE*AUTHENTICATION*SETTINGS, MANAGE*CLOUD*PROVIDERS, MANAGE*CONFIG*AS*CODE, MANAGE*CONNECTORS, MANAGE*CUSTOM*DASHBOARDS, MANAGE*DELEGATE*PROFILES, MANAGE*DELEGATES, MANAGE*DEPLOYMENT*FREEZES, MANAGE*IP*WHITELIST, MANAGE*PIPELINE*GOVERNANCE*STANDARDS, MANAGE*RESTRICTED*ACCESS, MANAGE*SECRET*MANAGERS, MANAGE*SECRETS, MANAGE*SSH*AND*WINRM, MANAGE*TAGS, MANAGE*TEMPLATE*LIBRARY, MANAGE*USER*AND*USER*GROUPS*AND*API*KEYS, MANAGE*USERS*AND*GROUPS, READ*USERS*AND*GROUPS, VIEW*AUDITS, VIEW*USER*AND*USER*GROUPS*AND*API_KEYS
        """
        return pulumi.get(self, "account_permissions")

    @property
    @pulumi.getter(name="appPermissions")
    def app_permissions(self) -> Optional['outputs.UserGroupPermissionsAppPermissions']:
        """
        Application specific permissions
        """
        return pulumi.get(self, "app_permissions")


@pulumi.output_type
class UserGroupPermissionsAppPermissions(dict):
    def __init__(__self__, *,
                 alls: Optional[Sequence['outputs.UserGroupPermissionsAppPermissionsAll']] = None,
                 deployments: Optional[Sequence['outputs.UserGroupPermissionsAppPermissionsDeployment']] = None,
                 environments: Optional[Sequence['outputs.UserGroupPermissionsAppPermissionsEnvironment']] = None,
                 pipelines: Optional[Sequence['outputs.UserGroupPermissionsAppPermissionsPipeline']] = None,
                 provisioners: Optional[Sequence['outputs.UserGroupPermissionsAppPermissionsProvisioner']] = None,
                 services: Optional[Sequence['outputs.UserGroupPermissionsAppPermissionsService']] = None,
                 templates: Optional[Sequence['outputs.UserGroupPermissionsAppPermissionsTemplate']] = None,
                 workflows: Optional[Sequence['outputs.UserGroupPermissionsAppPermissionsWorkflow']] = None):
        """
        :param Sequence['UserGroupPermissionsAppPermissionsAllArgs'] alls: The permission to perform actions against all resources.
        :param Sequence['UserGroupPermissionsAppPermissionsDeploymentArgs'] deployments: Permission configuration to perform actions against deployments.
        :param Sequence['UserGroupPermissionsAppPermissionsEnvironmentArgs'] environments: Permission configuration to perform actions against workflows.
        :param Sequence['UserGroupPermissionsAppPermissionsPipelineArgs'] pipelines: Permission configuration to perform actions against pipelines.
        :param Sequence['UserGroupPermissionsAppPermissionsProvisionerArgs'] provisioners: Permission configuration to perform actions against provisioners.
        :param Sequence['UserGroupPermissionsAppPermissionsServiceArgs'] services: Permission configuration to perform actions against services.
        :param Sequence['UserGroupPermissionsAppPermissionsTemplateArgs'] templates: Permission configuration to perform actions against templates.
        :param Sequence['UserGroupPermissionsAppPermissionsWorkflowArgs'] workflows: Permission configuration to perform actions against workflows.
        """
        if alls is not None:
            pulumi.set(__self__, "alls", alls)
        if deployments is not None:
            pulumi.set(__self__, "deployments", deployments)
        if environments is not None:
            pulumi.set(__self__, "environments", environments)
        if pipelines is not None:
            pulumi.set(__self__, "pipelines", pipelines)
        if provisioners is not None:
            pulumi.set(__self__, "provisioners", provisioners)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if templates is not None:
            pulumi.set(__self__, "templates", templates)
        if workflows is not None:
            pulumi.set(__self__, "workflows", workflows)

    @property
    @pulumi.getter
    def alls(self) -> Optional[Sequence['outputs.UserGroupPermissionsAppPermissionsAll']]:
        """
        The permission to perform actions against all resources.
        """
        return pulumi.get(self, "alls")

    @property
    @pulumi.getter
    def deployments(self) -> Optional[Sequence['outputs.UserGroupPermissionsAppPermissionsDeployment']]:
        """
        Permission configuration to perform actions against deployments.
        """
        return pulumi.get(self, "deployments")

    @property
    @pulumi.getter
    def environments(self) -> Optional[Sequence['outputs.UserGroupPermissionsAppPermissionsEnvironment']]:
        """
        Permission configuration to perform actions against workflows.
        """
        return pulumi.get(self, "environments")

    @property
    @pulumi.getter
    def pipelines(self) -> Optional[Sequence['outputs.UserGroupPermissionsAppPermissionsPipeline']]:
        """
        Permission configuration to perform actions against pipelines.
        """
        return pulumi.get(self, "pipelines")

    @property
    @pulumi.getter
    def provisioners(self) -> Optional[Sequence['outputs.UserGroupPermissionsAppPermissionsProvisioner']]:
        """
        Permission configuration to perform actions against provisioners.
        """
        return pulumi.get(self, "provisioners")

    @property
    @pulumi.getter
    def services(self) -> Optional[Sequence['outputs.UserGroupPermissionsAppPermissionsService']]:
        """
        Permission configuration to perform actions against services.
        """
        return pulumi.get(self, "services")

    @property
    @pulumi.getter
    def templates(self) -> Optional[Sequence['outputs.UserGroupPermissionsAppPermissionsTemplate']]:
        """
        Permission configuration to perform actions against templates.
        """
        return pulumi.get(self, "templates")

    @property
    @pulumi.getter
    def workflows(self) -> Optional[Sequence['outputs.UserGroupPermissionsAppPermissionsWorkflow']]:
        """
        Permission configuration to perform actions against workflows.
        """
        return pulumi.get(self, "workflows")


@pulumi.output_type
class UserGroupPermissionsAppPermissionsAll(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appIds":
            suggest = "app_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserGroupPermissionsAppPermissionsAll. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserGroupPermissionsAppPermissionsAll.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserGroupPermissionsAppPermissionsAll.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions: Sequence[builtins.str],
                 app_ids: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] actions: The actions allowed to be performed. Valid options are CREATE, READ, UPDATE, DELETE, EXECUTE*WORKFLOW, EXECUTE*PIPELINE, ROLLBACK_WORKFLOW
        :param Sequence[builtins.str] app_ids: The application IDs to which the permission applies. Leave empty to apply to all applications.
        """
        pulumi.set(__self__, "actions", actions)
        if app_ids is not None:
            pulumi.set(__self__, "app_ids", app_ids)

    @property
    @pulumi.getter
    def actions(self) -> Sequence[builtins.str]:
        """
        The actions allowed to be performed. Valid options are CREATE, READ, UPDATE, DELETE, EXECUTE*WORKFLOW, EXECUTE*PIPELINE, ROLLBACK_WORKFLOW
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="appIds")
    def app_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The application IDs to which the permission applies. Leave empty to apply to all applications.
        """
        return pulumi.get(self, "app_ids")


@pulumi.output_type
class UserGroupPermissionsAppPermissionsDeployment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appIds":
            suggest = "app_ids"
        elif key == "envIds":
            suggest = "env_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserGroupPermissionsAppPermissionsDeployment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserGroupPermissionsAppPermissionsDeployment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserGroupPermissionsAppPermissionsDeployment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions: Sequence[builtins.str],
                 app_ids: Optional[Sequence[builtins.str]] = None,
                 env_ids: Optional[Sequence[builtins.str]] = None,
                 filters: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] actions: The actions allowed to be performed. Valid options are READ, EXECUTE*WORKFLOW, EXECUTE*PIPELINE, ROLLBACK*WORKFLOW, ABORT*WORKFLOW
        :param Sequence[builtins.str] app_ids: The application IDs to which the permission applies. Leave empty to apply to all applications.
        :param Sequence[builtins.str] env_ids: The environment IDs to which the permission applies. Leave empty to apply to all environments.
        :param Sequence[builtins.str] filters: The filters to apply to the action. Valid options are: NON*PRODUCTION*ENVIRONMENTS, PRODUCTION_ENVIRONMENTS.
        """
        pulumi.set(__self__, "actions", actions)
        if app_ids is not None:
            pulumi.set(__self__, "app_ids", app_ids)
        if env_ids is not None:
            pulumi.set(__self__, "env_ids", env_ids)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)

    @property
    @pulumi.getter
    def actions(self) -> Sequence[builtins.str]:
        """
        The actions allowed to be performed. Valid options are READ, EXECUTE*WORKFLOW, EXECUTE*PIPELINE, ROLLBACK*WORKFLOW, ABORT*WORKFLOW
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="appIds")
    def app_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The application IDs to which the permission applies. Leave empty to apply to all applications.
        """
        return pulumi.get(self, "app_ids")

    @property
    @pulumi.getter(name="envIds")
    def env_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The environment IDs to which the permission applies. Leave empty to apply to all environments.
        """
        return pulumi.get(self, "env_ids")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence[builtins.str]]:
        """
        The filters to apply to the action. Valid options are: NON*PRODUCTION*ENVIRONMENTS, PRODUCTION_ENVIRONMENTS.
        """
        return pulumi.get(self, "filters")


@pulumi.output_type
class UserGroupPermissionsAppPermissionsEnvironment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appIds":
            suggest = "app_ids"
        elif key == "envIds":
            suggest = "env_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserGroupPermissionsAppPermissionsEnvironment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserGroupPermissionsAppPermissionsEnvironment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserGroupPermissionsAppPermissionsEnvironment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions: Sequence[builtins.str],
                 app_ids: Optional[Sequence[builtins.str]] = None,
                 env_ids: Optional[Sequence[builtins.str]] = None,
                 filters: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] actions: The actions allowed to be performed. Valid options are CREATE, READ, UPDATE, DELETE
        :param Sequence[builtins.str] app_ids: The application IDs to which the permission applies. Leave empty to apply to all applications.
        :param Sequence[builtins.str] env_ids: The environment IDs to which the permission applies. Leave empty to apply to all environments.
        :param Sequence[builtins.str] filters: The filters to apply to the action. Valid options are: NON*PRODUCTION*ENVIRONMENTS, PRODUCTION_ENVIRONMENTS.
        """
        pulumi.set(__self__, "actions", actions)
        if app_ids is not None:
            pulumi.set(__self__, "app_ids", app_ids)
        if env_ids is not None:
            pulumi.set(__self__, "env_ids", env_ids)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)

    @property
    @pulumi.getter
    def actions(self) -> Sequence[builtins.str]:
        """
        The actions allowed to be performed. Valid options are CREATE, READ, UPDATE, DELETE
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="appIds")
    def app_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The application IDs to which the permission applies. Leave empty to apply to all applications.
        """
        return pulumi.get(self, "app_ids")

    @property
    @pulumi.getter(name="envIds")
    def env_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The environment IDs to which the permission applies. Leave empty to apply to all environments.
        """
        return pulumi.get(self, "env_ids")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence[builtins.str]]:
        """
        The filters to apply to the action. Valid options are: NON*PRODUCTION*ENVIRONMENTS, PRODUCTION_ENVIRONMENTS.
        """
        return pulumi.get(self, "filters")


@pulumi.output_type
class UserGroupPermissionsAppPermissionsPipeline(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appIds":
            suggest = "app_ids"
        elif key == "envIds":
            suggest = "env_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserGroupPermissionsAppPermissionsPipeline. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserGroupPermissionsAppPermissionsPipeline.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserGroupPermissionsAppPermissionsPipeline.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions: Sequence[builtins.str],
                 app_ids: Optional[Sequence[builtins.str]] = None,
                 env_ids: Optional[Sequence[builtins.str]] = None,
                 filters: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] actions: The actions allowed to be performed. Valid options are [CREATE READ UPDATE DELETE]
        :param Sequence[builtins.str] app_ids: The application IDs to which the permission applies. Leave empty to apply to all applications.
        :param Sequence[builtins.str] env_ids: The environment IDs to which the permission applies. Leave empty to apply to all environments.
        :param Sequence[builtins.str] filters: The filters to apply to the action. Valid options are: NON*PRODUCTION*PIPELINES, PRODUCTION_PIPELINES.
        """
        pulumi.set(__self__, "actions", actions)
        if app_ids is not None:
            pulumi.set(__self__, "app_ids", app_ids)
        if env_ids is not None:
            pulumi.set(__self__, "env_ids", env_ids)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)

    @property
    @pulumi.getter
    def actions(self) -> Sequence[builtins.str]:
        """
        The actions allowed to be performed. Valid options are [CREATE READ UPDATE DELETE]
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="appIds")
    def app_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The application IDs to which the permission applies. Leave empty to apply to all applications.
        """
        return pulumi.get(self, "app_ids")

    @property
    @pulumi.getter(name="envIds")
    def env_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The environment IDs to which the permission applies. Leave empty to apply to all environments.
        """
        return pulumi.get(self, "env_ids")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence[builtins.str]]:
        """
        The filters to apply to the action. Valid options are: NON*PRODUCTION*PIPELINES, PRODUCTION_PIPELINES.
        """
        return pulumi.get(self, "filters")


@pulumi.output_type
class UserGroupPermissionsAppPermissionsProvisioner(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appIds":
            suggest = "app_ids"
        elif key == "provisionerIds":
            suggest = "provisioner_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserGroupPermissionsAppPermissionsProvisioner. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserGroupPermissionsAppPermissionsProvisioner.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserGroupPermissionsAppPermissionsProvisioner.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions: Sequence[builtins.str],
                 app_ids: Optional[Sequence[builtins.str]] = None,
                 provisioner_ids: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] actions: The actions allowed to be performed. Valid options are CREATE, READ, UPDATE, DELETE
        :param Sequence[builtins.str] app_ids: The application IDs to which the permission applies. Leave empty to apply to all applications.
        :param Sequence[builtins.str] provisioner_ids: The provisioner IDs to which the permission applies. Leave empty to apply to all provisioners.
        """
        pulumi.set(__self__, "actions", actions)
        if app_ids is not None:
            pulumi.set(__self__, "app_ids", app_ids)
        if provisioner_ids is not None:
            pulumi.set(__self__, "provisioner_ids", provisioner_ids)

    @property
    @pulumi.getter
    def actions(self) -> Sequence[builtins.str]:
        """
        The actions allowed to be performed. Valid options are CREATE, READ, UPDATE, DELETE
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="appIds")
    def app_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The application IDs to which the permission applies. Leave empty to apply to all applications.
        """
        return pulumi.get(self, "app_ids")

    @property
    @pulumi.getter(name="provisionerIds")
    def provisioner_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The provisioner IDs to which the permission applies. Leave empty to apply to all provisioners.
        """
        return pulumi.get(self, "provisioner_ids")


@pulumi.output_type
class UserGroupPermissionsAppPermissionsService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appIds":
            suggest = "app_ids"
        elif key == "serviceIds":
            suggest = "service_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserGroupPermissionsAppPermissionsService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserGroupPermissionsAppPermissionsService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserGroupPermissionsAppPermissionsService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions: Sequence[builtins.str],
                 app_ids: Optional[Sequence[builtins.str]] = None,
                 service_ids: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] actions: The actions allowed to be performed. Valid options are CREATE, READ, UPDATE, DELETE
        :param Sequence[builtins.str] app_ids: The application IDs to which the permission applies. Leave empty to apply to all applications.
        :param Sequence[builtins.str] service_ids: The service IDs to which the permission applies. Leave empty to apply to all services.
        """
        pulumi.set(__self__, "actions", actions)
        if app_ids is not None:
            pulumi.set(__self__, "app_ids", app_ids)
        if service_ids is not None:
            pulumi.set(__self__, "service_ids", service_ids)

    @property
    @pulumi.getter
    def actions(self) -> Sequence[builtins.str]:
        """
        The actions allowed to be performed. Valid options are CREATE, READ, UPDATE, DELETE
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="appIds")
    def app_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The application IDs to which the permission applies. Leave empty to apply to all applications.
        """
        return pulumi.get(self, "app_ids")

    @property
    @pulumi.getter(name="serviceIds")
    def service_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The service IDs to which the permission applies. Leave empty to apply to all services.
        """
        return pulumi.get(self, "service_ids")


@pulumi.output_type
class UserGroupPermissionsAppPermissionsTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appIds":
            suggest = "app_ids"
        elif key == "templateIds":
            suggest = "template_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserGroupPermissionsAppPermissionsTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserGroupPermissionsAppPermissionsTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserGroupPermissionsAppPermissionsTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions: Sequence[builtins.str],
                 app_ids: Optional[Sequence[builtins.str]] = None,
                 template_ids: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] actions: The actions allowed to be performed. Valid options are CREATE, READ, UPDATE, DELETE
        :param Sequence[builtins.str] app_ids: The application IDs to which the permission applies. Leave empty to apply to all applications.
        :param Sequence[builtins.str] template_ids: The template IDs to which the permission applies. Leave empty to apply to all environments.
        """
        pulumi.set(__self__, "actions", actions)
        if app_ids is not None:
            pulumi.set(__self__, "app_ids", app_ids)
        if template_ids is not None:
            pulumi.set(__self__, "template_ids", template_ids)

    @property
    @pulumi.getter
    def actions(self) -> Sequence[builtins.str]:
        """
        The actions allowed to be performed. Valid options are CREATE, READ, UPDATE, DELETE
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="appIds")
    def app_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The application IDs to which the permission applies. Leave empty to apply to all applications.
        """
        return pulumi.get(self, "app_ids")

    @property
    @pulumi.getter(name="templateIds")
    def template_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The template IDs to which the permission applies. Leave empty to apply to all environments.
        """
        return pulumi.get(self, "template_ids")


@pulumi.output_type
class UserGroupPermissionsAppPermissionsWorkflow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appIds":
            suggest = "app_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserGroupPermissionsAppPermissionsWorkflow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserGroupPermissionsAppPermissionsWorkflow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserGroupPermissionsAppPermissionsWorkflow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions: Sequence[builtins.str],
                 app_ids: Optional[Sequence[builtins.str]] = None,
                 filters: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] actions: The actions allowed to be performed. Valid options are CREATE, READ, UPDATE, DELETE
        :param Sequence[builtins.str] app_ids: The application IDs to which the permission applies. Leave empty to apply to all applications.
        :param Sequence[builtins.str] filters: The filters to apply to the action. Valid options are: NON*PRODUCTION*WORKFLOWS, PRODUCTION*WORKFLOWS, WORKFLOW*TEMPLATES.
        """
        pulumi.set(__self__, "actions", actions)
        if app_ids is not None:
            pulumi.set(__self__, "app_ids", app_ids)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)

    @property
    @pulumi.getter
    def actions(self) -> Sequence[builtins.str]:
        """
        The actions allowed to be performed. Valid options are CREATE, READ, UPDATE, DELETE
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="appIds")
    def app_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The application IDs to which the permission applies. Leave empty to apply to all applications.
        """
        return pulumi.get(self, "app_ids")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence[builtins.str]]:
        """
        The filters to apply to the action. Valid options are: NON*PRODUCTION*WORKFLOWS, PRODUCTION*WORKFLOWS, WORKFLOW*TEMPLATES.
        """
        return pulumi.get(self, "filters")


@pulumi.output_type
class UserGroupSamlSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupName":
            suggest = "group_name"
        elif key == "ssoProviderId":
            suggest = "sso_provider_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserGroupSamlSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserGroupSamlSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserGroupSamlSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_name: Optional[builtins.str] = None,
                 sso_provider_id: Optional[builtins.str] = None):
        """
        :param builtins.str group_name: The group name of the SAML user group.
        :param builtins.str sso_provider_id: The ID of the SSO provider.
        """
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if sso_provider_id is not None:
            pulumi.set(__self__, "sso_provider_id", sso_provider_id)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[builtins.str]:
        """
        The group name of the SAML user group.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter(name="ssoProviderId")
    def sso_provider_id(self) -> Optional[builtins.str]:
        """
        The ID of the SSO provider.
        """
        return pulumi.get(self, "sso_provider_id")


@pulumi.output_type
class GetEncryptedTextUsageScopeResult(dict):
    def __init__(__self__, *,
                 application_id: Optional[builtins.str] = None,
                 environment_filter_type: Optional[builtins.str] = None,
                 environment_id: Optional[builtins.str] = None):
        """
        :param builtins.str application_id: Id of the application to scope to. If empty then this scope applies to all applications.
        :param builtins.str environment_filter_type: Type of environment filter applied. Cannot be used with `environment_id`. Valid options are NON*PRODUCTION*ENVIRONMENTS, PRODUCTION_ENVIRONMENTS.
        :param builtins.str environment_id: Id of the id of the specific environment to scope to. Cannot be used with `environment_filter_type`.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if environment_filter_type is not None:
            pulumi.set(__self__, "environment_filter_type", environment_filter_type)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[builtins.str]:
        """
        Id of the application to scope to. If empty then this scope applies to all applications.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="environmentFilterType")
    def environment_filter_type(self) -> Optional[builtins.str]:
        """
        Type of environment filter applied. Cannot be used with `environment_id`. Valid options are NON*PRODUCTION*ENVIRONMENTS, PRODUCTION_ENVIRONMENTS.
        """
        return pulumi.get(self, "environment_filter_type")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[builtins.str]:
        """
        Id of the id of the specific environment to scope to. Cannot be used with `environment_filter_type`.
        """
        return pulumi.get(self, "environment_id")


@pulumi.output_type
class GetEnvironmentVariableOverrideResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 service_name: builtins.str,
                 type: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: The name of the variable
        :param builtins.str service_name: The name of the service
        :param builtins.str type: The type of the service variable. Valid values are `TEXT` and `ENCRYPTED_TEXT`
        :param builtins.str value: The value of the service variable
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the variable
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> builtins.str:
        """
        The name of the service
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the service variable. Valid values are `TEXT` and `ENCRYPTED_TEXT`
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the service variable
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetGitConnectorCommitDetailResult(dict):
    def __init__(__self__, *,
                 author_email_id: builtins.str,
                 author_name: builtins.str,
                 message: builtins.str):
        """
        :param builtins.str author_email_id: The email id of the author.
        :param builtins.str author_name: The name of the author.
        :param builtins.str message: Commit message.
        """
        pulumi.set(__self__, "author_email_id", author_email_id)
        pulumi.set(__self__, "author_name", author_name)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter(name="authorEmailId")
    def author_email_id(self) -> builtins.str:
        """
        The email id of the author.
        """
        return pulumi.get(self, "author_email_id")

    @property
    @pulumi.getter(name="authorName")
    def author_name(self) -> builtins.str:
        """
        The name of the author.
        """
        return pulumi.get(self, "author_name")

    @property
    @pulumi.getter
    def message(self) -> builtins.str:
        """
        Commit message.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class GetSecretManagerUsageScopeResult(dict):
    def __init__(__self__, *,
                 application_id: Optional[builtins.str] = None,
                 environment_filter_type: Optional[builtins.str] = None,
                 environment_id: Optional[builtins.str] = None):
        """
        :param builtins.str application_id: Id of the application to scope to. If empty then this scope applies to all applications.
        :param builtins.str environment_filter_type: Type of environment filter applied. Cannot be used with `environment_id`. Valid options are NON*PRODUCTION*ENVIRONMENTS, PRODUCTION_ENVIRONMENTS.
        :param builtins.str environment_id: Id of the id of the specific environment to scope to. Cannot be used with `environment_filter_type`.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if environment_filter_type is not None:
            pulumi.set(__self__, "environment_filter_type", environment_filter_type)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[builtins.str]:
        """
        Id of the application to scope to. If empty then this scope applies to all applications.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="environmentFilterType")
    def environment_filter_type(self) -> Optional[builtins.str]:
        """
        Type of environment filter applied. Cannot be used with `environment_id`. Valid options are NON*PRODUCTION*ENVIRONMENTS, PRODUCTION_ENVIRONMENTS.
        """
        return pulumi.get(self, "environment_filter_type")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[builtins.str]:
        """
        Id of the id of the specific environment to scope to. Cannot be used with `environment_filter_type`.
        """
        return pulumi.get(self, "environment_id")


@pulumi.output_type
class GetSshCredentialUsageScopeResult(dict):
    def __init__(__self__, *,
                 application_id: Optional[builtins.str] = None,
                 environment_filter_type: Optional[builtins.str] = None,
                 environment_id: Optional[builtins.str] = None):
        """
        :param builtins.str application_id: Id of the application to scope to. If empty then this scope applies to all applications.
        :param builtins.str environment_filter_type: Type of environment filter applied. Cannot be used with `environment_id`. Valid options are NON*PRODUCTION*ENVIRONMENTS, PRODUCTION_ENVIRONMENTS.
        :param builtins.str environment_id: Id of the id of the specific environment to scope to. Cannot be used with `environment_filter_type`.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if environment_filter_type is not None:
            pulumi.set(__self__, "environment_filter_type", environment_filter_type)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[builtins.str]:
        """
        Id of the application to scope to. If empty then this scope applies to all applications.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="environmentFilterType")
    def environment_filter_type(self) -> Optional[builtins.str]:
        """
        Type of environment filter applied. Cannot be used with `environment_id`. Valid options are NON*PRODUCTION*ENVIRONMENTS, PRODUCTION_ENVIRONMENTS.
        """
        return pulumi.get(self, "environment_filter_type")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[builtins.str]:
        """
        Id of the id of the specific environment to scope to. Cannot be used with `environment_filter_type`.
        """
        return pulumi.get(self, "environment_id")


@pulumi.output_type
class GetTriggerConditionResult(dict):
    def __init__(__self__, *,
                 on_webhooks: Sequence['outputs.GetTriggerConditionOnWebhookResult'],
                 trigger_condition_type: builtins.str):
        """
        :param Sequence['GetTriggerConditionOnWebhookArgs'] on_webhooks: On webhook.
        :param builtins.str trigger_condition_type: Trigger condition.
        """
        pulumi.set(__self__, "on_webhooks", on_webhooks)
        pulumi.set(__self__, "trigger_condition_type", trigger_condition_type)

    @property
    @pulumi.getter(name="onWebhooks")
    def on_webhooks(self) -> Sequence['outputs.GetTriggerConditionOnWebhookResult']:
        """
        On webhook.
        """
        return pulumi.get(self, "on_webhooks")

    @property
    @pulumi.getter(name="triggerConditionType")
    def trigger_condition_type(self) -> builtins.str:
        """
        Trigger condition.
        """
        return pulumi.get(self, "trigger_condition_type")


@pulumi.output_type
class GetTriggerConditionOnWebhookResult(dict):
    def __init__(__self__, *,
                 webhook_details: Sequence['outputs.GetTriggerConditionOnWebhookWebhookDetailResult']):
        """
        :param Sequence['GetTriggerConditionOnWebhookWebhookDetailArgs'] webhook_details: Webhook details.
        """
        pulumi.set(__self__, "webhook_details", webhook_details)

    @property
    @pulumi.getter(name="webhookDetails")
    def webhook_details(self) -> Sequence['outputs.GetTriggerConditionOnWebhookWebhookDetailResult']:
        """
        Webhook details.
        """
        return pulumi.get(self, "webhook_details")


@pulumi.output_type
class GetTriggerConditionOnWebhookWebhookDetailResult(dict):
    def __init__(__self__, *,
                 header: builtins.str,
                 method: builtins.str,
                 payload: builtins.str,
                 webhook_token: builtins.str,
                 webhook_url: builtins.str):
        """
        :param builtins.str header: Header.
        :param builtins.str method: Method.
        :param builtins.str payload: Payload.
        :param builtins.str webhook_token: Webhook token.
        :param builtins.str webhook_url: Webhook URL.
        """
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "payload", payload)
        pulumi.set(__self__, "webhook_token", webhook_token)
        pulumi.set(__self__, "webhook_url", webhook_url)

    @property
    @pulumi.getter
    def header(self) -> builtins.str:
        """
        Header.
        """
        return pulumi.get(self, "header")

    @property
    @pulumi.getter
    def method(self) -> builtins.str:
        """
        Method.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def payload(self) -> builtins.str:
        """
        Payload.
        """
        return pulumi.get(self, "payload")

    @property
    @pulumi.getter(name="webhookToken")
    def webhook_token(self) -> builtins.str:
        """
        Webhook token.
        """
        return pulumi.get(self, "webhook_token")

    @property
    @pulumi.getter(name="webhookUrl")
    def webhook_url(self) -> builtins.str:
        """
        Webhook URL.
        """
        return pulumi.get(self, "webhook_url")


