# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsSecretManagerConnectorArgs', 'AwsSecretManagerConnector']

@pulumi.input_type
class AwsSecretManagerConnectorArgs:
    def __init__(__self__, *,
                 credentials: pulumi.Input['AwsSecretManagerConnectorCredentialsArgs'],
                 identifier: pulumi.Input[builtins.str],
                 region: pulumi.Input[builtins.str],
                 default: Optional[pulumi.Input[builtins.bool]] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 execute_on_delegate: Optional[pulumi.Input[builtins.bool]] = None,
                 force_delete_without_recovery: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 recovery_window_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 secret_name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 use_put_secret: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a AwsSecretManagerConnector resource.
        :param pulumi.Input['AwsSecretManagerConnectorCredentialsArgs'] credentials: Credentials to connect to AWS.
        :param pulumi.Input[builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[builtins.str] region: The AWS region where the AWS Secret Manager is.
        :param pulumi.Input[builtins.bool] default: Use as Default Secrets Manager.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] delegate_selectors: Tags to filter delegates for connection.
        :param pulumi.Input[builtins.str] description: Description of the resource.
        :param pulumi.Input[builtins.bool] execute_on_delegate: Run the operation on the delegate or harness platform.
        :param pulumi.Input[builtins.bool] force_delete_without_recovery: Whether to force delete secret value or not.
        :param pulumi.Input[builtins.str] name: Name of the resource.
        :param pulumi.Input[builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[builtins.int] recovery_window_in_days: recovery duration in days in AWS Secrets Manager.
        :param pulumi.Input[builtins.str] secret_name_prefix: A prefix to be added to all secrets.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[builtins.bool] use_put_secret: Whether to update secret value using putSecretValue action.
        """
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "region", region)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if delegate_selectors is not None:
            pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execute_on_delegate is not None:
            pulumi.set(__self__, "execute_on_delegate", execute_on_delegate)
        if force_delete_without_recovery is not None:
            pulumi.set(__self__, "force_delete_without_recovery", force_delete_without_recovery)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if recovery_window_in_days is not None:
            pulumi.set(__self__, "recovery_window_in_days", recovery_window_in_days)
        if secret_name_prefix is not None:
            pulumi.set(__self__, "secret_name_prefix", secret_name_prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if use_put_secret is not None:
            pulumi.set(__self__, "use_put_secret", use_put_secret)

    @property
    @pulumi.getter
    def credentials(self) -> pulumi.Input['AwsSecretManagerConnectorCredentialsArgs']:
        """
        Credentials to connect to AWS.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: pulumi.Input['AwsSecretManagerConnectorCredentialsArgs']):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[builtins.str]:
        """
        The AWS region where the AWS Secret Manager is.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Use as Default Secrets Manager.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Tags to filter delegates for connection.
        """
        return pulumi.get(self, "delegate_selectors")

    @delegate_selectors.setter
    def delegate_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "delegate_selectors", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="executeOnDelegate")
    def execute_on_delegate(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Run the operation on the delegate or harness platform.
        """
        return pulumi.get(self, "execute_on_delegate")

    @execute_on_delegate.setter
    def execute_on_delegate(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "execute_on_delegate", value)

    @property
    @pulumi.getter(name="forceDeleteWithoutRecovery")
    def force_delete_without_recovery(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to force delete secret value or not.
        """
        return pulumi.get(self, "force_delete_without_recovery")

    @force_delete_without_recovery.setter
    def force_delete_without_recovery(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_delete_without_recovery", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="recoveryWindowInDays")
    def recovery_window_in_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        recovery duration in days in AWS Secrets Manager.
        """
        return pulumi.get(self, "recovery_window_in_days")

    @recovery_window_in_days.setter
    def recovery_window_in_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "recovery_window_in_days", value)

    @property
    @pulumi.getter(name="secretNamePrefix")
    def secret_name_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A prefix to be added to all secrets.
        """
        return pulumi.get(self, "secret_name_prefix")

    @secret_name_prefix.setter
    def secret_name_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_name_prefix", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="usePutSecret")
    def use_put_secret(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to update secret value using putSecretValue action.
        """
        return pulumi.get(self, "use_put_secret")

    @use_put_secret.setter
    def use_put_secret(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_put_secret", value)


@pulumi.input_type
class _AwsSecretManagerConnectorState:
    def __init__(__self__, *,
                 credentials: Optional[pulumi.Input['AwsSecretManagerConnectorCredentialsArgs']] = None,
                 default: Optional[pulumi.Input[builtins.bool]] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 execute_on_delegate: Optional[pulumi.Input[builtins.bool]] = None,
                 force_delete_without_recovery: Optional[pulumi.Input[builtins.bool]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 recovery_window_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 secret_name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 use_put_secret: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering AwsSecretManagerConnector resources.
        :param pulumi.Input['AwsSecretManagerConnectorCredentialsArgs'] credentials: Credentials to connect to AWS.
        :param pulumi.Input[builtins.bool] default: Use as Default Secrets Manager.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] delegate_selectors: Tags to filter delegates for connection.
        :param pulumi.Input[builtins.str] description: Description of the resource.
        :param pulumi.Input[builtins.bool] execute_on_delegate: Run the operation on the delegate or harness platform.
        :param pulumi.Input[builtins.bool] force_delete_without_recovery: Whether to force delete secret value or not.
        :param pulumi.Input[builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[builtins.str] name: Name of the resource.
        :param pulumi.Input[builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[builtins.int] recovery_window_in_days: recovery duration in days in AWS Secrets Manager.
        :param pulumi.Input[builtins.str] region: The AWS region where the AWS Secret Manager is.
        :param pulumi.Input[builtins.str] secret_name_prefix: A prefix to be added to all secrets.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[builtins.bool] use_put_secret: Whether to update secret value using putSecretValue action.
        """
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if delegate_selectors is not None:
            pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execute_on_delegate is not None:
            pulumi.set(__self__, "execute_on_delegate", execute_on_delegate)
        if force_delete_without_recovery is not None:
            pulumi.set(__self__, "force_delete_without_recovery", force_delete_without_recovery)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if recovery_window_in_days is not None:
            pulumi.set(__self__, "recovery_window_in_days", recovery_window_in_days)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_name_prefix is not None:
            pulumi.set(__self__, "secret_name_prefix", secret_name_prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if use_put_secret is not None:
            pulumi.set(__self__, "use_put_secret", use_put_secret)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['AwsSecretManagerConnectorCredentialsArgs']]:
        """
        Credentials to connect to AWS.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['AwsSecretManagerConnectorCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Use as Default Secrets Manager.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Tags to filter delegates for connection.
        """
        return pulumi.get(self, "delegate_selectors")

    @delegate_selectors.setter
    def delegate_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "delegate_selectors", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="executeOnDelegate")
    def execute_on_delegate(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Run the operation on the delegate or harness platform.
        """
        return pulumi.get(self, "execute_on_delegate")

    @execute_on_delegate.setter
    def execute_on_delegate(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "execute_on_delegate", value)

    @property
    @pulumi.getter(name="forceDeleteWithoutRecovery")
    def force_delete_without_recovery(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to force delete secret value or not.
        """
        return pulumi.get(self, "force_delete_without_recovery")

    @force_delete_without_recovery.setter
    def force_delete_without_recovery(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_delete_without_recovery", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="recoveryWindowInDays")
    def recovery_window_in_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        recovery duration in days in AWS Secrets Manager.
        """
        return pulumi.get(self, "recovery_window_in_days")

    @recovery_window_in_days.setter
    def recovery_window_in_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "recovery_window_in_days", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS region where the AWS Secret Manager is.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="secretNamePrefix")
    def secret_name_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A prefix to be added to all secrets.
        """
        return pulumi.get(self, "secret_name_prefix")

    @secret_name_prefix.setter
    def secret_name_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_name_prefix", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="usePutSecret")
    def use_put_secret(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to update secret value using putSecretValue action.
        """
        return pulumi.get(self, "use_put_secret")

    @use_put_secret.setter
    def use_put_secret(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_put_secret", value)


@pulumi.type_token("harness:platform/awsSecretManagerConnector:AwsSecretManagerConnector")
class AwsSecretManagerConnector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credentials: Optional[pulumi.Input[Union['AwsSecretManagerConnectorCredentialsArgs', 'AwsSecretManagerConnectorCredentialsArgsDict']]] = None,
                 default: Optional[pulumi.Input[builtins.bool]] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 execute_on_delegate: Optional[pulumi.Input[builtins.bool]] = None,
                 force_delete_without_recovery: Optional[pulumi.Input[builtins.bool]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 recovery_window_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 secret_name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 use_put_secret: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        Import account level aws secret manager connector

        ```sh
        $ pulumi import harness:platform/awsSecretManagerConnector:AwsSecretManagerConnector example <connector_id>
        ```

        Import org level aws secret manager connector

        ```sh
        $ pulumi import harness:platform/awsSecretManagerConnector:AwsSecretManagerConnector example <ord_id>/<connector_id>
        ```

        Import project level aws secret manager connector

        ```sh
        $ pulumi import harness:platform/awsSecretManagerConnector:AwsSecretManagerConnector example <org_id>/<project_id>/<connector_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AwsSecretManagerConnectorCredentialsArgs', 'AwsSecretManagerConnectorCredentialsArgsDict']] credentials: Credentials to connect to AWS.
        :param pulumi.Input[builtins.bool] default: Use as Default Secrets Manager.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] delegate_selectors: Tags to filter delegates for connection.
        :param pulumi.Input[builtins.str] description: Description of the resource.
        :param pulumi.Input[builtins.bool] execute_on_delegate: Run the operation on the delegate or harness platform.
        :param pulumi.Input[builtins.bool] force_delete_without_recovery: Whether to force delete secret value or not.
        :param pulumi.Input[builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[builtins.str] name: Name of the resource.
        :param pulumi.Input[builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[builtins.int] recovery_window_in_days: recovery duration in days in AWS Secrets Manager.
        :param pulumi.Input[builtins.str] region: The AWS region where the AWS Secret Manager is.
        :param pulumi.Input[builtins.str] secret_name_prefix: A prefix to be added to all secrets.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[builtins.bool] use_put_secret: Whether to update secret value using putSecretValue action.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsSecretManagerConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        Import account level aws secret manager connector

        ```sh
        $ pulumi import harness:platform/awsSecretManagerConnector:AwsSecretManagerConnector example <connector_id>
        ```

        Import org level aws secret manager connector

        ```sh
        $ pulumi import harness:platform/awsSecretManagerConnector:AwsSecretManagerConnector example <ord_id>/<connector_id>
        ```

        Import project level aws secret manager connector

        ```sh
        $ pulumi import harness:platform/awsSecretManagerConnector:AwsSecretManagerConnector example <org_id>/<project_id>/<connector_id>
        ```

        :param str resource_name: The name of the resource.
        :param AwsSecretManagerConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsSecretManagerConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credentials: Optional[pulumi.Input[Union['AwsSecretManagerConnectorCredentialsArgs', 'AwsSecretManagerConnectorCredentialsArgsDict']]] = None,
                 default: Optional[pulumi.Input[builtins.bool]] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 execute_on_delegate: Optional[pulumi.Input[builtins.bool]] = None,
                 force_delete_without_recovery: Optional[pulumi.Input[builtins.bool]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 recovery_window_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 secret_name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 use_put_secret: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsSecretManagerConnectorArgs.__new__(AwsSecretManagerConnectorArgs)

            if credentials is None and not opts.urn:
                raise TypeError("Missing required property 'credentials'")
            __props__.__dict__["credentials"] = credentials
            __props__.__dict__["default"] = default
            __props__.__dict__["delegate_selectors"] = delegate_selectors
            __props__.__dict__["description"] = description
            __props__.__dict__["execute_on_delegate"] = execute_on_delegate
            __props__.__dict__["force_delete_without_recovery"] = force_delete_without_recovery
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["name"] = name
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["recovery_window_in_days"] = recovery_window_in_days
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["secret_name_prefix"] = secret_name_prefix
            __props__.__dict__["tags"] = tags
            __props__.__dict__["use_put_secret"] = use_put_secret
        super(AwsSecretManagerConnector, __self__).__init__(
            'harness:platform/awsSecretManagerConnector:AwsSecretManagerConnector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            credentials: Optional[pulumi.Input[Union['AwsSecretManagerConnectorCredentialsArgs', 'AwsSecretManagerConnectorCredentialsArgsDict']]] = None,
            default: Optional[pulumi.Input[builtins.bool]] = None,
            delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            execute_on_delegate: Optional[pulumi.Input[builtins.bool]] = None,
            force_delete_without_recovery: Optional[pulumi.Input[builtins.bool]] = None,
            identifier: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            org_id: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            recovery_window_in_days: Optional[pulumi.Input[builtins.int]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            secret_name_prefix: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            use_put_secret: Optional[pulumi.Input[builtins.bool]] = None) -> 'AwsSecretManagerConnector':
        """
        Get an existing AwsSecretManagerConnector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AwsSecretManagerConnectorCredentialsArgs', 'AwsSecretManagerConnectorCredentialsArgsDict']] credentials: Credentials to connect to AWS.
        :param pulumi.Input[builtins.bool] default: Use as Default Secrets Manager.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] delegate_selectors: Tags to filter delegates for connection.
        :param pulumi.Input[builtins.str] description: Description of the resource.
        :param pulumi.Input[builtins.bool] execute_on_delegate: Run the operation on the delegate or harness platform.
        :param pulumi.Input[builtins.bool] force_delete_without_recovery: Whether to force delete secret value or not.
        :param pulumi.Input[builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[builtins.str] name: Name of the resource.
        :param pulumi.Input[builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[builtins.int] recovery_window_in_days: recovery duration in days in AWS Secrets Manager.
        :param pulumi.Input[builtins.str] region: The AWS region where the AWS Secret Manager is.
        :param pulumi.Input[builtins.str] secret_name_prefix: A prefix to be added to all secrets.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[builtins.bool] use_put_secret: Whether to update secret value using putSecretValue action.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsSecretManagerConnectorState.__new__(_AwsSecretManagerConnectorState)

        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["default"] = default
        __props__.__dict__["delegate_selectors"] = delegate_selectors
        __props__.__dict__["description"] = description
        __props__.__dict__["execute_on_delegate"] = execute_on_delegate
        __props__.__dict__["force_delete_without_recovery"] = force_delete_without_recovery
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["recovery_window_in_days"] = recovery_window_in_days
        __props__.__dict__["region"] = region
        __props__.__dict__["secret_name_prefix"] = secret_name_prefix
        __props__.__dict__["tags"] = tags
        __props__.__dict__["use_put_secret"] = use_put_secret
        return AwsSecretManagerConnector(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def credentials(self) -> pulumi.Output['outputs.AwsSecretManagerConnectorCredentials']:
        """
        Credentials to connect to AWS.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter
    def default(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Use as Default Secrets Manager.
        """
        return pulumi.get(self, "default")

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Tags to filter delegates for connection.
        """
        return pulumi.get(self, "delegate_selectors")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="executeOnDelegate")
    def execute_on_delegate(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Run the operation on the delegate or harness platform.
        """
        return pulumi.get(self, "execute_on_delegate")

    @property
    @pulumi.getter(name="forceDeleteWithoutRecovery")
    def force_delete_without_recovery(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to force delete secret value or not.
        """
        return pulumi.get(self, "force_delete_without_recovery")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="recoveryWindowInDays")
    def recovery_window_in_days(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        recovery duration in days in AWS Secrets Manager.
        """
        return pulumi.get(self, "recovery_window_in_days")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        The AWS region where the AWS Secret Manager is.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secretNamePrefix")
    def secret_name_prefix(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A prefix to be added to all secrets.
        """
        return pulumi.get(self, "secret_name_prefix")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="usePutSecret")
    def use_put_secret(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to update secret value using putSecretValue action.
        """
        return pulumi.get(self, "use_put_secret")

