# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DashboardsArgs', 'Dashboards']

@pulumi.input_type
class DashboardsArgs:
    def __init__(__self__, *,
                 dashboard_id: pulumi.Input[builtins.str],
                 resource_identifier: pulumi.Input[builtins.str],
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 data_sources: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[builtins.str]] = None,
                 models: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 view_count: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a Dashboards resource.
        :param pulumi.Input[builtins.str] dashboard_id: Unique identifier of the Template Dashboard to create from.
        :param pulumi.Input[builtins.str] resource_identifier: The Folder ID that the Dashboard belongs to.
        :param pulumi.Input[builtins.str] created_at: Created at timestamp of the Dashboard.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] data_sources: Data Sources within the Dashboard.
        :param pulumi.Input[builtins.str] description: Description of the Dashboard.
        :param pulumi.Input[builtins.str] folder_id: The Folder ID that the Dashboard belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] models: Data Models within the Dashboard.
        :param pulumi.Input[builtins.str] name: Name of the Dashboard.
        :param pulumi.Input[builtins.str] title: Title of the Dashboard.
        :param pulumi.Input[builtins.str] type: Type of the dashboard.
        :param pulumi.Input[builtins.int] view_count: View count of the dashboard.
        """
        pulumi.set(__self__, "dashboard_id", dashboard_id)
        pulumi.set(__self__, "resource_identifier", resource_identifier)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if data_sources is not None:
            pulumi.set(__self__, "data_sources", data_sources)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if models is not None:
            pulumi.set(__self__, "models", models)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if view_count is not None:
            pulumi.set(__self__, "view_count", view_count)

    @property
    @pulumi.getter(name="dashboardId")
    def dashboard_id(self) -> pulumi.Input[builtins.str]:
        """
        Unique identifier of the Template Dashboard to create from.
        """
        return pulumi.get(self, "dashboard_id")

    @dashboard_id.setter
    def dashboard_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "dashboard_id", value)

    @property
    @pulumi.getter(name="resourceIdentifier")
    def resource_identifier(self) -> pulumi.Input[builtins.str]:
        """
        The Folder ID that the Dashboard belongs to.
        """
        return pulumi.get(self, "resource_identifier")

    @resource_identifier.setter
    def resource_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_identifier", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Created at timestamp of the Dashboard.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="dataSources")
    def data_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Data Sources within the Dashboard.
        """
        return pulumi.get(self, "data_sources")

    @data_sources.setter
    def data_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "data_sources", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the Dashboard.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Folder ID that the Dashboard belongs to.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter
    def models(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Data Models within the Dashboard.
        """
        return pulumi.get(self, "models")

    @models.setter
    def models(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "models", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Dashboard.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Title of the Dashboard.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of the dashboard.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="viewCount")
    def view_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        View count of the dashboard.
        """
        return pulumi.get(self, "view_count")

    @view_count.setter
    def view_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "view_count", value)


@pulumi.input_type
class _DashboardsState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 dashboard_id: Optional[pulumi.Input[builtins.str]] = None,
                 data_sources: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 favorite_count: Optional[pulumi.Input[builtins.int]] = None,
                 folder_id: Optional[pulumi.Input[builtins.str]] = None,
                 last_accessed_at: Optional[pulumi.Input[builtins.str]] = None,
                 models: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 view_count: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering Dashboards resources.
        :param pulumi.Input[builtins.str] created_at: Created at timestamp of the Dashboard.
        :param pulumi.Input[builtins.str] dashboard_id: Unique identifier of the Template Dashboard to create from.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] data_sources: Data Sources within the Dashboard.
        :param pulumi.Input[builtins.str] description: Description of the Dashboard.
        :param pulumi.Input[builtins.int] favorite_count: Favorite count of the dashboard.
        :param pulumi.Input[builtins.str] folder_id: The Folder ID that the Dashboard belongs to.
        :param pulumi.Input[builtins.str] last_accessed_at: Last accessed at timestamp of the Dashboard.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] models: Data Models within the Dashboard.
        :param pulumi.Input[builtins.str] name: Name of the Dashboard.
        :param pulumi.Input[builtins.str] resource_identifier: The Folder ID that the Dashboard belongs to.
        :param pulumi.Input[builtins.str] title: Title of the Dashboard.
        :param pulumi.Input[builtins.str] type: Type of the dashboard.
        :param pulumi.Input[builtins.int] view_count: View count of the dashboard.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if dashboard_id is not None:
            pulumi.set(__self__, "dashboard_id", dashboard_id)
        if data_sources is not None:
            pulumi.set(__self__, "data_sources", data_sources)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if favorite_count is not None:
            pulumi.set(__self__, "favorite_count", favorite_count)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if last_accessed_at is not None:
            pulumi.set(__self__, "last_accessed_at", last_accessed_at)
        if models is not None:
            pulumi.set(__self__, "models", models)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_identifier is not None:
            pulumi.set(__self__, "resource_identifier", resource_identifier)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if view_count is not None:
            pulumi.set(__self__, "view_count", view_count)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Created at timestamp of the Dashboard.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="dashboardId")
    def dashboard_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier of the Template Dashboard to create from.
        """
        return pulumi.get(self, "dashboard_id")

    @dashboard_id.setter
    def dashboard_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dashboard_id", value)

    @property
    @pulumi.getter(name="dataSources")
    def data_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Data Sources within the Dashboard.
        """
        return pulumi.get(self, "data_sources")

    @data_sources.setter
    def data_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "data_sources", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the Dashboard.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="favoriteCount")
    def favorite_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Favorite count of the dashboard.
        """
        return pulumi.get(self, "favorite_count")

    @favorite_count.setter
    def favorite_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "favorite_count", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Folder ID that the Dashboard belongs to.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter(name="lastAccessedAt")
    def last_accessed_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Last accessed at timestamp of the Dashboard.
        """
        return pulumi.get(self, "last_accessed_at")

    @last_accessed_at.setter
    def last_accessed_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_accessed_at", value)

    @property
    @pulumi.getter
    def models(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Data Models within the Dashboard.
        """
        return pulumi.get(self, "models")

    @models.setter
    def models(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "models", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Dashboard.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceIdentifier")
    def resource_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Folder ID that the Dashboard belongs to.
        """
        return pulumi.get(self, "resource_identifier")

    @resource_identifier.setter
    def resource_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_identifier", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Title of the Dashboard.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of the dashboard.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="viewCount")
    def view_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        View count of the dashboard.
        """
        return pulumi.get(self, "view_count")

    @view_count.setter
    def view_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "view_count", value)


@pulumi.type_token("harness:platform/dashboards:Dashboards")
class Dashboards(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 dashboard_id: Optional[pulumi.Input[builtins.str]] = None,
                 data_sources: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[builtins.str]] = None,
                 models: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 view_count: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        Resource for a Harness Custom Dashboard.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.Dashboards("example",
            dashboard_id="48507",
            description="Example dashboard description",
            resource_identifier="shared",
            title="Example Dashboard",
            data_sources=[],
            models=[])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] created_at: Created at timestamp of the Dashboard.
        :param pulumi.Input[builtins.str] dashboard_id: Unique identifier of the Template Dashboard to create from.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] data_sources: Data Sources within the Dashboard.
        :param pulumi.Input[builtins.str] description: Description of the Dashboard.
        :param pulumi.Input[builtins.str] folder_id: The Folder ID that the Dashboard belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] models: Data Models within the Dashboard.
        :param pulumi.Input[builtins.str] name: Name of the Dashboard.
        :param pulumi.Input[builtins.str] resource_identifier: The Folder ID that the Dashboard belongs to.
        :param pulumi.Input[builtins.str] title: Title of the Dashboard.
        :param pulumi.Input[builtins.str] type: Type of the dashboard.
        :param pulumi.Input[builtins.int] view_count: View count of the dashboard.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DashboardsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for a Harness Custom Dashboard.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.Dashboards("example",
            dashboard_id="48507",
            description="Example dashboard description",
            resource_identifier="shared",
            title="Example Dashboard",
            data_sources=[],
            models=[])
        ```

        :param str resource_name: The name of the resource.
        :param DashboardsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DashboardsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 dashboard_id: Optional[pulumi.Input[builtins.str]] = None,
                 data_sources: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[builtins.str]] = None,
                 models: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 view_count: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DashboardsArgs.__new__(DashboardsArgs)

            __props__.__dict__["created_at"] = created_at
            if dashboard_id is None and not opts.urn:
                raise TypeError("Missing required property 'dashboard_id'")
            __props__.__dict__["dashboard_id"] = dashboard_id
            __props__.__dict__["data_sources"] = data_sources
            __props__.__dict__["description"] = description
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["models"] = models
            __props__.__dict__["name"] = name
            if resource_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'resource_identifier'")
            __props__.__dict__["resource_identifier"] = resource_identifier
            __props__.__dict__["title"] = title
            __props__.__dict__["type"] = type
            __props__.__dict__["view_count"] = view_count
            __props__.__dict__["favorite_count"] = None
            __props__.__dict__["last_accessed_at"] = None
        super(Dashboards, __self__).__init__(
            'harness:platform/dashboards:Dashboards',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            dashboard_id: Optional[pulumi.Input[builtins.str]] = None,
            data_sources: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            favorite_count: Optional[pulumi.Input[builtins.int]] = None,
            folder_id: Optional[pulumi.Input[builtins.str]] = None,
            last_accessed_at: Optional[pulumi.Input[builtins.str]] = None,
            models: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            resource_identifier: Optional[pulumi.Input[builtins.str]] = None,
            title: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            view_count: Optional[pulumi.Input[builtins.int]] = None) -> 'Dashboards':
        """
        Get an existing Dashboards resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] created_at: Created at timestamp of the Dashboard.
        :param pulumi.Input[builtins.str] dashboard_id: Unique identifier of the Template Dashboard to create from.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] data_sources: Data Sources within the Dashboard.
        :param pulumi.Input[builtins.str] description: Description of the Dashboard.
        :param pulumi.Input[builtins.int] favorite_count: Favorite count of the dashboard.
        :param pulumi.Input[builtins.str] folder_id: The Folder ID that the Dashboard belongs to.
        :param pulumi.Input[builtins.str] last_accessed_at: Last accessed at timestamp of the Dashboard.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] models: Data Models within the Dashboard.
        :param pulumi.Input[builtins.str] name: Name of the Dashboard.
        :param pulumi.Input[builtins.str] resource_identifier: The Folder ID that the Dashboard belongs to.
        :param pulumi.Input[builtins.str] title: Title of the Dashboard.
        :param pulumi.Input[builtins.str] type: Type of the dashboard.
        :param pulumi.Input[builtins.int] view_count: View count of the dashboard.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DashboardsState.__new__(_DashboardsState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["dashboard_id"] = dashboard_id
        __props__.__dict__["data_sources"] = data_sources
        __props__.__dict__["description"] = description
        __props__.__dict__["favorite_count"] = favorite_count
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["last_accessed_at"] = last_accessed_at
        __props__.__dict__["models"] = models
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_identifier"] = resource_identifier
        __props__.__dict__["title"] = title
        __props__.__dict__["type"] = type
        __props__.__dict__["view_count"] = view_count
        return Dashboards(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        Created at timestamp of the Dashboard.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="dashboardId")
    def dashboard_id(self) -> pulumi.Output[builtins.str]:
        """
        Unique identifier of the Template Dashboard to create from.
        """
        return pulumi.get(self, "dashboard_id")

    @property
    @pulumi.getter(name="dataSources")
    def data_sources(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Data Sources within the Dashboard.
        """
        return pulumi.get(self, "data_sources")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the Dashboard.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="favoriteCount")
    def favorite_count(self) -> pulumi.Output[builtins.int]:
        """
        Favorite count of the dashboard.
        """
        return pulumi.get(self, "favorite_count")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Folder ID that the Dashboard belongs to.
        """
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter(name="lastAccessedAt")
    def last_accessed_at(self) -> pulumi.Output[builtins.str]:
        """
        Last accessed at timestamp of the Dashboard.
        """
        return pulumi.get(self, "last_accessed_at")

    @property
    @pulumi.getter
    def models(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Data Models within the Dashboard.
        """
        return pulumi.get(self, "models")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the Dashboard.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceIdentifier")
    def resource_identifier(self) -> pulumi.Output[builtins.str]:
        """
        The Folder ID that the Dashboard belongs to.
        """
        return pulumi.get(self, "resource_identifier")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Title of the Dashboard.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        Type of the dashboard.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="viewCount")
    def view_count(self) -> pulumi.Output[builtins.int]:
        """
        View count of the dashboard.
        """
        return pulumi.get(self, "view_count")

