# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EnvironmentArgs', 'Environment']

@pulumi.input_type
class EnvironmentArgs:
    def __init__(__self__, *,
                 identifier: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 color: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[builtins.bool]] = None,
                 git_details: Optional[pulumi.Input['EnvironmentGitDetailsArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 yaml: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Environment resource.
        :param pulumi.Input[builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[builtins.str] type: The type of environment. Valid values are PreProduction, Production
        :param pulumi.Input[builtins.str] color: Color of the environment.
        :param pulumi.Input[builtins.str] description: Description of the resource.
        :param pulumi.Input[builtins.bool] force_delete: When set to true, enables force deletion of environments.
        :param pulumi.Input['EnvironmentGitDetailsArgs'] git_details: Contains Git Information for remote entities from Git for Create/Update/Import
        :param pulumi.Input[builtins.str] name: Name of the resource.
        :param pulumi.Input[builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[builtins.str] yaml: Environment YAML. In YAML, to reference an entity at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference an entity at the account scope, prefix 'account` to the expression: account.{identifier}. For eg, to reference a connector with identifier 'connectorId' at the organization scope in a stage mention it as connectorRef: org.
               connectorId.
        """
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "type", type)
        if color is not None:
            pulumi.set(__self__, "color", color)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if git_details is not None:
            pulumi.set(__self__, "git_details", git_details)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if yaml is not None:
            pulumi.set(__self__, "yaml", yaml)

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of environment. Valid values are PreProduction, Production
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def color(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Color of the environment.
        """
        return pulumi.get(self, "color")

    @color.setter
    def color(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "color", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When set to true, enables force deletion of environments.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @property
    @pulumi.getter(name="gitDetails")
    def git_details(self) -> Optional[pulumi.Input['EnvironmentGitDetailsArgs']]:
        """
        Contains Git Information for remote entities from Git for Create/Update/Import
        """
        return pulumi.get(self, "git_details")

    @git_details.setter
    def git_details(self, value: Optional[pulumi.Input['EnvironmentGitDetailsArgs']]):
        pulumi.set(self, "git_details", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def yaml(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Environment YAML. In YAML, to reference an entity at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference an entity at the account scope, prefix 'account` to the expression: account.{identifier}. For eg, to reference a connector with identifier 'connectorId' at the organization scope in a stage mention it as connectorRef: org.
        connectorId.
        """
        return pulumi.get(self, "yaml")

    @yaml.setter
    def yaml(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "yaml", value)


@pulumi.input_type
class _EnvironmentState:
    def __init__(__self__, *,
                 color: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[builtins.bool]] = None,
                 git_details: Optional[pulumi.Input['EnvironmentGitDetailsArgs']] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 yaml: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Environment resources.
        :param pulumi.Input[builtins.str] color: Color of the environment.
        :param pulumi.Input[builtins.str] description: Description of the resource.
        :param pulumi.Input[builtins.bool] force_delete: When set to true, enables force deletion of environments.
        :param pulumi.Input['EnvironmentGitDetailsArgs'] git_details: Contains Git Information for remote entities from Git for Create/Update/Import
        :param pulumi.Input[builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[builtins.str] name: Name of the resource.
        :param pulumi.Input[builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[builtins.str] type: The type of environment. Valid values are PreProduction, Production
        :param pulumi.Input[builtins.str] yaml: Environment YAML. In YAML, to reference an entity at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference an entity at the account scope, prefix 'account` to the expression: account.{identifier}. For eg, to reference a connector with identifier 'connectorId' at the organization scope in a stage mention it as connectorRef: org.
               connectorId.
        """
        if color is not None:
            pulumi.set(__self__, "color", color)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if git_details is not None:
            pulumi.set(__self__, "git_details", git_details)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if yaml is not None:
            pulumi.set(__self__, "yaml", yaml)

    @property
    @pulumi.getter
    def color(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Color of the environment.
        """
        return pulumi.get(self, "color")

    @color.setter
    def color(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "color", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When set to true, enables force deletion of environments.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @property
    @pulumi.getter(name="gitDetails")
    def git_details(self) -> Optional[pulumi.Input['EnvironmentGitDetailsArgs']]:
        """
        Contains Git Information for remote entities from Git for Create/Update/Import
        """
        return pulumi.get(self, "git_details")

    @git_details.setter
    def git_details(self, value: Optional[pulumi.Input['EnvironmentGitDetailsArgs']]):
        pulumi.set(self, "git_details", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of environment. Valid values are PreProduction, Production
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def yaml(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Environment YAML. In YAML, to reference an entity at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference an entity at the account scope, prefix 'account` to the expression: account.{identifier}. For eg, to reference a connector with identifier 'connectorId' at the organization scope in a stage mention it as connectorRef: org.
        connectorId.
        """
        return pulumi.get(self, "yaml")

    @yaml.setter
    def yaml(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "yaml", value)


@pulumi.type_token("harness:platform/environment:Environment")
class Environment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 color: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[builtins.bool]] = None,
                 git_details: Optional[pulumi.Input[Union['EnvironmentGitDetailsArgs', 'EnvironmentGitDetailsArgsDict']]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 yaml: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource for creating a Harness environment.

        ## Example to create Environment at different levels (Org, Project, Account)

        ### Account Level
        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.Environment("example",
            identifier="identifier",
            name="name",
            tags=[
                "foo:bar",
                "bar:foo",
            ],
            type="PreProduction",
            description="env description",
            yaml=\"\"\"environment:
           name: name
           identifier: identifier
           type: PreProduction
           tags:
             foo: bar
             bar: foo
           variables:
             - name: envVar1
               type: String
               value: v1
               description: ""
             - name: envVar2
               type: String
               value: v2
               description: ""
           overrides:
             manifests:
               - manifest:
                   identifier: manifestEnv
                   type: Values
                   spec:
                     store:
                       type: Git
                       spec:
                         connectorRef: <+input>
                         gitFetchType: Branch
                         paths:
                           - file1
                         repoName: <+input>
                         branch: master
             configFiles:
               - configFile:
                   identifier: configFileEnv
                   spec:
                     store:
                       type: Harness
                       spec:
                         files:
                           - account:/Add-ons/svcOverrideTest
                         secretFiles: []
        \"\"\")
        ```

        ### Org Level
        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.Environment("example",
            identifier="identifier",
            name="name",
            org_id="org_id",
            tags=[
                "foo:bar",
                "bar:foo",
            ],
            type="PreProduction",
            description="env description",
            yaml=\"\"\"environment:
           name: name
           identifier: identifier
           orgIdentifier: org_id
           type: PreProduction
           tags:
             foo: bar
             bar: foo
           variables:
             - name: envVar1
               type: String
               value: v1
               description: ""
             - name: envVar2
               type: String
               value: v2
               description: ""
           overrides:
             manifests:
               - manifest:
                   identifier: manifestEnv
                   type: Values
                   spec:
                     store:
                       type: Git
                       spec:
                         connectorRef: <+input>
                         gitFetchType: Branch
                         paths:
                           - file1
                         repoName: <+input>
                         branch: master
             configFiles:
               - configFile:
                   identifier: configFileEnv
                   spec:
                     store:
                       type: Harness
                       spec:
                         files:
                           - account:/Add-ons/svcOverrideTest
                         secretFiles: []
        \"\"\")
        ```

        ### Project Level
        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.Environment("example",
            identifier="identifier",
            name="name",
            org_id="org_id",
            project_id="project_id",
            tags=[
                "foo:bar",
                "bar:foo",
            ],
            type="PreProduction",
            description="env description",
            yaml=\"\"\"environment:
           name: name
           identifier: identifier
           orgIdentifier: org_id
           projectIdentifier: project_id
           type: PreProduction
           tags:
             foo: bar
             bar: foo
           variables:
             - name: envVar1
               type: String
               value: v1
               description: ""
             - name: envVar2
               type: String
               value: v2
               description: ""
           overrides:
             manifests:
               - manifest:
                   identifier: manifestEnv
                   type: Values
                   spec:
                     store:
                       type: Git
                       spec:
                         connectorRef: <+input>
                         gitFetchType: Branch
                         paths:
                           - file1
                         repoName: <+input>
                         branch: master
             configFiles:
               - configFile:
                   identifier: configFileEnv
                   spec:
                     store:
                       type: Harness
                       spec:
                         files:
                           - account:/Add-ons/svcOverrideTest
                         secretFiles: []
        \"\"\")
        ```

        ### Creating Remote Environment
        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.Environment("example",
            identifier="identifier",
            name="name",
            description="test",
            org_id="org_id",
            project_id="project_id",
            git_details={
                "store_type": "REMOTE",
                "connector_ref": "connector_ref",
                "repo_name": "repo_name",
                "file_path": "file_path",
                "branch": "branch",
            },
            yaml=\"\"\"environment:
          name: env
          identifier: env
          tags:
            test: ""
          type: PreProduction
          orgIdentifier: default
          projectIdentifier: proj1
          variables:
            - name: var1
              type: String
              value: abc
              description: ""
              required: false
          overrides:
            manifests:
              - manifest:
                  identifier: Manifest1
                  type: Values
                  spec:
                    store:
                      type: Github
                      spec:
                        connectorRef: <+input>
                        gitFetchType: Branch
                        paths:
                          - .harness/
                        repoName: <+input>
                        branch: <+input>
        \"\"\")
        ```

        ### Importing Environment From Git
        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.Environment("example",
            identifier="identifier",
            name="name",
            type="PreProduction",
            git_details={
                "store_type": "REMOTE",
                "connector_ref": "connector_ref",
                "repo_name": "repo_name",
                "file_path": "file_path",
                "branch": "branch",
                "import_from_git": True,
            })
        ```

        ## Import

        Import account level environment id

        ```sh
        $ pulumi import harness:platform/environment:Environment example <environment_id>
        ```

        Import org level environment id

        ```sh
        $ pulumi import harness:platform/environment:Environment example <org_id>/<environment_id>
        ```

        Import project level environment id

        ```sh
        $ pulumi import harness:platform/environment:Environment example <org_id>/<project_id>/<environment_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] color: Color of the environment.
        :param pulumi.Input[builtins.str] description: Description of the resource.
        :param pulumi.Input[builtins.bool] force_delete: When set to true, enables force deletion of environments.
        :param pulumi.Input[Union['EnvironmentGitDetailsArgs', 'EnvironmentGitDetailsArgsDict']] git_details: Contains Git Information for remote entities from Git for Create/Update/Import
        :param pulumi.Input[builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[builtins.str] name: Name of the resource.
        :param pulumi.Input[builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[builtins.str] type: The type of environment. Valid values are PreProduction, Production
        :param pulumi.Input[builtins.str] yaml: Environment YAML. In YAML, to reference an entity at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference an entity at the account scope, prefix 'account` to the expression: account.{identifier}. For eg, to reference a connector with identifier 'connectorId' at the organization scope in a stage mention it as connectorRef: org.
               connectorId.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvironmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating a Harness environment.

        ## Example to create Environment at different levels (Org, Project, Account)

        ### Account Level
        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.Environment("example",
            identifier="identifier",
            name="name",
            tags=[
                "foo:bar",
                "bar:foo",
            ],
            type="PreProduction",
            description="env description",
            yaml=\"\"\"environment:
           name: name
           identifier: identifier
           type: PreProduction
           tags:
             foo: bar
             bar: foo
           variables:
             - name: envVar1
               type: String
               value: v1
               description: ""
             - name: envVar2
               type: String
               value: v2
               description: ""
           overrides:
             manifests:
               - manifest:
                   identifier: manifestEnv
                   type: Values
                   spec:
                     store:
                       type: Git
                       spec:
                         connectorRef: <+input>
                         gitFetchType: Branch
                         paths:
                           - file1
                         repoName: <+input>
                         branch: master
             configFiles:
               - configFile:
                   identifier: configFileEnv
                   spec:
                     store:
                       type: Harness
                       spec:
                         files:
                           - account:/Add-ons/svcOverrideTest
                         secretFiles: []
        \"\"\")
        ```

        ### Org Level
        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.Environment("example",
            identifier="identifier",
            name="name",
            org_id="org_id",
            tags=[
                "foo:bar",
                "bar:foo",
            ],
            type="PreProduction",
            description="env description",
            yaml=\"\"\"environment:
           name: name
           identifier: identifier
           orgIdentifier: org_id
           type: PreProduction
           tags:
             foo: bar
             bar: foo
           variables:
             - name: envVar1
               type: String
               value: v1
               description: ""
             - name: envVar2
               type: String
               value: v2
               description: ""
           overrides:
             manifests:
               - manifest:
                   identifier: manifestEnv
                   type: Values
                   spec:
                     store:
                       type: Git
                       spec:
                         connectorRef: <+input>
                         gitFetchType: Branch
                         paths:
                           - file1
                         repoName: <+input>
                         branch: master
             configFiles:
               - configFile:
                   identifier: configFileEnv
                   spec:
                     store:
                       type: Harness
                       spec:
                         files:
                           - account:/Add-ons/svcOverrideTest
                         secretFiles: []
        \"\"\")
        ```

        ### Project Level
        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.Environment("example",
            identifier="identifier",
            name="name",
            org_id="org_id",
            project_id="project_id",
            tags=[
                "foo:bar",
                "bar:foo",
            ],
            type="PreProduction",
            description="env description",
            yaml=\"\"\"environment:
           name: name
           identifier: identifier
           orgIdentifier: org_id
           projectIdentifier: project_id
           type: PreProduction
           tags:
             foo: bar
             bar: foo
           variables:
             - name: envVar1
               type: String
               value: v1
               description: ""
             - name: envVar2
               type: String
               value: v2
               description: ""
           overrides:
             manifests:
               - manifest:
                   identifier: manifestEnv
                   type: Values
                   spec:
                     store:
                       type: Git
                       spec:
                         connectorRef: <+input>
                         gitFetchType: Branch
                         paths:
                           - file1
                         repoName: <+input>
                         branch: master
             configFiles:
               - configFile:
                   identifier: configFileEnv
                   spec:
                     store:
                       type: Harness
                       spec:
                         files:
                           - account:/Add-ons/svcOverrideTest
                         secretFiles: []
        \"\"\")
        ```

        ### Creating Remote Environment
        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.Environment("example",
            identifier="identifier",
            name="name",
            description="test",
            org_id="org_id",
            project_id="project_id",
            git_details={
                "store_type": "REMOTE",
                "connector_ref": "connector_ref",
                "repo_name": "repo_name",
                "file_path": "file_path",
                "branch": "branch",
            },
            yaml=\"\"\"environment:
          name: env
          identifier: env
          tags:
            test: ""
          type: PreProduction
          orgIdentifier: default
          projectIdentifier: proj1
          variables:
            - name: var1
              type: String
              value: abc
              description: ""
              required: false
          overrides:
            manifests:
              - manifest:
                  identifier: Manifest1
                  type: Values
                  spec:
                    store:
                      type: Github
                      spec:
                        connectorRef: <+input>
                        gitFetchType: Branch
                        paths:
                          - .harness/
                        repoName: <+input>
                        branch: <+input>
        \"\"\")
        ```

        ### Importing Environment From Git
        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.Environment("example",
            identifier="identifier",
            name="name",
            type="PreProduction",
            git_details={
                "store_type": "REMOTE",
                "connector_ref": "connector_ref",
                "repo_name": "repo_name",
                "file_path": "file_path",
                "branch": "branch",
                "import_from_git": True,
            })
        ```

        ## Import

        Import account level environment id

        ```sh
        $ pulumi import harness:platform/environment:Environment example <environment_id>
        ```

        Import org level environment id

        ```sh
        $ pulumi import harness:platform/environment:Environment example <org_id>/<environment_id>
        ```

        Import project level environment id

        ```sh
        $ pulumi import harness:platform/environment:Environment example <org_id>/<project_id>/<environment_id>
        ```

        :param str resource_name: The name of the resource.
        :param EnvironmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvironmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 color: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[builtins.bool]] = None,
                 git_details: Optional[pulumi.Input[Union['EnvironmentGitDetailsArgs', 'EnvironmentGitDetailsArgsDict']]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 yaml: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvironmentArgs.__new__(EnvironmentArgs)

            __props__.__dict__["color"] = color
            __props__.__dict__["description"] = description
            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["git_details"] = git_details
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["name"] = name
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["yaml"] = yaml
        super(Environment, __self__).__init__(
            'harness:platform/environment:Environment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            color: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            force_delete: Optional[pulumi.Input[builtins.bool]] = None,
            git_details: Optional[pulumi.Input[Union['EnvironmentGitDetailsArgs', 'EnvironmentGitDetailsArgsDict']]] = None,
            identifier: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            org_id: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            yaml: Optional[pulumi.Input[builtins.str]] = None) -> 'Environment':
        """
        Get an existing Environment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] color: Color of the environment.
        :param pulumi.Input[builtins.str] description: Description of the resource.
        :param pulumi.Input[builtins.bool] force_delete: When set to true, enables force deletion of environments.
        :param pulumi.Input[Union['EnvironmentGitDetailsArgs', 'EnvironmentGitDetailsArgsDict']] git_details: Contains Git Information for remote entities from Git for Create/Update/Import
        :param pulumi.Input[builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[builtins.str] name: Name of the resource.
        :param pulumi.Input[builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[builtins.str] type: The type of environment. Valid values are PreProduction, Production
        :param pulumi.Input[builtins.str] yaml: Environment YAML. In YAML, to reference an entity at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference an entity at the account scope, prefix 'account` to the expression: account.{identifier}. For eg, to reference a connector with identifier 'connectorId' at the organization scope in a stage mention it as connectorRef: org.
               connectorId.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnvironmentState.__new__(_EnvironmentState)

        __props__.__dict__["color"] = color
        __props__.__dict__["description"] = description
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["git_details"] = git_details
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["yaml"] = yaml
        return Environment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def color(self) -> pulumi.Output[builtins.str]:
        """
        Color of the environment.
        """
        return pulumi.get(self, "color")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[builtins.bool]:
        """
        When set to true, enables force deletion of environments.
        """
        return pulumi.get(self, "force_delete")

    @property
    @pulumi.getter(name="gitDetails")
    def git_details(self) -> pulumi.Output['outputs.EnvironmentGitDetails']:
        """
        Contains Git Information for remote entities from Git for Create/Update/Import
        """
        return pulumi.get(self, "git_details")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The type of environment. Valid values are PreProduction, Production
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def yaml(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Environment YAML. In YAML, to reference an entity at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference an entity at the account scope, prefix 'account` to the expression: account.{identifier}. For eg, to reference a connector with identifier 'connectorId' at the organization scope in a stage mention it as connectorRef: org.
        connectorId.
        """
        return pulumi.get(self, "yaml")

